/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseAssignmentSubmissionDao_Impl
extends CourseAssignmentSubmissionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseAssignmentSubmission> __insertionAdapterOfCourseAssignmentSubmission;
    private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission> __updateAdapterOfCourseAssignmentSubmission;

    public CourseAssignmentSubmissionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseAssignmentSubmission = new EntityInsertionAdapter<CourseAssignmentSubmission>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseAssignmentSubmission` (`casUid`,`casAssignmentUid`,`casSubmitterUid`,`casSubmitterPersonUid`,`casText`,`casType`,`casTimestamp`,`casClazzUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentSubmission entity) {
                statement.bindLong(1, entity.getCasUid());
                statement.bindLong(2, entity.getCasAssignmentUid());
                statement.bindLong(3, entity.getCasSubmitterUid());
                statement.bindLong(4, entity.getCasSubmitterPersonUid());
                if (entity.getCasText() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCasText());
                }
                statement.bindLong(6, (long)entity.getCasType());
                statement.bindLong(7, entity.getCasTimestamp());
                statement.bindLong(8, entity.getCasClazzUid());
            }
        };
        this.__updateAdapterOfCourseAssignmentSubmission = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseAssignmentSubmission` SET `casUid` = ?,`casAssignmentUid` = ?,`casSubmitterUid` = ?,`casSubmitterPersonUid` = ?,`casText` = ?,`casType` = ?,`casTimestamp` = ?,`casClazzUid` = ? WHERE `casUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseAssignmentSubmission entity) {
                statement.bindLong(1, entity.getCasUid());
                statement.bindLong(2, entity.getCasAssignmentUid());
                statement.bindLong(3, entity.getCasSubmitterUid());
                statement.bindLong(4, entity.getCasSubmitterPersonUid());
                if (entity.getCasText() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCasText());
                }
                statement.bindLong(6, (long)entity.getCasType());
                statement.bindLong(7, entity.getCasTimestamp());
                statement.bindLong(8, entity.getCasClazzUid());
                statement.bindLong(9, entity.getCasUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseAssignmentSubmission entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseAssignmentSubmission entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseAssignmentSubmissionDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseAssignmentSubmissionDao_Impl.this.__insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId((Object)entity);
                    CourseAssignmentSubmissionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseAssignmentSubmissionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseAssignmentSubmission> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseAssignmentSubmission.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<CourseAssignmentSubmission> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseAssignmentSubmissionDao_Impl.this.__db.beginTransaction();
                try {
                    CourseAssignmentSubmissionDao_Impl.this.__insertionAdapterOfCourseAssignmentSubmission.insert((Iterable)entityList);
                    CourseAssignmentSubmissionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseAssignmentSubmissionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(CourseAssignmentSubmission entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseAssignmentSubmission.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public PagingSource<Integer, CourseAssignmentSubmission> getAllSubmissionsFromSubmitter(long assignmentUid, long submitterUid) {
        String _sql = "\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n      ORDER BY casTimestamp DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n      ORDER BY casTimestamp DESC\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        return new LimitOffsetPagingSource<CourseAssignmentSubmission>(_statement, this.__db, new String[]{"CourseAssignmentSubmission"}){

            @NonNull
            protected List<CourseAssignmentSubmission> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casUid");
                int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casAssignmentUid");
                int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casSubmitterUid");
                int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casSubmitterPersonUid");
                int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casText");
                int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casType");
                int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casTimestamp");
                int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"casClazzUid");
                ArrayList<CourseAssignmentSubmission> _result2 = new ArrayList<CourseAssignmentSubmission>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpCasUid = cursor.getLong(_cursorIndexOfCasUid);
                    long _tmpCasAssignmentUid = cursor.getLong(_cursorIndexOfCasAssignmentUid);
                    long _tmpCasSubmitterUid = cursor.getLong(_cursorIndexOfCasSubmitterUid);
                    long _tmpCasSubmitterPersonUid = cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                    String _tmpCasText = cursor.isNull(_cursorIndexOfCasText) ? null : cursor.getString(_cursorIndexOfCasText);
                    int _tmpCasType = cursor.getInt(_cursorIndexOfCasType);
                    long _tmpCasTimestamp = cursor.getLong(_cursorIndexOfCasTimestamp);
                    long _tmpCasClazzUid = cursor.getLong(_cursorIndexOfCasClazzUid);
                    CourseAssignmentSubmission _item = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Flow<List<CourseAssignmentSubmission>> getAllSubmissionsForUser(long accountPersonUid, long assignmentUid) {
        String _sql = "\n         SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember"}, (Callable)new Callable<List<CourseAssignmentSubmission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmission> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    ArrayList<CourseAssignmentSubmission> _result2 = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        CourseAssignmentSubmission _item = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmission> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentSubmission>> getAllSubmissionsFromSubmitterAsFlow(long submitterUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = ?\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC      \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = ?\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC      \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission"}, (Callable)new Callable<List<CourseAssignmentSubmission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmission> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    ArrayList<CourseAssignmentSubmission> _result2 = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        CourseAssignmentSubmission _item = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmission> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getLatestSubmissionForUserAsync(long accountPersonUid, long assignmentUid, Continuation<? super CourseAssignmentSubmission> $completion) {
        String _sql = "\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n           AND CourseAssignmentSubmission.casAssignmentUid = ?\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n           AND CourseAssignmentSubmission.casAssignmentUid = ?\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseAssignmentSubmission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseAssignmentSubmission call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseAssignmentSubmission _result2;
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    if (_cursor.moveToFirst()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        _result2 = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                    } else {
                        _result2 = null;
                    }
                    CourseAssignmentSubmission courseAssignmentSubmission = _result2;
                    return courseAssignmentSubmission;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object doesUserHaveSubmissions(long accountPersonUid, long assignmentUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS\n               (SELECT CourseAssignmentSubmission.casUid\n                  FROM CourseAssignmentSubmission\n                 WHERE CourseAssignmentSubmission.casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND CourseAssignmentSubmission.casAssignmentUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS\n               (SELECT CourseAssignmentSubmission.casUid\n                  FROM CourseAssignmentSubmission\n                 WHERE CourseAssignmentSubmission.casSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n                   AND CourseAssignmentSubmission.casAssignmentUid = ?)\n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object countFileSubmissionFromStudent(long assignmentUid, long submitterUid, Continuation<? super Integer> $completion) {
        String _sql = "\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n           AND casType = 2\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n           AND casType = 2\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object countSubmissionsFromSubmitter(long assignmentUid, long submitterUid, Continuation<? super Integer> $completion) {
        String _sql = "\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = ?\n           AND casSubmitterUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Integer> getStatusOfAssignmentForSubmitter(long assignmentUid, long submitterUid) {
        String _sql = "\n           SELECT COALESCE((\n                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n                             THEN 2\n                             ELSE 1 \n                             END) AS status\n                  FROM CourseAssignmentSubmission\n                       \n                       LEFT JOIN CourseAssignmentMark\n                       ON CourseAssignmentMark.camAssignmentUid = ?\n                       AND CourseAssignmentMark.camSubmitterUid = ?\n                       \n                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                   AND CourseAssignmentSubmission.casSubmitterUid = ?\n                 LIMIT 1\n           ),0) AS Status\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n           SELECT COALESCE((\n                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n                             THEN 2\n                             ELSE 1 \n                             END) AS status\n                  FROM CourseAssignmentSubmission\n                       \n                       LEFT JOIN CourseAssignmentMark\n                       ON CourseAssignmentMark.camAssignmentUid = ?\n                       AND CourseAssignmentMark.camSubmitterUid = ?\n                       \n                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                   AND CourseAssignmentSubmission.casSubmitterUid = ?\n                 LIMIT 1\n           ),0) AS Status\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, submitterUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission", "CourseAssignmentMark"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findLastSubmissionFromStudent(long submitterUid, long assignmentUid, Continuation<? super CourseAssignmentSubmission> $completion) {
        String _sql = "\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = ?\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = ?\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, submitterUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseAssignmentSubmission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseAssignmentSubmission call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseAssignmentSubmission _result2;
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    if (_cursor.moveToFirst()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        _result2 = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                    } else {
                        _result2 = null;
                    }
                    CourseAssignmentSubmission courseAssignmentSubmission = _result2;
                    return courseAssignmentSubmission;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Boolean> checkNoSubmissionsMade(long assignmentUid) {
        String _sql = "\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object checkNoSubmissionsMadeAsync(long assignmentUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Boolean> checkNoSubmissionsMadeFlow(long assignmentUid) {
        String _sql = "\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n                       LIMIT 1)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<CourseAssignmentSubmission> findByUidAsFlow(long submissionUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE casUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, submissionUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission"}, (Callable)new Callable<CourseAssignmentSubmission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseAssignmentSubmission call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseAssignmentSubmission _result2;
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    if (_cursor.moveToFirst()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        _result2 = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                    } else {
                        _result2 = null;
                    }
                    CourseAssignmentSubmission courseAssignmentSubmission = _result2;
                    return courseAssignmentSubmission;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<CourseAssignmentSubmission>> findByAssignmentUidAndAccountPersonUid(long accountPersonUid, long assignmentUid) {
        String _sql = "\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = \n               (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseAssignmentSubmission.*\n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n           AND CourseAssignmentSubmission.casSubmitterUid = \n               (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentSubmission.casTimestamp DESC\n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseAssignmentSubmission", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember"}, (Callable)new Callable<List<CourseAssignmentSubmission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseAssignmentSubmission> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseAssignmentSubmissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casUid");
                    int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casAssignmentUid");
                    int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterUid");
                    int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casSubmitterPersonUid");
                    int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casText");
                    int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casType");
                    int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casTimestamp");
                    int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"casClazzUid");
                    ArrayList<CourseAssignmentSubmission> _result2 = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
                        long _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
                        long _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
                        long _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
                        String _tmpCasText = _cursor.isNull(_cursorIndexOfCasText) ? null : _cursor.getString(_cursorIndexOfCasText);
                        int _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
                        long _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
                        long _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
                        CourseAssignmentSubmission _item = new CourseAssignmentSubmission(_tmpCasUid, _tmpCasAssignmentUid, _tmpCasSubmitterUid, _tmpCasSubmitterPersonUid, _tmpCasText, _tmpCasType, _tmpCasTimestamp, _tmpCasClazzUid);
                        _result2.add(_item);
                    }
                    ArrayList<CourseAssignmentSubmission> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

