/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzLogDao;
import com.ustadmobile.lib.db.entities.ClazzLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ClazzLogDao_Impl
extends ClazzLogDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog;
    private final EntityInsertionAdapter<ClazzLog> __insertionAdapterOfClazzLog_1;
    private final EntityDeletionOrUpdateAdapter<ClazzLog> __updateAdapterOfClazzLog;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatusByClazzLogUid;

    public ClazzLogDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazzLog = new EntityInsertionAdapter<ClazzLog>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLog entity) {
                statement.bindLong(1, entity.getClazzLogUid());
                statement.bindLong(2, entity.getClazzLogClazzUid());
                statement.bindLong(3, entity.getLogDate());
                statement.bindLong(4, entity.getTimeRecorded());
                int _tmp = entity.getClazzLogDone() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                if (entity.getCancellationNote() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCancellationNote());
                }
                int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_1);
                statement.bindLong(8, (long)entity.getClazzLogNumPresent());
                statement.bindLong(9, (long)entity.getClazzLogNumAbsent());
                statement.bindLong(10, (long)entity.getClazzLogNumPartial());
                statement.bindLong(11, entity.getClazzLogScheduleUid());
                statement.bindLong(12, (long)entity.getClazzLogStatusFlag());
                statement.bindLong(13, entity.getClazzLogMSQN());
                statement.bindLong(14, entity.getClazzLogLCSN());
                statement.bindLong(15, (long)entity.getClazzLogLCB());
                statement.bindLong(16, entity.getClazzLogLastChangedTime());
            }
        };
        this.__insertionAdapterOfClazzLog_1 = new EntityInsertionAdapter<ClazzLog>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ClazzLog` (`clazzLogUid`,`clazzLogClazzUid`,`logDate`,`timeRecorded`,`clazzLogDone`,`cancellationNote`,`clazzLogCancelled`,`clazzLogNumPresent`,`clazzLogNumAbsent`,`clazzLogNumPartial`,`clazzLogScheduleUid`,`clazzLogStatusFlag`,`clazzLogMSQN`,`clazzLogLCSN`,`clazzLogLCB`,`clazzLogLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLog entity) {
                statement.bindLong(1, entity.getClazzLogUid());
                statement.bindLong(2, entity.getClazzLogClazzUid());
                statement.bindLong(3, entity.getLogDate());
                statement.bindLong(4, entity.getTimeRecorded());
                int _tmp = entity.getClazzLogDone() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                if (entity.getCancellationNote() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCancellationNote());
                }
                int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_1);
                statement.bindLong(8, (long)entity.getClazzLogNumPresent());
                statement.bindLong(9, (long)entity.getClazzLogNumAbsent());
                statement.bindLong(10, (long)entity.getClazzLogNumPartial());
                statement.bindLong(11, entity.getClazzLogScheduleUid());
                statement.bindLong(12, (long)entity.getClazzLogStatusFlag());
                statement.bindLong(13, entity.getClazzLogMSQN());
                statement.bindLong(14, entity.getClazzLogLCSN());
                statement.bindLong(15, (long)entity.getClazzLogLCB());
                statement.bindLong(16, entity.getClazzLogLastChangedTime());
            }
        };
        this.__updateAdapterOfClazzLog = new EntityDeletionOrUpdateAdapter<ClazzLog>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ClazzLog` SET `clazzLogUid` = ?,`clazzLogClazzUid` = ?,`logDate` = ?,`timeRecorded` = ?,`clazzLogDone` = ?,`cancellationNote` = ?,`clazzLogCancelled` = ?,`clazzLogNumPresent` = ?,`clazzLogNumAbsent` = ?,`clazzLogNumPartial` = ?,`clazzLogScheduleUid` = ?,`clazzLogStatusFlag` = ?,`clazzLogMSQN` = ?,`clazzLogLCSN` = ?,`clazzLogLCB` = ?,`clazzLogLastChangedTime` = ? WHERE `clazzLogUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLog entity) {
                statement.bindLong(1, entity.getClazzLogUid());
                statement.bindLong(2, entity.getClazzLogClazzUid());
                statement.bindLong(3, entity.getLogDate());
                statement.bindLong(4, entity.getTimeRecorded());
                int _tmp = entity.getClazzLogDone() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                if (entity.getCancellationNote() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCancellationNote());
                }
                int _tmp_1 = entity.getClazzLogCancelled() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_1);
                statement.bindLong(8, (long)entity.getClazzLogNumPresent());
                statement.bindLong(9, (long)entity.getClazzLogNumAbsent());
                statement.bindLong(10, (long)entity.getClazzLogNumPartial());
                statement.bindLong(11, entity.getClazzLogScheduleUid());
                statement.bindLong(12, (long)entity.getClazzLogStatusFlag());
                statement.bindLong(13, entity.getClazzLogMSQN());
                statement.bindLong(14, entity.getClazzLogLCSN());
                statement.bindLong(15, (long)entity.getClazzLogLCB());
                statement.bindLong(16, entity.getClazzLogLastChangedTime());
                statement.bindLong(17, entity.getClazzLogUid());
            }
        };
        this.__preparedStmtOfUpdateStatusByClazzLogUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE ClazzLog \n        SET clazzLogStatusFlag = ?,\n        clazzLogLastChangedTime = ?\n        WHERE clazzLogUid = ?";
                return "UPDATE ClazzLog \n        SET clazzLogStatusFlag = ?,\n        clazzLogLastChangedTime = ?\n        WHERE clazzLogUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ClazzLog entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzLog.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ClazzLog entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzLogDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzLogDao_Impl.this.__insertionAdapterOfClazzLog.insertAndReturnId((Object)entity);
                    ClazzLogDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzLogDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ClazzLog> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzLog.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replace(ClazzLog entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzLog_1.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsertListAsync(final List<? extends ClazzLog> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzLogDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzLogDao_Impl.this.__insertionAdapterOfClazzLog_1.insert((Iterable)entityList);
                    ClazzLogDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzLogDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(ClazzLog entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazzLog.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final ClazzLog clazzLog, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzLogDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzLogDao_Impl.this.__updateAdapterOfClazzLog.handle((Object)clazzLog);
                    ClazzLogDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzLogDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatusByClazzLogUid(long clazzLogUid, int newStatus, long timeChanged) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateStatusByClazzLogUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, timeChanged);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, clazzLogUid);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateStatusByClazzLogUid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClazzLog findByUid(long uid) {
        String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzLog WHERE clazzLogUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ClazzLog _result2;
            int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
            int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
            int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
            int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
            int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
            int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
            int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
            int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
            int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
            int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
            int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
            int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
            int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
            int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
            int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
            int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
            if (_cursor.moveToFirst()) {
                _result2 = new ClazzLog();
                long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                _result2.setClazzLogUid(_tmpClazzLogUid);
                long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                _result2.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                _result2.setLogDate(_tmpLogDate);
                long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                _result2.setTimeRecorded(_tmpTimeRecorded);
                int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                boolean _tmpClazzLogDone = _tmp != 0;
                _result2.setClazzLogDone(_tmpClazzLogDone);
                String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                _result2.setCancellationNote(_tmpCancellationNote);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                _result2.setClazzLogCancelled(_tmpClazzLogCancelled);
                int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                _result2.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                _result2.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                _result2.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                _result2.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                _result2.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                _result2.setClazzLogMSQN(_tmpClazzLogMSQN);
                long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                _result2.setClazzLogLCSN(_tmpClazzLogLCSN);
                int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                _result2.setClazzLogLCB(_tmpClazzLogLCB);
                long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                _result2.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
            } else {
                _result2 = null;
            }
            ClazzLog clazzLog = _result2;
            return clazzLog;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super ClazzLog> $completion) {
        String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzLog WHERE clazzLogUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzLog>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzLog call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzLog _result2;
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _result2.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _result2.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _result2.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _result2.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _result2.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _result2.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _result2.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _result2.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _result2.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _result2.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _result2.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _result2.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _result2.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _result2.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _result2.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _result2.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                    } else {
                        _result2 = null;
                    }
                    ClazzLog clazzLog = _result2;
                    return clazzLog;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ClazzLog> findByUidLive(long uid) {
        String _sql = "SELECT * FROM ClazzLog WHERE clazzLogUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzLog WHERE clazzLogUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzLog"}, (Callable)new Callable<ClazzLog>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzLog call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzLog _result2;
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _result2.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _result2.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _result2.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _result2.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _result2.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _result2.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _result2.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _result2.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _result2.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _result2.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _result2.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _result2.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _result2.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _result2.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _result2.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _result2.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                    } else {
                        _result2 = null;
                    }
                    ClazzLog clazzLog = _result2;
                    return clazzLog;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, ClazzLog> findByClazzUidAsFactory(long clazzUid, int excludeStatus) {
        String _sql = "\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE clazzLogClazzUid = ?\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE clazzLogClazzUid = ?\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate DESC\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)excludeStatus);
        return new LimitOffsetPagingSource<ClazzLog>(_statement, this.__db, new String[]{"ClazzLog"}){

            @NonNull
            protected List<ClazzLog> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogUid");
                int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogClazzUid");
                int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"logDate");
                int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"timeRecorded");
                int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogDone");
                int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cancellationNote");
                int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogCancelled");
                int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogNumPresent");
                int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogNumAbsent");
                int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogNumPartial");
                int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogScheduleUid");
                int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogStatusFlag");
                int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogMSQN");
                int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogLCSN");
                int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogLCB");
                int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"clazzLogLastChangedTime");
                ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(cursor.getCount());
                while (cursor.moveToNext()) {
                    ClazzLog _item = new ClazzLog();
                    long _tmpClazzLogUid = cursor.getLong(_cursorIndexOfClazzLogUid);
                    _item.setClazzLogUid(_tmpClazzLogUid);
                    long _tmpClazzLogClazzUid = cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                    _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                    long _tmpLogDate = cursor.getLong(_cursorIndexOfLogDate);
                    _item.setLogDate(_tmpLogDate);
                    long _tmpTimeRecorded = cursor.getLong(_cursorIndexOfTimeRecorded);
                    _item.setTimeRecorded(_tmpTimeRecorded);
                    int _tmp = cursor.getInt(_cursorIndexOfClazzLogDone);
                    boolean _tmpClazzLogDone = _tmp != 0;
                    _item.setClazzLogDone(_tmpClazzLogDone);
                    String _tmpCancellationNote = cursor.isNull(_cursorIndexOfCancellationNote) ? null : cursor.getString(_cursorIndexOfCancellationNote);
                    _item.setCancellationNote(_tmpCancellationNote);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfClazzLogCancelled);
                    boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                    _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                    int _tmpClazzLogNumPresent = cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                    _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                    int _tmpClazzLogNumAbsent = cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                    _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                    int _tmpClazzLogNumPartial = cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                    _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                    long _tmpClazzLogScheduleUid = cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                    _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                    int _tmpClazzLogStatusFlag = cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                    _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                    long _tmpClazzLogMSQN = cursor.getLong(_cursorIndexOfClazzLogMSQN);
                    _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                    long _tmpClazzLogLCSN = cursor.getLong(_cursorIndexOfClazzLogLCSN);
                    _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                    int _tmpClazzLogLCB = cursor.getInt(_cursorIndexOfClazzLogLCB);
                    _item.setClazzLogLCB(_tmpClazzLogLCB);
                    long _tmpClazzLogLastChangedTime = cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                    _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findByClazzUidAsync(long clazzUid, int excludeStatus, Continuation<? super List<? extends ClazzLog>> $completion) {
        String _sql = "\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE ClazzLog.clazzLogClazzUid = ?\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate ASC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE ClazzLog.clazzLogClazzUid = ?\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate ASC\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)excludeStatus);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzLog>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzLog> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzLog _item = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _item.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _item.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _item.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _item.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _item.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _item.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzLog> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllForClazzByClazzLogUid(long clazzLogUid, int excludeStatus, Continuation<? super List<? extends ClazzLog>> $completion) {
        String _sql = "\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE ClazzLog.clazzLogClazzUid = \n               (SELECT ClazzLogInner.clazzLogClazzUid\n                  FROM ClazzLog ClazzLogInner\n                 WHERE ClazzLogInner.clazzLogUid = ?)\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate ASC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzLog.* \n          FROM ClazzLog \n         WHERE ClazzLog.clazzLogClazzUid = \n               (SELECT ClazzLogInner.clazzLogClazzUid\n                  FROM ClazzLog ClazzLogInner\n                 WHERE ClazzLogInner.clazzLogUid = ?)\n           AND clazzLog.clazzLogStatusFlag != ?\n      ORDER BY ClazzLog.logDate ASC\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzLogUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)excludeStatus);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzLog>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzLog> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzLog _item = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _item.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _item.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _item.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _item.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _item.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _item.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzLog> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzUidWithinTimeRangeAsync(long clazzUid, long fromTime, long toTime, int excludeStatusFilter, int limit, Continuation<? super List<? extends ClazzLog>> $completion) {
        String _sql = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT ?\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, fromTime);
        _argIndex = 3;
        _statement.bindLong(_argIndex, toTime);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)limit);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzLog>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzLog> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzLog _item = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _item.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _item.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _item.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _item.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _item.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _item.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzLog> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClazzLog> findByClazzUidWithinTimeRange(long clazzUid, long fromTime, long toTime, int excludeStatusFilter, int limit) {
        String _sql = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT ?\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT ?\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, fromTime);
        _argIndex = 3;
        _statement.bindLong(_argIndex, toTime);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
            int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
            int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
            int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
            int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
            int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
            int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
            int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
            int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
            int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
            int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
            int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
            int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
            int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
            int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
            int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
            ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ClazzLog _item = new ClazzLog();
                long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                _item.setClazzLogUid(_tmpClazzLogUid);
                long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                _item.setLogDate(_tmpLogDate);
                long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                _item.setTimeRecorded(_tmpTimeRecorded);
                int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                boolean _tmpClazzLogDone = _tmp != 0;
                _item.setClazzLogDone(_tmpClazzLogDone);
                String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                _item.setCancellationNote(_tmpCancellationNote);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                _item.setClazzLogLCB(_tmpClazzLogLCB);
                long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                _result2.add(_item);
            }
            ArrayList<ClazzLog> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<List<ClazzLog>> findByClazzUidWithinTimeRangeLive(long clazzUid, long fromTime, long toTime, int statusFilter) {
        String _sql = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ClazzLog.clazzLogStatusFlag = ?)\n        ORDER BY ClazzLog.logDate\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = ? \n        AND ClazzLog.logDate BETWEEN ? AND ?\n        AND (? = 0 OR ClazzLog.clazzLogStatusFlag = ?)\n        ORDER BY ClazzLog.logDate\n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, fromTime);
        _argIndex = 3;
        _statement.bindLong(_argIndex, toTime);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)statusFilter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)statusFilter);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzLog"}, (Callable)new Callable<List<ClazzLog>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzLog> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogUid");
                    int _cursorIndexOfClazzLogClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogClazzUid");
                    int _cursorIndexOfLogDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logDate");
                    int _cursorIndexOfTimeRecorded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeRecorded");
                    int _cursorIndexOfClazzLogDone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogDone");
                    int _cursorIndexOfCancellationNote = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cancellationNote");
                    int _cursorIndexOfClazzLogCancelled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogCancelled");
                    int _cursorIndexOfClazzLogNumPresent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPresent");
                    int _cursorIndexOfClazzLogNumAbsent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumAbsent");
                    int _cursorIndexOfClazzLogNumPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogNumPartial");
                    int _cursorIndexOfClazzLogScheduleUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogScheduleUid");
                    int _cursorIndexOfClazzLogStatusFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogStatusFlag");
                    int _cursorIndexOfClazzLogMSQN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogMSQN");
                    int _cursorIndexOfClazzLogLCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCSN");
                    int _cursorIndexOfClazzLogLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLCB");
                    int _cursorIndexOfClazzLogLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogLastChangedTime");
                    ArrayList<ClazzLog> _result2 = new ArrayList<ClazzLog>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzLog _item = new ClazzLog();
                        long _tmpClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogUid);
                        _item.setClazzLogUid(_tmpClazzLogUid);
                        long _tmpClazzLogClazzUid = _cursor.getLong(_cursorIndexOfClazzLogClazzUid);
                        _item.setClazzLogClazzUid(_tmpClazzLogClazzUid);
                        long _tmpLogDate = _cursor.getLong(_cursorIndexOfLogDate);
                        _item.setLogDate(_tmpLogDate);
                        long _tmpTimeRecorded = _cursor.getLong(_cursorIndexOfTimeRecorded);
                        _item.setTimeRecorded(_tmpTimeRecorded);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzLogDone);
                        boolean _tmpClazzLogDone = _tmp != 0;
                        _item.setClazzLogDone(_tmpClazzLogDone);
                        String _tmpCancellationNote = _cursor.isNull(_cursorIndexOfCancellationNote) ? null : _cursor.getString(_cursorIndexOfCancellationNote);
                        _item.setCancellationNote(_tmpCancellationNote);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzLogCancelled);
                        boolean _tmpClazzLogCancelled = _tmp_1 != 0;
                        _item.setClazzLogCancelled(_tmpClazzLogCancelled);
                        int _tmpClazzLogNumPresent = _cursor.getInt(_cursorIndexOfClazzLogNumPresent);
                        _item.setClazzLogNumPresent(_tmpClazzLogNumPresent);
                        int _tmpClazzLogNumAbsent = _cursor.getInt(_cursorIndexOfClazzLogNumAbsent);
                        _item.setClazzLogNumAbsent(_tmpClazzLogNumAbsent);
                        int _tmpClazzLogNumPartial = _cursor.getInt(_cursorIndexOfClazzLogNumPartial);
                        _item.setClazzLogNumPartial(_tmpClazzLogNumPartial);
                        long _tmpClazzLogScheduleUid = _cursor.getLong(_cursorIndexOfClazzLogScheduleUid);
                        _item.setClazzLogScheduleUid(_tmpClazzLogScheduleUid);
                        int _tmpClazzLogStatusFlag = _cursor.getInt(_cursorIndexOfClazzLogStatusFlag);
                        _item.setClazzLogStatusFlag(_tmpClazzLogStatusFlag);
                        long _tmpClazzLogMSQN = _cursor.getLong(_cursorIndexOfClazzLogMSQN);
                        _item.setClazzLogMSQN(_tmpClazzLogMSQN);
                        long _tmpClazzLogLCSN = _cursor.getLong(_cursorIndexOfClazzLogLCSN);
                        _item.setClazzLogLCSN(_tmpClazzLogLCSN);
                        int _tmpClazzLogLCB = _cursor.getInt(_cursorIndexOfClazzLogLCB);
                        _item.setClazzLogLCB(_tmpClazzLogLCB);
                        long _tmpClazzLogLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogLastChangedTime);
                        _item.setClazzLogLastChangedTime(_tmpClazzLogLastChangedTime);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzLog> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<Boolean> clazzHasScheduleLive(long clazzUid, int excludeStatusFilter) {
        String _sql = "\n        SELECT EXISTS\n               (SELECT ClazzLog.clazzLogUid \n                  FROM ClazzLog \n                 WHERE clazzLogClazzUid = ? \n                 AND (? = 0 \n                      OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n               )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS\n               (SELECT ClazzLog.clazzLogUid \n                  FROM ClazzLog \n                 WHERE clazzLogClazzUid = ? \n                 AND (? = 0 \n                      OR ((ClazzLog.clazzLogStatusFlag & ?) = 0))\n               )\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)excludeStatusFilter);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzLog"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findMostRecentClazzLogToEditUid(long clazzUid, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT ClazzLog.clazzLogUid\n                  FROM ClazzLog\n                 WHERE ClazzLog.clazzLogClazzUid = ?\n                   AND (ClazzLog.clazzLogStatusFlag & 8) != 8\n              ORDER BY ClazzLog.logDate DESC\n                 LIMIT 1), 0)\n\n        \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT ClazzLog.clazzLogUid\n                  FROM ClazzLog\n                 WHERE ClazzLog.clazzLogClazzUid = ?\n                   AND (ClazzLog.clazzLogStatusFlag & 8) != 8\n              ORDER BY ClazzLog.logDate DESC\n                 LIMIT 1), 0)\n\n        \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

