/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPerson;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPersonDetailDetails;
import com.ustadmobile.lib.db.composites.CourseNameAndPersonName;
import com.ustadmobile.lib.db.composites.PersonAndClazzMemberListDetails;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithPerson;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import com.ustadmobile.lib.db.entities.LeavingReason;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ClazzEnrolmentDao_Impl
extends ClazzEnrolmentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ClazzEnrolment> __insertionAdapterOfClazzEnrolment;
    private final EntityDeletionOrUpdateAdapter<ClazzEnrolment> __updateAdapterOfClazzEnrolment;
    private final SharedSQLiteStatement __preparedStmtOfUpdateDateLeftByUid;
    private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment;
    private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentRole;
    private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentInviteUid;

    public ClazzEnrolmentDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazzEnrolment = new EntityInsertionAdapter<ClazzEnrolment>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ClazzEnrolment` (`clazzEnrolmentUid`,`clazzEnrolmentPersonUid`,`clazzEnrolmentClazzUid`,`clazzEnrolmentDateJoined`,`clazzEnrolmentDateLeft`,`clazzEnrolmentRole`,`clazzEnrolmentAttendancePercentage`,`clazzEnrolmentActive`,`clazzEnrolmentLeavingReasonUid`,`clazzEnrolmentOutcome`,`clazzEnrolmentLocalChangeSeqNum`,`clazzEnrolmentMasterChangeSeqNum`,`clazzEnrolmentLastChangedBy`,`clazzEnrolmentLct`,`clazzEnrolmentInviteUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzEnrolment entity) {
                statement.bindLong(1, entity.getClazzEnrolmentUid());
                statement.bindLong(2, entity.getClazzEnrolmentPersonUid());
                statement.bindLong(3, entity.getClazzEnrolmentClazzUid());
                statement.bindLong(4, entity.getClazzEnrolmentDateJoined());
                statement.bindLong(5, entity.getClazzEnrolmentDateLeft());
                statement.bindLong(6, (long)entity.getClazzEnrolmentRole());
                statement.bindDouble(7, (double)entity.getClazzEnrolmentAttendancePercentage());
                int _tmp = entity.getClazzEnrolmentActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                statement.bindLong(9, entity.getClazzEnrolmentLeavingReasonUid());
                statement.bindLong(10, (long)entity.getClazzEnrolmentOutcome());
                statement.bindLong(11, entity.getClazzEnrolmentLocalChangeSeqNum());
                statement.bindLong(12, entity.getClazzEnrolmentMasterChangeSeqNum());
                statement.bindLong(13, (long)entity.getClazzEnrolmentLastChangedBy());
                statement.bindLong(14, entity.getClazzEnrolmentLct());
                statement.bindLong(15, entity.getClazzEnrolmentInviteUid());
            }
        };
        this.__updateAdapterOfClazzEnrolment = new EntityDeletionOrUpdateAdapter<ClazzEnrolment>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ClazzEnrolment` SET `clazzEnrolmentUid` = ?,`clazzEnrolmentPersonUid` = ?,`clazzEnrolmentClazzUid` = ?,`clazzEnrolmentDateJoined` = ?,`clazzEnrolmentDateLeft` = ?,`clazzEnrolmentRole` = ?,`clazzEnrolmentAttendancePercentage` = ?,`clazzEnrolmentActive` = ?,`clazzEnrolmentLeavingReasonUid` = ?,`clazzEnrolmentOutcome` = ?,`clazzEnrolmentLocalChangeSeqNum` = ?,`clazzEnrolmentMasterChangeSeqNum` = ?,`clazzEnrolmentLastChangedBy` = ?,`clazzEnrolmentLct` = ?,`clazzEnrolmentInviteUid` = ? WHERE `clazzEnrolmentUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzEnrolment entity) {
                statement.bindLong(1, entity.getClazzEnrolmentUid());
                statement.bindLong(2, entity.getClazzEnrolmentPersonUid());
                statement.bindLong(3, entity.getClazzEnrolmentClazzUid());
                statement.bindLong(4, entity.getClazzEnrolmentDateJoined());
                statement.bindLong(5, entity.getClazzEnrolmentDateLeft());
                statement.bindLong(6, (long)entity.getClazzEnrolmentRole());
                statement.bindDouble(7, (double)entity.getClazzEnrolmentAttendancePercentage());
                int _tmp = entity.getClazzEnrolmentActive() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                statement.bindLong(9, entity.getClazzEnrolmentLeavingReasonUid());
                statement.bindLong(10, (long)entity.getClazzEnrolmentOutcome());
                statement.bindLong(11, entity.getClazzEnrolmentLocalChangeSeqNum());
                statement.bindLong(12, entity.getClazzEnrolmentMasterChangeSeqNum());
                statement.bindLong(13, (long)entity.getClazzEnrolmentLastChangedBy());
                statement.bindLong(14, entity.getClazzEnrolmentLct());
                statement.bindLong(15, entity.getClazzEnrolmentInviteUid());
                statement.bindLong(16, entity.getClazzEnrolmentUid());
            }
        };
        this.__preparedStmtOfUpdateDateLeftByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentDateLeft = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?";
                return "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentDateLeft = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?";
            }
        };
        this.__preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentActive = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?";
                return "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentActive = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?";
            }
        };
        this.__preparedStmtOfUpdateClazzEnrolmentRole = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n            UPDATE ClazzEnrolment \n               SET clazzEnrolmentRole = ?,\n                   clazzEnrolmentLct = ?      \n             -- Avoid potential for duplicate approvals if user was previously refused      \n             WHERE clazzEnrolmentUid = COALESCE( \n                    (SELECT clazzEnrolmentUid\n                       FROM ClazzEnrolment\n                      WHERE clazzEnrolmentPersonUid = ? \n                            AND clazzEnrolmentClazzUid = ?\n                            AND clazzEnrolmentRole = ?\n                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n                      LIMIT 1), 0)";
                return "\n            UPDATE ClazzEnrolment \n               SET clazzEnrolmentRole = ?,\n                   clazzEnrolmentLct = ?      \n             -- Avoid potential for duplicate approvals if user was previously refused      \n             WHERE clazzEnrolmentUid = COALESCE( \n                    (SELECT clazzEnrolmentUid\n                       FROM ClazzEnrolment\n                      WHERE clazzEnrolmentPersonUid = ? \n                            AND clazzEnrolmentClazzUid = ?\n                            AND clazzEnrolmentRole = ?\n                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n                      LIMIT 1), 0)";
            }
        };
        this.__preparedStmtOfUpdateClazzEnrolmentInviteUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n       UPDATE ClazzEnrolment \n          SET clazzEnrolmentInviteUid = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?\n    ";
                return "\n       UPDATE ClazzEnrolment \n          SET clazzEnrolmentInviteUid = ?,\n              clazzEnrolmentLct = ?\n        WHERE clazzEnrolmentUid = ?\n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ClazzEnrolment entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzEnrolment.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ClazzEnrolment entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzEnrolmentDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzEnrolmentDao_Impl.this.__insertionAdapterOfClazzEnrolment.insertAndReturnId((Object)entity);
                    ClazzEnrolmentDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ClazzEnrolment> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzEnrolment.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertListAsync(List<? extends ClazzEnrolment> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzEnrolment.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ClazzEnrolment entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazzEnrolment.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final ClazzEnrolment entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                ClazzEnrolmentDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzEnrolmentDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ClazzEnrolmentDao_Impl.this.__updateAdapterOfClazzEnrolment.handle((Object)entity);
                    return n;
                }
                finally {
                    ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateDateLeftByUid(final long clazzEnrolmentUid, final long endDate, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateDateLeftByUid.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, endDate);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, clazzEnrolmentUid);
                try {
                    Unit unit;
                    ClazzEnrolmentDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ClazzEnrolmentDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateDateLeftByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateClazzEnrolmentActiveForClazzEnrolment(long clazzEnrolmentUid, boolean enrolled, long timeChanged) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.acquire();
        int _argIndex = 1;
        int _tmp = enrolled ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, timeChanged);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, clazzEnrolmentUid);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result2 = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result2;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.release(_stmt);
        }
    }

    @Override
    public Object updateClazzEnrolmentRole(final long personUid, final long clazzUid, final int newRole, final int oldRole, final long updateTime, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateClazzEnrolmentRole.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)newRole);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, personUid);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, clazzUid);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)oldRole);
                try {
                    Integer n;
                    ClazzEnrolmentDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        ClazzEnrolmentDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateClazzEnrolmentRole.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateClazzEnrolmentInviteUid(final long clazzEnrolmentInviteUid, final long clazzEnrolmentUid, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateClazzEnrolmentInviteUid.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, clazzEnrolmentInviteUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, clazzEnrolmentUid);
                try {
                    Unit unit;
                    ClazzEnrolmentDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ClazzEnrolmentDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ClazzEnrolmentDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ClazzEnrolmentDao_Impl.this.__preparedStmtOfUpdateClazzEnrolmentInviteUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<ClazzEnrolmentWithLeavingReason>> findAllEnrolmentsByPersonAndClazzUid(long personUid, long clazzUid) {
        String _sql = "\n        SELECT ClazzEnrolment.*, LeavingReason.*, \n               COALESCE(Clazz.clazzTimeZone, 'UTC') as timeZone\n          FROM ClazzEnrolment \n               LEFT JOIN LeavingReason \n                         ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n               LEFT JOIN Clazz \n                         ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n         WHERE clazzEnrolmentPersonUid = ? \n           AND ClazzEnrolment.clazzEnrolmentActive \n           AND clazzEnrolmentClazzUid = ? \n      ORDER BY clazzEnrolmentDateLeft DESC\n           ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*, LeavingReason.*, \n               COALESCE(Clazz.clazzTimeZone, 'UTC') as timeZone\n          FROM ClazzEnrolment \n               LEFT JOIN LeavingReason \n                         ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n               LEFT JOIN Clazz \n                         ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n         WHERE clazzEnrolmentPersonUid = ? \n           AND ClazzEnrolment.clazzEnrolmentActive \n           AND clazzEnrolmentClazzUid = ? \n      ORDER BY clazzEnrolmentDateLeft DESC\n           ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "LeavingReason", "Clazz"}, (Callable)new Callable<List<ClazzEnrolmentWithLeavingReason>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolmentWithLeavingReason> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonUid");
                    int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonTitle");
                    int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonMCSN");
                    int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonCSN");
                    int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonLCB");
                    int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonLct");
                    int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeZone");
                    ArrayList<ClazzEnrolmentWithLeavingReason> _result2 = new ArrayList<ClazzEnrolmentWithLeavingReason>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        LeavingReason _tmpLeavingReason;
                        if (!(_cursor.isNull(_cursorIndexOfLeavingReasonUid) && _cursor.isNull(_cursorIndexOfLeavingReasonTitle) && _cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonLCB) && _cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
                            _tmpLeavingReason = new LeavingReason();
                            long _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
                            _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
                            String _tmpLeavingReasonTitle = _cursor.isNull(_cursorIndexOfLeavingReasonTitle) ? null : _cursor.getString(_cursorIndexOfLeavingReasonTitle);
                            _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
                            long _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
                            _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
                            long _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
                            _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
                            int _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
                            _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
                            long _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
                            _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
                        } else {
                            _tmpLeavingReason = null;
                        }
                        ClazzEnrolmentWithLeavingReason _item = new ClazzEnrolmentWithLeavingReason();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        String _tmpTimeZone = _cursor.isNull(_cursorIndexOfTimeZone) ? null : _cursor.getString(_cursorIndexOfTimeZone);
                        _item.setTimeZone(_tmpTimeZone);
                        _item.setLeavingReason(_tmpLeavingReason);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolmentWithLeavingReason> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findEnrolmentWithLeavingReason(long enrolmentUid, Continuation<? super ClazzEnrolmentWithLeavingReason> $completion) {
        String _sql = "\n            SELECT ClazzEnrolment.*, \n                   LeavingReason.*,\n                   COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n              FROM ClazzEnrolment \n                   LEFT JOIN LeavingReason \n                             ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n                   LEFT JOIN Clazz \n                             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n             WHERE ClazzEnrolment.clazzEnrolmentUid = ?\n             ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT ClazzEnrolment.*, \n                   LeavingReason.*,\n                   COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n              FROM ClazzEnrolment \n                   LEFT JOIN LeavingReason \n                             ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n                   LEFT JOIN Clazz \n                             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n             WHERE ClazzEnrolment.clazzEnrolmentUid = ?\n             ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, enrolmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzEnrolmentWithLeavingReason>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzEnrolmentWithLeavingReason call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzEnrolmentWithLeavingReason _result2;
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonUid");
                    int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonTitle");
                    int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonMCSN");
                    int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonCSN");
                    int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonLCB");
                    int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leavingReasonLct");
                    int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeZone");
                    if (_cursor.moveToFirst()) {
                        LeavingReason _tmpLeavingReason;
                        if (!(_cursor.isNull(_cursorIndexOfLeavingReasonUid) && _cursor.isNull(_cursorIndexOfLeavingReasonTitle) && _cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonLCB) && _cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
                            _tmpLeavingReason = new LeavingReason();
                            long _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
                            _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
                            String _tmpLeavingReasonTitle = _cursor.isNull(_cursorIndexOfLeavingReasonTitle) ? null : _cursor.getString(_cursorIndexOfLeavingReasonTitle);
                            _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
                            long _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
                            _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
                            long _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
                            _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
                            int _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
                            _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
                            long _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
                            _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
                        } else {
                            _tmpLeavingReason = null;
                        }
                        _result2 = new ClazzEnrolmentWithLeavingReason();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _result2.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _result2.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _result2.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _result2.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _result2.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _result2.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _result2.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _result2.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _result2.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _result2.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _result2.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _result2.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _result2.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _result2.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _result2.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        String _tmpTimeZone = _cursor.isNull(_cursorIndexOfTimeZone) ? null : _cursor.getString(_cursorIndexOfTimeZone);
                        _result2.setTimeZone(_tmpTimeZone);
                        _result2.setLeavingReason(_tmpLeavingReason);
                    } else {
                        _result2 = null;
                    }
                    ClazzEnrolmentWithLeavingReason clazzEnrolmentWithLeavingReason = _result2;
                    return clazzEnrolmentWithLeavingReason;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<ClazzEnrolmentAndPersonDetailDetails>> findAllClazzesByPersonWithClazz(long accountPersonUid, long otherPersonUid) {
        String _sql = "\n               /* List of all CoursePermissions that are granted to the person as per accountPersonUid */\n          WITH CoursePermissionsForAccountPerson AS (\n               \n        /* Get CoursePermissions given to the active user based on their enrolment role*/\n        SELECT CoursePermission.*\n          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n               JOIN CoursePermission \n                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n         UNION\n        /* Get ClazzUids where the active user can view members based a grant directly to them */\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpToPersonUid  = ?\n    ),\n               /* Check if CoursePermission for accountPersonUid grants view permission */\n               CanViewPersonUidViaCoursePermission(personUid) AS (\n                    SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                      FROM CoursePermissionsForAccountPerson\n                           JOIN ClazzEnrolment \n                                ON (CoursePermissionsForAccountPerson.cpPermissionsFlag & 8192) > 0\n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = CoursePermissionsForAccountPerson.cpClazzUid  \n                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?         \n               )     \n        SELECT ClazzEnrolment.*,\n               Clazz.*,\n               CourseTerminology.*\n          FROM ClazzEnrolment\n               JOIN Clazz \n                    ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n               LEFT JOIN CourseTerminology\n                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE (? != 0 AND ? != 0)\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n               /* Check that accountPersonUid has permission to see otherPerson */\n           AND (    (SELECT ? = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT ? IN \n                             (SELECT CanViewPersonUidViaCoursePermission.personUid\n                                 FROM CanViewPersonUidViaCoursePermission))           \n               ) \n              /* Check that accountPersonUid has permission to see related Clazz */\n          AND (     (SELECT ? = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            1\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (EXISTS(SELECT 1\n                              FROM CoursePermissionsForAccountPerson\n                             WHERE CoursePermissionsForAccountPerson.cpClazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n                               AND (CoursePermissionsForAccountPerson.cpPermissionsFlag & 1) > 0)) \n               )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n               /* List of all CoursePermissions that are granted to the person as per accountPersonUid */\n          WITH CoursePermissionsForAccountPerson AS (\n               \n        /* Get CoursePermissions given to the active user based on their enrolment role*/\n        SELECT CoursePermission.*\n          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n               JOIN CoursePermission \n                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n         UNION\n        /* Get ClazzUids where the active user can view members based a grant directly to them */\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpToPersonUid  = ?\n    ),\n               /* Check if CoursePermission for accountPersonUid grants view permission */\n               CanViewPersonUidViaCoursePermission(personUid) AS (\n                    SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                      FROM CoursePermissionsForAccountPerson\n                           JOIN ClazzEnrolment \n                                ON (CoursePermissionsForAccountPerson.cpPermissionsFlag & 8192) > 0\n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = CoursePermissionsForAccountPerson.cpClazzUid  \n                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?         \n               )     \n        SELECT ClazzEnrolment.*,\n               Clazz.*,\n               CourseTerminology.*\n          FROM ClazzEnrolment\n               JOIN Clazz \n                    ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n               LEFT JOIN CourseTerminology\n                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE (? != 0 AND ? != 0)\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n               /* Check that accountPersonUid has permission to see otherPerson */\n           AND (    (SELECT ? = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT ? IN \n                             (SELECT CanViewPersonUidViaCoursePermission.personUid\n                                 FROM CanViewPersonUidViaCoursePermission))           \n               ) \n              /* Check that accountPersonUid has permission to see related Clazz */\n          AND (     (SELECT ? = ?)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE ? != 0 \n                  AND SystemPermission.spToPersonUid = ?\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            1\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (EXISTS(SELECT 1\n                              FROM CoursePermissionsForAccountPerson\n                             WHERE CoursePermissionsForAccountPerson.cpClazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n                               AND (CoursePermissionsForAccountPerson.cpPermissionsFlag & 1) > 0)) \n               )\n    ", (int)15);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "CoursePermission", "Clazz", "CourseTerminology", "SystemPermission"}, (Callable)new Callable<List<ClazzEnrolmentAndPersonDetailDetails>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolmentAndPersonDetailDetails> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctUid");
                    int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTitle");
                    int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctTerminology");
                    int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctLct");
                    ArrayList<ClazzEnrolmentAndPersonDetailDetails> _result2 = new ArrayList<ClazzEnrolmentAndPersonDetailDetails>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseTerminology _tmpCourseTerminology;
                        Clazz _tmpClazz;
                        ClazzEnrolment _tmpEnrolment;
                        if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
                            _tmpEnrolment = new ClazzEnrolment();
                            long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                            _tmpEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                            long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                            _tmpEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                            long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                            _tmpEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                            long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                            _tmpEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                            long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                            _tmpEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                            int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                            _tmpEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                            float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                            _tmpEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                            int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                            boolean _tmpClazzEnrolmentActive = _tmp != 0;
                            _tmpEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                            long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                            _tmpEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                            int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                            _tmpEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                            long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                            _tmpEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                            long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                            _tmpEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                            int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                            _tmpEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                            long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                            _tmpEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                            long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                            _tmpEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        } else {
                            _tmpEnrolment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
                            _tmpClazz = new Clazz();
                            long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                            _tmpClazz.setClazzUid(_tmpClazzUid);
                            String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                            _tmpClazz.setClazzName(_tmpClazzName);
                            String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                            _tmpClazz.setClazzDesc(_tmpClazzDesc);
                            float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                            _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                            long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                            _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                            long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                            _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsClazzActive);
                            boolean _tmpIsClazzActive = _tmp_1 != 0;
                            _tmpClazz.setClazzActive(_tmpIsClazzActive);
                            long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                            _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                            long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                            _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                            long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                            _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                            long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                            _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                            long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                            _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                            int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                            _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                            long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                            _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                            long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                            _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                            long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                            _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                            int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                            _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                            long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                            _tmpClazz.setClazzLct(_tmpClazzLct);
                            String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                            _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                            long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                            _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                            long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                            _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                            long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                            _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                            long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                            _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                            String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                            _tmpClazz.setClazzCode(_tmpClazzCode);
                            long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                            _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        } else {
                            _tmpClazz = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
                            _tmpCourseTerminology = new CourseTerminology();
                            long _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
                            _tmpCourseTerminology.setCtUid(_tmpCtUid);
                            String _tmpCtTitle = _cursor.isNull(_cursorIndexOfCtTitle) ? null : _cursor.getString(_cursorIndexOfCtTitle);
                            _tmpCourseTerminology.setCtTitle(_tmpCtTitle);
                            String _tmpCtTerminology = _cursor.isNull(_cursorIndexOfCtTerminology) ? null : _cursor.getString(_cursorIndexOfCtTerminology);
                            _tmpCourseTerminology.setCtTerminology(_tmpCtTerminology);
                            long _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
                            _tmpCourseTerminology.setCtLct(_tmpCtLct);
                        } else {
                            _tmpCourseTerminology = null;
                        }
                        ClazzEnrolmentAndPersonDetailDetails _item = new ClazzEnrolmentAndPersonDetailDetails(_tmpEnrolment, _tmpClazz, _tmpCourseTerminology);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolmentAndPersonDetailDetails> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<ClazzEnrolment>> findAllByPersonUid(long personUid) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment"}, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findAllClazzesByPersonWithClazzAsListAsync(long personUid, Continuation<? super List<? extends ClazzEnrolmentWithClazz>> $completion) {
        String _sql = "SELECT ClazzEnrolment.*, Clazz.* \n        FROM ClazzEnrolment \n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ClazzEnrolment.*, Clazz.* \n        FROM ClazzEnrolment \n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolmentWithClazz>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolmentWithClazz> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzUid");
                    int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzName");
                    int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzDesc");
                    int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceAverage");
                    int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzHolidayUMCalendarUid");
                    int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzScheuleUMCalendarUid");
                    int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isClazzActive");
                    int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocationUid");
                    int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStartTime");
                    int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEndTime");
                    int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzFeatures");
                    int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzSchoolUid");
                    int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPolicy");
                    int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTerminologyUid");
                    int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzMasterChangeSeqNum");
                    int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLocalChangeSeqNum");
                    int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLastChangedBy");
                    int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLct");
                    int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTimeZone");
                    int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzStudentsPersonGroupUid");
                    int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzTeachersPersonGroupUid");
                    int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzPendingStudentsPersonGroupUid");
                    int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzParentsPersonGroupUid");
                    int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzCode");
                    int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzOwnerPersonUid");
                    ArrayList<ClazzEnrolmentWithClazz> _result2 = new ArrayList<ClazzEnrolmentWithClazz>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Clazz _tmpClazz;
                        if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
                            _tmpClazz = new Clazz();
                            long _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
                            _tmpClazz.setClazzUid(_tmpClazzUid);
                            String _tmpClazzName = _cursor.isNull(_cursorIndexOfClazzName) ? null : _cursor.getString(_cursorIndexOfClazzName);
                            _tmpClazz.setClazzName(_tmpClazzName);
                            String _tmpClazzDesc = _cursor.isNull(_cursorIndexOfClazzDesc) ? null : _cursor.getString(_cursorIndexOfClazzDesc);
                            _tmpClazz.setClazzDesc(_tmpClazzDesc);
                            float _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
                            _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
                            long _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
                            _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
                            long _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
                            _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
                            int _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
                            boolean _tmpIsClazzActive = _tmp != 0;
                            _tmpClazz.setClazzActive(_tmpIsClazzActive);
                            long _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
                            _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
                            long _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
                            _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
                            long _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
                            _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
                            long _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
                            _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
                            long _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
                            _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
                            int _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
                            _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
                            long _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
                            _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
                            long _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
                            _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
                            long _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
                            _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
                            int _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
                            _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
                            long _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
                            _tmpClazz.setClazzLct(_tmpClazzLct);
                            String _tmpClazzTimeZone = _cursor.isNull(_cursorIndexOfClazzTimeZone) ? null : _cursor.getString(_cursorIndexOfClazzTimeZone);
                            _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
                            long _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
                            _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
                            long _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
                            _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
                            long _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
                            _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
                            long _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
                            _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
                            String _tmpClazzCode = _cursor.isNull(_cursorIndexOfClazzCode) ? null : _cursor.getString(_cursorIndexOfClazzCode);
                            _tmpClazz.setClazzCode(_tmpClazzCode);
                            long _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
                            _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
                        } else {
                            _tmpClazz = null;
                        }
                        ClazzEnrolmentWithClazz _item = new ClazzEnrolmentWithClazz();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp_1 != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _item.setClazz(_tmpClazz);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolmentWithClazz> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllClazzEnrolledAtTimeAsync(long clazzUid, long date, int roleFilter, long personUidFilter, Continuation<? super List<ClazzEnrolmentWithPerson>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*, Person.*\n          FROM ClazzEnrolment\n                LEFT JOIN Person \n                          ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n              AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n              AND ClazzEnrolment.clazzEnrolmentDateLeft\n              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentRole = ?)\n              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*, Person.*\n          FROM ClazzEnrolment\n                LEFT JOIN Person \n                          ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n              AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n              AND ClazzEnrolment.clazzEnrolmentDateLeft\n              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentRole = ?)\n              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n    ", (int)6);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, date);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleFilter);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)roleFilter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, personUidFilter);
        _argIndex = 6;
        _statement.bindLong(_argIndex, personUidFilter);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolmentWithPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolmentWithPerson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    ArrayList<ClazzEnrolmentWithPerson> _result2 = new ArrayList<ClazzEnrolmentWithPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        ClazzEnrolmentWithPerson _item = new ClazzEnrolmentWithPerson();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp_3 != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _item.setPerson(_tmpPerson);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolmentWithPerson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllEnrolmentsAtTimeByClazzAndPerson(long clazzUid, long accountPersonUid, long time, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n           AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                         AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive              \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n           AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                         AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive              \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, time);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUid(long uid, Continuation<? super ClazzEnrolment> $completion) {
        String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzEnrolment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzEnrolment call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzEnrolment _result2;
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _result2.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _result2.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _result2.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _result2.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _result2.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _result2.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _result2.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _result2.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _result2.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _result2.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _result2.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _result2.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _result2.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _result2.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _result2.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                    } else {
                        _result2 = null;
                    }
                    ClazzEnrolment clazzEnrolment = _result2;
                    return clazzEnrolment;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ClazzEnrolment> findByUidLive(long uid) {
        String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment"}, (Callable)new Callable<ClazzEnrolment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzEnrolment call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ClazzEnrolment _result2;
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _result2.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _result2.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _result2.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _result2.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _result2.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _result2.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _result2.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _result2.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _result2.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _result2.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _result2.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _result2.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _result2.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _result2.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _result2.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                    } else {
                        _result2 = null;
                    }
                    ClazzEnrolment clazzEnrolment = _result2;
                    return clazzEnrolment;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRole(long clazzUid, int roleId, int sortOrder, String searchText, int filter, long accountPersonUid, long currentTime, long permission) {
        String _sql = "\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n                           AND (? != 1 \n                                 OR (? \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                        OR Person.personUid = ?\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(?)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(?)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n                           AND (? != 1 \n                                 OR (? \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                        OR Person.personUid = ?\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(?)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(?)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ", (int)19);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 18;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 19;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<PersonAndClazzMemberListDetails>(_statement, this.__db, new String[]{"ClazzEnrolment", "Person", "PersonPicture", "Clazz", "CoursePermission", "SystemPermission"}){

            @NonNull
            protected List<PersonAndClazzMemberListDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                int _cursorIndexOfEarliestJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"earliestJoinDate");
                int _cursorIndexOfLatestDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"latestDateLeft");
                int _cursorIndexOfEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"enrolmentRole");
                ArrayList<PersonAndClazzMemberListDetails> _result2 = new ArrayList<PersonAndClazzMemberListDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPersonPicture;
                    Person _tmpPerson;
                    long _tmpEarliestJoinDate = cursor.getLong(_cursorIndexOfEarliestJoinDate);
                    long _tmpLatestDateLeft = cursor.getLong(_cursorIndexOfLatestDateLeft);
                    int _tmpEnrolmentRole = cursor.getInt(_cursorIndexOfEnrolmentRole);
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_3 != 0;
                        _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPersonPicture = null;
                    }
                    PersonAndClazzMemberListDetails _item = new PersonAndClazzMemberListDetails(_tmpPerson, _tmpPersonPicture, _tmpEarliestJoinDate, _tmpLatestDateLeft, _tmpEnrolmentRole);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRoleForGradebook(long clazzUid, int roleId, int sortOrder, String searchText, int filter, long accountPersonUid, long currentTime) {
        String _sql = "\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                       --Dummy join so that invalidations of the StatementEntity table will trigger\n                       -- PagingSource invalidation of ClazzGradebookPagingSource\n                       LEFT JOIN StatementEntity\n                                 ON StatementEntity.statementIdHi = 0 \n                                    AND StatementEntity.statementIdLo = 0\n                       LEFT JOIN ActorEntity\n                                 ON ActorEntity.actorUid = 0\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n                           AND (? != 1 \n                                 OR (? \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                            \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                            \n        ) > 0)\n               )\n    )\n                        OR Person.personUid = ?\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(?)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(?)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                       --Dummy join so that invalidations of the StatementEntity table will trigger\n                       -- PagingSource invalidation of ClazzGradebookPagingSource\n                       LEFT JOIN StatementEntity\n                                 ON StatementEntity.statementIdHi = 0 \n                                    AND StatementEntity.statementIdLo = 0\n                       LEFT JOIN ActorEntity\n                                 ON ActorEntity.actorUid = 0\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n                           AND (? != 1 \n                                 OR (? \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                            \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                            \n        ) > 0)\n               )\n    )\n                        OR Person.personUid = ?\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(?)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(?)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(?)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(?)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ", (int)17);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 14;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 15;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<PersonAndClazzMemberListDetails>(_statement, this.__db, new String[]{"ClazzEnrolment", "Person", "PersonPicture", "StatementEntity", "ActorEntity", "Clazz", "CoursePermission", "SystemPermission"}){

            @NonNull
            protected List<PersonAndClazzMemberListDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                int _cursorIndexOfEarliestJoinDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"earliestJoinDate");
                int _cursorIndexOfLatestDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"latestDateLeft");
                int _cursorIndexOfEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"enrolmentRole");
                ArrayList<PersonAndClazzMemberListDetails> _result2 = new ArrayList<PersonAndClazzMemberListDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPersonPicture;
                    Person _tmpPerson;
                    long _tmpEarliestJoinDate = cursor.getLong(_cursorIndexOfEarliestJoinDate);
                    long _tmpLatestDateLeft = cursor.getLong(_cursorIndexOfLatestDateLeft);
                    int _tmpEnrolmentRole = cursor.getInt(_cursorIndexOfEnrolmentRole);
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_3 != 0;
                        _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPersonPicture = null;
                    }
                    PersonAndClazzMemberListDetails _item = new PersonAndClazzMemberListDetails(_tmpPerson, _tmpPersonPicture, _tmpEarliestJoinDate, _tmpLatestDateLeft, _tmpEnrolmentRole);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findActorEntitiesForGradebook(long clazzUid, int roleId, int sortOrder, String searchText, int filter, long accountPersonUid, long currentTime, int studentsLimit, int studentsOffset, Continuation<? super List<ActorEntity>> $completion) {
        String _sql = "\n          WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    \n          \n        \n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorPersonUid IN \n               (SELECT PersonUids.personUid\n                  FROM PersonUids)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    \n          \n        \n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorPersonUid IN \n               (SELECT PersonUids.personUid\n                  FROM PersonUids)\n    ", (int)19);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 14;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 15;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 18;
        _statement.bindLong(_argIndex, (long)studentsLimit);
        _argIndex = 19;
        _statement.bindLong(_argIndex, (long)studentsOffset);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActorEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActorEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorUid");
                    int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorPersonUid");
                    int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorName");
                    int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox");
                    int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorMbox_sha1sum");
                    int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorOpenid");
                    int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountName");
                    int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorAccountHomePage");
                    int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorEtag");
                    int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorLct");
                    int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"actorObjectType");
                    ArrayList<ActorEntity> _result2 = new ArrayList<ActorEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
                        long _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
                        String _tmpActorName = _cursor.isNull(_cursorIndexOfActorName) ? null : _cursor.getString(_cursorIndexOfActorName);
                        String _tmpActorMbox = _cursor.isNull(_cursorIndexOfActorMbox) ? null : _cursor.getString(_cursorIndexOfActorMbox);
                        String _tmpActorMbox_sha1sum = _cursor.isNull(_cursorIndexOfActorMboxSha1sum) ? null : _cursor.getString(_cursorIndexOfActorMboxSha1sum);
                        String _tmpActorOpenid = _cursor.isNull(_cursorIndexOfActorOpenid) ? null : _cursor.getString(_cursorIndexOfActorOpenid);
                        String _tmpActorAccountName = _cursor.isNull(_cursorIndexOfActorAccountName) ? null : _cursor.getString(_cursorIndexOfActorAccountName);
                        String _tmpActorAccountHomePage = _cursor.isNull(_cursorIndexOfActorAccountHomePage) ? null : _cursor.getString(_cursorIndexOfActorAccountHomePage);
                        long _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
                        long _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
                        int _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
                        ActorEntity _item = new ActorEntity(_tmpActorUid, _tmpActorPersonUid, _tmpActorName, _tmpActorMbox, _tmpActorMbox_sha1sum, _tmpActorOpenid, _tmpActorAccountName, _tmpActorAccountHomePage, _tmpActorEtag, _tmpActorLct, _tmpActorObjectType);
                        _result2.add(_item);
                    }
                    ArrayList<ActorEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findEnrolmentsAndPersonByClazzUidWithPermissionCheck(long clazzUid, long accountPersonUid, Continuation<? super List<ClazzEnrolmentAndPerson>> $completion) {
        String _sql = "\n       SELECT ClazzEnrolment.*,\n              Person.*,\n              PersonPicture.*\n         FROM ClazzEnrolment\n              JOIN Person\n                   ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n              LEFT JOIN PersonPicture\n                   ON PersonPicture.personPictureUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                   \n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n              /* Begin permission check*/\n          AND (\n                   ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n        \n                    8192\n                    \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                    8192\n                    \n        ) > 0)\n               )\n    )\n              )  \n              /* End permission check */\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n       SELECT ClazzEnrolment.*,\n              Person.*,\n              PersonPicture.*\n         FROM ClazzEnrolment\n              JOIN Person\n                   ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n              LEFT JOIN PersonPicture\n                   ON PersonPicture.personPictureUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                   \n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n              /* Begin permission check*/\n          AND (\n                   ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n        \n                    8192\n                    \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                    8192\n                    \n        ) > 0)\n               )\n    )\n              )  \n              /* End permission check */\n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolmentAndPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolmentAndPerson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<ClazzEnrolmentAndPerson> _result2 = new ArrayList<ClazzEnrolmentAndPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        ClazzEnrolment _tmpEnrolment;
                        if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
                            _tmpEnrolment = new ClazzEnrolment();
                            long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                            _tmpEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                            long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                            _tmpEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                            long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                            _tmpEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                            long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                            _tmpEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                            long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                            _tmpEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                            int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                            _tmpEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                            float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                            _tmpEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                            int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                            boolean _tmpClazzEnrolmentActive = _tmp != 0;
                            _tmpEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                            long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                            _tmpEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                            int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                            _tmpEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                            long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                            _tmpEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                            long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                            _tmpEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                            int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                            _tmpEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                            long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                            _tmpEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                            long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                            _tmpEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        } else {
                            _tmpEnrolment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_2 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_3 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_4 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        ClazzEnrolmentAndPerson _item = new ClazzEnrolmentAndPerson(_tmpPerson, _tmpEnrolment, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolmentAndPerson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByAccountPersonUidAndClazzUid(long accountPersonUid, long clazzUid, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findEnrolmentsByClazzUidAndRole(long clazzUid, long accountPersonUid, int roleId, long permission, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n          AND ClazzEnrolment.clazzEnrolmentRole = ?\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n              )  \n              /* End permission check */\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n          AND ClazzEnrolment.clazzEnrolmentRole = ?\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n              )  \n              /* End permission check */\n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findEnrolmentsByClazzUidAndRolePaged(long clazzUid, int roleId, int sortOrder, String searchText, int filter, long accountPersonUid, long currentTime, long permission, int studentsLimit, int studentsOffset, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n         WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    \n        \n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n          AND ClazzEnrolment.clazzEnrolmentRole = ?\n          AND ClazzEnrolment.clazzEnrolmentPersonUid IN (\n              SELECT PersonUids.personUid\n                FROM PersonUids)\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n              )  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n                               AND (? != 1 \n                                     OR (? \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = ?\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(?)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(?)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(?)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(?)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT ?\n            OFFSET ?   \n         )\n    \n        \n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n          AND ClazzEnrolment.clazzEnrolmentRole = ?\n          AND ClazzEnrolment.clazzEnrolmentPersonUid IN (\n              SELECT PersonUids.personUid\n                FROM PersonUids)\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n              )  \n    ", (int)30);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)filter);
        _argIndex = 5;
        _statement.bindLong(_argIndex, currentTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        if (searchText == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, searchText);
        }
        _argIndex = 14;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 15;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 16;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 17;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 18;
        _statement.bindLong(_argIndex, (long)studentsLimit);
        _argIndex = 19;
        _statement.bindLong(_argIndex, (long)studentsOffset);
        _argIndex = 20;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, (long)roleId);
        _argIndex = 22;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 24;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 25;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 26;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 27;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 28;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 29;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 30;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllEnrolmentsByClazzUidAndRole(long clazzUid, int roleId, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentRole = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n           AND ClazzEnrolment.clazzEnrolmentRole = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)roleId);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getClazzNameAndPersonName(long personUid, long clazzUid, Continuation<? super CourseNameAndPersonName> $completion) {
        String _sql = "\n        SELECT Person.firstNames, Person.lastName, Clazz.clazzName\n          FROM Person\n               LEFT JOIN Clazz\n                         ON Clazz.clazzUid = ?\n        WHERE Person.personUid = ?                 \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.firstNames, Person.lastName, Clazz.clazzName\n          FROM Person\n               LEFT JOIN Clazz\n                         ON Clazz.clazzUid = ?\n        WHERE Person.personUid = ?                 \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseNameAndPersonName>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseNameAndPersonName call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseNameAndPersonName _result2;
                    boolean _cursorIndexOfFirstNames = false;
                    boolean _cursorIndexOfLastName = true;
                    int _cursorIndexOfClazzName = 2;
                    if (_cursor.moveToFirst()) {
                        String _tmpFirstNames = _cursor.isNull(0) ? null : _cursor.getString(0);
                        String _tmpLastName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        String _tmpClazzName = _cursor.isNull(2) ? null : _cursor.getString(2);
                        _result2 = new CourseNameAndPersonName(_tmpClazzName, _tmpFirstNames, _tmpLastName);
                    } else {
                        _result2 = null;
                    }
                    CourseNameAndPersonName courseNameAndPersonName = _result2;
                    return courseNameAndPersonName;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findClazzEnrolmentEntitiesForPersonViewPermissionCheck(long accountPersonUid, long otherPersonUid, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n          WITH CanViewMembersClazzesViaCoursePermission(clazzUid) AS\n               /* Get clazzuids where active user can view members based on their own enrolment role */\n               (SELECT CoursePermission.cpClazzUid\n                  FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n                       JOIN CoursePermission \n                            ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                           AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n                 WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0 \n                UNION\n                /* Get ClazzUids where the active user can view members based a grant directly to them */\n                SELECT CoursePermission.cpClazzUid\n                  FROM CoursePermission\n                 WHERE CoursePermission.cpToPersonUid  = ?\n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n               )\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n            OR (    ClazzEnrolment.clazzEnrolmentClazzUid IN \n                        (SELECT CanViewMembersClazzesViaCoursePermission.clazzUid\n                           FROM CanViewMembersClazzesViaCoursePermission)\n                AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)   \n                )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n          WITH CanViewMembersClazzesViaCoursePermission(clazzUid) AS\n               /* Get clazzuids where active user can view members based on their own enrolment role */\n               (SELECT CoursePermission.cpClazzUid\n                  FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n                       JOIN CoursePermission \n                            ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                           AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n                 WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0 \n                UNION\n                /* Get ClazzUids where the active user can view members based a grant directly to them */\n                SELECT CoursePermission.cpClazzUid\n                  FROM CoursePermission\n                 WHERE CoursePermission.cpToPersonUid  = ?\n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n               )\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n            OR (    ClazzEnrolment.clazzEnrolmentClazzUid IN \n                        (SELECT CanViewMembersClazzesViaCoursePermission.clazzUid\n                           FROM CanViewMembersClazzesViaCoursePermission)\n                AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)   \n                )\n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, otherPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findClazzEnrolmentEntityForClazzEnrolmentInviteUid(long clazzEnrolmentInviteUid, Continuation<? super ClazzEnrolment> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentInviteUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentInviteUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzEnrolmentInviteUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ClazzEnrolment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ClazzEnrolment call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzEnrolmentDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ClazzEnrolment _result2;
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _result2.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _result2.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _result2.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _result2.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _result2.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _result2.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _result2.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _result2.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _result2.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _result2.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _result2.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _result2.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _result2.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _result2.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                        _result2.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                    } else {
                        _result2 = null;
                    }
                    ClazzEnrolment clazzEnrolment = _result2;
                    return clazzEnrolment;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

