/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.HolidayDao;
import com.ustadmobile.lib.db.entities.Holiday;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class HolidayDao_Impl
extends HolidayDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Holiday> __insertionAdapterOfHoliday;
    private final EntityDeletionOrUpdateAdapter<Holiday> __updateAdapterOfHoliday;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

    public HolidayDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHoliday = new EntityInsertionAdapter<Holiday>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Holiday` (`holUid`,`holMasterCsn`,`holLocalCsn`,`holLastModBy`,`holLct`,`holActive`,`holHolidayCalendarUid`,`holStartTime`,`holEndTime`,`holName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Holiday entity) {
                statement.bindLong(1, entity.getHolUid());
                statement.bindLong(2, entity.getHolMasterCsn());
                statement.bindLong(3, entity.getHolLocalCsn());
                statement.bindLong(4, (long)entity.getHolLastModBy());
                statement.bindLong(5, entity.getHolLct());
                int _tmp = entity.getHolActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
                statement.bindLong(7, entity.getHolHolidayCalendarUid());
                statement.bindLong(8, entity.getHolStartTime());
                statement.bindLong(9, entity.getHolEndTime());
                if (entity.getHolName() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getHolName());
                }
            }
        };
        this.__updateAdapterOfHoliday = new EntityDeletionOrUpdateAdapter<Holiday>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Holiday` SET `holUid` = ?,`holMasterCsn` = ?,`holLocalCsn` = ?,`holLastModBy` = ?,`holLct` = ?,`holActive` = ?,`holHolidayCalendarUid` = ?,`holStartTime` = ?,`holEndTime` = ?,`holName` = ? WHERE `holUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Holiday entity) {
                statement.bindLong(1, entity.getHolUid());
                statement.bindLong(2, entity.getHolMasterCsn());
                statement.bindLong(3, entity.getHolLocalCsn());
                statement.bindLong(4, (long)entity.getHolLastModBy());
                statement.bindLong(5, entity.getHolLct());
                int _tmp = entity.getHolActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
                statement.bindLong(7, entity.getHolHolidayCalendarUid());
                statement.bindLong(8, entity.getHolStartTime());
                statement.bindLong(9, entity.getHolEndTime());
                if (entity.getHolName() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getHolName());
                }
                statement.bindLong(11, entity.getHolUid());
            }
        };
        this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE Holiday \n           SET holActive = ?, \n               holLct = ?\n         WHERE holUid = ?";
                return "\n        UPDATE Holiday \n           SET holActive = ?, \n               holLct = ?\n         WHERE holUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Holiday entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfHoliday.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Holiday entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                HolidayDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = HolidayDao_Impl.this.__insertionAdapterOfHoliday.insertAndReturnId((Object)entity);
                    HolidayDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    HolidayDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Holiday> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHoliday.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<? extends Holiday> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                HolidayDao_Impl.this.__db.beginTransaction();
                try {
                    HolidayDao_Impl.this.__insertionAdapterOfHoliday.insert((Iterable)entityList);
                    HolidayDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HolidayDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateAsync(final Holiday entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                HolidayDao_Impl.this.__db.beginTransaction();
                try {
                    HolidayDao_Impl.this.__insertionAdapterOfHoliday.insert((Object)entity);
                    HolidayDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HolidayDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(Holiday entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfHoliday.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateListAsync(final List<? extends Holiday> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                HolidayDao_Impl.this.__db.beginTransaction();
                try {
                    HolidayDao_Impl.this.__updateAdapterOfHoliday.handleMultiple((Iterable)entityList);
                    HolidayDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    HolidayDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateActiveByUid(long holidayUid, boolean active, long changeTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, holidayUid);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Holiday> findByHolidayCalendaUid(long holidayCalendarUid) {
        String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, holidayCalendarUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holUid");
            int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holMasterCsn");
            int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLocalCsn");
            int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLastModBy");
            int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLct");
            int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holActive");
            int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holHolidayCalendarUid");
            int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holStartTime");
            int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holEndTime");
            int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holName");
            ArrayList<Holiday> _result2 = new ArrayList<Holiday>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Holiday _item = new Holiday();
                long _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
                _item.setHolUid(_tmpHolUid);
                long _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
                _item.setHolMasterCsn(_tmpHolMasterCsn);
                long _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
                _item.setHolLocalCsn(_tmpHolLocalCsn);
                int _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
                _item.setHolLastModBy(_tmpHolLastModBy);
                long _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
                _item.setHolLct(_tmpHolLct);
                int _tmp = _cursor.getInt(_cursorIndexOfHolActive);
                boolean _tmpHolActive = _tmp != 0;
                _item.setHolActive(_tmpHolActive);
                long _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
                _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
                long _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
                _item.setHolStartTime(_tmpHolStartTime);
                long _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
                _item.setHolEndTime(_tmpHolEndTime);
                String _tmpHolName = _cursor.isNull(_cursorIndexOfHolName) ? null : _cursor.getString(_cursorIndexOfHolName);
                _item.setHolName(_tmpHolName);
                _result2.add(_item);
            }
            ArrayList<Holiday> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByHolidayCalendaUidAsync(long holidayCalendarUid, Continuation<? super List<Holiday>> $completion) {
        String _sql = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Holiday WHERE holHolidayCalendarUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, holidayCalendarUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Holiday>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Holiday> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)HolidayDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfHolUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holUid");
                    int _cursorIndexOfHolMasterCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holMasterCsn");
                    int _cursorIndexOfHolLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLocalCsn");
                    int _cursorIndexOfHolLastModBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLastModBy");
                    int _cursorIndexOfHolLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holLct");
                    int _cursorIndexOfHolActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holActive");
                    int _cursorIndexOfHolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holHolidayCalendarUid");
                    int _cursorIndexOfHolStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holStartTime");
                    int _cursorIndexOfHolEndTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holEndTime");
                    int _cursorIndexOfHolName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"holName");
                    ArrayList<Holiday> _result2 = new ArrayList<Holiday>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Holiday _item = new Holiday();
                        long _tmpHolUid = _cursor.getLong(_cursorIndexOfHolUid);
                        _item.setHolUid(_tmpHolUid);
                        long _tmpHolMasterCsn = _cursor.getLong(_cursorIndexOfHolMasterCsn);
                        _item.setHolMasterCsn(_tmpHolMasterCsn);
                        long _tmpHolLocalCsn = _cursor.getLong(_cursorIndexOfHolLocalCsn);
                        _item.setHolLocalCsn(_tmpHolLocalCsn);
                        int _tmpHolLastModBy = _cursor.getInt(_cursorIndexOfHolLastModBy);
                        _item.setHolLastModBy(_tmpHolLastModBy);
                        long _tmpHolLct = _cursor.getLong(_cursorIndexOfHolLct);
                        _item.setHolLct(_tmpHolLct);
                        int _tmp = _cursor.getInt(_cursorIndexOfHolActive);
                        boolean _tmpHolActive = _tmp != 0;
                        _item.setHolActive(_tmpHolActive);
                        long _tmpHolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfHolHolidayCalendarUid);
                        _item.setHolHolidayCalendarUid(_tmpHolHolidayCalendarUid);
                        long _tmpHolStartTime = _cursor.getLong(_cursorIndexOfHolStartTime);
                        _item.setHolStartTime(_tmpHolStartTime);
                        long _tmpHolEndTime = _cursor.getLong(_cursorIndexOfHolEndTime);
                        _item.setHolEndTime(_tmpHolEndTime);
                        String _tmpHolName = _cursor.isNull(_cursorIndexOfHolName) ? null : _cursor.getString(_cursorIndexOfHolName);
                        _item.setHolName(_tmpHolName);
                        _result2.add(_item);
                    }
                    ArrayList<Holiday> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

