/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonAuthDao;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonAuth;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class PersonAuthDao_Impl
extends PersonAuthDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonAuth> __insertionAdapterOfPersonAuth;
    private final EntityDeletionOrUpdateAdapter<PersonAuth> __updateAdapterOfPersonAuth;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePasswordForPersonUid;

    public PersonAuthDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonAuth = new EntityInsertionAdapter<PersonAuth>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonAuth` (`personAuthUid`,`passwordHash`,`personAuthStatus`) VALUES (nullif(?, 0),?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonAuth entity) {
                statement.bindLong(1, entity.getPersonAuthUid());
                if (entity.getPasswordHash() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getPasswordHash());
                }
                statement.bindLong(3, (long)entity.getPersonAuthStatus());
            }
        };
        this.__updateAdapterOfPersonAuth = new EntityDeletionOrUpdateAdapter<PersonAuth>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PersonAuth` SET `personAuthUid` = ?,`passwordHash` = ?,`personAuthStatus` = ? WHERE `personAuthUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonAuth entity) {
                statement.bindLong(1, entity.getPersonAuthUid());
                if (entity.getPasswordHash() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getPasswordHash());
                }
                statement.bindLong(3, (long)entity.getPersonAuthStatus());
                statement.bindLong(4, entity.getPersonAuthUid());
            }
        };
        this.__preparedStmtOfUpdatePasswordForPersonUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "UPDATE PersonAuth set passwordHash = ?  WHERE personAuthUid = ?";
                return "UPDATE PersonAuth set passwordHash = ?  WHERE personAuthUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(PersonAuth entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPersonAuth.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final PersonAuth entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonAuthDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonAuthDao_Impl.this.__insertionAdapterOfPersonAuth.insertAndReturnId((Object)entity);
                    PersonAuthDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonAuthDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends PersonAuth> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPersonAuth.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PersonAuth entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPersonAuth.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final PersonAuth entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                PersonAuthDao_Impl.this.__db.beginTransaction();
                try {
                    PersonAuthDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PersonAuthDao_Impl.this.__updateAdapterOfPersonAuth.handle((Object)entity);
                    return n;
                }
                finally {
                    PersonAuthDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updatePasswordForPersonUid(final long personUid, final String passwordHash, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = PersonAuthDao_Impl.this.__preparedStmtOfUpdatePasswordForPersonUid.acquire();
                int _argIndex = 1;
                _stmt.bindString(_argIndex, passwordHash);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, personUid);
                try {
                    Integer n;
                    PersonAuthDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        PersonAuthDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        PersonAuthDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonAuthDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    PersonAuthDao_Impl.this.__preparedStmtOfUpdatePasswordForPersonUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super PersonAuth> $completion) {
        String _sql = "SELECT * FROM PersonAuth WHERE personAuthUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonAuth WHERE personAuthUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonAuth>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonAuth call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonAuthDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonAuth _result2;
                    int _cursorIndexOfPersonAuthUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAuthUid");
                    int _cursorIndexOfPasswordHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passwordHash");
                    int _cursorIndexOfPersonAuthStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAuthStatus");
                    if (_cursor.moveToFirst()) {
                        _result2 = new PersonAuth();
                        long _tmpPersonAuthUid = _cursor.getLong(_cursorIndexOfPersonAuthUid);
                        _result2.setPersonAuthUid(_tmpPersonAuthUid);
                        String _tmpPasswordHash = _cursor.isNull(_cursorIndexOfPasswordHash) ? null : _cursor.getString(_cursorIndexOfPasswordHash);
                        _result2.setPasswordHash(_tmpPasswordHash);
                        int _tmpPersonAuthStatus = _cursor.getInt(_cursorIndexOfPersonAuthStatus);
                        _result2.setPersonAuthStatus(_tmpPersonAuthStatus);
                    } else {
                        _result2 = null;
                    }
                    PersonAuth personAuth = _result2;
                    return personAuth;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersonAuth findByUid(long uid) {
        String _sql = "SELECT * FROM PersonAuth WHERE personAuthUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PersonAuth WHERE personAuthUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PersonAuth _result2;
            int _cursorIndexOfPersonAuthUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAuthUid");
            int _cursorIndexOfPasswordHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passwordHash");
            int _cursorIndexOfPersonAuthStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAuthStatus");
            if (_cursor.moveToFirst()) {
                _result2 = new PersonAuth();
                long _tmpPersonAuthUid = _cursor.getLong(_cursorIndexOfPersonAuthUid);
                _result2.setPersonAuthUid(_tmpPersonAuthUid);
                String _tmpPasswordHash = _cursor.isNull(_cursorIndexOfPasswordHash) ? null : _cursor.getString(_cursorIndexOfPasswordHash);
                _result2.setPasswordHash(_tmpPasswordHash);
                int _tmpPersonAuthStatus = _cursor.getInt(_cursorIndexOfPersonAuthStatus);
                _result2.setPersonAuthStatus(_tmpPersonAuthStatus);
            } else {
                _result2 = null;
            }
            PersonAuth personAuth = _result2;
            return personAuth;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Person findPersonByUsername(String username) {
        String _sql = "SELECT * FROM Person WHERE username = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Person WHERE username = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, username);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Person _result2;
            int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
            int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
            int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
            int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
            int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
            int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
            int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
            int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
            int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
            int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
            int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
            int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
            int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
            int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
            int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
            int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
            int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
            int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
            int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
            int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
            int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
            if (_cursor.moveToFirst()) {
                long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                int _tmp = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                boolean _tmpAdmin = _tmp_2 != 0;
                String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                _result2 = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
            } else {
                _result2 = null;
            }
            Person person = _result2;
            return person;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

