/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.RawQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.PersonAndPictureAndNumAttempts;
import com.ustadmobile.lib.db.composites.StatementReportRow;
import com.ustadmobile.lib.db.composites.xapi.SessionTimeAndProgressInfo;
import com.ustadmobile.lib.db.composites.xapi.StatementAndActivity;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndRelated;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndVerb;
import com.ustadmobile.lib.db.composites.xapi.VerbEntityAndName;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.StatementEntityAndDisplayDetails;
import com.ustadmobile.lib.db.entities.StatementReportData;
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import com.ustadmobile.lib.db.entities.xapi.StatementEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ \u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ8\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H'J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00a7@\u00a2\u0006\u0002\u0010\u001fJ(\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010#J4\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020%0\u00172\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0018H'J,\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010#J\\\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H'J2\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00042\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ2\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u00040/2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u000e\u001a\u00020\u0007H'J2\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00042\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u00102\u001a\u000203H\u00a7@\u00a2\u0006\u0002\u00104Jh\u00105\u001a\b\u0012\u0004\u0012\u0002010\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u00107\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u00182\u0006\u00102\u001a\u000203H\u00a7@\u00a2\u0006\u0002\u0010;J$\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010=\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ,\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010#J$\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ \u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020B0\u00172\n\u0010C\u001a\u00060Dj\u0002`EH'J\u0010\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110/H'J\n\u0010G\u001a\u0004\u0018\u00010HH'J \u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u00042\n\u0010C\u001a\u00060Dj\u0002`EH\u00a7@\u00a2\u0006\u0002\u0010KJ$\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ4\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0\u00040/2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H'J\u001c\u0010O\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H\u00a7@\u00a2\u0006\u0002\u0010RJ \u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u00042\n\u0010C\u001a\u00060Dj\u0002`EH\u00a7@\u00a2\u0006\u0002\u0010KJ$\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\t\u00a8\u0006V"}, d2={"Lcom/ustadmobile/core/db/dao/xapi/StatementDao;", "", "()V", "findActivityEntryLangMapsForStatementsBySession", "", "Lcom/ustadmobile/lib/db/entities/xapi/ActivityLangMapEntry;", "registrationHi", "", "registrationLo", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActorEntitiesForStudentInClazzByUidList", "Lcom/ustadmobile/lib/db/entities/xapi/ActorEntity;", "clazzUid", "studentPersonUids", "accountPersonUid", "(JLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findById", "Lcom/ustadmobile/lib/db/entities/xapi/StatementEntity;", "statementIdHi", "statementIdLo", "findByUidWithActivityAsync", "Lcom/ustadmobile/lib/db/composites/xapi/StatementAndActivity;", "findPersonsWithAttempts", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/composites/PersonAndPictureAndNumAttempts;", "contentEntryUid", "searchText", "", "sortOrder", "findPersonsWithAttemptsStatements", "(JJLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findResumableRegistration", "activityUid", "actorUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSessionsByPersonAndContent", "Lcom/ustadmobile/lib/db/composites/xapi/SessionTimeAndProgressInfo;", "personUid", "findSessionsByPersonAndContentStatements", "findStatementsBySession", "Lcom/ustadmobile/lib/db/composites/xapi/StatementEntityAndVerb;", "selectedPersonUid", "deSelectedVerbUids", "findStatusForStudentsInClazz", "Lcom/ustadmobile/lib/db/composites/BlockStatus;", "findStatusForStudentsInClazzAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findStatusForStudentsInClazzByUidList", "Lcom/ustadmobile/lib/db/composites/xapi/StatementEntityAndRelated;", "completionOrProgressTrueVal", "", "(JLjava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findStatusForStudentsInClazzStatements", "roleId", "filter", "currentTime", "studentsLimit", "studentsOffset", "(JIILjava/lang/String;IJJIIZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findStatusStatementByParentContentEntryUid", "parentUid", "findStatusStatementsByContentEntryUid", "courseBlockUid", "findStatusStatementsForStudentByClazzUid", "getListResults", "Lcom/ustadmobile/lib/db/entities/StatementEntityAndDisplayDetails;", "query", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Lcom/ustadmobile/door/DoorQuery;", "getOneStatement", "getPerson", "Lcom/ustadmobile/lib/db/entities/Person;", "getResults", "Lcom/ustadmobile/lib/db/entities/StatementReportData;", "(Landroidx/sqlite/db/SupportSQLiteQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatements", "getUniqueVerbsForSession", "Lcom/ustadmobile/lib/db/composites/xapi/VerbEntityAndName;", "insertOrIgnoreListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runReportQuery", "Lcom/ustadmobile/lib/db/composites/StatementReportRow;", "scoreOrProgressDataExistsForContent", "lib-database_release"})
@Dao
public abstract class StatementDao {
    @Insert(entity=Object.class, onConflict=5)
    @Nullable
    public abstract Object insertOrIgnoreListAsync(@NotNull List<StatementEntity> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * From StatementEntity LIMIT 1")
    @NotNull
    public abstract Flow<StatementEntity> getOneStatement();

    @RawQuery(observedEntities={})
    @Nullable
    public abstract Object runReportQuery(@NotNull SupportSQLiteQuery var1, @NotNull Continuation<? super List<StatementReportRow>> var2);

    @RawQuery(observedEntities={})
    @Nullable
    public abstract Object getResults(@NotNull SupportSQLiteQuery var1, @NotNull Continuation<? super List<StatementReportData>> var2);

    @RawQuery(observedEntities={StatementEntity.class, Person.class})
    @NotNull
    public abstract PagingSource<Integer, StatementEntityAndDisplayDetails> getListResults(@NotNull SupportSQLiteQuery var1);

    @Query(value="SELECT * FROM PERSON LIMIT 1")
    @Nullable
    public abstract Person getPerson();

    @Query(value="\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE (    (:statementIdHi = 0 AND :statementIdLo = 0) \n                 OR (statementIdHi = :statementIdHi AND statementIdLo = :statementIdLo))\n                  \n    ")
    @Nullable
    public abstract Object getStatements(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE statementIdHi = :statementIdHi \n           AND statementIdLo = :statementIdLo       \n    ")
    @Nullable
    public abstract Object findById(long var1, long var3, @NotNull Continuation<? super StatementEntity> var5);

    @Query(value="\n        SELECT StatementEntity.*\n               \n            \n          FROM StatementEntity\n         WHERE StatementEntity.statementActorPersonUid = :accountPersonUid\n           AND StatementEntity.statementContentEntryUid = :contentEntryUid\n           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n           AND (:courseBlockUid = 0 OR StatementEntity.statementCbUid = :courseBlockUid)\n    \n        AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))\n        \n        \n    \n    ")
    @Nullable
    public abstract Object findStatusStatementsByContentEntryUid(long var1, long var3, long var5, @NotNull Continuation<? super List<StatementEntity>> var7);

    @Query(value="\n        SELECT StatementEntity.*\n               \n        FROM StatementEntity\n       WHERE StatementEntity.statementActorPersonUid = :accountPersonUid\n         AND StatementEntity.statementContentEntryUid IN (\n             SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n               FROM ContentEntryParentChildJoin\n              WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid)\n         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n         AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))     \n    \n    ")
    @Nullable
    public abstract Object findStatusStatementByParentContentEntryUid(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT :accountPersonUid AS personUid\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT StatementEntity.*\n               \n               FROM StatementEntity\n              WHERE (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                AND StatementEntity.statementActorUid IN (\n                    SELECT ActorUidsForPersonUid.actorUid\n                      FROM ActorUidsForPersonUid)\n                AND StatementEntity.statementClazzUid = :clazzUid\n                AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n                      OR (StatementEntity.extensionProgress IS NOT NULL))\n    \n    ")
    @Nullable
    public abstract Object findStatusStatementsForStudentByClazzUid(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        -- Get the PersonUids for those that are within the current page as per studentsLimit and \n        -- studentsOffset\n        WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                               AND (:filter != 1 \n                                     OR (:currentTime \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = :accountPersonUid\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(:sortOrder)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(:sortOrder)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT :studentsLimit\n            OFFSET :studentsOffset   \n         )\n    ,\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n\n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = :clazzUid\n           AND StatementEntity.completionOrProgress = :completionOrProgressTrueVal\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazzStatements(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9, int var11, int var12, boolean var13, @NotNull Continuation<? super List<StatementEntityAndRelated>> var14);

    public static /* synthetic */ Object findStatusForStudentsInClazzStatements$default(StatementDao statementDao, long l, int n, int n2, String string, int n3, long l2, long l3, int n4, int n5, boolean bl, Continuation continuation, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findStatusForStudentsInClazzStatements");
        }
        if ((n6 & 8) != 0) {
            string = "%";
        }
        return statementDao.findStatusForStudentsInClazzStatements(l, n, n2, string, n3, l2, l3, n4, n5, bl, (Continuation<? super List<StatementEntityAndRelated>>)continuation);
    }

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT Person.personUid\n              FROM Person\n             WHERE Person.personUid IN (:studentPersonUids) \n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = :clazzUid\n           AND StatementEntity.completionOrProgress = :completionOrProgressTrueVal\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazzByUidList(long var1, @NotNull List<Long> var3, boolean var4, @NotNull Continuation<? super List<StatementEntityAndRelated>> var5);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT Person.personUid\n              FROM Person\n             WHERE Person.personUid IN (:studentPersonUids) \n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorPersonUid IN \n               (SELECT PersonUids.personUid\n                  FROM PersonUids)\n           AND :clazzUid = :clazzUid\n           AND :accountPersonUid = :accountPersonUid\n    ")
    @Nullable
    public abstract Object findActorEntitiesForStudentInClazzByUidList(long var1, @NotNull List<Long> var3, long var4, @NotNull Continuation<? super List<ActorEntity>> var6);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n             SELECT Person.personUid\n               FROM Person\n              WHERE Person.personUid IN (:studentPersonUids)\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    ,\n        \n        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (\n             SELECT Person.personUid AS personUid,\n                    CourseBlock.cbUid AS cbUid,\n                    CourseBlock.cbType AS cbType,\n                    ClazzAssignment.caMarkingType AS caMarkingType\n               FROM Person\n                    JOIN CourseBlock\n                         ON CourseBlock.cbClazzUid = :clazzUid\n                    LEFT JOIN ClazzAssignment\n                         ON CourseBlock.cbType = 103\n                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     \n              WHERE Person.personUid IN (:studentPersonUids)       \n        )\n        \n        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,\n               PersonUidsAndCourseBlocks.cbUid AS sCbUid,\n               (SELECT MAX(StatementEntity.extensionProgress)\n                  FROM StatementEntity\n                       \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                 WHERE \n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n     \n               ) AS sProgress,\n               (SELECT EXISTS(\n                       SELECT 1\n                         FROM StatementEntity\n                              \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                        WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n               )) AS sIsCompleted,\n               (SELECT CASE\n                       /*If there is a statement marked as success, then count as successful even if\n                        *there were subsequent failed attempts\n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n                                   )                           \n                       ) THEN 1\n                       /*If there are no statements marked as success, however there are statements marekd as fail,\n                        *then count as fail \n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n                                   )                           \n                       ) THEN 0\n                       /* Else there is no known success/fail result*/\n                       ELSE NULL\n                       END\n               ) AS sIsSuccess,\n               -- See ClazzGradebookScreen for info on which score is selected\n               (SELECT CASE\n                       -- When there is a peer marked assignment, take the average of the latest distinct ...\n                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103\n                              AND PersonUidsAndCourseBlocks.caMarkingType = 2\n                            ) \n                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                     AND StatementEntity.timestamp = (\n                                         SELECT MAX(StatementEntity_Inner.timestamp)\n                                           FROM StatementEntity StatementEntity_Inner\n                                                \n       JOIN ActorEntity ActorEntity_Inner\n            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid\n       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner\n            ON ActorEntity_Inner.actorObjectType = 2\n               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                          WHERE (\n            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity_Inner.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)\n                                   LIMIT 1)\n                       -- When an assignment, but not peer marked, then the latest score     \n                       WHEN PersonUidsAndCourseBlocks.cbType = 103\n                            THEN (SELECT StatementEntity.resultScoreScaled\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                ORDER BY StatementEntity.timestamp DESC\n                                   LIMIT 1)\n                       -- else the best score accomplished so far            \n                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) \n                               FROM StatementEntity\n                                    \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                              WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    ))            \n                       END\n               ) AS sScoreScaled\n          FROM PersonUidsAndCourseBlocks\n         WHERE :accountPersonUid = :accountPersonUid \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazz(long var1, @NotNull List<Long> var3, long var4, @NotNull Continuation<? super List<BlockStatus>> var6);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n             SELECT Person.personUid\n               FROM Person\n              WHERE Person.personUid IN (:studentPersonUids)\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    ,\n        \n        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (\n             SELECT Person.personUid AS personUid,\n                    CourseBlock.cbUid AS cbUid,\n                    CourseBlock.cbType AS cbType,\n                    ClazzAssignment.caMarkingType AS caMarkingType\n               FROM Person\n                    JOIN CourseBlock\n                         ON CourseBlock.cbClazzUid = :clazzUid\n                    LEFT JOIN ClazzAssignment\n                         ON CourseBlock.cbType = 103\n                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     \n              WHERE Person.personUid IN (:studentPersonUids)       \n        )\n        \n        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,\n               PersonUidsAndCourseBlocks.cbUid AS sCbUid,\n               (SELECT MAX(StatementEntity.extensionProgress)\n                  FROM StatementEntity\n                       \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                 WHERE \n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n     \n               ) AS sProgress,\n               (SELECT EXISTS(\n                       SELECT 1\n                         FROM StatementEntity\n                              \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                        WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n               )) AS sIsCompleted,\n               (SELECT CASE\n                       /*If there is a statement marked as success, then count as successful even if\n                        *there were subsequent failed attempts\n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n                                   )                           \n                       ) THEN 1\n                       /*If there are no statements marked as success, however there are statements marekd as fail,\n                        *then count as fail \n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n                                   )                           \n                       ) THEN 0\n                       /* Else there is no known success/fail result*/\n                       ELSE NULL\n                       END\n               ) AS sIsSuccess,\n               -- See ClazzGradebookScreen for info on which score is selected\n               (SELECT CASE\n                       -- When there is a peer marked assignment, take the average of the latest distinct ...\n                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103\n                              AND PersonUidsAndCourseBlocks.caMarkingType = 2\n                            ) \n                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                     AND StatementEntity.timestamp = (\n                                         SELECT MAX(StatementEntity_Inner.timestamp)\n                                           FROM StatementEntity StatementEntity_Inner\n                                                \n       JOIN ActorEntity ActorEntity_Inner\n            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid\n       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner\n            ON ActorEntity_Inner.actorObjectType = 2\n               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                          WHERE (\n            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity_Inner.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)\n                                   LIMIT 1)\n                       -- When an assignment, but not peer marked, then the latest score     \n                       WHEN PersonUidsAndCourseBlocks.cbType = 103\n                            THEN (SELECT StatementEntity.resultScoreScaled\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                ORDER BY StatementEntity.timestamp DESC\n                                   LIMIT 1)\n                       -- else the best score accomplished so far            \n                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) \n                               FROM StatementEntity\n                                    \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                              WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    ))            \n                       END\n               ) AS sScoreScaled\n          FROM PersonUidsAndCourseBlocks\n         WHERE :accountPersonUid = :accountPersonUid \n    ")
    @NotNull
    public abstract Flow<List<BlockStatus>> findStatusForStudentsInClazzAsFlow(long var1, @NotNull List<Long> var3, long var4);

    @Query(value="\n        WITH MostRecentRegistration(statementIdHi, statementIdLo, contextRegistrationHi, contextRegistrationLo) AS (\n             SELECT StatementEntity.statementIdHi, StatementEntity.contextRegistrationLo,\n                    StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n               FROM StatementEntity\n              WHERE StatementEntity.statementActorUid = :actorUid\n                AND StatementEntity.statementObjectUid1 = :activityUid\n                AND StatementEntity.contextRegistrationHi != 0\n           ORDER BY StatementEntity.timestamp DESC\n              LIMIT 1\n        )\n        \n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE StatementEntity.statementIdHi = (SELECT statementIdHi FROM MostRecentRegistration)\n           AND StatementEntity.statementIdLo = (SELECT statementIdLo FROM MostRecentRegistration)\n           AND NOT EXISTS(\n                   SELECT 1\n                     FROM StatementEntity StatementEntity_Inner\n                    WHERE StatementEntity_Inner.statementActorUid = :actorUid\n                      AND StatementEntity_Inner.statementObjectUid1 = :activityUid\n                      AND StatementEntity_Inner.contextRegistrationHi = (SELECT contextRegistrationHi FROM MostRecentRegistration)\n                      AND StatementEntity_Inner.contextRegistrationLo = (SELECT contextRegistrationLo FROM MostRecentRegistration)\n                      AND CAST(StatementEntity_Inner.completionOrProgress AS INTEGER) = 1\n                      AND (     StatementEntity_Inner.resultCompletion IS NOT NULL \n                            AND CAST(StatementEntity_Inner.resultCompletion AS INTEGER) = 1)\n                     )\n           AND :accountPersonUid IN \n               (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = :actorUid)          \n                     \n    ")
    @Nullable
    public abstract Object findResumableRegistration(long var1, long var3, long var5, @NotNull Continuation<? super StatementEntity> var7);

    @Query(value="\n        SELECT StatementEntity.*\n          FROM Person\n               JOIN StatementEntity\n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN\n                            (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                               FROM StatementEntity\n                              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                                AND StatementEntity.statementActorPersonUid = Person.personUid\n                                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           ORDER BY StatementEntity.extensionProgress DESC\n                              LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       ORDER BY StatementEntity.resultScoreScaled DESC\n                       LIMIT 1)\n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN    \n                          (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                       ORDER BY StatementEntity.timestamp DESC\n                       LIMIT 1)    \n         WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = :accountPersonUid\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   :searchText = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE :searchText) \n                          \n    ")
    @Nullable
    public abstract Object findPersonsWithAttemptsStatements(long var1, long var3, @Nullable String var5, @NotNull Continuation<? super List<StatementEntity>> var6);

    public static /* synthetic */ Object findPersonsWithAttemptsStatements$default(StatementDao statementDao, long l, long l2, String string, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPersonsWithAttemptsStatements");
        }
        if ((n & 4) != 0) {
            string = "%";
        }
        return statementDao.findPersonsWithAttemptsStatements(l, l2, string, (Continuation<? super List<StatementEntity>>)continuation);
    }

    @Query(value="\n     SELECT Person.*, PersonPicture.*,\n            (SELECT COUNT(*)\n               FROM (SELECT DISTINCT StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n                       FROM StatementEntity\n                      WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                        AND StatementEntity.statementActorPersonUid = Person.personUid\n                    ) AS DistinctRegistrations) AS numAttempts,\n            (SELECT EXISTS(\n                    SELECT 1\n                      FROM StatementEntity\n                     WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                       AND StatementEntity.statementActorPersonUid = Person.personUid\n                       AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                       AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1)) AS isCompleted,\n            (SELECT CASE\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                    WHEN EXISTS(\n                         SELECT 1\n                           FROM StatementEntity\n                          WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                            AND StatementEntity.statementActorPersonUid = Person.personUid\n                            AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                            AND StatementEntity.resultSuccess IS NOT NULL\n                            AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 0\n                    ELSE NULL\n                    END) AS isSuccessful,\n            (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxProgress,\n            (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    ) AS maxScore,\n            \n            (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    ) AS mostRecentAttemptTime    \n       FROM Person\n            LEFT JOIN PersonPicture\n                 ON PersonPicture.personPictureUid = Person.personUid\n      WHERE Person.personUid IN\n            (SELECT DISTINCT StatementEntity.statementActorPersonUid\n                    \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = :accountPersonUid\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    )      \n            AND (   :searchText = '%' \n                 OR Person.firstNames || ' ' || Person.lastName LIKE :searchText)\n     ORDER BY \n    CASE \n        WHEN :sortOrder = 5 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN :sortOrder = 7 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN :sortOrder = 9 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END ASC,\n    CASE \n        WHEN :sortOrder = 1 THEN Person.firstNames\n        WHEN :sortOrder = 3 THEN Person.lastName\n        ELSE ''\n    END ASC,    \n    CASE \n        WHEN :sortOrder = 6 THEN (\n             SELECT MAX(StatementEntity.resultScoreScaled)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN :sortOrder = 8 THEN (\n             SELECT MAX(StatementEntity.extensionProgress)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n                AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n    )\n        WHEN :sortOrder = 10 THEN (\n        SELECT MAX(StatementEntity.timestamp)\n               FROM StatementEntity\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                AND StatementEntity.statementActorPersonUid = Person.personUid\n    )\n        ELSE 0\n    END DESC,\n    CASE\n        WHEN :sortOrder = 2 THEN Person.firstNames\n        WHEN :sortOrder = 4 THEN Person.lastName\n    END DESC    \n")
    @NotNull
    public abstract PagingSource<Integer, PersonAndPictureAndNumAttempts> findPersonsWithAttempts(long var1, long var3, @Nullable String var5, int var6);

    public static /* synthetic */ PagingSource findPersonsWithAttempts$default(StatementDao statementDao, long l, long l2, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPersonsWithAttempts");
        }
        if ((n2 & 4) != 0) {
            string = "%";
        }
        return statementDao.findPersonsWithAttempts(l, l2, string, n);
    }

    @Query(value="\n        WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                  AND StatementEntity.statementActorPersonUid = :personUid)\n    \n        SELECT StatementEntity.*\n          FROM DistinctRegistrationUids\n               JOIN StatementEntity \n                    ON (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                        -- Statement for time started\n                        (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                           FROM StatementEntity\n                          WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                            AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                       ORDER BY StatementEntity.timestamp ASC\n                          LIMIT 1)\n                          \n                       --statement for max progress   \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.extensionProgress DESC\n                         LIMIT 1) \n                         \n                       --statement for max score  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                      ORDER BY StatementEntity.resultScoreScaled DESC\n                         LIMIT 1)\n                         \n                        --statement with completion  \n                    OR (StatementEntity.statementIdHi, StatementEntity.statementIdLo) IN \n                       (SELECT StatementEntity.statementIdHi, StatementEntity.statementIdLo \n                          FROM StatementEntity\n                         WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                           AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                           AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                         LIMIT 1)\n         WHERE (\n            :personUid = :accountPersonUid \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )\n    ")
    @Nullable
    public abstract Object findSessionsByPersonAndContentStatements(long var1, long var3, long var5, @NotNull Continuation<? super List<StatementEntity>> var7);

    @Query(value="\n WITH \n             DistinctRegistrationUids(contextRegistrationHi, contextRegistrationLo, statementClazzUid) AS (\n      SELECT DISTINCT StatementEntity.contextRegistrationHi, \n                     StatementEntity.contextRegistrationLo,\n                     StatementEntity.statementClazzUid\n                 FROM StatementEntity\n                WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                  AND StatementEntity.statementActorPersonUid = :personUid)\n    ,\n      SessionsByPerson(contextRegistrationHi, contextRegistrationLo, timeStarted, maxProgress, maxScore, isCompleted, isSuccessful, resultDuration) AS (\n       SELECT DistinctRegistrationUids.contextRegistrationHi AS contextRegistrationHi,\n              DistinctRegistrationUids.contextRegistrationLo AS contextRegistrationLo,\n              (SELECT MIN(StatementEntity.timestamp)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = :personUid\n                  AND StatementEntity.statementContentEntryUid = :contentEntryUid\n              ) AS timeStarted,\n              \n              (SELECT MAX(StatementEntity.extensionProgress)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = :personUid\n                  AND StatementEntity.statementContentEntryUid = :contentEntryUid\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxProgress,\n               \n              (SELECT MAX(StatementEntity.resultScoreScaled)\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                  AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                  AND StatementEntity.statementActorPersonUid = :personUid\n                  AND StatementEntity.statementContentEntryUid = :contentEntryUid\n                  AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n               ) AS maxScore,\n               \n              (SELECT EXISTS(\n                      SELECT 1 \n                        FROM StatementEntity\n                       WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                         AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                         AND StatementEntity.statementActorPersonUid = :personUid\n                         AND StatementEntity.statementContentEntryUid = :contentEntryUid\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                         AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n              )) AS isCompleted,\n              (SELECT CASE \n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = :personUid\n                              AND StatementEntity.statementContentEntryUid = :contentEntryUid\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1) THEN 1\n                      WHEN EXISTS(\n                           SELECT 1 \n                             FROM StatementEntity\n                            WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                              AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                              AND StatementEntity.statementActorPersonUid = :personUid\n                              AND StatementEntity.statementContentEntryUid = :contentEntryUid\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                              AND StatementEntity.resultSuccess IS NOT NULL\n                              AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0) THEN 0\n                      ELSE NULL\n                      END) AS isSuccessful,\n                      (SELECT MAX(StatementEntity.resultDuration)\n                         FROM StatementEntity\n                        WHERE StatementEntity.contextRegistrationHi = DistinctRegistrationUids.contextRegistrationHi\n                          AND StatementEntity.contextRegistrationLo = DistinctRegistrationUids.contextRegistrationLo\n                          AND StatementEntity.statementActorPersonUid = :personUid\n                          AND StatementEntity.statementContentEntryUid = :contentEntryUid) AS resultDuration\n         FROM DistinctRegistrationUids\n         WHERE (\n            :personUid = :accountPersonUid \n                OR EXISTS(\n                    SELECT CoursePermission.cpUid\n                      FROM CoursePermission\n                           LEFT JOIN ClazzEnrolment \n                                ON ClazzEnrolment.clazzEnrolmentUid =\n                                  COALESCE(\n                                   (SELECT ClazzEnrolment.clazzEnrolmentUid \n                                      FROM ClazzEnrolment\n                                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND ClazzEnrolment.clazzEnrolmentActive\n                                       AND ClazzEnrolment.clazzEnrolmentClazzUid = DistinctRegistrationUids.statementClazzUid \n                                  ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0)\n                     WHERE CoursePermission.cpClazzUid = DistinctRegistrationUids.statementClazzUid\n                       AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                            OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                       AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                       AND NOT CoursePermission.cpIsDeleted)\n                OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                    128\n                    \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n    )) \n      SELECT SessionsByPerson.*\n        FROM SessionsByPerson\n    ORDER BY  \n        CASE :sortOrder\n            WHEN 1 THEN timeStarted\n            ELSE NULL\n        END DESC,\n        CASE :sortOrder\n            WHEN 2 THEN timeStarted\n            ELSE NULL\n        END ASC,\n        CASE :sortOrder\n            WHEN 4 THEN maxScore\n            ELSE NULL\n        END DESC,\n        CASE :sortOrder\n            WHEN 3 THEN maxScore\n            ELSE NULL\n        END ASC,\n        CASE :sortOrder\n            WHEN 6 THEN maxProgress\n            ELSE NULL\n        END DESC,\n        CASE :sortOrder\n            WHEN 5 THEN maxProgress\n            ELSE NULL\n        END ASC\n   ")
    @NotNull
    public abstract PagingSource<Integer, SessionTimeAndProgressInfo> findSessionsByPersonAndContent(long var1, long var3, long var5, int var7);

    @Query(value="\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid IN (\n               SELECT DISTINCT StatementEntity.statementObjectUid1\n                 FROM StatementEntity\n                WHERE StatementEntity.contextRegistrationHi = :registrationHi\n                  AND StatementEntity.contextRegistrationLo = :registrationLo)\n    ")
    @Nullable
    public abstract Object findActivityEntryLangMapsForStatementsBySession(long var1, long var3, @NotNull Continuation<? super List<ActivityLangMapEntry>> var5);

    @Query(value="\n    SELECT StatementEntity.*, VerbEntity.*, VerbLangMapEntry.*, ActivityEntity.*,\n           ActivityLangMapEntry.*,\n           ActivityLangMapDescription.almeValue AS statementActivityDescription\n    FROM StatementEntity\n    LEFT JOIN VerbEntity\n        ON StatementEntity.statementVerbUid = VerbEntity.verbUid\n    LEFT JOIN VerbLangMapEntry \n        ON (VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash) = \n            (SELECT VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash\n            FROM VerbLangMapEntry\n            WHERE VerbLangMapEntry.vlmeVerbUid = VerbEntity.verbUid\n            ORDER BY VerbLangMapEntry.vlmeLastModified DESC\n            LIMIT 1)\n    LEFT JOIN ActivityEntity\n              ON ActivityEntity.actUid = StatementEntity.statementObjectUid1\n    LEFT JOIN ActivityLangMapEntry\n              ON (ActivityLangMapEntry.almeActivityUid, ActivityLangMapEntry.almeHash) = \n                 (SELECT ActivityLangMapEntry.almeActivityUid, ActivityLangMapEntry.almeHash\n                    FROM ActivityLangMapEntry\n                   WHERE ActivityLangMapEntry.almeActivityUid = StatementEntity.statementObjectUid1\n                     AND ActivityLangMapEntry.almePropName = 'name'\n                   LIMIT 1)\n    LEFT JOIN ActivityLangMapEntry ActivityLangMapDescription\n              ON (ActivityLangMapDescription.almeActivityUid, ActivityLangMapDescription.almeHash) = \n                 (SELECT ActivityLangMapDescription.almeActivityUid, ActivityLangMapDescription.almeHash\n                    FROM ActivityLangMapEntry ActivityLangMapDescription\n                   WHERE ActivityLangMapDescription.almeActivityUid = StatementEntity.statementObjectUid1\n                     AND ActivityLangMapDescription.almePropName = 'description'\n                   LIMIT 1)\n    LEFT JOIN ClazzEnrolment \n        ON ClazzEnrolment.clazzEnrolmentUid =\n            COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentUid \n                FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentActive\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                LIMIT 1), 0)\n    WHERE StatementEntity.contextRegistrationHi = :registrationHi\n    AND StatementEntity.contextRegistrationLo = :registrationLo  \n    AND StatementEntity.statementActorPersonUid = :selectedPersonUid\n    AND StatementEntity.statementContentEntryUid = :contentEntryUid\n    AND (:searchText = '%' OR VerbEntity.verbUrlId LIKE :searchText)\n    AND StatementEntity.statementVerbUid NOT IN (:deSelectedVerbUids)\n    /* Permission check */\n    AND (\n        :accountPersonUid = :selectedPersonUid \n        OR EXISTS(\n            SELECT CoursePermission.cpUid\n            FROM CoursePermission\n            WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n            AND (\n                CoursePermission.cpToPersonUid = :accountPersonUid \n                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole\n            )\n            AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n            AND NOT CoursePermission.cpIsDeleted\n        )\n        OR (\n            \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n            128\n            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    \n        )\n    )\n    ORDER BY \n    CASE :sortOrder\n        WHEN 1 THEN StatementEntity.timestamp\n        ELSE NULL\n    END DESC,\n    CASE :sortOrder\n        WHEN 2 THEN StatementEntity.timestamp\n        ELSE NULL\n    END ASC,\n    CASE :sortOrder\n        WHEN 3 THEN StatementEntity.resultScoreRaw\n        ELSE NULL\n    END DESC,\n    CASE :sortOrder\n        WHEN 4 THEN StatementEntity.resultScoreRaw\n        ELSE NULL\n    END ASC\n")
    @NotNull
    public abstract PagingSource<Integer, StatementEntityAndVerb> findStatementsBySession(long var1, long var3, long var5, long var7, long var9, @NotNull String var11, int var12, @NotNull List<Long> var13);

    public static /* synthetic */ PagingSource findStatementsBySession$default(StatementDao statementDao, long l, long l2, long l3, long l4, long l5, String string, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findStatementsBySession");
        }
        if ((n2 & 0x20) != 0) {
            string = "%";
        }
        return statementDao.findStatementsBySession(l, l2, l3, l4, l5, string, n, list);
    }

    @Query(value="\n    WITH DistinctVerbUrls(statementVerbUid) AS (\n        SELECT DISTINCT StatementEntity.statementVerbUid\n        FROM StatementEntity\n        WHERE StatementEntity.contextRegistrationHi = :registrationHi\n            AND StatementEntity.contextRegistrationLo = :registrationLo\n            AND StatementEntity.statementActorPersonUid = :selectedPersonUid\n            AND StatementEntity.statementContentEntryUid = :contentEntryUid\n    )\n    \n    SELECT VerbEntity.*,\n           VerbLangMapEntry.*\n    FROM DistinctVerbUrls\n         JOIN VerbEntity \n              ON VerbEntity.verbUid = DistinctVerbUrls.statementVerbUid\n         LEFT JOIN VerbLangMapEntry\n                  ON (VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash) = \n                     (SELECT VerbLangMapEntry.vlmeVerbUid, VerbLangMapEntry.vlmeLangHash\n                      FROM VerbLangMapEntry\n                      WHERE VerbLangMapEntry.vlmeVerbUid = DistinctVerbUrls.statementVerbUid\n                      ORDER BY VerbLangMapEntry.vlmeLastModified DESC\n                      LIMIT 1)\n")
    @NotNull
    public abstract Flow<List<VerbEntityAndName>> getUniqueVerbsForSession(long var1, long var3, long var5, long var7);

    @Query(value="\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = :accountPersonUid\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.extensionProgress IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ProgressStatements\n        UNION\n        SELECT * \n          FROM (SELECT StatementEntity.*\n                 \n        FROM StatementEntity\n                    LEFT JOIN ClazzEnrolment \n                         ON ClazzEnrolment.clazzEnrolmentUid =\n                           COALESCE(\n                            (SELECT ClazzEnrolment.clazzEnrolmentUid \n                               FROM ClazzEnrolment\n                              WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                                AND ClazzEnrolment.clazzEnrolmentActive\n                                AND ClazzEnrolment.clazzEnrolmentClazzUid = StatementEntity.statementClazzUid \n                           ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n                              LIMIT 1), 0)\n              WHERE StatementEntity.statementContentEntryUid = :contentEntryUid\n                /* permission check */\n                AND (    StatementEntity.statementActorPersonUid = :accountPersonUid\n                      OR EXISTS(SELECT CoursePermission.cpUid\n                                  FROM CoursePermission\n                                 WHERE CoursePermission.cpClazzUid = StatementEntity.statementClazzUid\n                                   AND (   CoursePermission.cpToPersonUid = :accountPersonUid \n                                        OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n                                   AND (CoursePermission.cpPermissionsFlag & 128) > 0 \n                                   AND NOT CoursePermission.cpIsDeleted)\n                      OR (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                          128\n                          \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ))\n    \n                   AND (     StatementEntity.resultScoreScaled IS NOT NULL\n                         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                 LIMIT 1) AS ScoreStatements\n    ")
    @Nullable
    public abstract Object scoreOrProgressDataExistsForContent(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        SELECT StatementEntity.*, ActivityEntity.*\n          FROM StatementEntity\n               LEFT JOIN ActivityEntity\n                         ON ActivityEntity.actUid = StatementEntity.statementObjectUid1\n         WHERE StatementEntity.statementIdHi = :statementIdHi\n           AND StatementEntity.statementIdLo = :statementIdLo\n    ")
    @Nullable
    public abstract Object findByUidWithActivityAsync(long var1, long var3, @NotNull Continuation<? super StatementAndActivity> var5);
}

