/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CoursePermissionDao;
import com.ustadmobile.lib.db.composites.AssignmentPermissionAndActiveUserSubmitterUid;
import com.ustadmobile.lib.db.composites.CoursePermissionAndEnrolment;
import com.ustadmobile.lib.db.composites.CoursePermissionAndListDetail;
import com.ustadmobile.lib.db.composites.PermissionPair;
import com.ustadmobile.lib.db.composites.PermissionTriple;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CoursePermission;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CoursePermissionDao_Impl
extends CoursePermissionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CoursePermission> __insertionAdapterOfCoursePermission;
    private final SharedSQLiteStatement __preparedStmtOfSetDeleted;

    public CoursePermissionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCoursePermission = new EntityInsertionAdapter<CoursePermission>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CoursePermission` (`cpUid`,`cpLastModified`,`cpClazzUid`,`cpToEnrolmentRole`,`cpToPersonUid`,`cpToGroupUid`,`cpPermissionsFlag`,`cpIsDeleted`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CoursePermission entity) {
                statement.bindLong(1, entity.getCpUid());
                statement.bindLong(2, entity.getCpLastModified());
                statement.bindLong(3, entity.getCpClazzUid());
                statement.bindLong(4, (long)entity.getCpToEnrolmentRole());
                statement.bindLong(5, entity.getCpToPersonUid());
                statement.bindLong(6, entity.getCpToGroupUid());
                statement.bindLong(7, entity.getCpPermissionsFlag());
                int _tmp = entity.getCpIsDeleted() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
            }
        };
        this.__preparedStmtOfSetDeleted = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CoursePermission\n           SET cpIsDeleted = ?,\n               cpLastModified = ?\n         WHERE cpUid = ?  \n    ";
                return "\n        UPDATE CoursePermission\n           SET cpIsDeleted = ?,\n               cpLastModified = ?\n         WHERE cpUid = ?  \n    ";
            }
        };
    }

    @Override
    public Object upsertAsync(final CoursePermission coursePermission, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CoursePermissionDao_Impl.this.__db.beginTransaction();
                try {
                    CoursePermissionDao_Impl.this.__insertionAdapterOfCoursePermission.insert((Object)coursePermission);
                    CoursePermissionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CoursePermissionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object setDeleted(final long cpUid, final boolean isDeleted, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CoursePermissionDao_Impl.this.__preparedStmtOfSetDeleted.acquire();
                int _argIndex = 1;
                int _tmp = isDeleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cpUid);
                try {
                    Unit unit;
                    CoursePermissionDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CoursePermissionDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CoursePermissionDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CoursePermissionDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CoursePermissionDao_Impl.this.__preparedStmtOfSetDeleted.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, CoursePermissionAndListDetail> findByClazzUidAsPagingSource(long clazzUid, boolean includeDeleted) {
        String _sql = "\n        SELECT CoursePermission.*, Person.*, PersonPicture.*\n          FROM CoursePermission\n               LEFT JOIN Person\n                         ON Person.personUid = CoursePermission.cpToPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE CoursePermission.cpClazzUid = ? \n           AND (CAST(? AS INTEGER) = 1 OR NOT CoursePermission.cpIsDeleted) \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CoursePermission.*, Person.*, PersonPicture.*\n          FROM CoursePermission\n               LEFT JOIN Person\n                         ON Person.personUid = CoursePermission.cpToPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE CoursePermission.cpClazzUid = ? \n           AND (CAST(? AS INTEGER) = 1 OR NOT CoursePermission.cpIsDeleted) \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<CoursePermissionAndListDetail>(_statement, this.__db, new String[]{"CoursePermission", "Person", "PersonPicture"}){

            @NonNull
            protected List<CoursePermissionAndListDetail> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpUid");
                int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpLastModified");
                int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpClazzUid");
                int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpToEnrolmentRole");
                int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpToPersonUid");
                int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpToGroupUid");
                int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpPermissionsFlag");
                int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cpIsDeleted");
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                ArrayList<CoursePermissionAndListDetail> _result2 = new ArrayList<CoursePermissionAndListDetail>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPersonPicture;
                    Person _tmpPerson;
                    CoursePermission _tmpCoursePermission;
                    if (!(cursor.isNull(_cursorIndexOfCpUid) && cursor.isNull(_cursorIndexOfCpLastModified) && cursor.isNull(_cursorIndexOfCpClazzUid) && cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && cursor.isNull(_cursorIndexOfCpToPersonUid) && cursor.isNull(_cursorIndexOfCpToGroupUid) && cursor.isNull(_cursorIndexOfCpPermissionsFlag) && cursor.isNull(_cursorIndexOfCpIsDeleted))) {
                        long _tmpCpUid = cursor.getLong(_cursorIndexOfCpUid);
                        long _tmpCpLastModified = cursor.getLong(_cursorIndexOfCpLastModified);
                        long _tmpCpClazzUid = cursor.getLong(_cursorIndexOfCpClazzUid);
                        int _tmpCpToEnrolmentRole = cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                        long _tmpCpToPersonUid = cursor.getLong(_cursorIndexOfCpToPersonUid);
                        long _tmpCpToGroupUid = cursor.getLong(_cursorIndexOfCpToGroupUid);
                        long _tmpCpPermissionsFlag = cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfCpIsDeleted);
                        boolean _tmpCpIsDeleted = _tmp_1 != 0;
                        _tmpCoursePermission = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                    } else {
                        _tmpCoursePermission = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp_2 != 0;
                        int _tmp_3 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_3 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_4 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_4 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpPerson = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_5 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_5 != 0;
                        _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPersonPicture = null;
                    }
                    CoursePermissionAndListDetail _item = new CoursePermissionAndListDetail(_tmpCoursePermission, _tmpPerson, _tmpPersonPicture);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findByUidAndClazzUid(long uid, long clazzUid, Continuation<? super CoursePermission> $completion) {
        String _sql = "\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpUid = ?\n           AND CoursePermission.cpClazzUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpUid = ?\n           AND CoursePermission.cpClazzUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CoursePermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CoursePermission call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CoursePermission _result2;
                    int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpUid");
                    int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpLastModified");
                    int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpClazzUid");
                    int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToEnrolmentRole");
                    int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToPersonUid");
                    int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToGroupUid");
                    int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpPermissionsFlag");
                    int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpIsDeleted");
                    if (_cursor.moveToFirst()) {
                        long _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
                        long _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
                        long _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
                        int _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                        long _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
                        long _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
                        long _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                        int _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
                        boolean _tmpCpIsDeleted = _tmp != 0;
                        _result2 = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                    } else {
                        _result2 = null;
                    }
                    CoursePermission coursePermission = _result2;
                    return coursePermission;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<CoursePermission> findByUidAndClazzUidAsFlow(long uid, long clazzUid) {
        String _sql = "\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpUid = ?\n           AND CoursePermission.cpClazzUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpUid = ?\n           AND CoursePermission.cpClazzUid = ? \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CoursePermission"}, (Callable)new Callable<CoursePermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CoursePermission call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CoursePermission _result2;
                    int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpUid");
                    int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpLastModified");
                    int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpClazzUid");
                    int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToEnrolmentRole");
                    int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToPersonUid");
                    int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToGroupUid");
                    int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpPermissionsFlag");
                    int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpIsDeleted");
                    if (_cursor.moveToFirst()) {
                        long _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
                        long _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
                        long _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
                        int _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                        long _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
                        long _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
                        long _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                        int _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
                        boolean _tmpCpIsDeleted = _tmp != 0;
                        _result2 = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                    } else {
                        _result2 = null;
                    }
                    CoursePermission coursePermission = _result2;
                    return coursePermission;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object personHasPermissionWithClazzByEnrolmentUidEntities2(long accountPersonUid, long clazzEnrolmentUid, Continuation<? super List<CoursePermissionAndEnrolment>> $completion) {
        String _sql = "\n       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n         FROM CoursePermission\n              \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n        WHERE CoursePermission.cpClazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )\n          AND (CoursePermission.cpToPersonUid = ? \n               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n         FROM CoursePermission\n              \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n        WHERE CoursePermission.cpClazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )\n          AND (CoursePermission.cpToPersonUid = ? \n               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CoursePermissionAndEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CoursePermissionAndEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpUid");
                    int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpLastModified");
                    int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpClazzUid");
                    int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToEnrolmentRole");
                    int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToPersonUid");
                    int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToGroupUid");
                    int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpPermissionsFlag");
                    int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpIsDeleted");
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<CoursePermissionAndEnrolment> _result2 = new ArrayList<CoursePermissionAndEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _tmpClazzEnrolment;
                        CoursePermission _tmpCoursePermission;
                        if (!(_cursor.isNull(_cursorIndexOfCpUid) && _cursor.isNull(_cursorIndexOfCpLastModified) && _cursor.isNull(_cursorIndexOfCpClazzUid) && _cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && _cursor.isNull(_cursorIndexOfCpToPersonUid) && _cursor.isNull(_cursorIndexOfCpToGroupUid) && _cursor.isNull(_cursorIndexOfCpPermissionsFlag) && _cursor.isNull(_cursorIndexOfCpIsDeleted))) {
                            long _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
                            long _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
                            long _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
                            int _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                            long _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
                            long _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
                            long _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                            int _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
                            boolean _tmpCpIsDeleted = _tmp != 0;
                            _tmpCoursePermission = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                        } else {
                            _tmpCoursePermission = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
                            _tmpClazzEnrolment = new ClazzEnrolment();
                            long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                            _tmpClazzEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                            long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                            _tmpClazzEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                            long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                            _tmpClazzEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                            long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                            _tmpClazzEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                            long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                            _tmpClazzEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                            int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                            _tmpClazzEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                            float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                            _tmpClazzEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                            boolean _tmpClazzEnrolmentActive = _tmp_1 != 0;
                            _tmpClazzEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                            long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                            _tmpClazzEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                            int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                            _tmpClazzEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                            long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                            _tmpClazzEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                            long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                            _tmpClazzEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                            int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                            _tmpClazzEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                            long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                            _tmpClazzEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                            long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                            _tmpClazzEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        } else {
                            _tmpClazzEnrolment = null;
                        }
                        CoursePermissionAndEnrolment _item = new CoursePermissionAndEnrolment(_tmpCoursePermission, _tmpClazzEnrolment);
                        _result2.add(_item);
                    }
                    ArrayList<CoursePermissionAndEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object userHasEnrolmentEditPermission(long accountPersonUid, long clazzEnrolmentUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT CASE ? \n                WHEN 0 THEN (SELECT EXISTS(\n                         SELECT 1\n                           FROM SystemPermission\n                          WHERE ? != 0 \n                            AND SystemPermission.spToPersonUid = ?\n                            AND (SystemPermission.spPermissionsFlag & 2048) > 0\n                            AND NOT SystemPermission.spIsDeleted))\n                ELSE (\n                  SELECT (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                         (\n        CASE (\n        SELECT ClazzEnrolment.clazzEnrolmentRole\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n    )\n             WHEN 1000 THEN 8\n             ELSE 8\n        END     \n    )\n                         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     \n                         (\n        CASE (\n        SELECT ClazzEnrolment.clazzEnrolmentRole\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n    )\n             WHEN 1000 THEN 8\n             ELSE 8\n        END     \n    )\n                         \n        ) > 0)\n               )\n     \n                )\n               END \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CASE ? \n                WHEN 0 THEN (SELECT EXISTS(\n                         SELECT 1\n                           FROM SystemPermission\n                          WHERE ? != 0 \n                            AND SystemPermission.spToPersonUid = ?\n                            AND (SystemPermission.spPermissionsFlag & 2048) > 0\n                            AND NOT SystemPermission.spIsDeleted))\n                ELSE (\n                  SELECT (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = (\n        SELECT COALESCE(\n               (SELECT _ClazzEnrolment_ForClazzUid.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment _ClazzEnrolment_ForClazzUid\n                 WHERE _ClazzEnrolment_ForClazzUid.clazzEnrolmentUid = ?), 0)\n    )\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         \n                         (\n        CASE (\n        SELECT ClazzEnrolment.clazzEnrolmentRole\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n    )\n             WHEN 1000 THEN 8\n             ELSE 8\n        END     \n    )\n                         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     \n                         (\n        CASE (\n        SELECT ClazzEnrolment.clazzEnrolmentRole\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentUid = ?         \n    )\n             WHEN 1000 THEN 8\n             ELSE 8\n        END     \n    )\n                         \n        ) > 0)\n               )\n     \n                )\n               END \n    ", (int)11);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzEnrolmentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object personHasPermissionWithClazzEntities2(long accountPersonUid, long clazzUid, Continuation<? super List<CoursePermissionAndEnrolment>> $completion) {
        String _sql = "\n       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n         FROM CoursePermission\n              \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n        WHERE (? = 0 OR CoursePermission.cpClazzUid = ?)\n          AND (CoursePermission.cpToPersonUid = ? \n               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n       SELECT CoursePermission.*, ClazzEnrolment_ForAccountPerson.*\n         FROM CoursePermission\n              \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n        WHERE (? = 0 OR CoursePermission.cpClazzUid = ?)\n          AND (CoursePermission.cpToPersonUid = ? \n               OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CoursePermissionAndEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CoursePermissionAndEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpUid");
                    int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpLastModified");
                    int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpClazzUid");
                    int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToEnrolmentRole");
                    int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToPersonUid");
                    int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToGroupUid");
                    int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpPermissionsFlag");
                    int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpIsDeleted");
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentInviteUid");
                    ArrayList<CoursePermissionAndEnrolment> _result2 = new ArrayList<CoursePermissionAndEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _tmpClazzEnrolment;
                        CoursePermission _tmpCoursePermission;
                        if (!(_cursor.isNull(_cursorIndexOfCpUid) && _cursor.isNull(_cursorIndexOfCpLastModified) && _cursor.isNull(_cursorIndexOfCpClazzUid) && _cursor.isNull(_cursorIndexOfCpToEnrolmentRole) && _cursor.isNull(_cursorIndexOfCpToPersonUid) && _cursor.isNull(_cursorIndexOfCpToGroupUid) && _cursor.isNull(_cursorIndexOfCpPermissionsFlag) && _cursor.isNull(_cursorIndexOfCpIsDeleted))) {
                            long _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
                            long _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
                            long _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
                            int _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                            long _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
                            long _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
                            long _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                            int _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
                            boolean _tmpCpIsDeleted = _tmp != 0;
                            _tmpCoursePermission = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                        } else {
                            _tmpCoursePermission = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct) && _cursor.isNull(_cursorIndexOfClazzEnrolmentInviteUid))) {
                            _tmpClazzEnrolment = new ClazzEnrolment();
                            long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                            _tmpClazzEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                            long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                            _tmpClazzEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                            long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                            _tmpClazzEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                            long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                            _tmpClazzEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                            long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                            _tmpClazzEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                            int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                            _tmpClazzEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                            float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                            _tmpClazzEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                            boolean _tmpClazzEnrolmentActive = _tmp_1 != 0;
                            _tmpClazzEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                            long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                            _tmpClazzEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                            int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                            _tmpClazzEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                            long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                            _tmpClazzEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                            long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                            _tmpClazzEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                            int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                            _tmpClazzEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                            long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                            _tmpClazzEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                            long _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
                            _tmpClazzEnrolment.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
                        } else {
                            _tmpClazzEnrolment = null;
                        }
                        CoursePermissionAndEnrolment _item = new CoursePermissionAndEnrolment(_tmpCoursePermission, _tmpClazzEnrolment);
                        _result2.add(_item);
                    }
                    ArrayList<CoursePermissionAndEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Boolean> personHasPermissionWithClazzAsFlow2(long accountPersonUid, long clazzUid, long permission) {
        String _sql = "\n        SELECT (? != 0 AND ? != 0)\n          AND  (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )            \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (? != 0 AND ? != 0)\n          AND  (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )            \n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, permission);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission"}, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<PermissionPair> personHasPermissionWithClazzPairAsFlow(long accountPersonUid, long clazzUid, long firstPermission, long secondPermission) {
        String _sql = "\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission\n    ", (int)20);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, secondPermission);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, secondPermission);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission"}, (Callable)new Callable<PermissionPair>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public PermissionPair call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PermissionPair _result2;
                    boolean _cursorIndexOfFirstPermission = false;
                    boolean _cursorIndexOfSecondPermission = true;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpFirstPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpSecondPermission = _tmp_1 != 0;
                        _result2 = new PermissionPair(_tmpFirstPermission, _tmpSecondPermission);
                    } else {
                        _result2 = null;
                    }
                    PermissionPair permissionPair = _result2;
                    return permissionPair;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object personHasPermissionWithClazzPairAsync(long accountPersonUid, long clazzUid, long firstPermission, long secondPermission, Continuation<? super PermissionPair> $completion) {
        String _sql = "\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission\n    ", (int)20);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, secondPermission);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, secondPermission);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PermissionPair>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public PermissionPair call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PermissionPair _result2;
                    boolean _cursorIndexOfFirstPermission = false;
                    boolean _cursorIndexOfSecondPermission = true;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpFirstPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpSecondPermission = _tmp_1 != 0;
                        _result2 = new PermissionPair(_tmpFirstPermission, _tmpSecondPermission);
                    } else {
                        _result2 = null;
                    }
                    PermissionPair permissionPair = _result2;
                    return permissionPair;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<PermissionTriple> personHasPermissionWithClazzTripleAsFlow(long accountPersonUid, long clazzUid, long firstPermission, long secondPermission, long thirdPermission) {
        String _sql = "\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS thirdPermission\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS firstPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS secondPermission,\n               (    (? != 0 AND ? != 0)\n                AND ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n                     \n        ) > 0)\n               )\n    )\n               ) AS thirdPermission\n    ", (int)30);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, firstPermission);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, secondPermission);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, secondPermission);
        _argIndex = 21;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 24;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 25;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 26;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 27;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 28;
        _statement.bindLong(_argIndex, thirdPermission);
        _argIndex = 29;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 30;
        _statement.bindLong(_argIndex, thirdPermission);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission"}, (Callable)new Callable<PermissionTriple>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public PermissionTriple call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PermissionTriple _result2;
                    boolean _cursorIndexOfFirstPermission = false;
                    boolean _cursorIndexOfSecondPermission = true;
                    int _cursorIndexOfThirdPermission = 2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpFirstPermission = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpSecondPermission = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(2);
                        boolean _tmpThirdPermission = _tmp_2 != 0;
                        _result2 = new PermissionTriple(_tmpFirstPermission, _tmpSecondPermission, _tmpThirdPermission);
                    } else {
                        _result2 = null;
                    }
                    PermissionTriple permissionTriple = _result2;
                    return permissionTriple;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object personHasPermissionWithClazzAsync2(long accountPersonUid, long clazzUid, long permission, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT (? != 0 AND ? != 0)\n          AND  (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )            \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT (? != 0 AND ? != 0)\n          AND  (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         ?\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     ?\n         \n        ) > 0)\n               )\n    \n    )            \n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, permission);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, permission);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findApplicableCoursePermissionEntitiesForAccountPerson(long accountPersonUid, Continuation<? super List<CoursePermission>> $completion) {
        String _sql = "\n        /* Get CoursePermissions given to the active user based on their enrolment role*/\n        SELECT CoursePermission.*\n          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n               JOIN CoursePermission \n                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n         UNION\n        /* Get ClazzUids where the active user can view members based a grant directly to them */\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpToPersonUid  = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        /* Get CoursePermissions given to the active user based on their enrolment role*/\n        SELECT CoursePermission.*\n          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n               JOIN CoursePermission \n                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n         UNION\n        /* Get ClazzUids where the active user can view members based a grant directly to them */\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpToPersonUid  = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CoursePermission>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CoursePermission> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpUid");
                    int _cursorIndexOfCpLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpLastModified");
                    int _cursorIndexOfCpClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpClazzUid");
                    int _cursorIndexOfCpToEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToEnrolmentRole");
                    int _cursorIndexOfCpToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToPersonUid");
                    int _cursorIndexOfCpToGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpToGroupUid");
                    int _cursorIndexOfCpPermissionsFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpPermissionsFlag");
                    int _cursorIndexOfCpIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpIsDeleted");
                    ArrayList<CoursePermission> _result2 = new ArrayList<CoursePermission>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCpUid = _cursor.getLong(_cursorIndexOfCpUid);
                        long _tmpCpLastModified = _cursor.getLong(_cursorIndexOfCpLastModified);
                        long _tmpCpClazzUid = _cursor.getLong(_cursorIndexOfCpClazzUid);
                        int _tmpCpToEnrolmentRole = _cursor.getInt(_cursorIndexOfCpToEnrolmentRole);
                        long _tmpCpToPersonUid = _cursor.getLong(_cursorIndexOfCpToPersonUid);
                        long _tmpCpToGroupUid = _cursor.getLong(_cursorIndexOfCpToGroupUid);
                        long _tmpCpPermissionsFlag = _cursor.getLong(_cursorIndexOfCpPermissionsFlag);
                        int _tmp = _cursor.getInt(_cursorIndexOfCpIsDeleted);
                        boolean _tmpCpIsDeleted = _tmp != 0;
                        CoursePermission _item = new CoursePermission(_tmpCpUid, _tmpCpLastModified, _tmpCpClazzUid, _tmpCpToEnrolmentRole, _tmpCpToPersonUid, _tmpCpToGroupUid, _tmpCpPermissionsFlag, _tmpCpIsDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<CoursePermission> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<AssignmentPermissionAndActiveUserSubmitterUid> userPermissionsForAssignmentSubmitterUid(long accountPersonUid, long assignmentUid, long clazzUid, long submitterUid) {
        String _sql = "\n        WITH \n        AccountSubmitterUid(accountSubmitterUid) AS \n        (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n    ,\n             CanMarkSubmitter(canMark) AS\n             (SELECT CASE (SELECT ClazzAssignment.caMarkingType\n                             FROM ClazzAssignment\n                            WHERE ClazzAssignment.caUid = ?)\n                           WHEN 2 THEN \n                                EXISTS(SELECT 1\n                                         FROM PeerReviewerAllocation\n                                        WHERE PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                                          AND PeerReviewerAllocation.praMarkerSubmitterUid =\n                                              (SELECT AccountSubmitterUid.accountSubmitterUid\n                                                 FROM AccountSubmitterUid))\n                           ELSE ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         256\n                                 \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     256\n                                 \n        ) > 0)\n               )\n    )\n                          END)\n\n             \n                    /* Can edit */\n             SELECT (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n                      AND (SELECT CanMarkSubmitter.canMark \n                            FROM CanMarkSubmitter)) AS canMark,\n                    /* can view */   \n                    (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n                      AND (     (SELECT CanMarkSubmitter.canMark\n                                   FROM CanMarkSubmitter)\n                             OR (SELECT ? = \n                                  (SELECT AccountSubmitterUid.accountSubmitterUid\n                                     FROM AccountSubmitterUid))\n                             OR ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                 \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                 \n        ) > 0)\n               )\n    ))               \n                    ) AS canView,\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         4\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     4\n                     \n        ) > 0)\n               )\n    \n                    ) AS canModerate,\n                    (SELECT accountSubmitterUid\n                       FROM AccountSubmitterUid) AS activeUserSubmitterUid\n             \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH \n        AccountSubmitterUid(accountSubmitterUid) AS \n        (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = ?) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = ?)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = ?)\n                              AND CourseGroupMember.cgmPersonUid = ?\n                            LIMIT 1), -1)\n                    END\n    )\n    ,\n             CanMarkSubmitter(canMark) AS\n             (SELECT CASE (SELECT ClazzAssignment.caMarkingType\n                             FROM ClazzAssignment\n                            WHERE ClazzAssignment.caUid = ?)\n                           WHEN 2 THEN \n                                EXISTS(SELECT 1\n                                         FROM PeerReviewerAllocation\n                                        WHERE PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n                                          AND PeerReviewerAllocation.praMarkerSubmitterUid =\n                                              (SELECT AccountSubmitterUid.accountSubmitterUid\n                                                 FROM AccountSubmitterUid))\n                           ELSE ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         256\n                                 \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     256\n                                 \n        ) > 0)\n               )\n    )\n                          END)\n\n             \n                    /* Can edit */\n             SELECT (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n                      AND (SELECT CanMarkSubmitter.canMark \n                            FROM CanMarkSubmitter)) AS canMark,\n                    /* can view */   \n                    (     (? != 0 AND ? != 0 AND ? != 0 AND ? != 0)\n                      AND (     (SELECT CanMarkSubmitter.canMark\n                                   FROM CanMarkSubmitter)\n                             OR (SELECT ? = \n                                  (SELECT AccountSubmitterUid.accountSubmitterUid\n                                     FROM AccountSubmitterUid))\n                             OR ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                 \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                 \n        ) > 0)\n               )\n    ))               \n                    ) AS canView,\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         4\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     4\n                     \n        ) > 0)\n               )\n    \n                    ) AS canModerate,\n                    (SELECT accountSubmitterUid\n                       FROM AccountSubmitterUid) AS activeUserSubmitterUid\n             \n    ", (int)39);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 15;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 16;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 17;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 18;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 19;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 20;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 21;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 22;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 23;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 24;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 25;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 26;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 27;
        _statement.bindLong(_argIndex, submitterUid);
        _argIndex = 28;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 29;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 30;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 31;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 32;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 33;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 34;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 35;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 36;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 37;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 38;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 39;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzAssignment", "ClazzEnrolment", "CourseGroupMember", "PeerReviewerAllocation", "Clazz", "CoursePermission", "SystemPermission"}, (Callable)new Callable<AssignmentPermissionAndActiveUserSubmitterUid>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public AssignmentPermissionAndActiveUserSubmitterUid call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoursePermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AssignmentPermissionAndActiveUserSubmitterUid _result2;
                    boolean _cursorIndexOfCanMark = false;
                    boolean _cursorIndexOfCanView = true;
                    int _cursorIndexOfCanModerate = 2;
                    int _cursorIndexOfActiveUserSubmitterUid = 3;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        boolean _tmpCanMark = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(1);
                        boolean _tmpCanView = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(2);
                        boolean _tmpCanModerate = _tmp_2 != 0;
                        long _tmpActiveUserSubmitterUid = _cursor.getLong(3);
                        _result2 = new AssignmentPermissionAndActiveUserSubmitterUid(_tmpCanMark, _tmpCanView, _tmpCanModerate, _tmpActiveUserSubmitterUid);
                    } else {
                        _result2 = null;
                    }
                    AssignmentPermissionAndActiveUserSubmitterUid assignmentPermissionAndActiveUserSubmitterUid = _result2;
                    return assignmentPermissionAndActiveUserSubmitterUid;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

