/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.DiscussionPostDao;
import com.ustadmobile.lib.db.composites.DiscussionPostAndPosterNames;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.DiscussionPost;
import com.ustadmobile.lib.db.entities.DiscussionPostWithDetails;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class DiscussionPostDao_Impl
extends DiscussionPostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<DiscussionPost> __insertionAdapterOfDiscussionPost;
    private final EntityInsertionAdapter<DiscussionPost> __insertionAdapterOfDiscussionPost_1;
    private final EntityDeletionOrUpdateAdapter<DiscussionPost> __updateAdapterOfDiscussionPost;
    private final SharedSQLiteStatement __preparedStmtOfSetDeletedAsync;

    public DiscussionPostDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDiscussionPost = new EntityInsertionAdapter<DiscussionPost>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `DiscussionPost` (`discussionPostUid`,`discussionPostReplyToPostUid`,`discussionPostTitle`,`discussionPostMessage`,`discussionPostStartDate`,`discussionPostCourseBlockUid`,`dpDeleted`,`discussionPostStartedPersonUid`,`discussionPostClazzUid`,`discussionPostLct`,`discussionPostVisible`,`discussionPostArchive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull DiscussionPost entity) {
                statement.bindLong(1, entity.getDiscussionPostUid());
                statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
                if (entity.getDiscussionPostTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDiscussionPostTitle());
                }
                if (entity.getDiscussionPostMessage() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getDiscussionPostMessage());
                }
                statement.bindLong(5, entity.getDiscussionPostStartDate());
                statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
                int _tmp = entity.getDpDeleted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
                statement.bindLong(9, entity.getDiscussionPostClazzUid());
                statement.bindLong(10, entity.getDiscussionPostLct());
                int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
                statement.bindLong(11, (long)_tmp_1);
                int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_2);
            }
        };
        this.__insertionAdapterOfDiscussionPost_1 = new EntityInsertionAdapter<DiscussionPost>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `DiscussionPost` (`discussionPostUid`,`discussionPostReplyToPostUid`,`discussionPostTitle`,`discussionPostMessage`,`discussionPostStartDate`,`discussionPostCourseBlockUid`,`dpDeleted`,`discussionPostStartedPersonUid`,`discussionPostClazzUid`,`discussionPostLct`,`discussionPostVisible`,`discussionPostArchive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull DiscussionPost entity) {
                statement.bindLong(1, entity.getDiscussionPostUid());
                statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
                if (entity.getDiscussionPostTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDiscussionPostTitle());
                }
                if (entity.getDiscussionPostMessage() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getDiscussionPostMessage());
                }
                statement.bindLong(5, entity.getDiscussionPostStartDate());
                statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
                int _tmp = entity.getDpDeleted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
                statement.bindLong(9, entity.getDiscussionPostClazzUid());
                statement.bindLong(10, entity.getDiscussionPostLct());
                int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
                statement.bindLong(11, (long)_tmp_1);
                int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_2);
            }
        };
        this.__updateAdapterOfDiscussionPost = new EntityDeletionOrUpdateAdapter<DiscussionPost>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `DiscussionPost` SET `discussionPostUid` = ?,`discussionPostReplyToPostUid` = ?,`discussionPostTitle` = ?,`discussionPostMessage` = ?,`discussionPostStartDate` = ?,`discussionPostCourseBlockUid` = ?,`dpDeleted` = ?,`discussionPostStartedPersonUid` = ?,`discussionPostClazzUid` = ?,`discussionPostLct` = ?,`discussionPostVisible` = ?,`discussionPostArchive` = ? WHERE `discussionPostUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull DiscussionPost entity) {
                statement.bindLong(1, entity.getDiscussionPostUid());
                statement.bindLong(2, entity.getDiscussionPostReplyToPostUid());
                if (entity.getDiscussionPostTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDiscussionPostTitle());
                }
                if (entity.getDiscussionPostMessage() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getDiscussionPostMessage());
                }
                statement.bindLong(5, entity.getDiscussionPostStartDate());
                statement.bindLong(6, entity.getDiscussionPostCourseBlockUid());
                int _tmp = entity.getDpDeleted() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getDiscussionPostStartedPersonUid());
                statement.bindLong(9, entity.getDiscussionPostClazzUid());
                statement.bindLong(10, entity.getDiscussionPostLct());
                int _tmp_1 = entity.getDiscussionPostVisible() ? 1 : 0;
                statement.bindLong(11, (long)_tmp_1);
                int _tmp_2 = entity.getDiscussionPostArchive() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_2);
                statement.bindLong(13, entity.getDiscussionPostUid());
            }
        };
        this.__preparedStmtOfSetDeletedAsync = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE DiscussionPost\n           SET dpDeleted = ?,\n               discussionPostLct = ?\n         WHERE discussionPostUid = ?   \n    ";
                return "\n        UPDATE DiscussionPost\n           SET dpDeleted = ?,\n               discussionPostLct = ?\n         WHERE discussionPostUid = ?   \n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(DiscussionPost entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfDiscussionPost.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final DiscussionPost entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                DiscussionPostDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = DiscussionPostDao_Impl.this.__insertionAdapterOfDiscussionPost.insertAndReturnId((Object)entity);
                    DiscussionPostDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    DiscussionPostDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends DiscussionPost> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDiscussionPost.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsertAsync(final DiscussionPost entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                DiscussionPostDao_Impl.this.__db.beginTransaction();
                try {
                    DiscussionPostDao_Impl.this.__insertionAdapterOfDiscussionPost_1.insert((Object)entity);
                    DiscussionPostDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    DiscussionPostDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(DiscussionPost entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDiscussionPost.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final DiscussionPost entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                DiscussionPostDao_Impl.this.__db.beginTransaction();
                try {
                    DiscussionPostDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += DiscussionPostDao_Impl.this.__updateAdapterOfDiscussionPost.handle((Object)entity);
                    return n;
                }
                finally {
                    DiscussionPostDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object setDeletedAsync(final long uid, final boolean deleted, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = DiscussionPostDao_Impl.this.__preparedStmtOfSetDeletedAsync.acquire();
                int _argIndex = 1;
                int _tmp = deleted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    DiscussionPostDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        DiscussionPostDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        DiscussionPostDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    DiscussionPostDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    DiscussionPostDao_Impl.this.__preparedStmtOfSetDeletedAsync.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, DiscussionPostWithDetails> getTopLevelPostsByCourseBlockUid(long courseBlockUid, boolean includeDeleted) {
        String _sql = "\n        SELECT DiscussionPost.*,\n               Person.firstNames as authorPersonFirstNames,\n               Person.lastName as authorPersonLastName,\n               PersonPicture.personPictureThumbnailUri AS authorPictureUri,\n               MostRecentReply.discussionPostMessage AS postLatestMessage,\n               COALESCE(MostRecentReply.discussionPostStartDate, 0) AS postLatestMessageTimestamp,\n               (SELECT COUNT(*)\n                  FROM DiscussionPost DiscussionPostReplies\n                 WHERE DiscussionPostReplies.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                   AND NOT DiscussionPostReplies.dpDeleted\n               ) AS postRepliesCount\n          FROM DiscussionPost\n               LEFT JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n               LEFT JOIN Person \n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n           AND DiscussionPost.discussionPostReplyToPostUid = 0\n           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)\n      ORDER BY DiscussionPost.discussionPostStartDate DESC          \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DiscussionPost.*,\n               Person.firstNames as authorPersonFirstNames,\n               Person.lastName as authorPersonLastName,\n               PersonPicture.personPictureThumbnailUri AS authorPictureUri,\n               MostRecentReply.discussionPostMessage AS postLatestMessage,\n               COALESCE(MostRecentReply.discussionPostStartDate, 0) AS postLatestMessageTimestamp,\n               (SELECT COUNT(*)\n                  FROM DiscussionPost DiscussionPostReplies\n                 WHERE DiscussionPostReplies.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                   AND NOT DiscussionPostReplies.dpDeleted\n               ) AS postRepliesCount\n          FROM DiscussionPost\n               LEFT JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n               LEFT JOIN Person \n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n           AND DiscussionPost.discussionPostReplyToPostUid = 0\n           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)\n      ORDER BY DiscussionPost.discussionPostStartDate DESC          \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseBlockUid);
        _argIndex = 2;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<DiscussionPostWithDetails>(_statement, this.__db, new String[]{"DiscussionPost", "Person", "PersonPicture"}){

            @NonNull
            protected List<DiscussionPostWithDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostUid");
                int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostReplyToPostUid");
                int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostTitle");
                int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostMessage");
                int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostStartDate");
                int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostCourseBlockUid");
                int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dpDeleted");
                int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostStartedPersonUid");
                int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostClazzUid");
                int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostLct");
                int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostVisible");
                int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostArchive");
                int _cursorIndexOfAuthorPersonFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"authorPersonFirstNames");
                int _cursorIndexOfAuthorPersonLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"authorPersonLastName");
                int _cursorIndexOfAuthorPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"authorPictureUri");
                int _cursorIndexOfPostLatestMessage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postLatestMessage");
                int _cursorIndexOfPostLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postLatestMessageTimestamp");
                int _cursorIndexOfPostRepliesCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"postRepliesCount");
                ArrayList<DiscussionPostWithDetails> _result2 = new ArrayList<DiscussionPostWithDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    DiscussionPostWithDetails _item = new DiscussionPostWithDetails();
                    long _tmpDiscussionPostUid = cursor.getLong(_cursorIndexOfDiscussionPostUid);
                    _item.setDiscussionPostUid(_tmpDiscussionPostUid);
                    long _tmpDiscussionPostReplyToPostUid = cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
                    _item.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
                    String _tmpDiscussionPostTitle = cursor.isNull(_cursorIndexOfDiscussionPostTitle) ? null : cursor.getString(_cursorIndexOfDiscussionPostTitle);
                    _item.setDiscussionPostTitle(_tmpDiscussionPostTitle);
                    String _tmpDiscussionPostMessage = cursor.isNull(_cursorIndexOfDiscussionPostMessage) ? null : cursor.getString(_cursorIndexOfDiscussionPostMessage);
                    _item.setDiscussionPostMessage(_tmpDiscussionPostMessage);
                    long _tmpDiscussionPostStartDate = cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
                    _item.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
                    long _tmpDiscussionPostCourseBlockUid = cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
                    _item.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfDpDeleted);
                    boolean _tmpDpDeleted = _tmp_1 != 0;
                    _item.setDpDeleted(_tmpDpDeleted);
                    long _tmpDiscussionPostStartedPersonUid = cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
                    _item.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
                    long _tmpDiscussionPostClazzUid = cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
                    _item.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
                    long _tmpDiscussionPostLct = cursor.getLong(_cursorIndexOfDiscussionPostLct);
                    _item.setDiscussionPostLct(_tmpDiscussionPostLct);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfDiscussionPostVisible);
                    boolean _tmpDiscussionPostVisible = _tmp_2 != 0;
                    _item.setDiscussionPostVisible(_tmpDiscussionPostVisible);
                    int _tmp_3 = cursor.getInt(_cursorIndexOfDiscussionPostArchive);
                    boolean _tmpDiscussionPostArchive = _tmp_3 != 0;
                    _item.setDiscussionPostArchive(_tmpDiscussionPostArchive);
                    String _tmpAuthorPersonFirstNames = cursor.isNull(_cursorIndexOfAuthorPersonFirstNames) ? null : cursor.getString(_cursorIndexOfAuthorPersonFirstNames);
                    _item.setAuthorPersonFirstNames(_tmpAuthorPersonFirstNames);
                    String _tmpAuthorPersonLastName = cursor.isNull(_cursorIndexOfAuthorPersonLastName) ? null : cursor.getString(_cursorIndexOfAuthorPersonLastName);
                    _item.setAuthorPersonLastName(_tmpAuthorPersonLastName);
                    String _tmpAuthorPictureUri = cursor.isNull(_cursorIndexOfAuthorPictureUri) ? null : cursor.getString(_cursorIndexOfAuthorPictureUri);
                    _item.setAuthorPictureUri(_tmpAuthorPictureUri);
                    String _tmpPostLatestMessage = cursor.isNull(_cursorIndexOfPostLatestMessage) ? null : cursor.getString(_cursorIndexOfPostLatestMessage);
                    _item.setPostLatestMessage(_tmpPostLatestMessage);
                    long _tmpPostLatestMessageTimestamp = cursor.getLong(_cursorIndexOfPostLatestMessageTimestamp);
                    _item.setPostLatestMessageTimestamp(_tmpPostLatestMessageTimestamp);
                    int _tmpPostRepliesCount = cursor.getInt(_cursorIndexOfPostRepliesCount);
                    _item.setPostRepliesCount(_tmpPostRepliesCount);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object getTopLevelPostsByCourseBlockUidPersons(long courseBlockUid, Continuation<? super List<PersonAndPicture>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n                   AND DiscussionPost.discussionPostReplyToPostUid = 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n                   AND DiscussionPost.discussionPostReplyToPostUid = 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseBlockUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndPicture>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndPicture> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndPicture> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getTopLevelPostsByCourseBlockUidLatestMessage(long courseBlockUid, Continuation<? super List<? extends DiscussionPost>> $completion) {
        String _sql = "\n        SELECT MostRecentReply.*\n          FROM DiscussionPost\n               JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n           AND DiscussionPost.discussionPostReplyToPostUid = 0 \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT MostRecentReply.*\n          FROM DiscussionPost\n               JOIN DiscussionPost AS MostRecentReply\n                         ON MostRecentReply.discussionPostUid = \n                            (SELECT MostRecentReplyInner.discussionPostUid\n                               FROM DiscussionPost AS MostRecentReplyInner\n                              WHERE MostRecentReplyInner.discussionPostReplyToPostUid = DiscussionPost.discussionPostUid\n                           ORDER BY MostRecentReplyInner.discussionPostStartDate DESC\n                              LIMIT 1  \n                            )\n         WHERE DiscussionPost.discussionPostCourseBlockUid = ?\n           AND DiscussionPost.discussionPostReplyToPostUid = 0 \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseBlockUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<DiscussionPost>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<DiscussionPost> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostUid");
                    int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostReplyToPostUid");
                    int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostTitle");
                    int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostMessage");
                    int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostStartDate");
                    int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostCourseBlockUid");
                    int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dpDeleted");
                    int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostStartedPersonUid");
                    int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostClazzUid");
                    int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostLct");
                    int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostVisible");
                    int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostArchive");
                    ArrayList<DiscussionPost> _result2 = new ArrayList<DiscussionPost>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        DiscussionPost _item = new DiscussionPost();
                        long _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
                        _item.setDiscussionPostUid(_tmpDiscussionPostUid);
                        long _tmpDiscussionPostReplyToPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
                        _item.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
                        String _tmpDiscussionPostTitle = _cursor.isNull(_cursorIndexOfDiscussionPostTitle) ? null : _cursor.getString(_cursorIndexOfDiscussionPostTitle);
                        _item.setDiscussionPostTitle(_tmpDiscussionPostTitle);
                        String _tmpDiscussionPostMessage = _cursor.isNull(_cursorIndexOfDiscussionPostMessage) ? null : _cursor.getString(_cursorIndexOfDiscussionPostMessage);
                        _item.setDiscussionPostMessage(_tmpDiscussionPostMessage);
                        long _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
                        _item.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
                        long _tmpDiscussionPostCourseBlockUid = _cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
                        _item.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfDpDeleted);
                        boolean _tmpDpDeleted = _tmp != 0;
                        _item.setDpDeleted(_tmpDpDeleted);
                        long _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
                        _item.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
                        long _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
                        _item.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
                        long _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
                        _item.setDiscussionPostLct(_tmpDiscussionPostLct);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
                        boolean _tmpDiscussionPostVisible = _tmp_1 != 0;
                        _item.setDiscussionPostVisible(_tmpDiscussionPostVisible);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
                        boolean _tmpDiscussionPostArchive = _tmp_2 != 0;
                        _item.setDiscussionPostArchive(_tmpDiscussionPostArchive);
                        _result2.add(_item);
                    }
                    ArrayList<DiscussionPost> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getPostTitle(long postUid, Continuation<? super String> $completion) {
        String _sql = "\n        SELECT DiscussionPost.discussionPostTitle \n          FROM DiscussionPost \n         WHERE DiscussionPost.discussionPostUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DiscussionPost.discussionPostTitle \n          FROM DiscussionPost \n         WHERE DiscussionPost.discussionPostUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, postUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUid(long uid, Continuation<? super DiscussionPost> $completion) {
        String _sql = "\n        SELECT * \n         FROM DiscussionPost\n        WHERE DiscussionPost.discussionPostUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n         FROM DiscussionPost\n        WHERE DiscussionPost.discussionPostUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<DiscussionPost>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public DiscussionPost call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    DiscussionPost _result2;
                    int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostUid");
                    int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostReplyToPostUid");
                    int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostTitle");
                    int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostMessage");
                    int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostStartDate");
                    int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostCourseBlockUid");
                    int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dpDeleted");
                    int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostStartedPersonUid");
                    int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostClazzUid");
                    int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostLct");
                    int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostVisible");
                    int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"discussionPostArchive");
                    if (_cursor.moveToFirst()) {
                        _result2 = new DiscussionPost();
                        long _tmpDiscussionPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostUid);
                        _result2.setDiscussionPostUid(_tmpDiscussionPostUid);
                        long _tmpDiscussionPostReplyToPostUid = _cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
                        _result2.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
                        String _tmpDiscussionPostTitle = _cursor.isNull(_cursorIndexOfDiscussionPostTitle) ? null : _cursor.getString(_cursorIndexOfDiscussionPostTitle);
                        _result2.setDiscussionPostTitle(_tmpDiscussionPostTitle);
                        String _tmpDiscussionPostMessage = _cursor.isNull(_cursorIndexOfDiscussionPostMessage) ? null : _cursor.getString(_cursorIndexOfDiscussionPostMessage);
                        _result2.setDiscussionPostMessage(_tmpDiscussionPostMessage);
                        long _tmpDiscussionPostStartDate = _cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
                        _result2.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
                        long _tmpDiscussionPostCourseBlockUid = _cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
                        _result2.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfDpDeleted);
                        boolean _tmpDpDeleted = _tmp != 0;
                        _result2.setDpDeleted(_tmpDpDeleted);
                        long _tmpDiscussionPostStartedPersonUid = _cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
                        _result2.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
                        long _tmpDiscussionPostClazzUid = _cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
                        _result2.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
                        long _tmpDiscussionPostLct = _cursor.getLong(_cursorIndexOfDiscussionPostLct);
                        _result2.setDiscussionPostLct(_tmpDiscussionPostLct);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfDiscussionPostVisible);
                        boolean _tmpDiscussionPostVisible = _tmp_1 != 0;
                        _result2.setDiscussionPostVisible(_tmpDiscussionPostVisible);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfDiscussionPostArchive);
                        boolean _tmpDiscussionPostArchive = _tmp_2 != 0;
                        _result2.setDiscussionPostArchive(_tmpDiscussionPostArchive);
                    } else {
                        _result2 = null;
                    }
                    DiscussionPost discussionPost = _result2;
                    return discussionPost;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<String> getTitleByUidAsFlow(long uid) {
        String _sql = "\n        SELECT DiscussionPost.discussionPostTitle\n          FROM DiscussionPost\n         WHERE DiscussionPost.discussionPostUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DiscussionPost.discussionPostTitle\n          FROM DiscussionPost\n         WHERE DiscussionPost.discussionPostUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"DiscussionPost"}, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, DiscussionPostAndPosterNames> findByPostIdWithAllReplies(long postUid, boolean includeDeleted) {
        String _sql = "\n        SELECT DiscussionPost.*,\n               Person.firstNames,\n               Person.lastName,\n               PersonPicture.personPictureThumbnailUri AS personPictureUri\n          FROM DiscussionPost\n               LEFT JOIN Person\n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE (DiscussionPost.discussionPostUid = ?\n                 OR DiscussionPost.discussionPostReplyToPostUid= ?)\n           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)      \n            -- Always get the starting post first, followed by replies\n      ORDER BY CASE(DiscussionPost.discussionPostReplyToPostUid)\n               WHEN 0 THEN 0\n               ELSE 1 END ASC,\n               DiscussionPost.discussionPostStartDate DESC \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DiscussionPost.*,\n               Person.firstNames,\n               Person.lastName,\n               PersonPicture.personPictureThumbnailUri AS personPictureUri\n          FROM DiscussionPost\n               LEFT JOIN Person\n                         ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE (DiscussionPost.discussionPostUid = ?\n                 OR DiscussionPost.discussionPostReplyToPostUid= ?)\n           AND (NOT DiscussionPost.dpDeleted OR CAST(? AS INTEGER) = 1)      \n            -- Always get the starting post first, followed by replies\n      ORDER BY CASE(DiscussionPost.discussionPostReplyToPostUid)\n               WHEN 0 THEN 0\n               ELSE 1 END ASC,\n               DiscussionPost.discussionPostStartDate DESC \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, postUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, postUid);
        _argIndex = 3;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return new LimitOffsetPagingSource<DiscussionPostAndPosterNames>(_statement, this.__db, new String[]{"DiscussionPost", "Person", "PersonPicture"}){

            @NonNull
            protected List<DiscussionPostAndPosterNames> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfDiscussionPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostUid");
                int _cursorIndexOfDiscussionPostReplyToPostUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostReplyToPostUid");
                int _cursorIndexOfDiscussionPostTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostTitle");
                int _cursorIndexOfDiscussionPostMessage = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostMessage");
                int _cursorIndexOfDiscussionPostStartDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostStartDate");
                int _cursorIndexOfDiscussionPostCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostCourseBlockUid");
                int _cursorIndexOfDpDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dpDeleted");
                int _cursorIndexOfDiscussionPostStartedPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostStartedPersonUid");
                int _cursorIndexOfDiscussionPostClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostClazzUid");
                int _cursorIndexOfDiscussionPostLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostLct");
                int _cursorIndexOfDiscussionPostVisible = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostVisible");
                int _cursorIndexOfDiscussionPostArchive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"discussionPostArchive");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                ArrayList<DiscussionPostAndPosterNames> _result2 = new ArrayList<DiscussionPostAndPosterNames>(cursor.getCount());
                while (cursor.moveToNext()) {
                    DiscussionPost _tmpDiscussionPost;
                    String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                    String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                    String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                    if (!(cursor.isNull(_cursorIndexOfDiscussionPostUid) && cursor.isNull(_cursorIndexOfDiscussionPostReplyToPostUid) && cursor.isNull(_cursorIndexOfDiscussionPostTitle) && cursor.isNull(_cursorIndexOfDiscussionPostMessage) && cursor.isNull(_cursorIndexOfDiscussionPostStartDate) && cursor.isNull(_cursorIndexOfDiscussionPostCourseBlockUid) && cursor.isNull(_cursorIndexOfDpDeleted) && cursor.isNull(_cursorIndexOfDiscussionPostStartedPersonUid) && cursor.isNull(_cursorIndexOfDiscussionPostClazzUid) && cursor.isNull(_cursorIndexOfDiscussionPostLct) && cursor.isNull(_cursorIndexOfDiscussionPostVisible) && cursor.isNull(_cursorIndexOfDiscussionPostArchive))) {
                        _tmpDiscussionPost = new DiscussionPost();
                        long _tmpDiscussionPostUid = cursor.getLong(_cursorIndexOfDiscussionPostUid);
                        _tmpDiscussionPost.setDiscussionPostUid(_tmpDiscussionPostUid);
                        long _tmpDiscussionPostReplyToPostUid = cursor.getLong(_cursorIndexOfDiscussionPostReplyToPostUid);
                        _tmpDiscussionPost.setDiscussionPostReplyToPostUid(_tmpDiscussionPostReplyToPostUid);
                        String _tmpDiscussionPostTitle = cursor.isNull(_cursorIndexOfDiscussionPostTitle) ? null : cursor.getString(_cursorIndexOfDiscussionPostTitle);
                        _tmpDiscussionPost.setDiscussionPostTitle(_tmpDiscussionPostTitle);
                        String _tmpDiscussionPostMessage = cursor.isNull(_cursorIndexOfDiscussionPostMessage) ? null : cursor.getString(_cursorIndexOfDiscussionPostMessage);
                        _tmpDiscussionPost.setDiscussionPostMessage(_tmpDiscussionPostMessage);
                        long _tmpDiscussionPostStartDate = cursor.getLong(_cursorIndexOfDiscussionPostStartDate);
                        _tmpDiscussionPost.setDiscussionPostStartDate(_tmpDiscussionPostStartDate);
                        long _tmpDiscussionPostCourseBlockUid = cursor.getLong(_cursorIndexOfDiscussionPostCourseBlockUid);
                        _tmpDiscussionPost.setDiscussionPostCourseBlockUid(_tmpDiscussionPostCourseBlockUid);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfDpDeleted);
                        boolean _tmpDpDeleted = _tmp_1 != 0;
                        _tmpDiscussionPost.setDpDeleted(_tmpDpDeleted);
                        long _tmpDiscussionPostStartedPersonUid = cursor.getLong(_cursorIndexOfDiscussionPostStartedPersonUid);
                        _tmpDiscussionPost.setDiscussionPostStartedPersonUid(_tmpDiscussionPostStartedPersonUid);
                        long _tmpDiscussionPostClazzUid = cursor.getLong(_cursorIndexOfDiscussionPostClazzUid);
                        _tmpDiscussionPost.setDiscussionPostClazzUid(_tmpDiscussionPostClazzUid);
                        long _tmpDiscussionPostLct = cursor.getLong(_cursorIndexOfDiscussionPostLct);
                        _tmpDiscussionPost.setDiscussionPostLct(_tmpDiscussionPostLct);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfDiscussionPostVisible);
                        boolean _tmpDiscussionPostVisible = _tmp_2 != 0;
                        _tmpDiscussionPost.setDiscussionPostVisible(_tmpDiscussionPostVisible);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfDiscussionPostArchive);
                        boolean _tmpDiscussionPostArchive = _tmp_3 != 0;
                        _tmpDiscussionPost.setDiscussionPostArchive(_tmpDiscussionPostArchive);
                    } else {
                        _tmpDiscussionPost = null;
                    }
                    DiscussionPostAndPosterNames _item = new DiscussionPostAndPosterNames(_tmpDiscussionPost, _tmpFirstNames, _tmpLastName, _tmpPersonPictureUri);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findByPostIdWithAllRepliesPersons(long postUid, Continuation<? super List<PersonAndPicture>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?\n                    OR DiscussionPost.discussionPostReplyToPostUid= ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT DiscussionPost.discussionPostStartedPersonUid\n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?\n                    OR DiscussionPost.discussionPostReplyToPostUid= ?)\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, postUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, postUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndPicture>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndPicture> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DiscussionPostDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndPicture> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

