/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.HolidayCalendarDao;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class HolidayCalendarDao_Impl
extends HolidayCalendarDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<HolidayCalendar> __insertionAdapterOfHolidayCalendar;
    private final EntityInsertionAdapter<HolidayCalendar> __insertionAdapterOfHolidayCalendar_1;
    private final EntityDeletionOrUpdateAdapter<HolidayCalendar> __updateAdapterOfHolidayCalendar;

    public HolidayCalendarDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfHolidayCalendar = new EntityInsertionAdapter<HolidayCalendar>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `HolidayCalendar` (`umCalendarUid`,`umCalendarName`,`umCalendarCategory`,`umCalendarActive`,`umCalendarMasterChangeSeqNum`,`umCalendarLocalChangeSeqNum`,`umCalendarLastChangedBy`,`umCalendarLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull HolidayCalendar entity) {
                statement.bindLong(1, entity.getUmCalendarUid());
                if (entity.getUmCalendarName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUmCalendarName());
                }
                statement.bindLong(3, (long)entity.getUmCalendarCategory());
                int _tmp = entity.getUmCalendarActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getUmCalendarMasterChangeSeqNum());
                statement.bindLong(6, entity.getUmCalendarLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getUmCalendarLastChangedBy());
                statement.bindLong(8, entity.getUmCalendarLct());
            }
        };
        this.__insertionAdapterOfHolidayCalendar_1 = new EntityInsertionAdapter<HolidayCalendar>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `HolidayCalendar` (`umCalendarUid`,`umCalendarName`,`umCalendarCategory`,`umCalendarActive`,`umCalendarMasterChangeSeqNum`,`umCalendarLocalChangeSeqNum`,`umCalendarLastChangedBy`,`umCalendarLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull HolidayCalendar entity) {
                statement.bindLong(1, entity.getUmCalendarUid());
                if (entity.getUmCalendarName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUmCalendarName());
                }
                statement.bindLong(3, (long)entity.getUmCalendarCategory());
                int _tmp = entity.getUmCalendarActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getUmCalendarMasterChangeSeqNum());
                statement.bindLong(6, entity.getUmCalendarLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getUmCalendarLastChangedBy());
                statement.bindLong(8, entity.getUmCalendarLct());
            }
        };
        this.__updateAdapterOfHolidayCalendar = new EntityDeletionOrUpdateAdapter<HolidayCalendar>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `HolidayCalendar` SET `umCalendarUid` = ?,`umCalendarName` = ?,`umCalendarCategory` = ?,`umCalendarActive` = ?,`umCalendarMasterChangeSeqNum` = ?,`umCalendarLocalChangeSeqNum` = ?,`umCalendarLastChangedBy` = ?,`umCalendarLct` = ? WHERE `umCalendarUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull HolidayCalendar entity) {
                statement.bindLong(1, entity.getUmCalendarUid());
                if (entity.getUmCalendarName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getUmCalendarName());
                }
                statement.bindLong(3, (long)entity.getUmCalendarCategory());
                int _tmp = entity.getUmCalendarActive() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, entity.getUmCalendarMasterChangeSeqNum());
                statement.bindLong(6, entity.getUmCalendarLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getUmCalendarLastChangedBy());
                statement.bindLong(8, entity.getUmCalendarLct());
                statement.bindLong(9, entity.getUmCalendarUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(HolidayCalendar entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfHolidayCalendar.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final HolidayCalendar entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                HolidayCalendarDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = HolidayCalendarDao_Impl.this.__insertionAdapterOfHolidayCalendar.insertAndReturnId((Object)entity);
                    HolidayCalendarDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    HolidayCalendarDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends HolidayCalendar> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHolidayCalendar.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void replaceList(List<? extends HolidayCalendar> list) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfHolidayCalendar_1.insert(list);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(HolidayCalendar entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfHolidayCalendar.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final HolidayCalendar entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                HolidayCalendarDao_Impl.this.__db.beginTransaction();
                try {
                    HolidayCalendarDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += HolidayCalendarDao_Impl.this.__updateAdapterOfHolidayCalendar.handle((Object)entity);
                    return n;
                }
                finally {
                    HolidayCalendarDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, HolidayCalendarWithNumEntries> findAllHolidaysWithEntriesCount() {
        String _sql = "SELECT HolidayCalendar.* ,\n            (SELECT COUNT(*) FROM Holiday \n               WHERE holHolidayCalendarUid = HolidayCalendar.umCalendarUid \n               AND CAST(holActive AS INTEGER) = 1) AS numEntries \n             FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND \n             umCalendarCategory = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT HolidayCalendar.* ,\n            (SELECT COUNT(*) FROM Holiday \n               WHERE holHolidayCalendarUid = HolidayCalendar.umCalendarUid \n               AND CAST(holActive AS INTEGER) = 1) AS numEntries \n             FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND \n             umCalendarCategory = 1", (int)0);
        return new LimitOffsetPagingSource<HolidayCalendarWithNumEntries>(_statement, this.__db, new String[]{"Holiday", "HolidayCalendar"}){

            @NonNull
            protected List<HolidayCalendarWithNumEntries> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarUid");
                int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarName");
                int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarCategory");
                int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarActive");
                int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarMasterChangeSeqNum");
                int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarLocalChangeSeqNum");
                int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarLastChangedBy");
                int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"umCalendarLct");
                int _cursorIndexOfNumEntries = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"numEntries");
                ArrayList<HolidayCalendarWithNumEntries> _result2 = new ArrayList<HolidayCalendarWithNumEntries>(cursor.getCount());
                while (cursor.moveToNext()) {
                    HolidayCalendarWithNumEntries _item = new HolidayCalendarWithNumEntries();
                    long _tmpUmCalendarUid = cursor.getLong(_cursorIndexOfUmCalendarUid);
                    _item.setUmCalendarUid(_tmpUmCalendarUid);
                    String _tmpUmCalendarName = cursor.isNull(_cursorIndexOfUmCalendarName) ? null : cursor.getString(_cursorIndexOfUmCalendarName);
                    _item.setUmCalendarName(_tmpUmCalendarName);
                    int _tmpUmCalendarCategory = cursor.getInt(_cursorIndexOfUmCalendarCategory);
                    _item.setUmCalendarCategory(_tmpUmCalendarCategory);
                    int _tmp = cursor.getInt(_cursorIndexOfUmCalendarActive);
                    boolean _tmpUmCalendarActive = _tmp != 0;
                    _item.setUmCalendarActive(_tmpUmCalendarActive);
                    long _tmpUmCalendarMasterChangeSeqNum = cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                    _item.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                    long _tmpUmCalendarLocalChangeSeqNum = cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                    _item.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                    int _tmpUmCalendarLastChangedBy = cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                    _item.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                    long _tmpUmCalendarLct = cursor.getLong(_cursorIndexOfUmCalendarLct);
                    _item.setUmCalendarLct(_tmpUmCalendarLct);
                    int _tmpNumEntries = cursor.getInt(_cursorIndexOfNumEntries);
                    _item.setNumEntries(_tmpNumEntries);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Flow<List<HolidayCalendar>> findAllHolidaysLiveData() {
        String _sql = "SELECT * FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND umCalendarCategory = 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND umCalendarCategory = 1", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"HolidayCalendar"}, (Callable)new Callable<List<HolidayCalendar>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<HolidayCalendar> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HolidayCalendarDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
                    int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
                    int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
                    int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
                    int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
                    int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
                    int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
                    ArrayList<HolidayCalendar> _result2 = new ArrayList<HolidayCalendar>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        HolidayCalendar _item = new HolidayCalendar();
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _item.setUmCalendarUid(_tmpUmCalendarUid);
                        String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                        _item.setUmCalendarName(_tmpUmCalendarName);
                        int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                        _item.setUmCalendarCategory(_tmpUmCalendarCategory);
                        int _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                        boolean _tmpUmCalendarActive = _tmp != 0;
                        _item.setUmCalendarActive(_tmpUmCalendarActive);
                        long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                        _item.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                        long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                        _item.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                        int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                        _item.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                        long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                        _item.setUmCalendarLct(_tmpUmCalendarLct);
                        _result2.add(_item);
                    }
                    ArrayList<HolidayCalendar> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<HolidayCalendar> findByUidLive(long uid) {
        String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ? AND CAST(umCalendarActive AS INTEGER) = 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HolidayCalendar WHERE umCalendarUid = ? AND CAST(umCalendarActive AS INTEGER) = 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"HolidayCalendar"}, (Callable)new Callable<HolidayCalendar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public HolidayCalendar call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)HolidayCalendarDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    HolidayCalendar _result2;
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
                    int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
                    int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
                    int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
                    int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
                    int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
                    int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new HolidayCalendar();
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _result2.setUmCalendarUid(_tmpUmCalendarUid);
                        String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                        _result2.setUmCalendarName(_tmpUmCalendarName);
                        int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                        _result2.setUmCalendarCategory(_tmpUmCalendarCategory);
                        int _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                        boolean _tmpUmCalendarActive = _tmp != 0;
                        _result2.setUmCalendarActive(_tmpUmCalendarActive);
                        long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                        _result2.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                        long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                        _result2.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                        int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                        _result2.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                        long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                        _result2.setUmCalendarLct(_tmpUmCalendarLct);
                    } else {
                        _result2 = null;
                    }
                    HolidayCalendar holidayCalendar = _result2;
                    return holidayCalendar;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByUid(long uid, Continuation<? super HolidayCalendar> $completion) {
        String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<HolidayCalendar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public HolidayCalendar call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)HolidayCalendarDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    HolidayCalendar _result2;
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
                    int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
                    int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
                    int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
                    int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
                    int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
                    int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new HolidayCalendar();
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _result2.setUmCalendarUid(_tmpUmCalendarUid);
                        String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                        _result2.setUmCalendarName(_tmpUmCalendarName);
                        int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                        _result2.setUmCalendarCategory(_tmpUmCalendarCategory);
                        int _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                        boolean _tmpUmCalendarActive = _tmp != 0;
                        _result2.setUmCalendarActive(_tmpUmCalendarActive);
                        long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                        _result2.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                        long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                        _result2.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                        int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                        _result2.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                        long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                        _result2.setUmCalendarLct(_tmpUmCalendarLct);
                    } else {
                        _result2 = null;
                    }
                    HolidayCalendar holidayCalendar = _result2;
                    return holidayCalendar;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super HolidayCalendar> $completion) {
        String _sql = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM HolidayCalendar WHERE umCalendarUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<HolidayCalendar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public HolidayCalendar call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)HolidayCalendarDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    HolidayCalendar _result2;
                    int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarUid");
                    int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarName");
                    int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarCategory");
                    int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarActive");
                    int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarMasterChangeSeqNum");
                    int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLocalChangeSeqNum");
                    int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLastChangedBy");
                    int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"umCalendarLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new HolidayCalendar();
                        long _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
                        _result2.setUmCalendarUid(_tmpUmCalendarUid);
                        String _tmpUmCalendarName = _cursor.isNull(_cursorIndexOfUmCalendarName) ? null : _cursor.getString(_cursorIndexOfUmCalendarName);
                        _result2.setUmCalendarName(_tmpUmCalendarName);
                        int _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
                        _result2.setUmCalendarCategory(_tmpUmCalendarCategory);
                        int _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
                        boolean _tmpUmCalendarActive = _tmp != 0;
                        _result2.setUmCalendarActive(_tmpUmCalendarActive);
                        long _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
                        _result2.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
                        long _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
                        _result2.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
                        int _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
                        _result2.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
                        long _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
                        _result2.setUmCalendarLct(_tmpUmCalendarLct);
                    } else {
                        _result2 = null;
                    }
                    HolidayCalendar holidayCalendar = _result2;
                    return holidayCalendar;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

