/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ReportQueryResultDao;
import com.ustadmobile.lib.db.entities.ReportQueryResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ReportQueryResultDao_Impl
extends ReportQueryResultDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ReportQueryResult> __insertionAdapterOfReportQueryResult;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReportUidAndTimeZone;

    public ReportQueryResultDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReportQueryResult = new EntityInsertionAdapter<ReportQueryResult>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ReportQueryResult` (`rqrUid`,`rqrReportUid`,`rqrLastModified`,`rqrLastValidated`,`rqrReportSeriesUid`,`rqrXAxis`,`rqrYAxis`,`rqrSubgroup`,`rqrTimeZone`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ReportQueryResult entity) {
                statement.bindLong(1, entity.getRqrUid());
                statement.bindLong(2, entity.getRqrReportUid());
                statement.bindLong(3, entity.getRqrLastModified());
                statement.bindLong(4, entity.getRqrLastValidated());
                statement.bindLong(5, (long)entity.getRqrReportSeriesUid());
                statement.bindString(6, entity.getRqrXAxis());
                statement.bindDouble(7, entity.getRqrYAxis());
                statement.bindString(8, entity.getRqrSubgroup());
                statement.bindString(9, entity.getRqrTimeZone());
            }
        };
        this.__preparedStmtOfDeleteByReportUidAndTimeZone = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        DELETE FROM ReportQueryResult\n         WHERE rqrReportUid = ?\n           AND rqrTimeZone = ?\n    ";
                return "\n        DELETE FROM ReportQueryResult\n         WHERE rqrReportUid = ?\n           AND rqrTimeZone = ?\n    ";
            }
        };
    }

    @Override
    public Object insertAllAsync(final List<ReportQueryResult> results, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ReportQueryResultDao_Impl.this.__db.beginTransaction();
                try {
                    ReportQueryResultDao_Impl.this.__insertionAdapterOfReportQueryResult.insert((Iterable)results);
                    ReportQueryResultDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReportQueryResultDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteByReportUidAndTimeZone(final long reportUid, final String timeZone, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ReportQueryResultDao_Impl.this.__preparedStmtOfDeleteByReportUidAndTimeZone.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, reportUid);
                _argIndex = 2;
                _stmt.bindString(_argIndex, timeZone);
                try {
                    Unit unit;
                    ReportQueryResultDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ReportQueryResultDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ReportQueryResultDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ReportQueryResultDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ReportQueryResultDao_Impl.this.__preparedStmtOfDeleteByReportUidAndTimeZone.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllByReportUidAndTimeZone(long reportUid, String timeZone, Continuation<? super List<ReportQueryResult>> $completion) {
        String _sql = "\n        SELECT ReportQueryResult.*\n          FROM ReportQueryResult\n         WHERE ReportQueryResult.rqrReportUid = ? \n           AND ReportQueryResult.rqrTimeZone = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ReportQueryResult.*\n          FROM ReportQueryResult\n         WHERE ReportQueryResult.rqrReportUid = ? \n           AND ReportQueryResult.rqrTimeZone = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, reportUid);
        _argIndex = 2;
        _statement.bindString(_argIndex, timeZone);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ReportQueryResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ReportQueryResult> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReportQueryResultDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfRqrUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrUid");
                    int _cursorIndexOfRqrReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrReportUid");
                    int _cursorIndexOfRqrLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrLastModified");
                    int _cursorIndexOfRqrLastValidated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrLastValidated");
                    int _cursorIndexOfRqrReportSeriesUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrReportSeriesUid");
                    int _cursorIndexOfRqrXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrXAxis");
                    int _cursorIndexOfRqrYAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrYAxis");
                    int _cursorIndexOfRqrSubgroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrSubgroup");
                    int _cursorIndexOfRqrTimeZone = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rqrTimeZone");
                    ArrayList<ReportQueryResult> _result2 = new ArrayList<ReportQueryResult>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpRqrUid = _cursor.getLong(_cursorIndexOfRqrUid);
                        long _tmpRqrReportUid = _cursor.getLong(_cursorIndexOfRqrReportUid);
                        long _tmpRqrLastModified = _cursor.getLong(_cursorIndexOfRqrLastModified);
                        long _tmpRqrLastValidated = _cursor.getLong(_cursorIndexOfRqrLastValidated);
                        int _tmpRqrReportSeriesUid = _cursor.getInt(_cursorIndexOfRqrReportSeriesUid);
                        String _tmpRqrXAxis = _cursor.getString(_cursorIndexOfRqrXAxis);
                        double _tmpRqrYAxis = _cursor.getDouble(_cursorIndexOfRqrYAxis);
                        String _tmpRqrSubgroup = _cursor.getString(_cursorIndexOfRqrSubgroup);
                        String _tmpRqrTimeZone = _cursor.getString(_cursorIndexOfRqrTimeZone);
                        ReportQueryResult _item = new ReportQueryResult(_tmpRqrUid, _tmpRqrReportUid, _tmpRqrLastModified, _tmpRqrLastValidated, _tmpRqrReportSeriesUid, _tmpRqrXAxis, _tmpRqrYAxis, _tmpRqrSubgroup, _tmpRqrTimeZone);
                        _result2.add(_item);
                    }
                    ArrayList<ReportQueryResult> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object isReportFresh(long reportUid, String timeZone, long freshThresholdTime, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT ReportQueryResult.rqrLastModified\n                  FROM ReportQueryResult\n                 WHERE ReportQueryResult.rqrReportUid = ?\n                   AND ReportQueryResult.rqrTimeZone = ?\n                 LIMIT 1), 0) >= \n               (SELECT MAX(?, \n                            (SELECT COALESCE(\n                                    (SELECT Report.reportLastModTime\n                                       FROM Report\n                                      WHERE Report.reportUid = ?), 0))))\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT ReportQueryResult.rqrLastModified\n                  FROM ReportQueryResult\n                 WHERE ReportQueryResult.rqrReportUid = ?\n                   AND ReportQueryResult.rqrTimeZone = ?\n                 LIMIT 1), 0) >= \n               (SELECT MAX(?, \n                            (SELECT COALESCE(\n                                    (SELECT Report.reportLastModTime\n                                       FROM Report\n                                      WHERE Report.reportUid = ?), 0))))\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, reportUid);
        _argIndex = 2;
        _statement.bindString(_argIndex, timeZone);
        _argIndex = 3;
        _statement.bindLong(_argIndex, freshThresholdTime);
        _argIndex = 4;
        _statement.bindLong(_argIndex, reportUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReportQueryResultDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

