package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.AssignmentSubmitterUidAndName;
import com.ustadmobile.lib.db.composites.ClazzAssignmentAndBlock;
import com.ustadmobile.lib.db.entities.AssignmentProgressSummary;
import com.ustadmobile.lib.db.entities.AssignmentSubmitterSummary;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ClazzAssignmentCourseBlockAndSubmitterUid;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlockPicture;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupSet;
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Float;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzAssignmentDao_Impl extends ClazzAssignmentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzAssignment> __insertionAdapterOfClazzAssignment;

  private final EntityInsertionAdapter<ClazzAssignment> __insertionAdapterOfClazzAssignment_1;

  private final EntityDeletionOrUpdateAdapter<ClazzAssignment> __updateAdapterOfClazzAssignment;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public ClazzAssignmentDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzAssignment = new EntityInsertionAdapter<ClazzAssignment>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ClazzAssignment` (`caUid`,`caTitle`,`caDescription`,`caGroupUid`,`caActive`,`caClassCommentEnabled`,`caPrivateCommentsEnabled`,`caCompletionCriteria`,`caRequireFileSubmission`,`caFileType`,`caSizeLimit`,`caNumberOfFiles`,`caSubmissionPolicy`,`caMarkingType`,`caRequireTextSubmission`,`caTextLimitType`,`caTextLimit`,`caXObjectUid`,`caClazzUid`,`caPeerReviewerCount`,`caLocalChangeSeqNum`,`caMasterChangeSeqNum`,`caLastChangedBy`,`caLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzAssignment entity) {
        statement.bindLong(1, entity.getCaUid());
        if (entity.getCaTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCaTitle());
        }
        if (entity.getCaDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCaDescription());
        }
        statement.bindLong(4, entity.getCaGroupUid());
        final int _tmp = entity.getCaActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        final int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
        statement.bindLong(6, _tmp_1);
        final int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
        statement.bindLong(7, _tmp_2);
        statement.bindLong(8, entity.getCaCompletionCriteria());
        final int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
        statement.bindLong(9, _tmp_3);
        statement.bindLong(10, entity.getCaFileType());
        statement.bindLong(11, entity.getCaSizeLimit());
        statement.bindLong(12, entity.getCaNumberOfFiles());
        statement.bindLong(13, entity.getCaSubmissionPolicy());
        statement.bindLong(14, entity.getCaMarkingType());
        final int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
        statement.bindLong(15, _tmp_4);
        statement.bindLong(16, entity.getCaTextLimitType());
        statement.bindLong(17, entity.getCaTextLimit());
        statement.bindLong(18, entity.getCaXObjectUid());
        statement.bindLong(19, entity.getCaClazzUid());
        statement.bindLong(20, entity.getCaPeerReviewerCount());
        statement.bindLong(21, entity.getCaLocalChangeSeqNum());
        statement.bindLong(22, entity.getCaMasterChangeSeqNum());
        statement.bindLong(23, entity.getCaLastChangedBy());
        statement.bindLong(24, entity.getCaLct());
      }
    };
    this.__insertionAdapterOfClazzAssignment_1 = new EntityInsertionAdapter<ClazzAssignment>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ClazzAssignment` (`caUid`,`caTitle`,`caDescription`,`caGroupUid`,`caActive`,`caClassCommentEnabled`,`caPrivateCommentsEnabled`,`caCompletionCriteria`,`caRequireFileSubmission`,`caFileType`,`caSizeLimit`,`caNumberOfFiles`,`caSubmissionPolicy`,`caMarkingType`,`caRequireTextSubmission`,`caTextLimitType`,`caTextLimit`,`caXObjectUid`,`caClazzUid`,`caPeerReviewerCount`,`caLocalChangeSeqNum`,`caMasterChangeSeqNum`,`caLastChangedBy`,`caLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzAssignment entity) {
        statement.bindLong(1, entity.getCaUid());
        if (entity.getCaTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCaTitle());
        }
        if (entity.getCaDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCaDescription());
        }
        statement.bindLong(4, entity.getCaGroupUid());
        final int _tmp = entity.getCaActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        final int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
        statement.bindLong(6, _tmp_1);
        final int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
        statement.bindLong(7, _tmp_2);
        statement.bindLong(8, entity.getCaCompletionCriteria());
        final int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
        statement.bindLong(9, _tmp_3);
        statement.bindLong(10, entity.getCaFileType());
        statement.bindLong(11, entity.getCaSizeLimit());
        statement.bindLong(12, entity.getCaNumberOfFiles());
        statement.bindLong(13, entity.getCaSubmissionPolicy());
        statement.bindLong(14, entity.getCaMarkingType());
        final int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
        statement.bindLong(15, _tmp_4);
        statement.bindLong(16, entity.getCaTextLimitType());
        statement.bindLong(17, entity.getCaTextLimit());
        statement.bindLong(18, entity.getCaXObjectUid());
        statement.bindLong(19, entity.getCaClazzUid());
        statement.bindLong(20, entity.getCaPeerReviewerCount());
        statement.bindLong(21, entity.getCaLocalChangeSeqNum());
        statement.bindLong(22, entity.getCaMasterChangeSeqNum());
        statement.bindLong(23, entity.getCaLastChangedBy());
        statement.bindLong(24, entity.getCaLct());
      }
    };
    this.__updateAdapterOfClazzAssignment = new EntityDeletionOrUpdateAdapter<ClazzAssignment>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ClazzAssignment` SET `caUid` = ?,`caTitle` = ?,`caDescription` = ?,`caGroupUid` = ?,`caActive` = ?,`caClassCommentEnabled` = ?,`caPrivateCommentsEnabled` = ?,`caCompletionCriteria` = ?,`caRequireFileSubmission` = ?,`caFileType` = ?,`caSizeLimit` = ?,`caNumberOfFiles` = ?,`caSubmissionPolicy` = ?,`caMarkingType` = ?,`caRequireTextSubmission` = ?,`caTextLimitType` = ?,`caTextLimit` = ?,`caXObjectUid` = ?,`caClazzUid` = ?,`caPeerReviewerCount` = ?,`caLocalChangeSeqNum` = ?,`caMasterChangeSeqNum` = ?,`caLastChangedBy` = ?,`caLct` = ? WHERE `caUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzAssignment entity) {
        statement.bindLong(1, entity.getCaUid());
        if (entity.getCaTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCaTitle());
        }
        if (entity.getCaDescription() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCaDescription());
        }
        statement.bindLong(4, entity.getCaGroupUid());
        final int _tmp = entity.getCaActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        final int _tmp_1 = entity.getCaClassCommentEnabled() ? 1 : 0;
        statement.bindLong(6, _tmp_1);
        final int _tmp_2 = entity.getCaPrivateCommentsEnabled() ? 1 : 0;
        statement.bindLong(7, _tmp_2);
        statement.bindLong(8, entity.getCaCompletionCriteria());
        final int _tmp_3 = entity.getCaRequireFileSubmission() ? 1 : 0;
        statement.bindLong(9, _tmp_3);
        statement.bindLong(10, entity.getCaFileType());
        statement.bindLong(11, entity.getCaSizeLimit());
        statement.bindLong(12, entity.getCaNumberOfFiles());
        statement.bindLong(13, entity.getCaSubmissionPolicy());
        statement.bindLong(14, entity.getCaMarkingType());
        final int _tmp_4 = entity.getCaRequireTextSubmission() ? 1 : 0;
        statement.bindLong(15, _tmp_4);
        statement.bindLong(16, entity.getCaTextLimitType());
        statement.bindLong(17, entity.getCaTextLimit());
        statement.bindLong(18, entity.getCaXObjectUid());
        statement.bindLong(19, entity.getCaClazzUid());
        statement.bindLong(20, entity.getCaPeerReviewerCount());
        statement.bindLong(21, entity.getCaLocalChangeSeqNum());
        statement.bindLong(22, entity.getCaMasterChangeSeqNum());
        statement.bindLong(23, entity.getCaLastChangedBy());
        statement.bindLong(24, entity.getCaLct());
        statement.bindLong(25, entity.getCaUid());
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzAssignment \n"
                + "           SET caActive = ?, \n"
                + "               caLct = ?\n"
                + "         WHERE caUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzAssignment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzAssignment.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzAssignment entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzAssignment.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ClazzAssignment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzAssignment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ClazzAssignment> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzAssignment.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<ClazzAssignment> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzAssignment_1.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final ClazzAssignment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzAssignment.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends ClazzAssignment> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzAssignment.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateAsync(final ClazzAssignment clazzAssignment,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzAssignment.handle(clazzAssignment);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllAssignmentsByClazzUidAsync(final long clazzUid,
      final Continuation<? super List<ClazzAssignment>> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment\n"
            + "         WHERE ClazzAssignment.caClazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzAssignment>>() {
      @Override
      @NonNull
      public List<ClazzAssignment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final List<ClazzAssignment> _result = new ArrayList<ClazzAssignment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzAssignment _item;
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            final int _tmpCaPeerReviewerCount;
            _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _item = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<AssignmentProgressSummary> getProgressSummaryForAssignment(final long assignmentUid,
      final long clazzUid, final long accountPersonUid, final String group) {
    final String _sql = "\n"
            + "        WITH \n"
            + "            HasLearningRecordSelectPermission (hasPermission) AS\n"
            + "            (SELECT (\n"
            + "                  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))\n"
            + "        ,\n"
            + "        \n"
            + "        AssignmentClazzUid(clazzUid) AS\n"
            + "        (SELECT ClazzAssignment.caClazzUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?)  \n"
            + "    ,\n"
            + "        \n"
            + "        SubmitterList(submitterId, name) AS \n"
            + "        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n"
            + "        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                Person.firstNames || ' ' || Person.lastName AS name\n"
            + "           FROM ClazzEnrolment\n"
            + "                JOIN Person \n"
            + "                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) = 0\n"
            + "            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR  \n"
            + "                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n"
            + "                 (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                  AND\n"
            + "                  EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                           FROM PeerReviewerAllocation\n"
            + "                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n"
            + "                 )\n"
            + "         UNION\n"
            + "         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n"
            + "         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n"
            + "           FROM CourseGroupMember\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) != 0\n"
            + "            AND CourseGroupMember.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR \n"
            + "                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n"
            + "                (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                 AND\n"
            + "                 EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                          FROM PeerReviewerAllocation\n"
            + "                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n"
            + "                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n"
            + "                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n"
            + "                                  FROM CourseGroupMember CourseGroupMemberInner\n"
            + "                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n"
            + "                                 LIMIT 1)\n"
            + "                        ))\n"
            + "            )\n"
            + "        )\n"
            + "        \n"
            + "    \n"
            + "        \n"
            + "        SELECT \n"
            + "              -- whether or not the active user has permission to view learner records \n"
            + "              (SELECT hasPermission\n"
            + "                 FROM HasLearningRecordSelectPermission) AS activeUserHasViewLearnerRecordsPermission,\n"
            + "        \n"
            + "              (SELECT COUNT(*)\n"
            + "                 FROM SubmitterList) AS totalStudents,\n"
            + "              \n"
            + "              -- Total marked students\n"
            + "              (SELECT COUNT(*)\n"
            + "                 FROM SubmitterList\n"
            + "                WHERE EXISTS(\n"
            + "                      SELECT CourseAssignmentMark.camUid\n"
            + "                        FROM CourseAssignmentMark\n"
            + "                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                         AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId) \n"
            + "                ) AS markedStudents,\n"
            + "              \n"
            + "              -- Total who have submitted  \n"
            + "              (SELECT COUNT(*)\n"
            + "                 FROM SubmitterList\n"
            + "                WHERE EXISTS(\n"
            + "                      SELECT CourseAssignmentSubmission.casUid\n"
            + "                        FROM CourseAssignmentSubmission\n"
            + "                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                         AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId)\n"
            + "                ) AS submittedStudents,\n"
            + "              \n"
            + "              (SELECT (ClazzAssignment.caGroupUid != 0)\n"
            + "                 FROM ClazzAssignment\n"
            + "                WHERE ClazzAssignment.caUid = ?) AS isGroupAssignment\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 22);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindString(_argIndex, group);
    _argIndex = 14;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz", "CoursePermission",
        "ClazzEnrolment", "SystemPermission", "ClazzAssignment", "Person", "PeerReviewerAllocation",
        "CourseGroupMember", "CourseAssignmentMark",
        "CourseAssignmentSubmission"}, new Callable<AssignmentProgressSummary>() {
      @Override
      @Nullable
      public AssignmentProgressSummary call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActiveUserHasViewLearnerRecordsPermission = 0;
          final int _cursorIndexOfTotalStudents = 1;
          final int _cursorIndexOfMarkedStudents = 2;
          final int _cursorIndexOfSubmittedStudents = 3;
          final int _cursorIndexOfIsGroupAssignment = 4;
          final AssignmentProgressSummary _result;
          if (_cursor.moveToFirst()) {
            _result = new AssignmentProgressSummary();
            final boolean _tmpActiveUserHasViewLearnerRecordsPermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActiveUserHasViewLearnerRecordsPermission);
            _tmpActiveUserHasViewLearnerRecordsPermission = _tmp != 0;
            _result.setActiveUserHasViewLearnerRecordsPermission(_tmpActiveUserHasViewLearnerRecordsPermission);
            final int _tmpTotalStudents;
            _tmpTotalStudents = _cursor.getInt(_cursorIndexOfTotalStudents);
            _result.setTotalStudents(_tmpTotalStudents);
            final int _tmpMarkedStudents;
            _tmpMarkedStudents = _cursor.getInt(_cursorIndexOfMarkedStudents);
            _result.setMarkedStudents(_tmpMarkedStudents);
            final int _tmpSubmittedStudents;
            _tmpSubmittedStudents = _cursor.getInt(_cursorIndexOfSubmittedStudents);
            _result.setSubmittedStudents(_tmpSubmittedStudents);
            final boolean _tmpIsGroupAssignment;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsGroupAssignment);
            _tmpIsGroupAssignment = _tmp_1 != 0;
            _result.setGroupAssignment(_tmpIsGroupAssignment);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, AssignmentSubmitterSummary> getAssignmentSubmitterSummaryListForAssignment(
      final long assignmentUid, final long clazzUid, final long accountPersonUid,
      final String group, final String searchText, final int sortOption) {
    final String _sql = "\n"
            + "        WITH \n"
            + "            HasLearningRecordSelectPermission (hasPermission) AS\n"
            + "            (SELECT (\n"
            + "                  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))\n"
            + "        ,\n"
            + "             \n"
            + "        AssignmentClazzUid(clazzUid) AS\n"
            + "        (SELECT ClazzAssignment.caClazzUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?)  \n"
            + "    ,\n"
            + "             \n"
            + "        SubmitterList(submitterId, name) AS \n"
            + "        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n"
            + "        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                Person.firstNames || ' ' || Person.lastName AS name\n"
            + "           FROM ClazzEnrolment\n"
            + "                JOIN Person \n"
            + "                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) = 0\n"
            + "            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR  \n"
            + "                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n"
            + "                 (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                  AND\n"
            + "                  EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                           FROM PeerReviewerAllocation\n"
            + "                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n"
            + "                 )\n"
            + "         UNION\n"
            + "         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n"
            + "         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n"
            + "           FROM CourseGroupMember\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) != 0\n"
            + "            AND CourseGroupMember.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR \n"
            + "                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n"
            + "                (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                 AND\n"
            + "                 EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                          FROM PeerReviewerAllocation\n"
            + "                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n"
            + "                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n"
            + "                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n"
            + "                                  FROM CourseGroupMember CourseGroupMemberInner\n"
            + "                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n"
            + "                                 LIMIT 1)\n"
            + "                        ))\n"
            + "            )\n"
            + "        )\n"
            + "        \n"
            + "    \n"
            + "        \n"
            + "        SELECT SubmitterList.name AS name,\n"
            + "               SubmitterList.submitterId AS submitterUid,\n"
            + "               Comments.commentsText AS latestPrivateComment,\n"
            + "               CASE \n"
            + "               WHEN SubmitterList.submitterId >= 10000 THEN\n"
            + "                    (SELECT PersonPicture.personPictureThumbnailUri\n"
            + "                       FROM PersonPicture\n"
            + "                      WHERE PersonPicture.personPictureUid =  SubmitterList.submitterId)\n"
            + "               ELSE NULL\n"
            + "               END AS pictureUri,       \n"
            + "               -- Determine submission status - marked, submitted, or not yet submitted\n"
            + "               CASE \n"
            + "               WHEN CourseAssignmentMark.camUid IS NOT NULL THEN 2\n"
            + "               WHEN CourseAssignmentSubmission.casUid IS NOT NULL THEN 1\n"
            + "               ELSE 0 \n"
            + "               END AS fileSubmissionStatus\n"
            + "               \n"
            + "          FROM SubmitterList\n"
            + "               LEFT JOIN Comments \n"
            + "                         ON Comments.commentsUid = \n"
            + "                            (SELECT Comments.commentsUid \n"
            + "                               FROM Comments\n"
            + "                              WHERE Comments.commentsEntityUid = ?\n"
            + "                                AND Comments.commentsForSubmitterUid = SubmitterList.submitterId\n"
            + "                                AND NOT Comments.commentsDeleted\n"
            + "                           ORDER BY Comments.commentsDateTimeAdded DESC     \n"
            + "                              LIMIT 1) \n"
            + "               LEFT JOIN CourseAssignmentMark\n"
            + "                         ON CourseAssignmentMark.camUid = \n"
            + "                            (SELECT camUid\n"
            + "                               FROM CourseAssignmentMark\n"
            + "                              WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                                AND CourseAssignmentMark.camSubmitterUid = SubmitterList.submitterId\n"
            + "                              LIMIT 1)\n"
            + "               LEFT JOIN CourseAssignmentSubmission\n"
            + "                         ON CourseAssignmentSubmission.casUid = \n"
            + "                            (SELECT casUid\n"
            + "                               FROM CourseAssignmentSubmission\n"
            + "                              WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                                AND CourseAssignmentSubmission.casSubmitterUid = SubmitterList.submitterId \n"
            + "                              LIMIT 1)\n"
            + "         WHERE (? = '%' OR SubmitterList.name LIKE ?)\n"
            + "      ORDER BY CASE(?)\n"
            + "               WHEN 5 THEN SubmitterList.name\n"
            + "               ELSE '' END ASC,\n"
            + "               CASE(?)\n"
            + "               WHEN 6 THEN SubmitterList.name\n"
            + "               ELSE '' END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 26);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindString(_argIndex, group);
    _argIndex = 14;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 23;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 24;
    _statement.bindString(_argIndex, searchText);
    _argIndex = 25;
    _statement.bindLong(_argIndex, sortOption);
    _argIndex = 26;
    _statement.bindLong(_argIndex, sortOption);
    return new LimitOffsetPagingSource<AssignmentSubmitterSummary>(_statement, __db, "Clazz", "CoursePermission", "ClazzEnrolment", "SystemPermission", "ClazzAssignment", "Person", "PeerReviewerAllocation", "CourseGroupMember", "PersonPicture", "Comments", "CourseAssignmentMark", "CourseAssignmentSubmission") {
      @Override
      @NonNull
      protected List<AssignmentSubmitterSummary> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfName = 0;
        final int _cursorIndexOfSubmitterUid = 1;
        final int _cursorIndexOfLatestPrivateComment = 2;
        final int _cursorIndexOfPictureUri = 3;
        final int _cursorIndexOfFileSubmissionStatus = 4;
        final List<AssignmentSubmitterSummary> _result = new ArrayList<AssignmentSubmitterSummary>(cursor.getCount());
        while (cursor.moveToNext()) {
          final AssignmentSubmitterSummary _item;
          final String _tmpName;
          if (cursor.isNull(_cursorIndexOfName)) {
            _tmpName = null;
          } else {
            _tmpName = cursor.getString(_cursorIndexOfName);
          }
          final long _tmpSubmitterUid;
          _tmpSubmitterUid = cursor.getLong(_cursorIndexOfSubmitterUid);
          final String _tmpLatestPrivateComment;
          if (cursor.isNull(_cursorIndexOfLatestPrivateComment)) {
            _tmpLatestPrivateComment = null;
          } else {
            _tmpLatestPrivateComment = cursor.getString(_cursorIndexOfLatestPrivateComment);
          }
          final String _tmpPictureUri;
          if (cursor.isNull(_cursorIndexOfPictureUri)) {
            _tmpPictureUri = null;
          } else {
            _tmpPictureUri = cursor.getString(_cursorIndexOfPictureUri);
          }
          final int _tmpFileSubmissionStatus;
          _tmpFileSubmissionStatus = cursor.getInt(_cursorIndexOfFileSubmissionStatus);
          _item = new AssignmentSubmitterSummary(_tmpSubmitterUid,_tmpName,_tmpPictureUri,_tmpLatestPrivateComment,_tmpFileSubmissionStatus);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object getCourseGroupMembersByAssignmentUid(final long assignmentUid,
      final Continuation<? super List<CourseGroupMember>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseGroupMember.*\n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE CourseGroupMember.cgmSetUid = \n"
            + "               (SELECT ClazzAssignment.caGroupUid\n"
            + "                  FROM ClazzAssignment\n"
            + "                 WHERE ClazzAssignment.caUid = ?) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMember>>() {
      @Override
      @NonNull
      public List<CourseGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final List<CourseGroupMember> _result = new ArrayList<CourseGroupMember>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMember _item;
            final long _tmpCgmUid;
            _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
            final long _tmpCgmSetUid;
            _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
            final int _tmpCgmGroupNumber;
            _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
            final long _tmpCgmPersonUid;
            _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
            final long _tmpCgmLct;
            _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
            _item = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getAssignmentSubmissionsByAssignmentUid(final long assignmentUid,
      final long clazzUid, final long accountPersonUid, final String group,
      final Continuation<? super List<CourseAssignmentSubmission>> $completion) {
    final String _sql = "\n"
            + "        WITH \n"
            + "            HasLearningRecordSelectPermission (hasPermission) AS\n"
            + "            (SELECT (\n"
            + "                  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))\n"
            + "        ,\n"
            + "             \n"
            + "        AssignmentClazzUid(clazzUid) AS\n"
            + "        (SELECT ClazzAssignment.caClazzUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?)  \n"
            + "    ,\n"
            + "             \n"
            + "        SubmitterList(submitterId, name) AS \n"
            + "        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n"
            + "        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                Person.firstNames || ' ' || Person.lastName AS name\n"
            + "           FROM ClazzEnrolment\n"
            + "                JOIN Person \n"
            + "                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) = 0\n"
            + "            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR  \n"
            + "                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n"
            + "                 (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                  AND\n"
            + "                  EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                           FROM PeerReviewerAllocation\n"
            + "                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n"
            + "                 )\n"
            + "         UNION\n"
            + "         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n"
            + "         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n"
            + "           FROM CourseGroupMember\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) != 0\n"
            + "            AND CourseGroupMember.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR \n"
            + "                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n"
            + "                (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                 AND\n"
            + "                 EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                          FROM PeerReviewerAllocation\n"
            + "                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n"
            + "                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n"
            + "                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n"
            + "                                  FROM CourseGroupMember CourseGroupMemberInner\n"
            + "                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n"
            + "                                 LIMIT 1)\n"
            + "                        ))\n"
            + "            )\n"
            + "        )\n"
            + "        \n"
            + "    \n"
            + "      SELECT CourseAssignmentSubmission.*\n"
            + "        FROM CourseAssignmentSubmission \n"
            + "       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "         AND CourseAssignmentSubmission.casClazzUid = ?\n"
            + "         AND CourseAssignmentSubmission.casSubmitterUid IN \n"
            + "             (SELECT SubmitterList.submitterId\n"
            + "                FROM SubmitterList) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 21);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindString(_argIndex, group);
    _argIndex = 14;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseAssignmentSubmission>>() {
      @Override
      @NonNull
      public List<CourseAssignmentSubmission> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final int _cursorIndexOfCasClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casClazzUid");
          final List<CourseAssignmentSubmission> _result = new ArrayList<CourseAssignmentSubmission>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentSubmission _item;
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            final long _tmpCasClazzUid;
            _tmpCasClazzUid = _cursor.getLong(_cursorIndexOfCasClazzUid);
            _item = new CourseAssignmentSubmission(_tmpCasUid,_tmpCasAssignmentUid,_tmpCasSubmitterUid,_tmpCasSubmitterPersonUid,_tmpCasText,_tmpCasType,_tmpCasTimestamp,_tmpCasClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getAssignmentMarksByAssignmentUid(final long assignmentUid, final long clazzUid,
      final long accountPersonUid, final String group,
      final Continuation<? super List<? extends CourseAssignmentMark>> $completion) {
    final String _sql = "\n"
            + "        WITH \n"
            + "            HasLearningRecordSelectPermission (hasPermission) AS\n"
            + "            (SELECT (\n"
            + "                  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))\n"
            + "        ,\n"
            + "             \n"
            + "        AssignmentClazzUid(clazzUid) AS\n"
            + "        (SELECT ClazzAssignment.caClazzUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?)  \n"
            + "    ,\n"
            + "             \n"
            + "        SubmitterList(submitterId, name) AS \n"
            + "        -- List of submitter uids and names if individual assignment eg caGroupUid = 0\n"
            + "        (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                Person.firstNames || ' ' || Person.lastName AS name\n"
            + "           FROM ClazzEnrolment\n"
            + "                JOIN Person \n"
            + "                     ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) = 0\n"
            + "            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "            -- either the active user has learnign record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR  \n"
            + "                 -- check if the active person eg accountpersonuid is assigned to mark this peer\n"
            + "                 (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                  AND\n"
            + "                  EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                           FROM PeerReviewerAllocation\n"
            + "                          WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                            AND PeerReviewerAllocation.praToMarkerSubmitterUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                            AND PeerReviewerAllocation.praMarkerSubmitterUid = ?))\n"
            + "                 )\n"
            + "         UNION\n"
            + "         -- List of submitter uids and names if the assignment is submitted by groups e.g. caGroupUid != 0\n"
            + "         SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                ? || ' ' || CourseGroupMember.cgmGroupNumber AS name\n"
            + "           FROM CourseGroupMember\n"
            + "          WHERE (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    ) != 0\n"
            + "            AND CourseGroupMember.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "            -- either the active user has learning record select permission on class or is an assigned reviewer for submitter\n"
            + "            AND (\n"
            + "                (SELECT hasPermission \n"
            + "                   FROM HasLearningRecordSelectPermission)\n"
            + "                OR \n"
            + "                --check if the active user is in a group that was allocated to do a peer review of the given submitter uid\n"
            + "                (\n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "                 AND\n"
            + "                 EXISTS(SELECT PeerReviewerAllocation.praUid\n"
            + "                          FROM PeerReviewerAllocation\n"
            + "                         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "                           AND PeerReviewerAllocation.praToMarkerSubmitterUid = CourseGroupMember.cgmGroupNumber\n"
            + "                           AND PeerReviewerAllocation.praMarkerSubmitterUid = \n"
            + "                               (SELECT CourseGroupMemberInner.cgmGroupNumber\n"
            + "                                  FROM CourseGroupMember CourseGroupMemberInner\n"
            + "                                 WHERE CourseGroupMemberInner.cgmSetUid = (\n"
            + "        SELECT ClazzAssignment.caGroupUid\n"
            + "                   FROM ClazzAssignment\n"
            + "                  WHERE ClazzAssignment.caUid = ?\n"
            + "    )\n"
            + "                                   AND CourseGroupMemberInner.cgmPersonUid = ?\n"
            + "                                 LIMIT 1)\n"
            + "                        ))\n"
            + "            )\n"
            + "        )\n"
            + "        \n"
            + "    \n"
            + "      SELECT CourseAssignmentMark.*\n"
            + "        FROM CourseAssignmentMark \n"
            + "       WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "         AND CourseAssignmentMark.camClazzUid = ?\n"
            + "         AND CourseAssignmentMark.camSubmitterUid IN \n"
            + "             (SELECT SubmitterList.submitterId\n"
            + "                FROM SubmitterList)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 21);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindString(_argIndex, group);
    _argIndex = 14;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseAssignmentMark>>() {
      @Override
      @NonNull
      public List<CourseAssignmentMark> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camUid");
          final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camAssignmentUid");
          final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camSubmitterUid");
          final int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerSubmitterUid");
          final int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerPersonUid");
          final int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerComment");
          final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMark");
          final int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMaxMark");
          final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "camPenalty");
          final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(_cursor, "camLct");
          final int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camClazzUid");
          final List<CourseAssignmentMark> _result = new ArrayList<CourseAssignmentMark>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentMark _item;
            _item = new CourseAssignmentMark();
            final long _tmpCamUid;
            _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
            _item.setCamUid(_tmpCamUid);
            final long _tmpCamAssignmentUid;
            _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
            _item.setCamAssignmentUid(_tmpCamAssignmentUid);
            final long _tmpCamSubmitterUid;
            _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
            _item.setCamSubmitterUid(_tmpCamSubmitterUid);
            final long _tmpCamMarkerSubmitterUid;
            _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
            _item.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
            final long _tmpCamMarkerPersonUid;
            _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
            _item.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
            final String _tmpCamMarkerComment;
            if (_cursor.isNull(_cursorIndexOfCamMarkerComment)) {
              _tmpCamMarkerComment = null;
            } else {
              _tmpCamMarkerComment = _cursor.getString(_cursorIndexOfCamMarkerComment);
            }
            _item.setCamMarkerComment(_tmpCamMarkerComment);
            final float _tmpCamMark;
            _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
            _item.setCamMark(_tmpCamMark);
            final float _tmpCamMaxMark;
            _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
            _item.setCamMaxMark(_tmpCamMaxMark);
            final float _tmpCamPenalty;
            _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
            _item.setCamPenalty(_tmpCamPenalty);
            final long _tmpCamLct;
            _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
            _item.setCamLct(_tmpCamLct);
            final long _tmpCamClazzUid;
            _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
            _item.setCamClazzUid(_tmpCamClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getPeerReviewerAllocationsByAssignmentUid(final long assignmentUid,
      final long clazzUid, final long accountPersonUid,
      final Continuation<? super List<PeerReviewerAllocation>> $completion) {
    final String _sql = "\n"
            + "          WITH \n"
            + "            HasLearningRecordSelectPermission (hasPermission) AS\n"
            + "            (SELECT (\n"
            + "                  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ))\n"
            + "        \n"
            + "        SELECT PeerReviewerAllocation.*\n"
            + "          FROM PeerReviewerAllocation\n"
            + "         WHERE \n"
            + "        ((SELECT ClazzAssignment.caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE ClazzAssignment.caUid = ?) = 2)\n"
            + "    \n"
            + "          AND NOT \n"
            + "              (SELECT hasPermission \n"
            + "                 FROM HasLearningRecordSelectPermission) \n"
            + "           AND PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "           AND (   PeerReviewerAllocation.praMarkerSubmitterUid = ?\n"
            + "                OR PeerReviewerAllocation.praMarkerSubmitterUid IN \n"
            + "                   (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                      FROM CourseGroupMember\n"
            + "                     WHERE CourseGroupMember.cgmSetUid = \n"
            + "                           (SELECT ClazzAssignment.caGroupUid\n"
            + "                              FROM ClazzAssignment\n"
            + "                             WHERE ClazzAssignment.caUid = ?)))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 10);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PeerReviewerAllocation>>() {
      @Override
      @NonNull
      public List<PeerReviewerAllocation> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praUid");
          final int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praMarkerSubmitterUid");
          final int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praToMarkerSubmitterUid");
          final int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praAssignmentUid");
          final int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow(_cursor, "praActive");
          final int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow(_cursor, "praLct");
          final List<PeerReviewerAllocation> _result = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PeerReviewerAllocation _item;
            final long _tmpPraUid;
            _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
            final long _tmpPraMarkerSubmitterUid;
            _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
            final long _tmpPraToMarkerSubmitterUid;
            _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
            final long _tmpPraAssignmentUid;
            _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
            final boolean _tmpPraActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPraActive);
            _tmpPraActive = _tmp != 0;
            final long _tmpPraLct;
            _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
            _item = new PeerReviewerAllocation(_tmpPraUid,_tmpPraMarkerSubmitterUid,_tmpPraToMarkerSubmitterUid,_tmpPraAssignmentUid,_tmpPraActive,_tmpPraLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getPeerReviewAllocationsForPerson(final long assignmentUid,
      final long accountPersonUid,
      final Continuation<? super List<PeerReviewerAllocation>> $completion) {
    final String _sql = "\n"
            + "        SELECT PeerReviewerAllocation.*\n"
            + "          FROM PeerReviewerAllocation\n"
            + "         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "           AND (PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n"
            + "                OR\n"
            + "                PeerReviewerAllocation.praToMarkerSubmitterUid IN \n"
            + "                (SELECT CourseGroupMember.cgmSetUid \n"
            + "                   FROM CourseGroupMember\n"
            + "                  WHERE CourseGroupMember.cgmSetUid = \n"
            + "                        (SELECT ClazzAssignment.caGroupUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                    AND CourseGroupMember.cgmPersonUid = ?))                 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PeerReviewerAllocation>>() {
      @Override
      @NonNull
      public List<PeerReviewerAllocation> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praUid");
          final int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praMarkerSubmitterUid");
          final int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praToMarkerSubmitterUid");
          final int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praAssignmentUid");
          final int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow(_cursor, "praActive");
          final int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow(_cursor, "praLct");
          final List<PeerReviewerAllocation> _result = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PeerReviewerAllocation _item;
            final long _tmpPraUid;
            _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
            final long _tmpPraMarkerSubmitterUid;
            _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
            final long _tmpPraToMarkerSubmitterUid;
            _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
            final long _tmpPraAssignmentUid;
            _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
            final boolean _tmpPraActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPraActive);
            _tmpPraActive = _tmp != 0;
            final long _tmpPraLct;
            _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
            _item = new PeerReviewerAllocation(_tmpPraUid,_tmpPraMarkerSubmitterUid,_tmpPraToMarkerSubmitterUid,_tmpPraAssignmentUid,_tmpPraActive,_tmpPraLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getSubmitterUidsByClazzOrGroupSetUid(final long clazzUid, final long groupSetUid,
      final long time, final Continuation<? super List<Long>> $completion) {
    final String _sql = "\n"
            + "         -- Submitter UIDs for individual assignment the list of personuids enrolled in the course\n"
            + "         SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n"
            + "           FROM ClazzEnrolment\n"
            + "          WHERE (? = 0)\n"
            + "            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "            AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "            AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "          \n"
            + "         UNION\n"
            + "         \n"
            + "        SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE ? != 0\n"
            + "           AND CourseGroupMember.cgmSetUid = ?         \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, time);
    _argIndex = 4;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, groupSetUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      @NonNull
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Long _item;
            _item = _cursor.getLong(0);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getSubmitterUidsAndNameByClazzOrGroupSetUid(final long clazzUid,
      final long groupSetUid, final long date, final String groupStr,
      final Continuation<? super List<AssignmentSubmitterUidAndName>> $completion) {
    final String _sql = "\n"
            + "        WITH SubmitterUids(submitterUid) AS (\n"
            + "            SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterUid\n"
            + "               FROM ClazzEnrolment\n"
            + "              WHERE (? = 0)\n"
            + "                AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "              \n"
            + "             UNION\n"
            + "             \n"
            + "            SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterUid\n"
            + "              FROM CourseGroupMember\n"
            + "             WHERE ? != 0\n"
            + "               AND CourseGroupMember.cgmSetUid = ?    \n"
            + "        )\n"
            + "        \n"
            + "        SELECT SubmitterUids.submitterUid AS submitterUid,\n"
            + "               CASE ?\n"
            + "               WHEN 0 THEN\n"
            + "                      (SELECT Person.firstNames || ' ' || Person.lastName\n"
            + "                         FROM Person\n"
            + "                        WHERE Person.personUid = SubmitterUids.submitterUid)\n"
            + "               ELSE (? || ' ' || SubmitterUids.submitterUid)   \n"
            + "               END AS name\n"
            + "          FROM SubmitterUids                  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, date);
    _argIndex = 4;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, groupSetUid);
    _argIndex = 7;
    _statement.bindString(_argIndex, groupStr);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AssignmentSubmitterUidAndName>>() {
      @Override
      @NonNull
      public List<AssignmentSubmitterUidAndName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSubmitterUid = 0;
          final int _cursorIndexOfName = 1;
          final List<AssignmentSubmitterUidAndName> _result = new ArrayList<AssignmentSubmitterUidAndName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AssignmentSubmitterUidAndName _item;
            final long _tmpSubmitterUid;
            _tmpSubmitterUid = _cursor.getLong(_cursorIndexOfSubmitterUid);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _item = new AssignmentSubmitterUidAndName(_tmpName,_tmpSubmitterUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getSubmitterCountFromAssignment(final long groupUid, final long clazzUid,
      final String group, final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "         \n"
            + "             WITH SubmitterList (submitterId, name)\n"
            + "            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n"
            + "                       Person.firstNames || ' ' || Person.lastName AS name\n"
            + "                  FROM ClazzEnrolment\n"
            + "                  \n"
            + "                       JOIN Person \n"
            + "                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                       \n"
            + "                 WHERE ? = 0 \n"
            + "                   AND clazzEnrolmentClazzUid = ?\n"
            + "                   AND clazzEnrolmentActive\n"
            + "                   AND clazzEnrolmentRole = 1000\n"
            + "              GROUP BY submitterId, name\n"
            + "            UNION                 \n"
            + "             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n"
            + "                    ? || ' ' || CourseGroupMember.cgmGroupNumber AS name  \n"
            + "               FROM CourseGroupMember\n"
            + "                    JOIN CourseGroupSet\n"
            + "                    ON CourseGroupSet.cgsUid = ?\n"
            + "              WHERE CourseGroupMember.cgmSetUid = CourseGroupSet.cgsUid\n"
            + "                AND CourseGroupMember.cgmGroupNumber != 0\n"
            + "           GROUP BY submitterId, name\n"
            + "            )\n"
            + "        \n"
            + "        \n"
            + "         SELECT COUNT(*) \n"
            + "          FROM SubmitterList\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindString(_argIndex, group);
    _argIndex = 4;
    _statement.bindLong(_argIndex, groupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getSubmitterUid(final long assignmentUid, final long clazzUid,
      final long accountPersonUid, final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        WITH ClazzUidDummy(clazzUid) AS\n"
            + "             (SELECT ?)\n"
            + "             \n"
            + "        \n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super ClazzAssignment> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment \n"
            + "         WHERE caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzAssignment>() {
      @Override
      @Nullable
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            final int _tmpCaPeerReviewerCount;
            _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ClazzAssignment> findByUidAndClazzUidAsFlow(final long uid, final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment \n"
            + "         WHERE caUid = ?\n"
            + "           AND caClazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzAssignment"}, new Callable<ClazzAssignment>() {
      @Override
      @Nullable
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            final int _tmpCaPeerReviewerCount;
            _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByUidAndClazzUidAsync(final long assignmentUid, final long clazzUid,
      final Continuation<? super ClazzAssignment> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzAssignment.* \n"
            + "          FROM ClazzAssignment \n"
            + "         WHERE ClazzAssignment.caUid = ?\n"
            + "           AND ClazzAssignment.caClazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzAssignment>() {
      @Override
      @Nullable
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            final int _tmpCaPeerReviewerCount;
            _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getGroupUidFromAssignment(final long uid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "          SELECT COALESCE((\n"
            + "           SELECT caGroupUid\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE caUid = ?),-1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getMarkingTypeFromAssignment(final long uid,
      final Continuation<? super Integer> $completion) {
    final String _sql = "\n"
            + "          SELECT COALESCE((\n"
            + "           SELECT caMarkingType\n"
            + "           FROM ClazzAssignment\n"
            + "          WHERE caUid = ?),-1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidWithBlockAsync(final long uid,
      final Continuation<? super ClazzAssignmentAndBlock> $completion) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment\n"
            + "               LEFT JOIN CourseBlock\n"
            + "               ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "               AND CourseBlock.cbType = 103\n"
            + "         WHERE caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzAssignmentAndBlock>() {
      @Override
      @Nullable
      public ClazzAssignmentAndBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final ClazzAssignmentAndBlock _result;
          if (_cursor.moveToFirst()) {
            final ClazzAssignment _tmpAssignment;
            if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
              final long _tmpCaUid;
              _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
              final String _tmpCaTitle;
              if (_cursor.isNull(_cursorIndexOfCaTitle)) {
                _tmpCaTitle = null;
              } else {
                _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
              }
              final String _tmpCaDescription;
              if (_cursor.isNull(_cursorIndexOfCaDescription)) {
                _tmpCaDescription = null;
              } else {
                _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
              }
              final long _tmpCaGroupUid;
              _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
              final boolean _tmpCaActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCaActive);
              _tmpCaActive = _tmp != 0;
              final boolean _tmpCaClassCommentEnabled;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
              _tmpCaClassCommentEnabled = _tmp_1 != 0;
              final boolean _tmpCaPrivateCommentsEnabled;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
              _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
              final int _tmpCaCompletionCriteria;
              _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
              final boolean _tmpCaRequireFileSubmission;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
              _tmpCaRequireFileSubmission = _tmp_3 != 0;
              final int _tmpCaFileType;
              _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
              final int _tmpCaSizeLimit;
              _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
              final int _tmpCaNumberOfFiles;
              _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
              final int _tmpCaSubmissionPolicy;
              _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
              final int _tmpCaMarkingType;
              _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
              final boolean _tmpCaRequireTextSubmission;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
              _tmpCaRequireTextSubmission = _tmp_4 != 0;
              final int _tmpCaTextLimitType;
              _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
              final int _tmpCaTextLimit;
              _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
              final long _tmpCaXObjectUid;
              _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
              final long _tmpCaClazzUid;
              _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
              final int _tmpCaPeerReviewerCount;
              _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
              final long _tmpCaLocalChangeSeqNum;
              _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
              final long _tmpCaMasterChangeSeqNum;
              _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
              final int _tmpCaLastChangedBy;
              _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
              final long _tmpCaLct;
              _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
              _tmpAssignment = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
            } else {
              _tmpAssignment = null;
            }
            final CourseBlock _tmpBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_5 != 0;
              final boolean _tmpCbHidden;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_6 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpBlock = null;
            }
            _result = new ClazzAssignmentAndBlock(_tmpAssignment,_tmpBlock);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public ClazzAssignment findClazzAssignment() {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ClazzAssignment LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
      final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
      final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
      final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
      final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
      final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
      final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
      final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
      final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
      final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
      final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
      final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
      final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
      final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
      final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
      final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
      final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
      final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
      final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
      final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
      final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
      final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
      final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
      final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
      final ClazzAssignment _result;
      if (_cursor.moveToFirst()) {
        final long _tmpCaUid;
        _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
        final String _tmpCaTitle;
        if (_cursor.isNull(_cursorIndexOfCaTitle)) {
          _tmpCaTitle = null;
        } else {
          _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
        }
        final String _tmpCaDescription;
        if (_cursor.isNull(_cursorIndexOfCaDescription)) {
          _tmpCaDescription = null;
        } else {
          _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
        }
        final long _tmpCaGroupUid;
        _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
        final boolean _tmpCaActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCaActive);
        _tmpCaActive = _tmp != 0;
        final boolean _tmpCaClassCommentEnabled;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
        _tmpCaClassCommentEnabled = _tmp_1 != 0;
        final boolean _tmpCaPrivateCommentsEnabled;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
        _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
        final int _tmpCaCompletionCriteria;
        _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
        final boolean _tmpCaRequireFileSubmission;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
        _tmpCaRequireFileSubmission = _tmp_3 != 0;
        final int _tmpCaFileType;
        _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
        final int _tmpCaSizeLimit;
        _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
        final int _tmpCaNumberOfFiles;
        _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
        final int _tmpCaSubmissionPolicy;
        _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
        final int _tmpCaMarkingType;
        _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
        final boolean _tmpCaRequireTextSubmission;
        final int _tmp_4;
        _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
        _tmpCaRequireTextSubmission = _tmp_4 != 0;
        final int _tmpCaTextLimitType;
        _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
        final int _tmpCaTextLimit;
        _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
        final long _tmpCaXObjectUid;
        _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
        final long _tmpCaClazzUid;
        _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
        final int _tmpCaPeerReviewerCount;
        _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
        final long _tmpCaLocalChangeSeqNum;
        _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
        final long _tmpCaMasterChangeSeqNum;
        _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
        final int _tmpCaLastChangedBy;
        _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
        final long _tmpCaLct;
        _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
        _result = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<ClazzAssignment> findByUidLive(final long uid) {
    final String _sql = "SELECT * \n"
            + "                      FROM ClazzAssignment \n"
            + "                     WHERE caUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzAssignment"}, new Callable<ClazzAssignment>() {
      @Override
      @Nullable
      public ClazzAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final ClazzAssignment _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCaUid;
            _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
            final String _tmpCaTitle;
            if (_cursor.isNull(_cursorIndexOfCaTitle)) {
              _tmpCaTitle = null;
            } else {
              _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
            }
            final String _tmpCaDescription;
            if (_cursor.isNull(_cursorIndexOfCaDescription)) {
              _tmpCaDescription = null;
            } else {
              _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
            }
            final long _tmpCaGroupUid;
            _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
            final boolean _tmpCaActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCaActive);
            _tmpCaActive = _tmp != 0;
            final boolean _tmpCaClassCommentEnabled;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
            _tmpCaClassCommentEnabled = _tmp_1 != 0;
            final boolean _tmpCaPrivateCommentsEnabled;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
            _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
            final int _tmpCaCompletionCriteria;
            _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
            final boolean _tmpCaRequireFileSubmission;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
            _tmpCaRequireFileSubmission = _tmp_3 != 0;
            final int _tmpCaFileType;
            _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
            final int _tmpCaSizeLimit;
            _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
            final int _tmpCaNumberOfFiles;
            _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
            final int _tmpCaSubmissionPolicy;
            _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
            final int _tmpCaMarkingType;
            _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
            final boolean _tmpCaRequireTextSubmission;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
            _tmpCaRequireTextSubmission = _tmp_4 != 0;
            final int _tmpCaTextLimitType;
            _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
            final int _tmpCaTextLimit;
            _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
            final long _tmpCaXObjectUid;
            _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
            final long _tmpCaClazzUid;
            _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
            final int _tmpCaPeerReviewerCount;
            _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
            final long _tmpCaLocalChangeSeqNum;
            _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
            final long _tmpCaMasterChangeSeqNum;
            _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
            final int _tmpCaLastChangedBy;
            _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
            final long _tmpCaLct;
            _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
            _result = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<ClazzAssignmentCourseBlockAndSubmitterUid> findAssignmentCourseBlockAndSubmitterUidAsFlow(
      final long assignmentUid, final long clazzUid, final long accountPersonUid) {
    final String _sql = "\n"
            + "        WITH PersonIsStudent(isStudent)\n"
            + "             AS (SELECT EXISTS(\n"
            + "                        SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                           FROM ClazzEnrolment\n"
            + "                          WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                            AND ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                            AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n"
            + "                        \n"
            + "        SELECT ClazzAssignment.*,\n"
            + "               CourseBlock.*,\n"
            + "               CourseBlockPicture.*,\n"
            + "               CourseGroupSet.*,\n"
            + "               (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    ) AS submitterUid,\n"
            + "               \n"
            + "               ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         4\n"
            + "                \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     4\n"
            + "                \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    ) AS hasModeratePermission\n"
            + "                   \n"
            + "          FROM ClazzAssignment\n"
            + "               JOIN CourseBlock\n"
            + "                    ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n"
            + "               LEFT JOIN CourseBlockPicture\n"
            + "                    ON CourseBlockPicture.cbpUid = CourseBlock.cbUid\n"
            + "               LEFT JOIN CourseGroupSet\n"
            + "                    ON CourseGroupSet.cgsUid = ClazzAssignment.caGroupUid\n"
            + "         WHERE ClazzAssignment.caUid = ?\n"
            + "           AND ClazzAssignment.caClazzUid = ?\n"
            + "           AND (\n"
            + "                (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         1\n"
            + "                \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     1\n"
            + "                \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 26);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 23;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 24;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 25;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 26;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment", "ClazzAssignment",
        "CourseGroupMember", "Clazz", "CoursePermission", "SystemPermission", "CourseBlock",
        "CourseBlockPicture",
        "CourseGroupSet"}, new Callable<ClazzAssignmentCourseBlockAndSubmitterUid>() {
      @Override
      @Nullable
      public ClazzAssignmentCourseBlockAndSubmitterUid call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpUid");
          final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpLct");
          final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpPictureUri");
          final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpThumbnailUri");
          final int _cursorIndexOfCgsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsUid");
          final int _cursorIndexOfCgsName = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsName");
          final int _cursorIndexOfCgsTotalGroups = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsTotalGroups");
          final int _cursorIndexOfCgsActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsActive");
          final int _cursorIndexOfCgsClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsClazzUid");
          final int _cursorIndexOfCgsLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgsLct");
          final int _cursorIndexOfSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "submitterUid");
          final int _cursorIndexOfHasModeratePermission = CursorUtil.getColumnIndexOrThrow(_cursor, "hasModeratePermission");
          final ClazzAssignmentCourseBlockAndSubmitterUid _result;
          if (_cursor.moveToFirst()) {
            final long _tmpSubmitterUid;
            _tmpSubmitterUid = _cursor.getLong(_cursorIndexOfSubmitterUid);
            final boolean _tmpHasModeratePermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHasModeratePermission);
            _tmpHasModeratePermission = _tmp != 0;
            final ClazzAssignment _tmpClazzAssignment;
            if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
              final long _tmpCaUid;
              _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
              final String _tmpCaTitle;
              if (_cursor.isNull(_cursorIndexOfCaTitle)) {
                _tmpCaTitle = null;
              } else {
                _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
              }
              final String _tmpCaDescription;
              if (_cursor.isNull(_cursorIndexOfCaDescription)) {
                _tmpCaDescription = null;
              } else {
                _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
              }
              final long _tmpCaGroupUid;
              _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
              final boolean _tmpCaActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCaActive);
              _tmpCaActive = _tmp_1 != 0;
              final boolean _tmpCaClassCommentEnabled;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
              _tmpCaClassCommentEnabled = _tmp_2 != 0;
              final boolean _tmpCaPrivateCommentsEnabled;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
              _tmpCaPrivateCommentsEnabled = _tmp_3 != 0;
              final int _tmpCaCompletionCriteria;
              _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
              final boolean _tmpCaRequireFileSubmission;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
              _tmpCaRequireFileSubmission = _tmp_4 != 0;
              final int _tmpCaFileType;
              _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
              final int _tmpCaSizeLimit;
              _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
              final int _tmpCaNumberOfFiles;
              _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
              final int _tmpCaSubmissionPolicy;
              _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
              final int _tmpCaMarkingType;
              _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
              final boolean _tmpCaRequireTextSubmission;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
              _tmpCaRequireTextSubmission = _tmp_5 != 0;
              final int _tmpCaTextLimitType;
              _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
              final int _tmpCaTextLimit;
              _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
              final long _tmpCaXObjectUid;
              _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
              final long _tmpCaClazzUid;
              _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
              final int _tmpCaPeerReviewerCount;
              _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
              final long _tmpCaLocalChangeSeqNum;
              _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
              final long _tmpCaMasterChangeSeqNum;
              _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
              final int _tmpCaLastChangedBy;
              _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
              final long _tmpCaLct;
              _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
              _tmpClazzAssignment = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
            } else {
              _tmpClazzAssignment = null;
            }
            final CourseBlock _tmpCourseBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_6 != 0;
              final boolean _tmpCbHidden;
              final int _tmp_7;
              _tmp_7 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_7 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpCourseBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpCourseBlock = null;
            }
            final CourseBlockPicture _tmpCourseBlockPicture;
            if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
              final long _tmpCbpUid;
              _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
              final long _tmpCbpLct;
              _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
              final String _tmpCbpPictureUri;
              if (_cursor.isNull(_cursorIndexOfCbpPictureUri)) {
                _tmpCbpPictureUri = null;
              } else {
                _tmpCbpPictureUri = _cursor.getString(_cursorIndexOfCbpPictureUri);
              }
              final String _tmpCbpThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
                _tmpCbpThumbnailUri = null;
              } else {
                _tmpCbpThumbnailUri = _cursor.getString(_cursorIndexOfCbpThumbnailUri);
              }
              _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
            } else {
              _tmpCourseBlockPicture = null;
            }
            final CourseGroupSet _tmpCourseGroupSet;
            if (!(_cursor.isNull(_cursorIndexOfCgsUid) && _cursor.isNull(_cursorIndexOfCgsName) && _cursor.isNull(_cursorIndexOfCgsTotalGroups) && _cursor.isNull(_cursorIndexOfCgsActive) && _cursor.isNull(_cursorIndexOfCgsClazzUid) && _cursor.isNull(_cursorIndexOfCgsLct))) {
              _tmpCourseGroupSet = new CourseGroupSet();
              final long _tmpCgsUid;
              _tmpCgsUid = _cursor.getLong(_cursorIndexOfCgsUid);
              _tmpCourseGroupSet.setCgsUid(_tmpCgsUid);
              final String _tmpCgsName;
              if (_cursor.isNull(_cursorIndexOfCgsName)) {
                _tmpCgsName = null;
              } else {
                _tmpCgsName = _cursor.getString(_cursorIndexOfCgsName);
              }
              _tmpCourseGroupSet.setCgsName(_tmpCgsName);
              final int _tmpCgsTotalGroups;
              _tmpCgsTotalGroups = _cursor.getInt(_cursorIndexOfCgsTotalGroups);
              _tmpCourseGroupSet.setCgsTotalGroups(_tmpCgsTotalGroups);
              final boolean _tmpCgsActive;
              final int _tmp_8;
              _tmp_8 = _cursor.getInt(_cursorIndexOfCgsActive);
              _tmpCgsActive = _tmp_8 != 0;
              _tmpCourseGroupSet.setCgsActive(_tmpCgsActive);
              final long _tmpCgsClazzUid;
              _tmpCgsClazzUid = _cursor.getLong(_cursorIndexOfCgsClazzUid);
              _tmpCourseGroupSet.setCgsClazzUid(_tmpCgsClazzUid);
              final long _tmpCgsLct;
              _tmpCgsLct = _cursor.getLong(_cursorIndexOfCgsLct);
              _tmpCourseGroupSet.setCgsLct(_tmpCgsLct);
            } else {
              _tmpCourseGroupSet = null;
            }
            _result = new ClazzAssignmentCourseBlockAndSubmitterUid(_tmpClazzAssignment,_tmpCourseBlock,_tmpCourseBlockPicture,_tmpCourseGroupSet,_tmpSubmitterUid,_tmpHasModeratePermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findEnrolmentsByPersonUidAndAssignmentUid(final long assignmentUid,
      final long accountPersonUid,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "               (SELECT ClazzAssignment.caClazzUid\n"
            + "                  FROM ClazzAssignment\n"
            + "                 WHERE ClazzAssignment.caUid = ?)\n"
            + "           AND ClazzEnrolment.clazzEnrolmentPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzEnrolmentInviteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentInviteUid");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            final long _tmpClazzEnrolmentInviteUid;
            _tmpClazzEnrolmentInviteUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentInviteUid);
            _item.setClazzEnrolmentInviteUid(_tmpClazzEnrolmentInviteUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findCourseGroupMembersByPersonUidAndAssignmentUid(final long assignmentUid,
      final long accountPersonUid,
      final Continuation<? super List<CourseGroupMember>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseGroupMember.*\n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE CourseGroupMember.cgmSetUid = \n"
            + "               (SELECT ClazzAssignment.caGroupUid \n"
            + "                  FROM ClazzAssignment\n"
            + "                 WHERE ClazzAssignment.caUid = ?)\n"
            + "           AND CourseGroupMember.cgmPersonUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMember>>() {
      @Override
      @NonNull
      public List<CourseGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final List<CourseGroupMember> _result = new ArrayList<CourseGroupMember>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseGroupMember _item;
            final long _tmpCgmUid;
            _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
            final long _tmpCgmSetUid;
            _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
            final int _tmpCgmGroupNumber;
            _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
            final long _tmpCgmPersonUid;
            _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
            final long _tmpCgmLct;
            _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
            _item = new CourseGroupMember(_tmpCgmUid,_tmpCgmSetUid,_tmpCgmGroupNumber,_tmpCgmPersonUid,_tmpCgmLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findPeerReviewerAllocationsByPersonUidAndAssignmentUid(final long assignmentUid,
      final long accountPersonUid,
      final Continuation<? super List<PeerReviewerAllocation>> $completion) {
    final String _sql = "\n"
            + "        SELECT PeerReviewerAllocation.*\n"
            + "          FROM PeerReviewerAllocation\n"
            + "         WHERE PeerReviewerAllocation.praAssignmentUid = ?\n"
            + "           AND (\n"
            + "                    PeerReviewerAllocation.praMarkerSubmitterUid = ?\n"
            + "                 OR PeerReviewerAllocation.praToMarkerSubmitterUid = ?\n"
            + "                 OR PeerReviewerAllocation.praMarkerSubmitterUid IN\n"
            + "                    (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                       FROM CourseGroupMember\n"
            + "                      WHERE CourseGroupMember.cgmSetUid = \n"
            + "                            (SELECT ClazzAssignment.caGroupUid\n"
            + "                               FROM ClazzAssignment\n"
            + "                              WHERE ClazzAssignment.caUid = ?)\n"
            + "                        AND CourseGroupMember.cgmPersonUid = ?)\n"
            + "                 OR PeerReviewerAllocation.praToMarkerSubmitterUid IN\n"
            + "                    (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                       FROM CourseGroupMember\n"
            + "                      WHERE CourseGroupMember.cgmSetUid = \n"
            + "                            (SELECT ClazzAssignment.caGroupUid\n"
            + "                               FROM ClazzAssignment\n"
            + "                              WHERE ClazzAssignment.caUid = ?)\n"
            + "                                AND CourseGroupMember.cgmPersonUid = ?))\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PeerReviewerAllocation>>() {
      @Override
      @NonNull
      public List<PeerReviewerAllocation> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praUid");
          final int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praMarkerSubmitterUid");
          final int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praToMarkerSubmitterUid");
          final int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praAssignmentUid");
          final int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow(_cursor, "praActive");
          final int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow(_cursor, "praLct");
          final List<PeerReviewerAllocation> _result = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PeerReviewerAllocation _item;
            final long _tmpPraUid;
            _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
            final long _tmpPraMarkerSubmitterUid;
            _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
            final long _tmpPraToMarkerSubmitterUid;
            _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
            final long _tmpPraAssignmentUid;
            _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
            final boolean _tmpPraActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPraActive);
            _tmpPraActive = _tmp != 0;
            final long _tmpPraLct;
            _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
            _item = new PeerReviewerAllocation(_tmpPraUid,_tmpPraMarkerSubmitterUid,_tmpPraToMarkerSubmitterUid,_tmpPraAssignmentUid,_tmpPraActive,_tmpPraLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getLatestSubmissionTimeAllowed(final long assignmentUid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        WITH CourseBlockDeadlines(deadline, gracePeriod) AS\n"
            + "             (SELECT CourseBlock.cbDeadlineDate AS deadline,\n"
            + "                     CourseBlock.cbGracePeriodDate AS gracePeriod\n"
            + "                FROM CourseBlock\n"
            + "               WHERE CourseBlock.cbEntityUid = ?\n"
            + "                 AND CourseBlock.cbType = 103\n"
            + "               LIMIT 1)\n"
            + "        SELECT CASE\n"
            + "               WHEN (SELECT gracePeriod \n"
            + "                       FROM CourseBlockDeadlines)\n"
            + "                    BETWEEN 1 AND 7258118400000 THEN (SELECT gracePeriod FROM CourseBlockDeadlines)\n"
            + "               ELSE (SELECT deadline FROM CourseBlockDeadlines)\n"
            + "               END AS latestSubmissionTimeAllowed\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateActiveByList(final List<Long> uidList, final boolean active,
      final long changeTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE ClazzAssignment");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET caActive = ");
        _stringBuilder.append("?");
        _stringBuilder.append(",");
        _stringBuilder.append("\n");
        _stringBuilder.append("               caLct = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE caUid IN (");
        final int _inputSize = uidList.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")   ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        for (long _item : uidList) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
