package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.DeletedItem;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DeletedItemDao_Impl extends DeletedItemDao {
  private final RoomDatabase __db;

  private final SharedSQLiteStatement __preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin;

  public DeletedItemDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        INSERT INTO DeletedItem(delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder)\n"
                + "        SELECT (SELECT ContentEntry.title\n"
                + "                  FROM ContentEntry\n"
                + "                 WHERE ContentEntry.contentEntryUid = \n"
                + "                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n"
                + "                          FROM ContentEntryParentChildJoin\n"
                + "                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemName,\n"
                + "               NULL as delItemIconUri,\n"
                + "               ? AS delItemLastModTime,\n"
                + "               ? AS delItemTimeDeleted,\n"
                + "               7 AS delItemEntityTable,\n"
                + "               ? AS delItemEntityUid,\n"
                + "               ? AS delItemDeletedByPersonUid,\n"
                + "               1 AS delItemStatus,\n"
                + "               (SELECT NOT ContentEntry.leaf\n"
                + "                  FROM ContentEntry\n"
                + "                 WHERE ContentEntry.contentEntryUid = \n"
                + "                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n"
                + "                          FROM ContentEntryParentChildJoin\n"
                + "                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemIsFolder\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertDeletedItemForContentEntryParentChildJoin(final long cepcjUid,
      final long time, final long deletedByPersonUid,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, cepcjUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, cepcjUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, deletedByPersonUid);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, cepcjUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeInsert();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByTableIdAndEntityUid(final int tableId, final long entityUid,
      final Continuation<? super List<DeletedItem>> $completion) {
    final String _sql = "\n"
            + "        SELECT DeletedItem.*\n"
            + "          FROM DeletedItem\n"
            + "         WHERE DeletedItem.delItemEntityTable = ?\n"
            + "           AND DeletedItem.delItemEntityUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<DeletedItem>>() {
      @Override
      @NonNull
      public List<DeletedItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfDelItemUid = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemUid");
          final int _cursorIndexOfDelItemName = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemName");
          final int _cursorIndexOfDelItemIconUri = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemIconUri");
          final int _cursorIndexOfDelItemLastModTime = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemLastModTime");
          final int _cursorIndexOfDelItemTimeDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemTimeDeleted");
          final int _cursorIndexOfDelItemEntityTable = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemEntityTable");
          final int _cursorIndexOfDelItemEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemEntityUid");
          final int _cursorIndexOfDelItemDeletedByPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemDeletedByPersonUid");
          final int _cursorIndexOfDelItemStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemStatus");
          final int _cursorIndexOfDelItemIsFolder = CursorUtil.getColumnIndexOrThrow(_cursor, "delItemIsFolder");
          final List<DeletedItem> _result = new ArrayList<DeletedItem>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final DeletedItem _item;
            final long _tmpDelItemUid;
            _tmpDelItemUid = _cursor.getLong(_cursorIndexOfDelItemUid);
            final String _tmpDelItemName;
            if (_cursor.isNull(_cursorIndexOfDelItemName)) {
              _tmpDelItemName = null;
            } else {
              _tmpDelItemName = _cursor.getString(_cursorIndexOfDelItemName);
            }
            final String _tmpDelItemIconUri;
            if (_cursor.isNull(_cursorIndexOfDelItemIconUri)) {
              _tmpDelItemIconUri = null;
            } else {
              _tmpDelItemIconUri = _cursor.getString(_cursorIndexOfDelItemIconUri);
            }
            final long _tmpDelItemLastModTime;
            _tmpDelItemLastModTime = _cursor.getLong(_cursorIndexOfDelItemLastModTime);
            final long _tmpDelItemTimeDeleted;
            _tmpDelItemTimeDeleted = _cursor.getLong(_cursorIndexOfDelItemTimeDeleted);
            final int _tmpDelItemEntityTable;
            _tmpDelItemEntityTable = _cursor.getInt(_cursorIndexOfDelItemEntityTable);
            final long _tmpDelItemEntityUid;
            _tmpDelItemEntityUid = _cursor.getLong(_cursorIndexOfDelItemEntityUid);
            final long _tmpDelItemDeletedByPersonUid;
            _tmpDelItemDeletedByPersonUid = _cursor.getLong(_cursorIndexOfDelItemDeletedByPersonUid);
            final int _tmpDelItemStatus;
            _tmpDelItemStatus = _cursor.getInt(_cursorIndexOfDelItemStatus);
            final boolean _tmpDelItemIsFolder;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfDelItemIsFolder);
            _tmpDelItemIsFolder = _tmp != 0;
            _item = new DeletedItem(_tmpDelItemUid,_tmpDelItemName,_tmpDelItemIconUri,_tmpDelItemLastModTime,_tmpDelItemTimeDeleted,_tmpDelItemEntityTable,_tmpDelItemEntityUid,_tmpDelItemDeletedByPersonUid,_tmpDelItemStatus,_tmpDelItemIsFolder);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, DeletedItem> findDeletedItemsForUser(final long personUid,
      final boolean includeActionedItems) {
    final String _sql = "\n"
            + "        SELECT DeletedItem.*\n"
            + "          FROM DeletedItem\n"
            + "         WHERE (  (CAST(? AS INTEGER) = 1)\n"
            + "                OR DeletedItem.delItemStatus = 1)\n"
            + "           AND DeletedItem.delItemDeletedByPersonUid = ?       \n"
            + "      ORDER BY DeletedItem.delItemTimeDeleted DESC            \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = includeActionedItems ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    return new LimitOffsetPagingSource<DeletedItem>(_statement, __db, "DeletedItem") {
      @Override
      @NonNull
      protected List<DeletedItem> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfDelItemUid = CursorUtil.getColumnIndexOrThrow(cursor, "delItemUid");
        final int _cursorIndexOfDelItemName = CursorUtil.getColumnIndexOrThrow(cursor, "delItemName");
        final int _cursorIndexOfDelItemIconUri = CursorUtil.getColumnIndexOrThrow(cursor, "delItemIconUri");
        final int _cursorIndexOfDelItemLastModTime = CursorUtil.getColumnIndexOrThrow(cursor, "delItemLastModTime");
        final int _cursorIndexOfDelItemTimeDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "delItemTimeDeleted");
        final int _cursorIndexOfDelItemEntityTable = CursorUtil.getColumnIndexOrThrow(cursor, "delItemEntityTable");
        final int _cursorIndexOfDelItemEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "delItemEntityUid");
        final int _cursorIndexOfDelItemDeletedByPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "delItemDeletedByPersonUid");
        final int _cursorIndexOfDelItemStatus = CursorUtil.getColumnIndexOrThrow(cursor, "delItemStatus");
        final int _cursorIndexOfDelItemIsFolder = CursorUtil.getColumnIndexOrThrow(cursor, "delItemIsFolder");
        final List<DeletedItem> _result = new ArrayList<DeletedItem>(cursor.getCount());
        while (cursor.moveToNext()) {
          final DeletedItem _item;
          final long _tmpDelItemUid;
          _tmpDelItemUid = cursor.getLong(_cursorIndexOfDelItemUid);
          final String _tmpDelItemName;
          if (cursor.isNull(_cursorIndexOfDelItemName)) {
            _tmpDelItemName = null;
          } else {
            _tmpDelItemName = cursor.getString(_cursorIndexOfDelItemName);
          }
          final String _tmpDelItemIconUri;
          if (cursor.isNull(_cursorIndexOfDelItemIconUri)) {
            _tmpDelItemIconUri = null;
          } else {
            _tmpDelItemIconUri = cursor.getString(_cursorIndexOfDelItemIconUri);
          }
          final long _tmpDelItemLastModTime;
          _tmpDelItemLastModTime = cursor.getLong(_cursorIndexOfDelItemLastModTime);
          final long _tmpDelItemTimeDeleted;
          _tmpDelItemTimeDeleted = cursor.getLong(_cursorIndexOfDelItemTimeDeleted);
          final int _tmpDelItemEntityTable;
          _tmpDelItemEntityTable = cursor.getInt(_cursorIndexOfDelItemEntityTable);
          final long _tmpDelItemEntityUid;
          _tmpDelItemEntityUid = cursor.getLong(_cursorIndexOfDelItemEntityUid);
          final long _tmpDelItemDeletedByPersonUid;
          _tmpDelItemDeletedByPersonUid = cursor.getLong(_cursorIndexOfDelItemDeletedByPersonUid);
          final int _tmpDelItemStatus;
          _tmpDelItemStatus = cursor.getInt(_cursorIndexOfDelItemStatus);
          final boolean _tmpDelItemIsFolder;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfDelItemIsFolder);
          _tmpDelItemIsFolder = _tmp_1 != 0;
          _item = new DeletedItem(_tmpDelItemUid,_tmpDelItemName,_tmpDelItemIconUri,_tmpDelItemLastModTime,_tmpDelItemTimeDeleted,_tmpDelItemEntityTable,_tmpDelItemEntityUid,_tmpDelItemDeletedByPersonUid,_tmpDelItemStatus,_tmpDelItemIsFolder);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object updateStatusByUids(final List<Long> uidList, final int newStatus,
      final long updateTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE DeletedItem");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET delItemStatus = ");
        _stringBuilder.append("?");
        _stringBuilder.append(",");
        _stringBuilder.append("\n");
        _stringBuilder.append("               delItemLastModTime = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE delItemUid IN (");
        final int _inputSize = uidList.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        for (long _item : uidList) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
