package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.ext.doorNodeIdHeader
import com.ustadmobile.door.ext.pagingSourceLoadParameters
import com.ustadmobile.door.ext.setRepoUrl
import com.ustadmobile.door.http.RepoDaoFlowHelper
import com.ustadmobile.door.http.RepositoryDaoWithFlowHelper
import com.ustadmobile.door.http.replicateHttpRequestCatchAndLog
import com.ustadmobile.door.http.replicateHttpRequestOrThrow
import com.ustadmobile.door.paging.DoorRepositoryReplicatePullPagingSource
import com.ustadmobile.door.paging.endOfPaginationReached
import com.ustadmobile.door.replication.onClientRepoDoorMessageHttpResponse
import com.ustadmobile.door.replication.withRepoChangeMonitor
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone
import com.ustadmobile.lib.db.entities.ClazzInvite
import io.ktor.client.HttpClient
import io.ktor.client.request.`get`
import io.ktor.client.request.`header`
import io.ktor.client.request.parameter
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class ClazzInviteDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: ClazzInviteDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : ClazzInviteDao(), RepositoryDaoWithFlowHelper {
  override val repoDaoFlowHelper: RepoDaoFlowHelper = RepoDaoFlowHelper(_repo)


  override suspend fun replace(entity: ClazzInvite): Long {
    val _result = _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.replace(entity)
    }
    return _result
  }

  override suspend fun insertAll(entity: List<ClazzInvite>) {
    _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.insertAll(entity)
    }
  }

  override suspend fun updateAll(entity: List<ClazzInvite>) {
    _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.updateAll(entity)
    }
  }

  override suspend fun findInviteAsync(): List<ClazzInvite> {
    _repo.replicateHttpRequestCatchAndLog(repoPath = "ClazzInviteDao/findInviteAsync") {
      val _response = _httpClient.`get` {
        setRepoUrl(_repo.config, "ClazzInviteDao/findInviteAsync")
        doorNodeIdHeader(_repo)
        `header`("cache-control", "no-store")
      }

      _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
    }
    val _result = _dao.findInviteAsync()
    return _result
  }

  override suspend fun findClazzInviteEntityForInviteToken(inviteTokenUid: String):
      ClazzInviteWithTimeZone? {
    _repo.replicateHttpRequestCatchAndLog(repoPath =
        "ClazzInviteDao/findClazzInviteEntityForInviteToken") {
      val _response = _httpClient.`get` {
        setRepoUrl(_repo.config, "ClazzInviteDao/findClazzInviteEntityForInviteToken")
        doorNodeIdHeader(_repo)
        `header`("cache-control", "no-store")
        parameter("inviteTokenUid", _repo.config.json.encodeToString(String.serializer(),
            inviteTokenUid))
      }

      _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
    }
    val _result = _dao.findClazzInviteEntityForInviteToken(inviteTokenUid)
    return _result
  }

  override fun findClazzInviteEntityForInviteTokenAsFlow(inviteTokenUid: String):
      Flow<ClazzInviteAndClazz?> = repoDaoFlowHelper.asRepoFlow(
    dbFlow = _dao.findClazzInviteEntityForInviteTokenAsFlow(inviteTokenUid),
    onMakeHttpRequest =  {
      _repo.replicateHttpRequestCatchAndLog(repoPath =
          "ClazzInviteDao/findClazzInviteEntityForInviteTokenAsFlow") {
        val _response = _httpClient.`get` {
          setRepoUrl(_repo.config, "ClazzInviteDao/findClazzInviteEntityForInviteTokenAsFlow")
          doorNodeIdHeader(_repo)
          `header`("cache-control", "no-store")
          parameter("inviteTokenUid", _repo.config.json.encodeToString(String.serializer(),
              inviteTokenUid))
        }

        _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
      }
    },
  )

  override suspend fun updateInviteStatus(
    status: Int,
    ciUid: Long,
    updateTime: Long,
  ) {
    _repo.replicateHttpRequestCatchAndLog(repoPath = "ClazzInviteDao/updateInviteStatus") {
      val _response = _httpClient.`get` {
        setRepoUrl(_repo.config, "ClazzInviteDao/updateInviteStatus")
        doorNodeIdHeader(_repo)
        `header`("cache-control", "no-store")
        parameter("status", _repo.config.json.encodeToString(Int.serializer(), status))
        parameter("ciUid", _repo.config.json.encodeToString(Long.serializer(), ciUid))
        parameter("updateTime", _repo.config.json.encodeToString(Long.serializer(), updateTime))
      }

      _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
    }
    _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.updateInviteStatus(status, ciUid, updateTime)
    }
  }

  override fun findPendingInviteByPersonUid(
    ciPersonUid: Long,
    clazzUid: Long,
    currentTime: Long,
  ): PagingSource<Int, ClazzInvite> = DoorRepositoryReplicatePullPagingSource(
    repo = _repo,
    repoPath = "ClazzInviteDao/findPendingInviteByPersonUid",
    dbPagingSource = _dao.findPendingInviteByPersonUid(ciPersonUid, clazzUid, currentTime),
    onLoadHttp =  {
      _pagingParams -> 
      _repo.replicateHttpRequestOrThrow(repoPath = "ClazzInviteDao/findPendingInviteByPersonUid") {
        val _response = _httpClient.`get` {
          setRepoUrl(_repo.config, "ClazzInviteDao/findPendingInviteByPersonUid")
          doorNodeIdHeader(_repo)
          `header`("cache-control", "no-store")
          parameter("ciPersonUid", _repo.config.json.encodeToString(Long.serializer(), ciPersonUid))
          parameter("clazzUid", _repo.config.json.encodeToString(Long.serializer(), clazzUid))
          parameter("currentTime", _repo.config.json.encodeToString(Long.serializer(), currentTime))
          pagingSourceLoadParameters(
            json = _repo.config.json, 
            keySerializer = Int.serializer().nullable,
            loadParams = _pagingParams
          )
        }

        _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
        _response.endOfPaginationReached()
      }
    },
  )

  override suspend fun updateClazzInviteToRevokeInvite(inviteContact: String): Int {
    _repo.replicateHttpRequestCatchAndLog(repoPath =
        "ClazzInviteDao/updateClazzInviteToRevokeInvite") {
      val _response = _httpClient.`get` {
        setRepoUrl(_repo.config, "ClazzInviteDao/updateClazzInviteToRevokeInvite")
        doorNodeIdHeader(_repo)
        `header`("cache-control", "no-store")
        parameter("inviteContact", _repo.config.json.encodeToString(String.serializer(),
            inviteContact))
      }

      _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
    }
    val _result = _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.updateClazzInviteToRevokeInvite(inviteContact)
    }
    return _result
  }

  override suspend fun findClazzInviteFromContact(inviteContact: String): ClazzInvite? {
    val _result = _dao.findClazzInviteFromContact(inviteContact)
    return _result
  }

  public override fun insert(entity: ClazzInvite): Long {
    val _result = _repo.withRepoChangeMonitor("ClazzInvite") {
      _dao.insert(entity)
    }
    return _result
  }

  public override suspend fun insertAsync(entity: ClazzInvite): Long {
    val _result = _repo.withRepoChangeMonitorAsync("ClazzInvite") {
      _dao.insertAsync(entity)
    }
    return _result
  }

  public override fun insertList(entityList: List<ClazzInvite>) {
    _repo.withRepoChangeMonitor("ClazzInvite") {
      _dao.insertList(entityList)
    }
  }

  public override fun update(entity: ClazzInvite) {
    _repo.withRepoChangeMonitor("ClazzInvite") {
      _dao.update(entity)
    }
  }
}
