package com.ustadmobile.core.db.dao

import com.ustadmobile.lib.db.entities.ReportQueryResult
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.collections.List

public actual abstract class ReportQueryResultDao {
  public actual abstract suspend fun deleteByReportUidAndTimeZone(reportUid: Long, timeZone: String)

  public actual abstract suspend fun insertAllAsync(results: List<ReportQueryResult>)

  public actual abstract suspend fun getAllByReportUidAndTimeZone(reportUid: Long,
      timeZone: String): List<ReportQueryResult>

  public actual abstract suspend fun isReportFresh(
    reportUid: Long,
    timeZone: String,
    freshThresholdTime: Long,
  ): Boolean
}
