package com.ustadmobile.core.db.dao.xapi

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.StateEntityDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<StateEntityDao>) {
  `get`("findByActorAndHash") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByActorAndHash_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("findByAgentAndActivity") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.findByAgentAndActivity_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
  `get`("getStateIds") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getStateIds_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
}
