package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonGroup;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonGroupDao_Impl extends PersonGroupDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;

  private final EntityDeletionOrUpdateAdapter<PersonGroup> __updateAdapterOfPersonGroup;

  public PersonGroupDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroup entity) {
        statement.bindLong(1, entity.getGroupUid());
        statement.bindLong(2, entity.getGroupMasterCsn());
        statement.bindLong(3, entity.getGroupLocalCsn());
        statement.bindLong(4, entity.getGroupLastChangedBy());
        statement.bindLong(5, entity.getGroupLct());
        if (entity.getGroupName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getGroupName());
        }
        final int _tmp = entity.getGroupActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getPersonGroupFlag());
      }
    };
    this.__updateAdapterOfPersonGroup = new EntityDeletionOrUpdateAdapter<PersonGroup>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PersonGroup` SET `groupUid` = ?,`groupMasterCsn` = ?,`groupLocalCsn` = ?,`groupLastChangedBy` = ?,`groupLct` = ?,`groupName` = ?,`groupActive` = ?,`personGroupFlag` = ? WHERE `groupUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonGroup entity) {
        statement.bindLong(1, entity.getGroupUid());
        statement.bindLong(2, entity.getGroupMasterCsn());
        statement.bindLong(3, entity.getGroupLocalCsn());
        statement.bindLong(4, entity.getGroupLastChangedBy());
        statement.bindLong(5, entity.getGroupLct());
        if (entity.getGroupName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getGroupName());
        }
        final int _tmp = entity.getGroupActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getPersonGroupFlag());
        statement.bindLong(9, entity.getGroupUid());
      }
    };
  }

  @Override
  public long insert(final PersonGroup entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonGroup entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends PersonGroup> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonGroup.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonGroup entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroup.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final PersonGroup entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfPersonGroup.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public PersonGroup findByUid(final long uid) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
      final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
      final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
      final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
      final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
      final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
      final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
      final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
      final PersonGroup _result;
      if (_cursor.moveToFirst()) {
        _result = new PersonGroup();
        final long _tmpGroupUid;
        _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
        _result.setGroupUid(_tmpGroupUid);
        final long _tmpGroupMasterCsn;
        _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
        _result.setGroupMasterCsn(_tmpGroupMasterCsn);
        final long _tmpGroupLocalCsn;
        _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
        _result.setGroupLocalCsn(_tmpGroupLocalCsn);
        final int _tmpGroupLastChangedBy;
        _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
        _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
        final long _tmpGroupLct;
        _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
        _result.setGroupLct(_tmpGroupLct);
        final String _tmpGroupName;
        if (_cursor.isNull(_cursorIndexOfGroupName)) {
          _tmpGroupName = null;
        } else {
          _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
        }
        _result.setGroupName(_tmpGroupName);
        final boolean _tmpGroupActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
        _tmpGroupActive = _tmp != 0;
        _result.setGroupActive(_tmpGroupActive);
        final int _tmpPersonGroupFlag;
        _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
        _result.setPersonGroupFlag(_tmpPersonGroupFlag);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super PersonGroup> $completion) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonGroup>() {
      @Override
      @Nullable
      public PersonGroup call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
          final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
          final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
          final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
          final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
          final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
          final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
          final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
          final PersonGroup _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonGroup();
            final long _tmpGroupUid;
            _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
            _result.setGroupUid(_tmpGroupUid);
            final long _tmpGroupMasterCsn;
            _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
            _result.setGroupMasterCsn(_tmpGroupMasterCsn);
            final long _tmpGroupLocalCsn;
            _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
            _result.setGroupLocalCsn(_tmpGroupLocalCsn);
            final int _tmpGroupLastChangedBy;
            _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
            _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
            final long _tmpGroupLct;
            _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
            _result.setGroupLct(_tmpGroupLct);
            final String _tmpGroupName;
            if (_cursor.isNull(_cursorIndexOfGroupName)) {
              _tmpGroupName = null;
            } else {
              _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
            }
            _result.setGroupName(_tmpGroupName);
            final boolean _tmpGroupActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
            _tmpGroupActive = _tmp != 0;
            _result.setGroupActive(_tmpGroupActive);
            final int _tmpPersonGroupFlag;
            _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
            _result.setPersonGroupFlag(_tmpPersonGroupFlag);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<PersonGroup> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"PersonGroup"}, new Callable<PersonGroup>() {
      @Override
      @Nullable
      public PersonGroup call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
          final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
          final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
          final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
          final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
          final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
          final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
          final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
          final PersonGroup _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonGroup();
            final long _tmpGroupUid;
            _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
            _result.setGroupUid(_tmpGroupUid);
            final long _tmpGroupMasterCsn;
            _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
            _result.setGroupMasterCsn(_tmpGroupMasterCsn);
            final long _tmpGroupLocalCsn;
            _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
            _result.setGroupLocalCsn(_tmpGroupLocalCsn);
            final int _tmpGroupLastChangedBy;
            _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
            _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
            final long _tmpGroupLct;
            _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
            _result.setGroupLct(_tmpGroupLct);
            final String _tmpGroupName;
            if (_cursor.isNull(_cursorIndexOfGroupName)) {
              _tmpGroupName = null;
            } else {
              _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
            }
            _result.setGroupName(_tmpGroupName);
            final boolean _tmpGroupActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
            _tmpGroupActive = _tmp != 0;
            _result.setGroupActive(_tmpGroupActive);
            final int _tmpPersonGroupFlag;
            _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
            _result.setPersonGroupFlag(_tmpPersonGroupFlag);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findNameByGroupUid(final long groupUid,
      final Continuation<? super String> $completion) {
    final String _sql = "\n"
            + "        Select CASE\n"
            + "               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n"
            + "               ELSE PersonGroup.groupName \n"
            + "               END AS name\n"
            + "          FROM PersonGroup\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personGroupUid = PersonGroup.groupUid\n"
            + "         WHERE PersonGroup.groupUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            final String _tmp;
            if (_cursor.isNull(0)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(0);
            }
            _result = _tmp;
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
