package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.SiteTerms
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun SiteTermsDao.findAllTermsAsListFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_activeOnly : Int = request.queryParam("activeOnly")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _result_findAllTermsAsListFlow = findAllTermsAsListFlow(
    activeOnly = 0,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllTermsAsListFlow.map {
        _row ->
        DoorReplicationEntity(tableId = 272,
          orUid = 0,
          entity = json.encodeToJsonElement(SiteTerms.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun SiteTermsDao.findAllTerms_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_activeOnly : Int = request.queryParam("activeOnly")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _result_findAllTerms = findAllTerms(
    activeOnly = 0,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllTerms.map {
        _row ->
        DoorReplicationEntity(tableId = 272,
          orUid = 0,
          entity = json.encodeToJsonElement(SiteTerms.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun SiteTermsDao.findAvailableSiteTermLanguages_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_active : Int = request.queryParam("active")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _result_findAllTerms = findAllTerms(
    activeOnly = 0,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findAllTerms.map {
        _row ->
        DoorReplicationEntity(tableId = 272,
          orUid = 0,
          entity = json.encodeToJsonElement(SiteTerms.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
