package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Report;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ReportDao_Impl extends ReportDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Report> __insertionAdapterOfReport;

  private final EntityInsertionAdapter<Report> __insertionAdapterOfReport_1;

  private final EntityDeletionOrUpdateAdapter<Report> __updateAdapterOfReport;

  private final SharedSQLiteStatement __preparedStmtOfDeleteReportByUid;

  public ReportDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfReport = new EntityInsertionAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Report` (`reportUid`,`reportTitle`,`reportOptions`,`reportIsTemplate`,`reportLastModTime`,`reportOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        if (entity.getReportTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getReportTitle());
        }
        if (entity.getReportOptions() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getReportOptions());
        }
        final int _tmp = entity.getReportIsTemplate() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getReportLastModTime());
        statement.bindLong(6, entity.getReportOwnerPersonUid());
      }
    };
    this.__insertionAdapterOfReport_1 = new EntityInsertionAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Report` (`reportUid`,`reportTitle`,`reportOptions`,`reportIsTemplate`,`reportLastModTime`,`reportOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        if (entity.getReportTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getReportTitle());
        }
        if (entity.getReportOptions() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getReportOptions());
        }
        final int _tmp = entity.getReportIsTemplate() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getReportLastModTime());
        statement.bindLong(6, entity.getReportOwnerPersonUid());
      }
    };
    this.__updateAdapterOfReport = new EntityDeletionOrUpdateAdapter<Report>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Report` SET `reportUid` = ?,`reportTitle` = ?,`reportOptions` = ?,`reportIsTemplate` = ?,`reportLastModTime` = ?,`reportOwnerPersonUid` = ? WHERE `reportUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Report entity) {
        statement.bindLong(1, entity.getReportUid());
        if (entity.getReportTitle() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getReportTitle());
        }
        if (entity.getReportOptions() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getReportOptions());
        }
        final int _tmp = entity.getReportIsTemplate() ? 1 : 0;
        statement.bindLong(4, _tmp);
        statement.bindLong(5, entity.getReportLastModTime());
        statement.bindLong(6, entity.getReportOwnerPersonUid());
        statement.bindLong(7, entity.getReportUid());
      }
    };
    this.__preparedStmtOfDeleteReportByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM Report WHERE reportUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Report entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfReport.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Report entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfReport.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Report> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfReport.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void replaceList(final List<Report> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfReport_1.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Report entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfReport.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Report entity, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfReport.handle(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteReportByUid(final long reportUid,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteReportByUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, reportUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteReportByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, Report> findAllReports() {
    final String _sql = "SELECT * FROM Report ORDER BY reportTitle ASC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new LimitOffsetPagingSource<Report>(_statement, __db, "Report") {
      @Override
      @NonNull
      protected List<Report> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportUid");
        final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(cursor, "reportTitle");
        final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(cursor, "reportOptions");
        final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(cursor, "reportIsTemplate");
        final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(cursor, "reportLastModTime");
        final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportOwnerPersonUid");
        final List<Report> _result = new ArrayList<Report>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Report _item;
          final long _tmpReportUid;
          _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
          final String _tmpReportTitle;
          if (cursor.isNull(_cursorIndexOfReportTitle)) {
            _tmpReportTitle = null;
          } else {
            _tmpReportTitle = cursor.getString(_cursorIndexOfReportTitle);
          }
          final String _tmpReportOptions;
          if (cursor.isNull(_cursorIndexOfReportOptions)) {
            _tmpReportOptions = null;
          } else {
            _tmpReportOptions = cursor.getString(_cursorIndexOfReportOptions);
          }
          final boolean _tmpReportIsTemplate;
          final int _tmp;
          _tmp = cursor.getInt(_cursorIndexOfReportIsTemplate);
          _tmpReportIsTemplate = _tmp != 0;
          final long _tmpReportLastModTime;
          _tmpReportLastModTime = cursor.getLong(_cursorIndexOfReportLastModTime);
          final long _tmpReportOwnerPersonUid;
          _tmpReportOwnerPersonUid = cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
          _item = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public PagingSource<Integer, Report> findAllActiveReport(final String searchBit,
      final boolean isTemplate) {
    final String _sql = "\n"
            + "        SELECT * FROM Report \n"
            + "        WHERE reportIsTemplate = ?\n"
            + "        AND reportTitle LIKE ?\n"
            + "        ORDER BY reportTitle\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _statement.bindString(_argIndex, searchBit);
    return new LimitOffsetPagingSource<Report>(_statement, __db, "Report") {
      @Override
      @NonNull
      protected List<Report> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportUid");
        final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(cursor, "reportTitle");
        final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(cursor, "reportOptions");
        final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(cursor, "reportIsTemplate");
        final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(cursor, "reportLastModTime");
        final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "reportOwnerPersonUid");
        final List<Report> _result = new ArrayList<Report>(cursor.getCount());
        while (cursor.moveToNext()) {
          final Report _item;
          final long _tmpReportUid;
          _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
          final String _tmpReportTitle;
          if (cursor.isNull(_cursorIndexOfReportTitle)) {
            _tmpReportTitle = null;
          } else {
            _tmpReportTitle = cursor.getString(_cursorIndexOfReportTitle);
          }
          final String _tmpReportOptions;
          if (cursor.isNull(_cursorIndexOfReportOptions)) {
            _tmpReportOptions = null;
          } else {
            _tmpReportOptions = cursor.getString(_cursorIndexOfReportOptions);
          }
          final boolean _tmpReportIsTemplate;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfReportIsTemplate);
          _tmpReportIsTemplate = _tmp_1 != 0;
          final long _tmpReportLastModTime;
          _tmpReportLastModTime = cursor.getLong(_cursorIndexOfReportLastModTime);
          final long _tmpReportOwnerPersonUid;
          _tmpReportOwnerPersonUid = cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
          _item = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findByUid(final long entityUid, final Continuation<? super Report> $completion) {
    final String _sql = "SELECT * FROM Report WHERE reportUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Report>() {
      @Override
      @Nullable
      public Report call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOptions");
          final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "reportIsTemplate");
          final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastModTime");
          final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerPersonUid");
          final Report _result;
          if (_cursor.moveToFirst()) {
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            final String _tmpReportOptions;
            if (_cursor.isNull(_cursorIndexOfReportOptions)) {
              _tmpReportOptions = null;
            } else {
              _tmpReportOptions = _cursor.getString(_cursorIndexOfReportOptions);
            }
            final boolean _tmpReportIsTemplate;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfReportIsTemplate);
            _tmpReportIsTemplate = _tmp != 0;
            final long _tmpReportLastModTime;
            _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
            final long _tmpReportOwnerPersonUid;
            _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
            _result = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Report> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM Report WHERE reportUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Report"}, new Callable<Report>() {
      @Override
      @Nullable
      public Report call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOptions");
          final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "reportIsTemplate");
          final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastModTime");
          final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerPersonUid");
          final Report _result;
          if (_cursor.moveToFirst()) {
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            final String _tmpReportOptions;
            if (_cursor.isNull(_cursorIndexOfReportOptions)) {
              _tmpReportOptions = null;
            } else {
              _tmpReportOptions = _cursor.getString(_cursorIndexOfReportOptions);
            }
            final boolean _tmpReportIsTemplate;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfReportIsTemplate);
            _tmpReportIsTemplate = _tmp != 0;
            final long _tmpReportLastModTime;
            _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
            final long _tmpReportOwnerPersonUid;
            _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
            _result = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<Report>> findAllActiveReportLive(final boolean isTemplate) {
    final String _sql = "\n"
            + "        SELECT * FROM Report \n"
            + "        WHERE reportIsTemplate = ?\n"
            + "        ORDER BY reportTitle ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Report"}, new Callable<List<Report>>() {
      @Override
      @NonNull
      public List<Report> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
          final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
          final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOptions");
          final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "reportIsTemplate");
          final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastModTime");
          final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerPersonUid");
          final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Report _item;
            final long _tmpReportUid;
            _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
            final String _tmpReportTitle;
            if (_cursor.isNull(_cursorIndexOfReportTitle)) {
              _tmpReportTitle = null;
            } else {
              _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
            }
            final String _tmpReportOptions;
            if (_cursor.isNull(_cursorIndexOfReportOptions)) {
              _tmpReportOptions = null;
            } else {
              _tmpReportOptions = _cursor.getString(_cursorIndexOfReportOptions);
            }
            final boolean _tmpReportIsTemplate;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfReportIsTemplate);
            _tmpReportIsTemplate = _tmp_1 != 0;
            final long _tmpReportLastModTime;
            _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
            final long _tmpReportOwnerPersonUid;
            _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
            _item = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Report> findAllActiveReportList(final boolean isTemplate) {
    final String _sql = "\n"
            + "        SELECT * FROM Report \n"
            + "        WHERE reportIsTemplate = ?\n"
            + "        ORDER BY reportTitle ASC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp = isTemplate ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportUid");
      final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "reportTitle");
      final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOptions");
      final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndexOrThrow(_cursor, "reportIsTemplate");
      final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndexOrThrow(_cursor, "reportLastModTime");
      final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "reportOwnerPersonUid");
      final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Report _item;
        final long _tmpReportUid;
        _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
        final String _tmpReportTitle;
        if (_cursor.isNull(_cursorIndexOfReportTitle)) {
          _tmpReportTitle = null;
        } else {
          _tmpReportTitle = _cursor.getString(_cursorIndexOfReportTitle);
        }
        final String _tmpReportOptions;
        if (_cursor.isNull(_cursorIndexOfReportOptions)) {
          _tmpReportOptions = null;
        } else {
          _tmpReportOptions = _cursor.getString(_cursorIndexOfReportOptions);
        }
        final boolean _tmpReportIsTemplate;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfReportIsTemplate);
        _tmpReportIsTemplate = _tmp_1 != 0;
        final long _tmpReportLastModTime;
        _tmpReportLastModTime = _cursor.getLong(_cursorIndexOfReportLastModTime);
        final long _tmpReportOwnerPersonUid;
        _tmpReportOwnerPersonUid = _cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
        _item = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<Long> findByUidList(final List<Long> uidList) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT reportUid FROM Report WHERE reportUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Long _item_1;
        _item_1 = _cursor.getLong(0);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object toggleVisibilityReportItems(final boolean toggleVisibility,
      final List<Long> selectedItem, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE Report ");
        _stringBuilder.append("\n");
        _stringBuilder.append("        SET reportIsTemplate = ");
        _stringBuilder.append("?");
        _stringBuilder.append(",");
        _stringBuilder.append("\n");
        _stringBuilder.append("            reportLastModTime = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHERE reportUid IN (");
        final int _inputSize = selectedItem.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final int _tmp = toggleVisibility ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        for (long _item : selectedItem) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public List<Report> getResults(final SupportSQLiteQuery query) {
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, query, false, null);
    try {
      final List<Report> _result = new ArrayList<Report>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Report _item;
        _item = __entityCursorConverter_comUstadmobileLibDbEntitiesReport(_cursor);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private Report __entityCursorConverter_comUstadmobileLibDbEntitiesReport(
      @NonNull final Cursor cursor) {
    final Report _entity;
    final int _cursorIndexOfReportUid = CursorUtil.getColumnIndex(cursor, "reportUid");
    final int _cursorIndexOfReportTitle = CursorUtil.getColumnIndex(cursor, "reportTitle");
    final int _cursorIndexOfReportOptions = CursorUtil.getColumnIndex(cursor, "reportOptions");
    final int _cursorIndexOfReportIsTemplate = CursorUtil.getColumnIndex(cursor, "reportIsTemplate");
    final int _cursorIndexOfReportLastModTime = CursorUtil.getColumnIndex(cursor, "reportLastModTime");
    final int _cursorIndexOfReportOwnerPersonUid = CursorUtil.getColumnIndex(cursor, "reportOwnerPersonUid");
    final long _tmpReportUid;
    if (_cursorIndexOfReportUid == -1) {
      _tmpReportUid = 0;
    } else {
      _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
    }
    final String _tmpReportTitle;
    if (_cursorIndexOfReportTitle == -1) {
      _tmpReportTitle = null;
    } else {
      if (cursor.isNull(_cursorIndexOfReportTitle)) {
        _tmpReportTitle = null;
      } else {
        _tmpReportTitle = cursor.getString(_cursorIndexOfReportTitle);
      }
    }
    final String _tmpReportOptions;
    if (_cursorIndexOfReportOptions == -1) {
      _tmpReportOptions = null;
    } else {
      if (cursor.isNull(_cursorIndexOfReportOptions)) {
        _tmpReportOptions = null;
      } else {
        _tmpReportOptions = cursor.getString(_cursorIndexOfReportOptions);
      }
    }
    final boolean _tmpReportIsTemplate;
    if (_cursorIndexOfReportIsTemplate == -1) {
      _tmpReportIsTemplate = false;
    } else {
      final int _tmp;
      _tmp = cursor.getInt(_cursorIndexOfReportIsTemplate);
      _tmpReportIsTemplate = _tmp != 0;
    }
    final long _tmpReportLastModTime;
    if (_cursorIndexOfReportLastModTime == -1) {
      _tmpReportLastModTime = 0;
    } else {
      _tmpReportLastModTime = cursor.getLong(_cursorIndexOfReportLastModTime);
    }
    final long _tmpReportOwnerPersonUid;
    if (_cursorIndexOfReportOwnerPersonUid == -1) {
      _tmpReportOwnerPersonUid = 0;
    } else {
      _tmpReportOwnerPersonUid = cursor.getLong(_cursorIndexOfReportOwnerPersonUid);
    }
    _entity = new Report(_tmpReportUid,_tmpReportTitle,_tmpReportOptions,_tmpReportIsTemplate,_tmpReportLastModTime,_tmpReportOwnerPersonUid);
    return _entity;
  }
}
