package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.DoorQuery
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.Report
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class ReportDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ReportDao,
) : ReportDao() {
  override fun getResults(query: DoorQuery): List<Report> = _dao.getResults(query)

  override suspend fun deleteReportByUid(reportUid: Long) {
    _dao.deleteReportByUid(reportUid)
  }

  override fun findAllReports(): PagingSource<Int, Report> = _dao.findAllReports()

  override fun findAllActiveReport(searchBit: String, isTemplate: Boolean):
      PagingSource<Int, Report> = _dao.findAllActiveReport(searchBit, isTemplate)

  override suspend fun findByUid(entityUid: Long): Report? = _dao.findByUid(entityUid)

  override suspend fun updateAsync(entity: Report) {
    entity.reportLastModTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(entity)
  }

  override fun findByUidLive(uid: Long): Flow<Report?> = _dao.findByUidLive(uid)

  override fun findAllActiveReportLive(isTemplate: Boolean): Flow<List<Report>> =
      _dao.findAllActiveReportLive(isTemplate)

  override fun findAllActiveReportList(isTemplate: Boolean): List<Report> =
      _dao.findAllActiveReportList(isTemplate)

  override fun findByUidList(uidList: List<Long>): List<Long> = _dao.findByUidList(uidList)

  override suspend fun toggleVisibilityReportItems(
    toggleVisibility: Boolean,
    selectedItem: List<Long>,
    updateTime: Long,
  ) {
    _dao.toggleVisibilityReportItems(toggleVisibility, selectedItem, updateTime)
  }

  override fun replaceList(entityList: List<Report>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.reportUid == 0L) {
        val _newPk = _pkManager.nextId(101)
        it.reportUid = _newPk
        _generatedPks += _newPk
      }
      it.reportLastModTime = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.replaceList(entityList)
  }

  public override fun insert(entity: Report): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.reportUid == 0L) {
      val _newPk = _pkManager.nextId(101)
      entity.reportUid = _newPk
    }
    entity.reportLastModTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.reportUid
  }

  public override suspend fun insertAsync(entity: Report): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.reportUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(101)
      entity.reportUid = _newPk
    }
    entity.reportLastModTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.reportUid
  }

  public override fun insertList(entityList: List<Report>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.reportUid == 0L) {
        val _newPk = _pkManager.nextId(101)
        it.reportUid = _newPk
        _generatedPks += _newPk
      }
      it.reportLastModTime = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: Report) {
    entity.reportLastModTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
