package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ReportQueryResult
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ReportQueryResultDao {
  @Query(`value` =
      "\n        DELETE FROM ReportQueryResult\n         WHERE rqrReportUid = :reportUid\n           AND rqrTimeZone = :timeZone\n    ")
  public actual abstract suspend fun deleteByReportUidAndTimeZone(reportUid: Long, timeZone: String)

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertAllAsync(results: List<ReportQueryResult>)

  @Query(`value` =
      "\n        SELECT ReportQueryResult.*\n          FROM ReportQueryResult\n         WHERE ReportQueryResult.rqrReportUid = :reportUid \n           AND ReportQueryResult.rqrTimeZone = :timeZone\n    ")
  public actual abstract suspend fun getAllByReportUidAndTimeZone(reportUid: Long,
      timeZone: String): List<ReportQueryResult>

  @Query(`value` =
      "\n        SELECT COALESCE(\n               (SELECT ReportQueryResult.rqrLastModified\n                  FROM ReportQueryResult\n                 WHERE ReportQueryResult.rqrReportUid = :reportUid\n                   AND ReportQueryResult.rqrTimeZone = :timeZone\n                 LIMIT 1), 0) >= \n               (SELECT MAX(:freshThresholdTime, \n                            (SELECT COALESCE(\n                                    (SELECT Report.reportLastModTime\n                                       FROM Report\n                                      WHERE Report.reportUid = :reportUid), 0))))\n    ")
  public actual abstract suspend fun isReportFresh(
    reportUid: Long,
    timeZone: String,
    freshThresholdTime: Long,
  ): Boolean
}
