package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.Clazz
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.CoursePermission
import com.ustadmobile.lib.db.entities.CoursePicture
import com.ustadmobile.lib.db.entities.CourseTerminology
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.SystemPermission
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.findByClazzCode_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_code : String = request.queryParam("code")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _thisNodeId = request.db.doorWrapperNodeId
  val _result = findByClazzCode(_arg_code,)
  return DoorJsonResponse(
    bodyText = json.encodeToString(Clazz.serializer().nullable, _result),
    headers = listOf(DoorConstants.HEADER_NODE_ID to _thisNodeId.toString()),
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.clazzUidExistsAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsync = findByUidAsync(
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.findByUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsFlow = findByUidAsFlow(
    uid = _arg_uid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzDao.findByUidWithHolidayCalendarAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidWithHolidayCalendarAsync = findByUidWithHolidayCalendarAsync(
    uid = _arg_uid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidWithHolidayCalendarAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidWithHolidayCalendarAsync?.holidayCalendar?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 28,
          orUid = 0,
          entity = json.encodeToJsonElement(HolidayCalendar.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidWithHolidayCalendarAsync?.terminology?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 450,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseTerminology.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidWithHolidayCalendarAsync?.coursePicture?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 125,
          orUid = 0,
          entity = json.encodeToJsonElement(CoursePicture.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.findClazzesWithPermission_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_searchQuery : String = request.queryParam("searchQuery")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_excludeSelectedClazzList : List<Long> =
      request.queryParam("excludeSelectedClazzList")?.let {
    json.decodeFromString(ListSerializer(Long.serializer()), it)
  } ?: mutableListOf()
  val _arg_sortOrder : Int = request.queryParam("sortOrder")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _arg_filter : Int = request.queryParam("filter")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _arg_currentTime : Long = request.queryParam("currentTime")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_permission : Long = request.queryParam("permission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findClazzesWithPermission_pagingSource = findClazzesWithPermission(
    searchQuery = _arg_searchQuery,
    accountPersonUid = _arg_accountPersonUid,
    excludeSelectedClazzList = _arg_excludeSelectedClazzList,
    sortOrder = _arg_sortOrder,
    filter = _arg_filter,
    currentTime = _arg_currentTime,
    permission = _arg_permission,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findClazzesWithPermission = _result_findClazzesWithPermission_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findClazzesWithPermission_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findClazzesWithPermission_pagingSource.endOfPaginationReached

  val _result_personHasPermissionWithClazzEntities2 =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = 0,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findClazzesWithPermission.map {
        _row ->
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findClazzesWithPermission.mapNotNull {
        _row ->
        _row.clazzActiveEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findClazzesWithPermission.mapNotNull {
        _row ->
        _row.terminology?.let {
          DoorReplicationEntity(tableId = 450,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseTerminology.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findClazzesWithPermission.mapNotNull {
        _row ->
        _row.coursePicture?.let {
          DoorReplicationEntity(tableId = 125,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePicture.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzDao.clazzAndDetailPermissionsAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val _result_clazzAndDetailPermissionsAsFlow = clazzAndDetailPermissionsAsFlow(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
    _result_clazzAndDetailPermissionsAsFlow?.clazz?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.getClazzWithDisplayDetails_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_currentTime : Long = request.queryParam("currentTime")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getClazzWithDisplayDetails = getClazzWithDisplayDetails(
    clazzUid = _arg_clazzUid,
    currentTime = _arg_currentTime,
    accountPersonUid = _arg_accountPersonUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_getClazzWithDisplayDetails?.clazz?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
    _result_getClazzWithDisplayDetails?.terminology?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 450,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseTerminology.serializer(), _row).jsonObject,
        )
      )
    }
    _result_getClazzWithDisplayDetails?.coursePicture?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 125,
          orUid = 0,
          entity = json.encodeToJsonElement(CoursePicture.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.getTitleByUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsync = findByUidAsync(
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzDao.getClazzNameAndTerminologyAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getClazzNameAndTerminologyAsFlow = getClazzNameAndTerminologyAsFlow(
    clazzUid = _arg_clazzUid,
  ).first()
  val _result_findByUidAsync = findByUidAsync(
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_getClazzNameAndTerminologyAsFlow?.terminology?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 450,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseTerminology.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.getClazzNameAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getClazzNameAndTerminologyAsFlow = getClazzNameAndTerminologyAsFlow(
    clazzUid = _arg_clazzUid,
  ).first()
  val _result_findByUidAsync = findByUidAsync(
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_getClazzNameAndTerminologyAsFlow?.terminology?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 450,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseTerminology.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findByUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzDao.getClazzTimeZoneByClazzUidAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _thisNodeId = request.db.doorWrapperNodeId
  val _result = getClazzTimeZoneByClazzUidAsync(_arg_clazzUid,)
  return DoorJsonResponse(
    bodyText = json.encodeToString(String.serializer().nullable, _result),
    headers = listOf(DoorConstants.HEADER_NODE_ID to _thisNodeId.toString()),
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.getCoursesByName_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_names : List<String> = request.queryParam("names")?.let {
    json.decodeFromString(ListSerializer(String.serializer()), it)
  } ?: mutableListOf()
  val _result_getCoursesByName = getCoursesByName(
    names = _arg_names,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getCoursesByName.map {
        _row ->
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzDao.findOneRosterUserClazzes_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_filterByEnrolledMemberPersonUid : Long =
      request.queryParam("filterByEnrolledMemberPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findOneRosterUserClazzes = findOneRosterUserClazzes(
    accountPersonUid = _arg_accountPersonUid,
    filterByEnrolledMemberPersonUid = _arg_filterByEnrolledMemberPersonUid,
  )
  val _result_personHasPermissionWithClazzEntities2 =
      request.db.doorWrapper.getDaoByClass(CoursePermissionDao::class).personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = 0,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findOneRosterUserClazzes.map {
        _row ->
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
