/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.util.test;

import com.ustadmobile.lib.util.RangeResponse;
import com.ustadmobile.lib.util.RangeUtilKt;
import com.ustadmobile.util.test.RangeInputStream;
import com.ustadmobile.util.test.ext.ByteArrayExtKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/util/test/ResourcesDispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "clazz", "Ljava/lang/Class;", "contentEncoding", "", "responseTransform", "Lkotlin/Function1;", "Lokhttp3/mockwebserver/MockResponse;", "(Ljava/lang/Class;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "dispatch", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "lib-test-common"})
public class ResourcesDispatcher
extends Dispatcher {
    @NotNull
    private final Class<?> clazz;
    @Nullable
    private final String contentEncoding;
    @NotNull
    private final Function1<MockResponse, MockResponse> responseTransform;

    public ResourcesDispatcher(@NotNull Class<?> clazz, @Nullable String contentEncoding, @NotNull Function1<? super MockResponse, MockResponse> responseTransform) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(responseTransform, (String)"responseTransform");
        this.clazz = clazz;
        this.contentEncoding = contentEncoding;
        this.responseTransform = responseTransform;
    }

    public /* synthetic */ ResourcesDispatcher(Class clazz, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(clazz, string, (Function1<? super MockResponse, MockResponse>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MockResponse dispatch(@NotNull RecordedRequest request) {
        MockResponse mockResponse;
        RangeResponse rangeResponse;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Buffer buffer = new Buffer();
        String string = request.getPath();
        if (string == null) {
            return new MockResponse().setResponseCode(500);
        }
        String path = string;
        InputStream inputStream = this.clazz.getResourceAsStream(path);
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] it = inputStream.readAllBytes();
        boolean bl = false;
        String string2 = this.contentEncoding;
        if (string2 == null) {
            byArray = it;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"gzip")) {
            Intrinsics.checkNotNull((Object)it);
            byArray = ByteArrayExtKt.gzipped(it);
        } else {
            throw new IllegalArgumentException("unsupported encoding: " + this.contentEncoding);
        }
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            return new MockResponse().setResponseCode(404);
        }
        byte[] contentBytes = byArray2;
        ByteArrayInputStream contentInStream = new ByteArrayInputStream(contentBytes);
        String string3 = request.getHeader("range");
        if (string3 != null) {
            String it2 = string3;
            boolean bl2 = false;
            rangeResponse = RangeUtilKt.parseRangeRequestHeader((String)it2, (long)contentBytes.length);
        } else {
            rangeResponse = null;
        }
        RangeResponse rangeResponse2 = rangeResponse;
        BufferedSource contentSource = rangeResponse2 != null ? Okio.buffer((Source)Okio.source((InputStream)new RangeInputStream(contentInStream, rangeResponse2.getFromByte(), rangeResponse2.getToByte()))) : Okio.buffer((Source)Okio.source((InputStream)contentInStream));
        contentSource.readAll((Sink)buffer);
        RangeResponse rangeResponse3 = rangeResponse2;
        long contentLength = rangeResponse3 != null ? rangeResponse3.getActualContentLength() : (long)contentBytes.length;
        RangeResponse rangeResponse4 = rangeResponse2;
        MockResponse mockResponse2 = mockResponse = new MockResponse().setResponseCode(rangeResponse4 != null ? rangeResponse4.getStatusCode() : 200).setBody(buffer).addHeader("content-length", (Object)contentLength);
        Function1<MockResponse, MockResponse> function1 = this.responseTransform;
        boolean bl3 = false;
        if (this.contentEncoding != null) {
            void $this$dispatch_u24lambda_u242;
            $this$dispatch_u24lambda_u242.addHeader("content-encoding", (Object)this.contentEncoding);
        }
        return (MockResponse)function1.invoke((Object)mockResponse);
    }
}

