/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions.serialization;

import io.ktor.server.sessions.SessionSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/sessions/serialization/KotlinxSessionSerializer;", "T", "", "Lio/ktor/server/sessions/SessionSerializer;", "format", "Lkotlinx/serialization/StringFormat;", "serializer", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/StringFormat;Lkotlinx/serialization/KSerializer;)V", "deserialize", "text", "", "(Ljava/lang/String;)Ljava/lang/Object;", "serialize", "session", "(Ljava/lang/Object;)Ljava/lang/String;", "ktor-server-sessions"})
final class KotlinxSessionSerializer<T>
implements SessionSerializer<T> {
    @NotNull
    private final StringFormat format;
    @NotNull
    private final KSerializer<T> serializer;

    public KotlinxSessionSerializer(@NotNull StringFormat format, @NotNull KSerializer<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.format = format;
        this.serializer = serializer;
    }

    @Override
    @NotNull
    public String serialize(@NotNull T session) {
        Intrinsics.checkNotNullParameter(session, (String)"session");
        return this.format.encodeToString((SerializationStrategy)this.serializer, session);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (T)this.format.decodeFromString((DeserializationStrategy)this.serializer, text);
    }
}

