/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.contentformats.epub;

import com.ustadmobile.core.contentformats.epub.XhtmlFixResult;
import com.ustadmobile.core.contentformats.epub.XhtmlFixer;
import com.ustadmobile.core.contentformats.epub.minxhtml.MinXhtmlDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import nl.adaptivity.xmlutil.serialization.XML;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/core/contentformats/epub/XhtmlFixerJsoup;", "Lcom/ustadmobile/core/contentformats/epub/XhtmlFixer;", "xml", "Lnl/adaptivity/xmlutil/serialization/XML;", "(Lnl/adaptivity/xmlutil/serialization/XML;)V", "fixXhtml", "Lcom/ustadmobile/core/contentformats/epub/XhtmlFixResult;", "xhtml", "", "core"})
@SourceDebugExtension(value={"SMAP\nXhtmlFixerJsoup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XhtmlFixerJsoup.kt\ncom/ustadmobile/core/contentformats/epub/XhtmlFixerJsoup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class XhtmlFixerJsoup
implements XhtmlFixer {
    @NotNull
    private final XML xml;

    public XhtmlFixerJsoup(@NotNull XML xml) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        this.xml = xml;
    }

    @Override
    @NotNull
    public XhtmlFixResult fixXhtml(@NotNull String xhtml) {
        Intrinsics.checkNotNullParameter((Object)xhtml, (String)"xhtml");
        try {
            this.xml.decodeFromString((DeserializationStrategy)MinXhtmlDocument.Companion.serializer(), xhtml);
            return new XhtmlFixResult(true, xhtml);
        }
        catch (Exception e) {
            Document doc = Jsoup.parse((String)xhtml, (Parser)Parser.htmlParser());
            doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
            doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
            DocumentType documentType = doc.documentType();
            if (documentType != null) {
                DocumentType documentType2;
                DocumentType it = documentType2 = documentType;
                boolean bl = false;
                it.replaceWith((Node)new DocumentType("html", "", ""));
                Node it2 = doc.body().firstChild();
                boolean bl2 = false;
                TextNode textNode = it2 instanceof TextNode ? (TextNode)it2 : null;
                if (textNode != null) {
                    TextNode textNode2;
                    TextNode textNode3;
                    TextNode it3 = textNode3 = textNode;
                    boolean bl3 = false;
                    String string = it3.text();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                    Object object = textNode2 = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"]>") ? textNode3 : null;
                    if (textNode2 != null) {
                        textNode2.remove();
                    }
                }
            }
            Element element = doc.getElementById("pb-dictionary-loder");
            if (element != null) {
                element.remove();
            }
            String string = doc.html();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
            return new XhtmlFixResult(false, string);
        }
    }
}

