/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.matomo;

import com.ustadmobile.core.domain.matomo.MatomoTrackingJob;
import com.ustadmobile.core.domain.matomo.RecordMatomoTrackingUseCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/core/domain/matomo/RecordMatomoTrackingUseCaseJvmImpl;", "Lcom/ustadmobile/core/domain/matomo/RecordMatomoTrackingUseCase;", "scheduler", "Lorg/quartz/Scheduler;", "endpoint", "", "(Lorg/quartz/Scheduler;Ljava/lang/String;)V", "invoke", "", "screenName", "path", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "core"})
public final class RecordMatomoTrackingUseCaseJvmImpl
implements RecordMatomoTrackingUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final String endpoint;
    @NotNull
    public static final String DATA_SCREEN_NAME = "screenName";
    @NotNull
    public static final String DATA_PATH = "path";
    @NotNull
    public static final String DATA_ENDPOINT = "endpoint";

    public RecordMatomoTrackingUseCaseJvmImpl(@NotNull Scheduler scheduler, @NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)DATA_ENDPOINT);
        this.scheduler = scheduler;
        this.endpoint = endpoint;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull String screenName, @NotNull String path, @NotNull Continuation<? super Unit> $completion) {
        JobDetail quartzJob = JobBuilder.newJob(MatomoTrackingJob.class).usingJobData(DATA_SCREEN_NAME, screenName).usingJobData(DATA_PATH, path).usingJobData(DATA_ENDPOINT, this.endpoint).build();
        TriggerKey triggerKey = Companion.triggerKeyFor(screenName, path, this.endpoint);
        this.scheduler.unscheduleJob(triggerKey);
        Trigger jobTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startNow().build();
        this.scheduler.scheduleJob(quartzJob, jobTrigger);
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/core/domain/matomo/RecordMatomoTrackingUseCaseJvmImpl$Companion;", "", "()V", "DATA_ENDPOINT", "", "DATA_PATH", "DATA_SCREEN_NAME", "triggerKeyFor", "Lorg/quartz/TriggerKey;", "screenName", "path", "endpoint", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TriggerKey triggerKeyFor(@NotNull String screenName, @NotNull String path, @NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)screenName, (String)RecordMatomoTrackingUseCaseJvmImpl.DATA_SCREEN_NAME);
            Intrinsics.checkNotNullParameter((Object)path, (String)RecordMatomoTrackingUseCaseJvmImpl.DATA_PATH);
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)RecordMatomoTrackingUseCaseJvmImpl.DATA_ENDPOINT);
            String endpointUrl = StringsKt.take((String)endpoint, (int)100);
            String screenNameHash = String.valueOf(screenName.hashCode());
            String pathHash = String.valueOf(path.hashCode());
            return new TriggerKey("matomo-track-" + endpointUrl + "-" + screenNameHash + "-" + pathHash, "com.ustadmobile.pendingconnection");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

