/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.passkey;

import com.ustadmobile.core.MR;
import com.ustadmobile.core.domain.passkey.CreatePasskeyParams;
import com.ustadmobile.core.domain.passkey.UserPasskeyChallenge;
import com.ustadmobile.core.impl.UstadMobileSystemImpl;
import io.github.aakira.napier.Napier;
import io.ktor.util.Base64Kt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/core/domain/passkey/PasskeyRequestJsonUseCase;", "", "systemImpl", "Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;", "json", "Lkotlinx/serialization/json/Json;", "(Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;Lkotlinx/serialization/json/Json;)V", "createPasskeyRequestJson", "", "createPasskeyParams", "Lcom/ustadmobile/core/domain/passkey/CreatePasskeyParams;", "randomString", "length", "", "requestJsonForSignIn", "domain", "core"})
@SourceDebugExtension(value={"SMAP\nPasskeyRequestJsonUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasskeyRequestJsonUseCase.kt\ncom/ustadmobile/core/domain/passkey/PasskeyRequestJsonUseCase\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n113#2:99\n1549#3:100\n1620#3,3:101\n*S KotlinDebug\n*F\n+ 1 PasskeyRequestJsonUseCase.kt\ncom/ustadmobile/core/domain/passkey/PasskeyRequestJsonUseCase\n*L\n30#1:99\n79#1:100\n79#1:101,3\n*E\n"})
public final class PasskeyRequestJsonUseCase {
    @NotNull
    private final UstadMobileSystemImpl systemImpl;
    @NotNull
    private final Json json;

    public PasskeyRequestJsonUseCase(@NotNull UstadMobileSystemImpl systemImpl, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)systemImpl, (String)"systemImpl");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.systemImpl = systemImpl;
        this.json = json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createPasskeyRequestJson(@NotNull CreatePasskeyParams createPasskeyParams) {
        void value$iv;
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)createPasskeyParams, (String)"createPasskeyParams");
        String userId = this.randomString(16);
        StringFormat stringFormat = (StringFormat)this.json;
        UserPasskeyChallenge userPasskeyChallenge = new UserPasskeyChallenge(createPasskeyParams.getUsername(), createPasskeyParams.getPersonUid(), createPasskeyParams.getDoorNodeId(), createPasskeyParams.getUsStartTime());
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String challenge = $this$encodeToString$iv.encodeToString((SerializationStrategy)UserPasskeyChallenge.Companion.serializer(), (Object)value$iv);
        String challengeBase64Encoded = Base64Kt.encodeBase64((String)challenge);
        String useridBase64Encoded = Base64Kt.encodeBase64((String)(userId + "@" + createPasskeyParams.getServerUrl()));
        String requestJson = StringsKt.trimIndent((String)("\n                  {\n                    \"challenge\": \"" + challengeBase64Encoded + "\",\n                    \"rp\": {\n                      \"id\": \"credential-manager-" + createPasskeyParams.getDomainName() + "\",\n                      \"name\": \"" + this.systemImpl.getString(MR.strings.INSTANCE.getApp_name()) + "\"\n                    },\n                    \"pubKeyCredParams\": [\n                      {\n                        \"type\": \"public-key\",\n                        \"alg\": -7\n                      },\n                      {\n                        \"type\": \"public-key\",\n                        \"alg\": -257\n                      }\n                    ],\n                    \"authenticatorSelection\": {\n                      \"authenticatorAttachment\": \"platform\",\n                      \"residentKey\": \"required\"\n                    },\n                    \"user\": {\n                      \"id\": \"" + useridBase64Encoded + "\",\n                      \"name\": \"" + createPasskeyParams.getUsername() + "\",\n                      \"displayName\": \"" + createPasskeyParams.getUsername() + "\"\n                    }\n                  }\n              "));
        Napier.e$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(requestJson){
            final /* synthetic */ String $requestJson;
            {
                this.$requestJson = $requestJson;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$requestJson;
            }
        }), (int)3, null);
        return requestJson;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String randomString(int length) {
        void $this$mapTo$iv$iv;
        String charPool = "abcdefghikjmnpqrstuvxwyz23456789";
        Iterable $this$map$iv = (Iterable)new IntRange(1, length);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(charPool.charAt(Random.Default.nextInt(0, charPool.length()))));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String requestJsonForSignIn(@NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        String challenge = this.randomString(16);
        String requestJson = StringsKt.trimIndent((String)("\n    {\n    \"challenge\": \"" + challenge + "\",\n    \"allowCredentials\": [],\n    \"timeout\": 1800000,\n    \"userVerification\": \"required\",\n    \"rpId\": \"credential-manager-" + domain + "\"\n}\n"));
        Napier.e$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(requestJson){
            final /* synthetic */ String $requestJson;
            {
                this.$requestJson = $requestJson;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$requestJson;
            }
        }), (int)3, null);
        return requestJson;
    }
}

