/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0011H\u0082 J\u0011\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0082 J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0011\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\nH\u0082 J\u0011\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\nH\u0082 J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\nH\u0082 J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0011\u0010'\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0082 J\u0011\u0010(\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0082 J)\u0010)\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0082 J\b\u0010-\u001a\u00020.H\u0002J(\u0010/\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u00100\u001a\u00020\nH\u0014J!\u00101\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u00102\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoView;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "", "bytesToDraw", "", "context", "Lorg/jetbrains/skia/DirectContext;", "device", "rowBytesAlignment", "", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "texturePtr", "widthSizeAlignment", "chooseAdapter", "adapterPriority", "createDirectXOffscreenDevice", "dispose", "", "disposeDevice", "disposeDirectXTexture", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getAlignment", "isAdapterSupported", "", "name", "", "makeDirectXContext", "makeDirectXRenderTargetOffScreen", "makeDirectXTexture", "oldTexturePtr", "width", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "readPixels", "byteArray", "Companion", "skiko"})
public final class Direct3DSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkikoView skikoView;
    private final long adapter;
    private final long device;
    @NotNull
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    @NotNull
    private final DirectContext context;
    private long texturePtr;
    @NotNull
    private byte[] bytesToDraw;
    private final int rowBytesAlignment;
    private final int widthSizeAlignment;

    public Direct3DSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoView skikoView, @NotNull SkiaLayerAnalytics analytics) {
        long l;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)skikoView, (String)"skikoView");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.DIRECT3D);
        this.skikoView = skikoView;
        long l2 = l = this.chooseAdapter(swingLayerProperties2.getAdapterPriority().ordinal());
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen("DirectX12");
        direct3DSwingRedrawer.adapter = l;
        this.device = this.createDirectXOffscreenDevice(this.adapter);
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
        this.context = new DirectContext(this.makeDirectXContext(this.device));
        this.bytesToDraw = new byte[0];
        this.rowBytesAlignment = (int)this.getAlignment();
        this.widthSizeAlignment = this.rowBytesAlignment / 4;
        this.onContextInit();
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.context.close();
        this.disposeDirectXTexture(this.texturePtr);
        this.disposeDevice(this.device);
        super.dispose();
    }

    @Override
    protected void onRender(@NotNull Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(width2, this, height2, nanoTime, g){
            final /* synthetic */ int $width;
            final /* synthetic */ Direct3DSwingRedrawer this$0;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                this.$width = $width;
                this.this$0 = $receiver;
                this.$height = $height;
                this.$nanoTime = $nanoTime;
                this.$g = $g;
                super(1);
            }

            public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                Surface surface;
                Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                int alignedWidth = this.$width % Direct3DSwingRedrawer.access$getWidthSizeAlignment$p(this.this$0) != 0 ? this.$width + Direct3DSwingRedrawer.access$getWidthSizeAlignment$p(this.this$0) - this.$width % Direct3DSwingRedrawer.access$getWidthSizeAlignment$p(this.this$0) : this.$width;
                Direct3DSwingRedrawer.access$setTexturePtr$p(this.this$0, Direct3DSwingRedrawer.access$makeDirectXTexture(this.this$0, Direct3DSwingRedrawer.access$getDevice$p(this.this$0), Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0), alignedWidth, this.$height));
                if (Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0) == 0L) {
                    throw new RenderException("Can't allocate DirectX resources", null, 2, null);
                }
                BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)Direct3DSwingRedrawer.access$makeRenderTarget(this.this$0));
                Surface surface2 = Surface.Companion.makeFromBackendRenderTarget(Direct3DSwingRedrawer.access$getContext$p(this.this$0), renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                if (surface2 == null || (surface = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface2)) == null) {
                    throw new RenderException("Cannot create surface", null, 2, null);
                }
                Surface surface3 = surface;
                Canvas canvas = surface3.getCanvas();
                canvas.clear(0);
                Direct3DSwingRedrawer.access$getSkikoView$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                this.this$0.flush(surface3, this.$g);
            }
        }));
    }

    public final void flush(@NotNull Surface surface, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        surface.flushAndSubmit(false);
        int bytesArraySize = surface.getWidth() * surface.getHeight() * 4;
        if (this.bytesToDraw.length != bytesArraySize) {
            this.bytesToDraw = new byte[bytesArraySize];
        }
        if (!this.readPixels(this.device, this.texturePtr, this.bytesToDraw)) {
            throw new RenderException("Couldn't read pixels", null, 2, null);
        }
        this.swingOffscreenDrawer.draw(g, this.bytesToDraw, surface.getWidth(), surface.getHeight());
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(this.makeDirectXRenderTargetOffScreen(this.texturePtr));
    }

    private final boolean isAdapterSupported(String name) {
        return GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.DIRECT3D, OsArch_jvmKt.getHostOs(), name);
    }

    private final native long chooseAdapter(int var1);

    private final native long createDirectXOffscreenDevice(long var1);

    private final native long makeDirectXContext(long var1);

    private final native boolean readPixels(long var1, long var3, byte[] var5);

    private final native long getAlignment();

    private final native long makeDirectXTexture(long var1, long var3, int var5, int var6);

    private final native void disposeDirectXTexture(long var1);

    private final native long makeDirectXRenderTargetOffScreen(long var1);

    private final native void disposeDevice(long var1);

    public static final /* synthetic */ int access$getWidthSizeAlignment$p(Direct3DSwingRedrawer $this) {
        return $this.widthSizeAlignment;
    }

    public static final /* synthetic */ void access$setTexturePtr$p(Direct3DSwingRedrawer $this, long l) {
        $this.texturePtr = l;
    }

    public static final /* synthetic */ long access$makeDirectXTexture(Direct3DSwingRedrawer $this, long device2, long oldTexturePtr, int width2, int height2) {
        return $this.makeDirectXTexture(device2, oldTexturePtr, width2, height2);
    }

    public static final /* synthetic */ long access$getDevice$p(Direct3DSwingRedrawer $this) {
        return $this.device;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(Direct3DSwingRedrawer $this) {
        return $this.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(Direct3DSwingRedrawer $this) {
        return $this.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(Direct3DSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoView access$getSkikoView$p(Direct3DSwingRedrawer $this) {
        return $this.skikoView;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

