/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B9\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000b\u0010\fB;\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000b\u0010\u000eB;\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00028\u00012\u0006\u0010%\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010(R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0016\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0013\u0010\n\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u001b\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u001c\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010#\u00a8\u0006)"}, d2={"Landroidx/compose/animation/core/DecayAnimation;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/Animation;", "animationSpec", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "typeConverter", "Landroidx/compose/animation/core/TwoWayConverter;", "initialValue", "initialVelocityVector", "<init>", "(Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "Landroidx/compose/animation/core/DecayAnimationSpec;", "(Landroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "initialVelocity", "(Landroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;)V", "getTypeConverter", "()Landroidx/compose/animation/core/TwoWayConverter;", "getInitialValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "initialValueVector", "Landroidx/compose/animation/core/AnimationVector;", "getInitialVelocityVector", "()Landroidx/compose/animation/core/AnimationVector;", "endVelocity", "targetValue", "getTargetValue", "durationNanos", "", "getDurationNanos", "()J", "isInfinite", "", "()Z", "getValueFromNanos", "playTimeNanos", "(J)Ljava/lang/Object;", "getVelocityVectorFromNanos", "(J)Landroidx/compose/animation/core/AnimationVector;", "animation-core"})
@StabilityInferred(parameters=3)
public final class DecayAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    @NotNull
    private final VectorizedDecayAnimationSpec<V> animationSpec;
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private final T initialValue;
    @NotNull
    private final V initialValueVector;
    @NotNull
    private final V initialVelocityVector;
    @NotNull
    private final V endVelocity;
    private final T targetValue;
    private final long durationNanos;
    private final boolean isInfinite;
    public static final int $stable;

    public DecayAnimation(@NotNull VectorizedDecayAnimationSpec<V> animationSpec2, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, @NotNull V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec2, "animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, "typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, "initialVelocityVector");
        this.animationSpec = animationSpec2;
        this.typeConverter = typeConverter;
        this.initialValue = initialValue;
        this.initialValueVector = (AnimationVector)this.getTypeConverter().getConvertToVector().invoke(this.initialValue);
        this.initialVelocityVector = AnimationVectorsKt.copy(initialVelocityVector);
        this.targetValue = this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getTargetValue(this.initialValueVector, initialVelocityVector));
        this.durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, initialVelocityVector);
        this.endVelocity = AnimationVectorsKt.copy(this.animationSpec.getVelocityFromNanos(this.getDurationNanos(), this.initialValueVector, initialVelocityVector));
        int n = ((AnimationVector)this.endVelocity).getSize$animation_core();
        for (int i2 = 0; i2 < n; ++i2) {
            ((AnimationVector)this.endVelocity).set$animation_core(i2, RangesKt.coerceIn(((AnimationVector)this.endVelocity).get$animation_core(i2), -this.animationSpec.getAbsVelocityThreshold(), this.animationSpec.getAbsVelocityThreshold()));
        }
    }

    @Override
    @NotNull
    public TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    public final T getInitialValue() {
        return this.initialValue;
    }

    @NotNull
    public final V getInitialVelocityVector() {
        return this.initialVelocityVector;
    }

    @Override
    public T getTargetValue() {
        return this.targetValue;
    }

    @Override
    public long getDurationNanos() {
        return this.durationNanos;
    }

    @Override
    public boolean isInfinite() {
        return this.isInfinite;
    }

    public DecayAnimation(@NotNull DecayAnimationSpec<T> animationSpec2, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, @NotNull V initialVelocityVector) {
        Intrinsics.checkNotNullParameter(animationSpec2, "animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, "typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, "initialVelocityVector");
        this(animationSpec2.vectorize(typeConverter), typeConverter, initialValue, initialVelocityVector);
    }

    public DecayAnimation(@NotNull DecayAnimationSpec<T> animationSpec2, @NotNull TwoWayConverter<T, V> typeConverter, T initialValue, T initialVelocity) {
        Intrinsics.checkNotNullParameter(animationSpec2, "animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, "typeConverter");
        this(animationSpec2.vectorize(typeConverter), typeConverter, initialValue, (AnimationVector)typeConverter.getConvertToVector().invoke(initialVelocity));
    }

    @Override
    public T getValueFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            return this.getTypeConverter().getConvertFromVector().invoke(this.animationSpec.getValueFromNanos(playTimeNanos, this.initialValueVector, this.initialVelocityVector));
        }
        return this.getTargetValue();
    }

    @Override
    @NotNull
    public V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            return this.animationSpec.getVelocityFromNanos(playTimeNanos, this.initialValueVector, this.initialVelocityVector);
        }
        return this.endVelocity;
    }
}

