/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.IntRange;
import androidx.paging.PagingConfig;
import androidx.paging.PagingSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B=\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0015\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0007\u001a\u00020\b2!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00160\u001d\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010#\u001a\u00020\u0016J\r\u0010$\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010%J\b\u0010'\u001a\u00020(H\u0016JY\u0010)\u001a\u0002H*\"\u0004\b\u0002\u0010*2\u0006\u0010\u0007\u001a\u00020\b26\u0010+\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(.\u0012\u0004\u0012\u0002H*0,H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Landroidx/paging/PagingState;", "Key", "", "Value", "pages", "", "Landroidx/paging/PagingSource$LoadResult$Page;", "anchorPosition", "", "config", "Landroidx/paging/PagingConfig;", "leadingPlaceholderCount", "<init>", "(Ljava/util/List;Ljava/lang/Integer;Landroidx/paging/PagingConfig;I)V", "getPages", "()Ljava/util/List;", "getAnchorPosition", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getConfig", "()Landroidx/paging/PagingConfig;", "equals", "", "other", "hashCode", "closestItemToPosition", "(I)Ljava/lang/Object;", "closestItemAroundPosition", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "closestPageToPosition", "isEmpty", "firstItemOrNull", "()Ljava/lang/Object;", "lastItemOrNull", "toString", "", "anchorPositionToPagedIndices", "T", "block", "Lkotlin/Function2;", "pageIndex", "index", "anchorPositionToPagedIndices$paging_common", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "paging-common"})
@SourceDebugExtension(value={"SMAP\nPagingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagingState.kt\nandroidx/paging/PagingState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n257#1,8:271\n257#1,8:290\n257#1,8:315\n1734#2,3:268\n230#2,2:279\n461#2,6:281\n1734#2,3:287\n360#2,7:298\n388#2,7:305\n1734#2,3:312\n1734#2,3:323\n295#2,2:326\n543#2,6:328\n*S KotlinDebug\n*F\n+ 1 PagingState.kt\nandroidx/paging/PagingState\n*L\n73#1:271,8\n118#1:290,8\n218#1:315,8\n71#1:268,3\n74#1:279,2\n75#1:281,6\n116#1:287,3\n119#1:298,7\n120#1:305,7\n216#1:312,3\n230#1:323,3\n237#1:326,2\n245#1:328,6\n*E\n"})
public final class PagingState<Key, Value> {
    @NotNull
    private final List<PagingSource.LoadResult.Page<Key, Value>> pages;
    @Nullable
    private final Integer anchorPosition;
    @NotNull
    private final PagingConfig config;
    private final int leadingPlaceholderCount;

    public PagingState(@NotNull List<PagingSource.LoadResult.Page<Key, Value>> pages, @Nullable Integer anchorPosition, @NotNull PagingConfig config, @IntRange(from=0L) int leadingPlaceholderCount) {
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.pages = pages;
        this.anchorPosition = anchorPosition;
        this.config = config;
        this.leadingPlaceholderCount = leadingPlaceholderCount;
    }

    @NotNull
    public final List<PagingSource.LoadResult.Page<Key, Value>> getPages() {
        return this.pages;
    }

    @Nullable
    public final Integer getAnchorPosition() {
        return this.anchorPosition;
    }

    @NotNull
    public final PagingConfig getConfig() {
        return this.config;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PagingState && Intrinsics.areEqual(this.pages, ((PagingState)other).pages) && Intrinsics.areEqual((Object)this.anchorPosition, (Object)((PagingState)other).anchorPosition) && Intrinsics.areEqual((Object)this.config, (Object)((PagingState)other).config) && this.leadingPlaceholderCount == ((PagingState)other).leadingPlaceholderCount;
    }

    public int hashCode() {
        Integer n = this.anchorPosition;
        return ((Object)this.pages).hashCode() + (n != null ? ((Object)n).hashCode() : 0) + this.config.hashCode() + Integer.hashCode(this.leadingPlaceholderCount);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Value closestItemToPosition(int anchorPosition) {
        void index;
        PagingSource.LoadResult.Page<Key, Value> element$iv;
        PagingSource.LoadResult.Page firstNonEmptyPage;
        int pageIndex;
        block9: {
            Object element$iv22;
            block8: {
                int index$iv;
                void this_$iv;
                int n;
                boolean bl;
                Object $this$all$iv;
                block7: {
                    $this$all$iv = this.pages;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv3 = iterator.next();
                            PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv3;
                            n = 0;
                            if (it.getData().isEmpty()) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
                $this$all$iv = this;
                int anchorPosition$iv = anchorPosition;
                boolean $i$f$anchorPositionToPagedIndices$paging_common = false;
                int pageIndex$iv = 0;
                for (index$iv = anchorPosition$iv - ((PagingState)this_$iv).leadingPlaceholderCount; pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
                }
                n = index$iv;
                pageIndex = pageIndex$iv;
                boolean bl2 = false;
                Iterable $this$first$iv = this.pages;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv22;
                    boolean bl3 = false;
                    boolean bl4 = !((Collection)it.getData()).isEmpty();
                    if (!bl4) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firstNonEmptyPage = (PagingSource.LoadResult.Page)element$iv22;
            List<PagingSource.LoadResult.Page<Key, Value>> $this$last$iv = this.pages;
            boolean $i$f$last = false;
            ListIterator<PagingSource.LoadResult.Page<Key, Value>> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                PagingSource.LoadResult.Page<Key, Value> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                boolean bl5 = !((Collection)it.getData()).isEmpty();
                if (!bl5) continue;
                break block9;
            }
            throw new NoSuchElementException("List contains no element matching the predicate.");
        }
        PagingSource.LoadResult.Page<Key, Value> lastNonEmptyPage = element$iv;
        return (Value)(index < 0 ? CollectionsKt.first(firstNonEmptyPage.getData()) : (pageIndex == CollectionsKt.getLastIndex(this.pages) && index > CollectionsKt.getLastIndex(((PagingSource.LoadResult.Page)CollectionsKt.last(this.pages)).getData()) ? CollectionsKt.last(lastNonEmptyPage.getData()) : this.pages.get(pageIndex).getData().get((int)index)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Value closestItemAroundPosition(int anchorPosition, @NotNull Function1<? super Value, Boolean> predicate) {
        void index;
        int n;
        int firstNonEmptyPageIndex;
        int pageIndex;
        block23: {
            int n2;
            block22: {
                int index$iv;
                void this_$iv;
                int n3;
                boolean bl;
                Object $this$all$iv;
                block21: {
                    Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                    $this$all$iv = this.pages;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                            n3 = 0;
                            if (it.getData().isEmpty()) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
                $this$all$iv = this;
                int anchorPosition$iv = anchorPosition;
                boolean $i$f$anchorPositionToPagedIndices$paging_common = false;
                int pageIndex$iv = 0;
                for (index$iv = anchorPosition$iv - ((PagingState)this_$iv).leadingPlaceholderCount; pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
                }
                n3 = index$iv;
                pageIndex = pageIndex$iv;
                boolean bl2 = false;
                List<PagingSource.LoadResult.Page<Key, Value>> $this$indexOfFirst$iv = this.pages;
                boolean $i$f$indexOfFirst = false;
                int index$iv2 = 0;
                Iterator<PagingSource.LoadResult.Page<Key, Value>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    PagingSource.LoadResult.Page<Key, Value> item$iv;
                    PagingSource.LoadResult.Page<Key, Value> it = item$iv = iterator.next();
                    boolean bl3 = false;
                    boolean bl4 = !((Collection)it.getData()).isEmpty();
                    if (bl4) {
                        n2 = index$iv2;
                        break block22;
                    }
                    ++index$iv2;
                }
                n2 = -1;
            }
            firstNonEmptyPageIndex = n2;
            List<PagingSource.LoadResult.Page<Key, Value>> $this$indexOfLast$iv = this.pages;
            boolean $i$f$indexOfLast = false;
            ListIterator<PagingSource.LoadResult.Page<Key, Value>> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                PagingSource.LoadResult.Page<Key, Value> it = iterator$iv.previous();
                boolean bl = false;
                boolean bl5 = !((Collection)it.getData()).isEmpty();
                if (!bl5) continue;
                n = iterator$iv.nextIndex();
                break block23;
            }
            n = -1;
        }
        int lastNonEmptyPageIndex = n;
        boolean prependComplete = false;
        boolean appendComplete = false;
        int prependedPageIndex = -1;
        PagingSource.LoadResult.Page<Key, Value> prependedPage = null;
        int prependedLocalIndex = -1;
        int appendedPageIndex = -1;
        PagingSource.LoadResult.Page<Key, Value> appendedPage = null;
        int appendedLocalIndex = -1;
        if (index < 0) {
            prependComplete = true;
            appendedPageIndex = firstNonEmptyPageIndex;
            appendedPage = this.pages.get(firstNonEmptyPageIndex);
            appendedLocalIndex = 0;
        } else if (pageIndex == CollectionsKt.getLastIndex(this.pages) && index > CollectionsKt.getLastIndex(((PagingSource.LoadResult.Page)CollectionsKt.last(this.pages)).getData())) {
            appendComplete = true;
            prependedPageIndex = lastNonEmptyPageIndex;
            prependedPage = this.pages.get(lastNonEmptyPageIndex);
            prependedLocalIndex = CollectionsKt.getLastIndex(prependedPage.getData());
        } else {
            prependedPageIndex = pageIndex;
            prependedPage = this.pages.get(pageIndex);
            prependedLocalIndex = index;
            appendedPageIndex = pageIndex;
            appendedPage = this.pages.get(pageIndex);
            appendedLocalIndex = index;
        }
        while (!prependComplete || !appendComplete) {
            if (!prependComplete) {
                while (prependedLocalIndex < 0 && --prependedPageIndex >= 0) {
                    prependedPage = this.pages.get(prependedPageIndex);
                    prependedLocalIndex = CollectionsKt.getLastIndex(prependedPage.getData());
                }
                if (prependedPageIndex < 0) {
                    prependComplete = true;
                } else {
                    PagingSource.LoadResult.Page<Key, Value> page = prependedPage;
                    Intrinsics.checkNotNull(page);
                    Value prevItem = page.getData().get(prependedLocalIndex);
                    if (((Boolean)predicate.invoke(prevItem)).booleanValue()) {
                        return prevItem;
                    }
                    --prependedLocalIndex;
                }
            }
            if (appendComplete) continue;
            while (true) {
                PagingSource.LoadResult.Page<Key, Value> page = appendedPage;
                Intrinsics.checkNotNull(page);
                if (appendedLocalIndex <= CollectionsKt.getLastIndex(page.getData()) || ++appendedPageIndex > CollectionsKt.getLastIndex(this.pages)) break;
                appendedPage = this.pages.get(appendedPageIndex);
                appendedLocalIndex = appendedPage.getData().isEmpty() ? Integer.MAX_VALUE : 0;
            }
            if (appendedPageIndex > CollectionsKt.getLastIndex(this.pages)) {
                appendComplete = true;
                continue;
            }
            Value nextItem = appendedPage.getData().get(appendedLocalIndex);
            if (((Boolean)predicate.invoke(nextItem)).booleanValue()) {
                return nextItem;
            }
            ++appendedLocalIndex;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PagingSource.LoadResult.Page<Key, Value> closestPageToPosition(int anchorPosition) {
        void index;
        int index$iv;
        void this_$iv;
        int n;
        boolean bl;
        Object $this$all$iv;
        block5: {
            $this$all$iv = this.pages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                    n = 0;
                    if (it.getData().isEmpty()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        $this$all$iv = this;
        int anchorPosition$iv = anchorPosition;
        boolean $i$f$anchorPositionToPagedIndices$paging_common = false;
        int pageIndex$iv = 0;
        for (index$iv = anchorPosition$iv - ((PagingState)this_$iv).leadingPlaceholderCount; pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
        }
        n = index$iv;
        int pageIndex = pageIndex$iv;
        boolean bl2 = false;
        return index < 0 ? (PagingSource.LoadResult.Page<Key, Value>)CollectionsKt.first(this.pages) : this.pages.get(pageIndex);
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.pages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                    boolean bl2 = false;
                    if (it.getData().isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public final Value firstItemOrNull() {
        Iterable iterable;
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = this.pages;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PagingSource.LoadResult.Page it = (PagingSource.LoadResult.Page)element$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getData()).isEmpty();
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return (Value)((iterable = (PagingSource.LoadResult.Page)v1) != null && (iterable = iterable.getData()) != null ? CollectionsKt.firstOrNull((List)iterable) : null);
    }

    @Nullable
    public final Value lastItemOrNull() {
        Iterable iterable;
        PagingSource.LoadResult.Page<Key, Value> page;
        block1: {
            List<PagingSource.LoadResult.Page<Key, Value>> $this$lastOrNull$iv = this.pages;
            boolean $i$f$lastOrNull = false;
            ListIterator<PagingSource.LoadResult.Page<Key, Value>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                PagingSource.LoadResult.Page<Key, Value> element$iv;
                PagingSource.LoadResult.Page<Key, Value> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                boolean bl2 = !((Collection)it.getData()).isEmpty();
                if (!bl2) continue;
                page = element$iv;
                break block1;
            }
            page = null;
        }
        return (Value)((iterable = (PagingSource.LoadResult.Page)page) != null && (iterable = iterable.getData()) != null ? CollectionsKt.lastOrNull((List)iterable) : null);
    }

    @NotNull
    public String toString() {
        return "PagingState(pages=" + this.pages + ", anchorPosition=" + this.anchorPosition + ", config=" + this.config + ", leadingPlaceholderCount=" + this.leadingPlaceholderCount + ")";
    }

    public final <T> T anchorPositionToPagedIndices$paging_common(int anchorPosition, @NotNull Function2<? super Integer, ? super Integer, ? extends T> block) {
        int index;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$anchorPositionToPagedIndices$paging_common = false;
        int pageIndex = 0;
        for (index = anchorPosition - this.leadingPlaceholderCount; pageIndex < CollectionsKt.getLastIndex(this.getPages()) && index > CollectionsKt.getLastIndex(this.getPages().get(pageIndex).getData()); index -= this.getPages().get(pageIndex).getData().size(), ++pageIndex) {
        }
        return (T)block.invoke((Object)pageIndex, (Object)index);
    }
}

