/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u000bH'J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\rH\u00a7@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "", "<init>", "()V", "upsertList", "", "neighborCacheEntryList", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCacheEntry;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "allEntriesAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findAvailableEntries", "", "urlHashes", "findAvailableNeighborsByUrlHash", "Lcom/ustadmobile/libcache/db/composites/NeighborCacheEntryAndNeighborCache;", "urlHash", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respect-lib-cache_release"})
@Dao
public abstract class NeighborCacheEntryDao {
    @Insert(onConflict=1)
    @Nullable
    public abstract Object upsertList(@NotNull List<NeighborCacheEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ")
    @NotNull
    public abstract Flow<List<NeighborCacheEntry>> allEntriesAsFlow();

    @Query(value="\n        SELECT NeighborCacheEntry.nceUrlHash\n          FROM NeighborCacheEntry\n         WHERE NeighborCacheEntry.nceUrlHash IN (:urlHashes) \n    ")
    @Nullable
    public abstract Object findAvailableEntries(@NotNull List<Long> var1, @NotNull Continuation<? super List<Long>> var2);

    @Query(value="\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = :urlHash\n           AND NeighborCache.neighborStatus = 1\n    ")
    @Nullable
    public abstract Object findAvailableNeighborsByUrlHash(long var1, @NotNull Continuation<? super List<NeighborCacheEntryAndNeighborCache>> var3);
}

