/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2BitReader;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.DecompressionException;

final class Bzip2HuffmanStageDecoder {
    private final Bzip2BitReader reader;
    byte[] selectors;
    private final int[] minimumLengths;
    private final int[][] codeBases;
    private final int[][] codeLimits;
    private final int[][] codeSymbols;
    private int currentTable;
    private int groupIndex = -1;
    private int groupPosition = -1;
    final int totalTables;
    final int alphabetSize;
    final Bzip2MoveToFrontTable tableMTF = new Bzip2MoveToFrontTable();
    int currentSelector;
    final byte[][] tableCodeLengths;
    int currentGroup;
    int currentLength = -1;
    int currentAlpha;
    boolean modifyLength;

    Bzip2HuffmanStageDecoder(Bzip2BitReader reader2, int totalTables, int alphabetSize) {
        this.reader = reader2;
        this.totalTables = totalTables;
        this.alphabetSize = alphabetSize;
        this.minimumLengths = new int[totalTables];
        this.codeBases = new int[totalTables][25];
        this.codeLimits = new int[totalTables][24];
        this.codeSymbols = new int[totalTables][258];
        this.tableCodeLengths = new byte[totalTables][258];
    }

    void createHuffmanDecodingTables() {
        int alphabetSize = this.alphabetSize;
        for (int table2 = 0; table2 < this.tableCodeLengths.length; ++table2) {
            int i2;
            int[] tableBases = this.codeBases[table2];
            int[] tableLimits = this.codeLimits[table2];
            int[] tableSymbols = this.codeSymbols[table2];
            byte[] codeLengths = this.tableCodeLengths[table2];
            int minimumLength = 23;
            int maximumLength = 0;
            for (i2 = 0; i2 < alphabetSize; ++i2) {
                byte currLength = codeLengths[i2];
                maximumLength = Math.max(currLength, maximumLength);
                minimumLength = Math.min(currLength, minimumLength);
            }
            this.minimumLengths[table2] = minimumLength;
            for (i2 = 0; i2 < alphabetSize; ++i2) {
                int n = codeLengths[i2] + 1;
                tableBases[n] = tableBases[n] + 1;
            }
            int b2 = tableBases[0];
            for (i2 = 1; i2 < 25; ++i2) {
                tableBases[i2] = b2 += tableBases[i2];
            }
            int code2 = 0;
            for (i2 = minimumLength; i2 <= maximumLength; ++i2) {
                int base2 = code2;
                tableBases[i2] = base2 - tableBases[i2];
                tableLimits[i2] = (code2 += tableBases[i2 + 1] - tableBases[i2]) - 1;
                code2 <<= 1;
            }
            int codeIndex = 0;
            for (int bitLength = minimumLength; bitLength <= maximumLength; ++bitLength) {
                for (int symbol = 0; symbol < alphabetSize; ++symbol) {
                    if (codeLengths[symbol] != bitLength) continue;
                    tableSymbols[codeIndex++] = symbol;
                }
            }
        }
        this.currentTable = this.selectors[0];
    }

    int nextSymbol() {
        int codeLength;
        if (++this.groupPosition % 50 == 0) {
            ++this.groupIndex;
            if (this.groupIndex == this.selectors.length) {
                throw new DecompressionException("error decoding block");
            }
            this.currentTable = this.selectors[this.groupIndex] & 0xFF;
        }
        Bzip2BitReader reader2 = this.reader;
        int currentTable = this.currentTable;
        int[] tableLimits = this.codeLimits[currentTable];
        int[] tableBases = this.codeBases[currentTable];
        int[] tableSymbols = this.codeSymbols[currentTable];
        int codeBits = reader2.readBits(codeLength);
        for (codeLength = this.minimumLengths[currentTable]; codeLength <= 23; ++codeLength) {
            if (codeBits <= tableLimits[codeLength]) {
                return tableSymbols[codeBits - tableBases[codeLength]];
            }
            codeBits = codeBits << 1 | reader2.readBits(1);
        }
        throw new DecompressionException("a valid code was not recognised");
    }
}

