package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.SchoolPermissionGrantEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.PersonRoleEnum
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolPermissionGrantDao_Impl(
  __db: RoomDatabase,
) : SchoolPermissionGrantDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolPermissionGrantEntity:
      EntityInsertAdapter<SchoolPermissionGrantEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolPermissionGrantEntity = object : EntityInsertAdapter<SchoolPermissionGrantEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `SchoolPermissionGrantEntity` (`spgUid`,`spgUidNum`,`spgStatusEnum`,`spgToRole`,`spgPermissions`,`spgLastModified`,`spgStored`) VALUES (?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolPermissionGrantEntity) {
        statement.bindText(1, entity.spgUid)
        statement.bindLong(2, entity.spgUidNum)
        val _tmp: Int = __schoolTypeConverters.fromStatusEnum(entity.spgStatusEnum)
        statement.bindLong(3, _tmp.toLong())
        val _tmp_1: Int = __schoolTypeConverters.fromPersonRoleType(entity.spgToRole)
        statement.bindLong(4, _tmp_1.toLong())
        statement.bindLong(5, entity.spgPermissions)
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.spgLastModified)
        if (_tmp_2 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_2)
        }
        val _tmp_3: Long? = __sharedConverters.fromInstant(entity.spgStored)
        if (_tmp_3 == null) {
          statement.bindNull(7)
        } else {
          statement.bindLong(7, _tmp_3)
        }
      }
    }
  }

  public override suspend fun upsert(entities: List<SchoolPermissionGrantEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolPermissionGrantEntity.insert(_connection, entities)
  }

  public override suspend fun list(authenticatedPersonUidNum: Long, uidNum: Long): List<SchoolPermissionGrantEntity> {
    val _sql: String = """
        |
        |          WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        
        |        SELECT SchoolPermissionGrantEntity.*
        |          FROM SchoolPermissionGrantEntity
        |         WHERE (? = 0 OR SchoolPermissionGrantEntity.spgUidNum = ?)
        |           AND (SchoolPermissionGrantEntity.spgToRole IN 
        |                (SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                        (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )))
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, uidNum)
        _argIndex = 5
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfSpgUid: Int = getColumnIndexOrThrow(_stmt, "spgUid")
        val _columnIndexOfSpgUidNum: Int = getColumnIndexOrThrow(_stmt, "spgUidNum")
        val _columnIndexOfSpgStatusEnum: Int = getColumnIndexOrThrow(_stmt, "spgStatusEnum")
        val _columnIndexOfSpgToRole: Int = getColumnIndexOrThrow(_stmt, "spgToRole")
        val _columnIndexOfSpgPermissions: Int = getColumnIndexOrThrow(_stmt, "spgPermissions")
        val _columnIndexOfSpgLastModified: Int = getColumnIndexOrThrow(_stmt, "spgLastModified")
        val _columnIndexOfSpgStored: Int = getColumnIndexOrThrow(_stmt, "spgStored")
        val _result: MutableList<SchoolPermissionGrantEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: SchoolPermissionGrantEntity
          val _tmpSpgUid: String
          _tmpSpgUid = _stmt.getText(_columnIndexOfSpgUid)
          val _tmpSpgUidNum: Long
          _tmpSpgUidNum = _stmt.getLong(_columnIndexOfSpgUidNum)
          val _tmpSpgStatusEnum: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfSpgStatusEnum).toInt()
          _tmpSpgStatusEnum = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpSpgToRole: PersonRoleEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfSpgToRole).toInt()
          _tmpSpgToRole = __schoolTypeConverters.toPersonRoleType(_tmp_1)
          val _tmpSpgPermissions: Long
          _tmpSpgPermissions = _stmt.getLong(_columnIndexOfSpgPermissions)
          val _tmpSpgLastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfSpgLastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfSpgLastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgLastModified = _tmp_3
          }
          val _tmpSpgStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSpgStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSpgStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgStored = _tmp_5
          }
          _item = SchoolPermissionGrantEntity(_tmpSpgUid,_tmpSpgUidNum,_tmpSpgStatusEnum,_tmpSpgToRole,_tmpSpgPermissions,_tmpSpgLastModified,_tmpSpgStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun listAsPagingSource(uidNum: Long): PagingSource<Int, SchoolPermissionGrantEntity> {
    val _sql: String = """
        |
        |        SELECT SchoolPermissionGrantEntity.*
        |          FROM SchoolPermissionGrantEntity
        |         WHERE (? = 0 OR SchoolPermissionGrantEntity.spgUidNum = ?)
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, uidNum)
      _argIndex = 2
      _stmt.bindLong(_argIndex, uidNum)
    }
    return object : LimitOffsetPagingSource<SchoolPermissionGrantEntity>(_rawQuery, __db, "SchoolPermissionGrantEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int): List<SchoolPermissionGrantEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfSpgUid: Int = getColumnIndexOrThrow(_stmt, "spgUid")
          val _columnIndexOfSpgUidNum: Int = getColumnIndexOrThrow(_stmt, "spgUidNum")
          val _columnIndexOfSpgStatusEnum: Int = getColumnIndexOrThrow(_stmt, "spgStatusEnum")
          val _columnIndexOfSpgToRole: Int = getColumnIndexOrThrow(_stmt, "spgToRole")
          val _columnIndexOfSpgPermissions: Int = getColumnIndexOrThrow(_stmt, "spgPermissions")
          val _columnIndexOfSpgLastModified: Int = getColumnIndexOrThrow(_stmt, "spgLastModified")
          val _columnIndexOfSpgStored: Int = getColumnIndexOrThrow(_stmt, "spgStored")
          val _result: MutableList<SchoolPermissionGrantEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: SchoolPermissionGrantEntity
            val _tmpSpgUid: String
            _tmpSpgUid = _stmt.getText(_columnIndexOfSpgUid)
            val _tmpSpgUidNum: Long
            _tmpSpgUidNum = _stmt.getLong(_columnIndexOfSpgUidNum)
            val _tmpSpgStatusEnum: StatusEnum
            val _tmp: Int
            _tmp = _stmt.getLong(_columnIndexOfSpgStatusEnum).toInt()
            _tmpSpgStatusEnum = __schoolTypeConverters.toStatusEnum(_tmp)
            val _tmpSpgToRole: PersonRoleEnum
            val _tmp_1: Int
            _tmp_1 = _stmt.getLong(_columnIndexOfSpgToRole).toInt()
            _tmpSpgToRole = __schoolTypeConverters.toPersonRoleType(_tmp_1)
            val _tmpSpgPermissions: Long
            _tmpSpgPermissions = _stmt.getLong(_columnIndexOfSpgPermissions)
            val _tmpSpgLastModified: Instant
            val _tmp_2: Long?
            if (_stmt.isNull(_columnIndexOfSpgLastModified)) {
              _tmp_2 = null
            } else {
              _tmp_2 = _stmt.getLong(_columnIndexOfSpgLastModified)
            }
            val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
            if (_tmp_3 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpSpgLastModified = _tmp_3
            }
            val _tmpSpgStored: Instant
            val _tmp_4: Long?
            if (_stmt.isNull(_columnIndexOfSpgStored)) {
              _tmp_4 = null
            } else {
              _tmp_4 = _stmt.getLong(_columnIndexOfSpgStored)
            }
            val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
            if (_tmp_5 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpSpgStored = _tmp_5
            }
            _item = SchoolPermissionGrantEntity(_tmpSpgUid,_tmpSpgUidNum,_tmpSpgStatusEnum,_tmpSpgToRole,_tmpSpgPermissions,_tmpSpgLastModified,_tmpSpgStored)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT SchoolPermissionGrantEntity.spgLastModified
        |          FROM SchoolPermissionGrantEntity
        |         WHERE SchoolPermissionGrantEntity.spgUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNum(uidNum: Long): SchoolPermissionGrantEntity? {
    val _sql: String = """
        |
        |        SELECT SchoolPermissionGrantEntity.*
        |          FROM SchoolPermissionGrantEntity
        |         WHERE SchoolPermissionGrantEntity.spgUidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfSpgUid: Int = getColumnIndexOrThrow(_stmt, "spgUid")
        val _columnIndexOfSpgUidNum: Int = getColumnIndexOrThrow(_stmt, "spgUidNum")
        val _columnIndexOfSpgStatusEnum: Int = getColumnIndexOrThrow(_stmt, "spgStatusEnum")
        val _columnIndexOfSpgToRole: Int = getColumnIndexOrThrow(_stmt, "spgToRole")
        val _columnIndexOfSpgPermissions: Int = getColumnIndexOrThrow(_stmt, "spgPermissions")
        val _columnIndexOfSpgLastModified: Int = getColumnIndexOrThrow(_stmt, "spgLastModified")
        val _columnIndexOfSpgStored: Int = getColumnIndexOrThrow(_stmt, "spgStored")
        val _result: SchoolPermissionGrantEntity?
        if (_stmt.step()) {
          val _tmpSpgUid: String
          _tmpSpgUid = _stmt.getText(_columnIndexOfSpgUid)
          val _tmpSpgUidNum: Long
          _tmpSpgUidNum = _stmt.getLong(_columnIndexOfSpgUidNum)
          val _tmpSpgStatusEnum: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfSpgStatusEnum).toInt()
          _tmpSpgStatusEnum = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpSpgToRole: PersonRoleEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfSpgToRole).toInt()
          _tmpSpgToRole = __schoolTypeConverters.toPersonRoleType(_tmp_1)
          val _tmpSpgPermissions: Long
          _tmpSpgPermissions = _stmt.getLong(_columnIndexOfSpgPermissions)
          val _tmpSpgLastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfSpgLastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfSpgLastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgLastModified = _tmp_3
          }
          val _tmpSpgStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSpgStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSpgStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgStored = _tmp_5
          }
          _result = SchoolPermissionGrantEntity(_tmpSpgUid,_tmpSpgUidNum,_tmpSpgStatusEnum,_tmpSpgToRole,_tmpSpgPermissions,_tmpSpgLastModified,_tmpSpgStored)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByUidNumAsFlow(uidNum: Long): Flow<SchoolPermissionGrantEntity?> {
    val _sql: String = """
        |
        |        SELECT SchoolPermissionGrantEntity.*
        |          FROM SchoolPermissionGrantEntity
        |         WHERE SchoolPermissionGrantEntity.spgUidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("SchoolPermissionGrantEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfSpgUid: Int = getColumnIndexOrThrow(_stmt, "spgUid")
        val _columnIndexOfSpgUidNum: Int = getColumnIndexOrThrow(_stmt, "spgUidNum")
        val _columnIndexOfSpgStatusEnum: Int = getColumnIndexOrThrow(_stmt, "spgStatusEnum")
        val _columnIndexOfSpgToRole: Int = getColumnIndexOrThrow(_stmt, "spgToRole")
        val _columnIndexOfSpgPermissions: Int = getColumnIndexOrThrow(_stmt, "spgPermissions")
        val _columnIndexOfSpgLastModified: Int = getColumnIndexOrThrow(_stmt, "spgLastModified")
        val _columnIndexOfSpgStored: Int = getColumnIndexOrThrow(_stmt, "spgStored")
        val _result: SchoolPermissionGrantEntity?
        if (_stmt.step()) {
          val _tmpSpgUid: String
          _tmpSpgUid = _stmt.getText(_columnIndexOfSpgUid)
          val _tmpSpgUidNum: Long
          _tmpSpgUidNum = _stmt.getLong(_columnIndexOfSpgUidNum)
          val _tmpSpgStatusEnum: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfSpgStatusEnum).toInt()
          _tmpSpgStatusEnum = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpSpgToRole: PersonRoleEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfSpgToRole).toInt()
          _tmpSpgToRole = __schoolTypeConverters.toPersonRoleType(_tmp_1)
          val _tmpSpgPermissions: Long
          _tmpSpgPermissions = _stmt.getLong(_columnIndexOfSpgPermissions)
          val _tmpSpgLastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfSpgLastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfSpgLastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgLastModified = _tmp_3
          }
          val _tmpSpgStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSpgStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSpgStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgStored = _tmp_5
          }
          _result = SchoolPermissionGrantEntity(_tmpSpgUid,_tmpSpgUidNum,_tmpSpgStatusEnum,_tmpSpgToRole,_tmpSpgPermissions,_tmpSpgLastModified,_tmpSpgStored)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidNums(uidNums: List<Long>): List<SchoolPermissionGrantEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT SchoolPermissionGrantEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM SchoolPermissionGrantEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE SchoolPermissionGrantEntity.spgUidNum IN (")
    val _inputSize: Int = uidNums.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uidNums) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfSpgUid: Int = getColumnIndexOrThrow(_stmt, "spgUid")
        val _columnIndexOfSpgUidNum: Int = getColumnIndexOrThrow(_stmt, "spgUidNum")
        val _columnIndexOfSpgStatusEnum: Int = getColumnIndexOrThrow(_stmt, "spgStatusEnum")
        val _columnIndexOfSpgToRole: Int = getColumnIndexOrThrow(_stmt, "spgToRole")
        val _columnIndexOfSpgPermissions: Int = getColumnIndexOrThrow(_stmt, "spgPermissions")
        val _columnIndexOfSpgLastModified: Int = getColumnIndexOrThrow(_stmt, "spgLastModified")
        val _columnIndexOfSpgStored: Int = getColumnIndexOrThrow(_stmt, "spgStored")
        val _result: MutableList<SchoolPermissionGrantEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: SchoolPermissionGrantEntity
          val _tmpSpgUid: String
          _tmpSpgUid = _stmt.getText(_columnIndexOfSpgUid)
          val _tmpSpgUidNum: Long
          _tmpSpgUidNum = _stmt.getLong(_columnIndexOfSpgUidNum)
          val _tmpSpgStatusEnum: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfSpgStatusEnum).toInt()
          _tmpSpgStatusEnum = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpSpgToRole: PersonRoleEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfSpgToRole).toInt()
          _tmpSpgToRole = __schoolTypeConverters.toPersonRoleType(_tmp_1)
          val _tmpSpgPermissions: Long
          _tmpSpgPermissions = _stmt.getLong(_columnIndexOfSpgPermissions)
          val _tmpSpgLastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfSpgLastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfSpgLastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgLastModified = _tmp_3
          }
          val _tmpSpgStored: Instant
          val _tmp_4: Long?
          if (_stmt.isNull(_columnIndexOfSpgStored)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getLong(_columnIndexOfSpgStored)
          }
          val _tmp_5: Instant? = __sharedConverters.toInstant(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpSpgStored = _tmp_5
          }
          _item_1 = SchoolPermissionGrantEntity(_tmpSpgUid,_tmpSpgUidNum,_tmpSpgStatusEnum,_tmpSpgToRole,_tmpSpgPermissions,_tmpSpgLastModified,_tmpSpgStored)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun personHasPermission(authenticatedPersonUidNum: Long, permissionFlag: Long): Boolean {
    val _sql: String = """
        |
        |        SELECT EXISTS(
        |               SELECT 1
        |                 FROM SchoolPermissionGrantEntity
        |                WHERE SchoolPermissionGrantEntity.spgToRole IN (
        |                      SELECT PersonRoleEntity.prRoleEnum
        |                        FROM PersonRoleEntity
        |                       WHERE PersonRoleEntity.prPersonGuidHash = ?) 
        |                  AND (SchoolPermissionGrantEntity.spgPermissions & ?) = ?)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, permissionFlag)
        _argIndex = 3
        _stmt.bindLong(_argIndex, permissionFlag)
        val _result: Boolean
        if (_stmt.step()) {
          val _tmp: Int
          _tmp = _stmt.getLong(0).toInt()
          _result = _tmp != 0
        } else {
          _result = false
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
