/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.ApplyDefaultsStrategy;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.JsonSchemaIdValidator;
import com.networknt.schema.PathType;
import com.networknt.schema.i18n.DefaultMessageSource;
import com.networknt.schema.i18n.MessageSource;
import com.networknt.schema.regex.ECMAScriptRegularExpressionFactory;
import com.networknt.schema.regex.JDKRegularExpressionFactory;
import com.networknt.schema.regex.RegularExpressionFactory;
import com.networknt.schema.walk.DefaultItemWalkListenerRunner;
import com.networknt.schema.walk.DefaultKeywordWalkListenerRunner;
import com.networknt.schema.walk.DefaultPropertyWalkListenerRunner;
import com.networknt.schema.walk.JsonSchemaWalkListener;
import com.networknt.schema.walk.WalkListenerRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SchemaValidatorsConfig {
    public static final String ALL_KEYWORD_WALK_LISTENER_KEY = "com.networknt.AllKeywordWalkListener";
    public static final int DEFAULT_PRELOAD_JSON_SCHEMA_REF_MAX_NESTING_DEPTH = 40;
    private ApplyDefaultsStrategy applyDefaultsStrategy = ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
    private boolean cacheRefs = true;
    private String errorMessageKeyword = "message";
    private ExecutionContextCustomizer executionContextCustomizer;
    private boolean failFast;
    private Boolean formatAssertionsEnabled = null;
    private boolean nullableKeywordEnabled = true;
    private final WalkListenerRunner itemWalkListenerRunner;
    private final List<JsonSchemaWalkListener> itemWalkListeners;
    private boolean javaSemantics;
    private final WalkListenerRunner keywordWalkListenerRunner;
    private final Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;
    private Locale locale;
    private boolean losslessNarrowing;
    private MessageSource messageSource;
    private boolean discriminatorKeywordEnabled = false;
    private PathType pathType = PathType.DEFAULT;
    private boolean preloadJsonSchema = true;
    private int preloadJsonSchemaRefMaxNestingDepth = 40;
    private final WalkListenerRunner propertyWalkListenerRunner;
    private final List<JsonSchemaWalkListener> propertyWalkListeners;
    private Boolean readOnly = null;
    private RegularExpressionFactory regularExpressionFactory = JDKRegularExpressionFactory.getInstance();
    private JsonSchemaIdValidator schemaIdValidator = JsonSchemaIdValidator.DEFAULT;
    private final Map<String, Boolean> strictness;
    private boolean typeLoose;
    private Boolean writeOnly = null;
    @Deprecated
    private boolean loadCollectors = true;

    @Deprecated
    public SchemaValidatorsConfig() {
        this.strictness = new HashMap<String, Boolean>(0);
        this.keywordWalkListenersMap = new HashMap<String, List<JsonSchemaWalkListener>>();
        this.propertyWalkListeners = new ArrayList<JsonSchemaWalkListener>();
        this.itemWalkListeners = new ArrayList<JsonSchemaWalkListener>();
        this.itemWalkListenerRunner = new DefaultItemWalkListenerRunner(this.getArrayItemWalkListeners());
        this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.getKeywordWalkListenersMap());
        this.propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.getPropertyWalkListeners());
    }

    SchemaValidatorsConfig(ApplyDefaultsStrategy applyDefaultsStrategy, boolean cacheRefs, String errorMessageKeyword, ExecutionContextCustomizer executionContextCustomizer, boolean failFast, Boolean formatAssertionsEnabled, boolean nullableKeywordEnabled, List<JsonSchemaWalkListener> itemWalkListeners, boolean javaSemantics, Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap, Locale locale, boolean losslessNarrowing, MessageSource messageSource, boolean discriminatorKeywordEnabled, PathType pathType, boolean preloadJsonSchema, int preloadJsonSchemaRefMaxNestingDepth, List<JsonSchemaWalkListener> propertyWalkListeners, Boolean readOnly, RegularExpressionFactory regularExpressionFactory, JsonSchemaIdValidator schemaIdValidator, Map<String, Boolean> strictness, boolean typeLoose, Boolean writeOnly) {
        this.applyDefaultsStrategy = applyDefaultsStrategy;
        this.cacheRefs = cacheRefs;
        this.errorMessageKeyword = errorMessageKeyword;
        this.executionContextCustomizer = executionContextCustomizer;
        this.failFast = failFast;
        this.formatAssertionsEnabled = formatAssertionsEnabled;
        this.nullableKeywordEnabled = nullableKeywordEnabled;
        this.itemWalkListeners = itemWalkListeners;
        this.javaSemantics = javaSemantics;
        this.keywordWalkListenersMap = keywordWalkListenersMap;
        this.locale = locale;
        this.losslessNarrowing = losslessNarrowing;
        this.messageSource = messageSource;
        this.discriminatorKeywordEnabled = discriminatorKeywordEnabled;
        this.pathType = pathType;
        this.preloadJsonSchema = preloadJsonSchema;
        this.preloadJsonSchemaRefMaxNestingDepth = preloadJsonSchemaRefMaxNestingDepth;
        this.propertyWalkListeners = propertyWalkListeners;
        this.readOnly = readOnly;
        this.regularExpressionFactory = regularExpressionFactory;
        this.schemaIdValidator = schemaIdValidator;
        this.strictness = strictness;
        this.typeLoose = typeLoose;
        this.writeOnly = writeOnly;
        this.itemWalkListenerRunner = new DefaultItemWalkListenerRunner(this.getArrayItemWalkListeners());
        this.keywordWalkListenerRunner = new DefaultKeywordWalkListenerRunner(this.getKeywordWalkListenersMap());
        this.propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.getPropertyWalkListeners());
    }

    public void addItemWalkListener(JsonSchemaWalkListener itemWalkListener) {
        this.itemWalkListeners.add(itemWalkListener);
    }

    public void addItemWalkListeners(List<JsonSchemaWalkListener> itemWalkListeners) {
        this.itemWalkListeners.addAll(itemWalkListeners);
    }

    public void addKeywordWalkListener(JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).add(keywordWalkListener);
    }

    public void addKeywordWalkListener(String keyword, JsonSchemaWalkListener keywordWalkListener) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList keywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, keywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).add(keywordWalkListener);
    }

    public void addKeywordWalkListeners(List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(ALL_KEYWORD_WALK_LISTENER_KEY, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(ALL_KEYWORD_WALK_LISTENER_KEY).addAll(keywordWalkListeners);
    }

    public void addKeywordWalkListeners(String keyword, List<JsonSchemaWalkListener> keywordWalkListeners) {
        if (this.keywordWalkListenersMap.get(keyword) == null) {
            ArrayList ikeywordWalkListeners = new ArrayList();
            this.keywordWalkListenersMap.put(keyword, ikeywordWalkListeners);
        }
        this.keywordWalkListenersMap.get(keyword).addAll(keywordWalkListeners);
    }

    public void addPropertyWalkListener(JsonSchemaWalkListener propertyWalkListener) {
        this.propertyWalkListeners.add(propertyWalkListener);
    }

    public void addPropertyWalkListeners(List<JsonSchemaWalkListener> propertyWalkListeners) {
        this.propertyWalkListeners.addAll(propertyWalkListeners);
    }

    public ApplyDefaultsStrategy getApplyDefaultsStrategy() {
        return this.applyDefaultsStrategy;
    }

    public List<JsonSchemaWalkListener> getArrayItemWalkListeners() {
        return this.itemWalkListeners;
    }

    public ExecutionContextCustomizer getExecutionContextCustomizer() {
        return this.executionContextCustomizer;
    }

    public Boolean getFormatAssertionsEnabled() {
        return this.formatAssertionsEnabled;
    }

    WalkListenerRunner getItemWalkListenerRunner() {
        return this.itemWalkListenerRunner;
    }

    WalkListenerRunner getKeywordWalkListenerRunner() {
        return this.keywordWalkListenerRunner;
    }

    public Map<String, List<JsonSchemaWalkListener>> getKeywordWalkListenersMap() {
        return this.keywordWalkListenersMap;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            return DefaultMessageSource.getInstance();
        }
        return this.messageSource;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public int getPreloadJsonSchemaRefMaxNestingDepth() {
        return this.preloadJsonSchemaRefMaxNestingDepth;
    }

    WalkListenerRunner getPropertyWalkListenerRunner() {
        return this.propertyWalkListenerRunner;
    }

    public List<JsonSchemaWalkListener> getPropertyWalkListeners() {
        return this.propertyWalkListeners;
    }

    public RegularExpressionFactory getRegularExpressionFactory() {
        return this.regularExpressionFactory;
    }

    public JsonSchemaIdValidator getSchemaIdValidator() {
        return this.schemaIdValidator;
    }

    public boolean isCacheRefs() {
        return this.cacheRefs;
    }

    @Deprecated
    public boolean isCustomMessageSupported() {
        return this.errorMessageKeyword != null;
    }

    public String getErrorMessageKeyword() {
        return this.errorMessageKeyword;
    }

    public boolean isEcma262Validator() {
        return !(this.regularExpressionFactory instanceof JDKRegularExpressionFactory);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    @Deprecated
    public boolean isHandleNullableField() {
        return this.isNullableKeywordEnabled();
    }

    public boolean isNullableKeywordEnabled() {
        return this.nullableKeywordEnabled;
    }

    public boolean isJavaSemantics() {
        return this.javaSemantics;
    }

    public boolean isLosslessNarrowing() {
        return this.losslessNarrowing;
    }

    @Deprecated
    public boolean isOpenAPI3StyleDiscriminators() {
        return this.isDiscriminatorKeywordEnabled();
    }

    public boolean isDiscriminatorKeywordEnabled() {
        return this.discriminatorKeywordEnabled;
    }

    public boolean isPreloadJsonSchema() {
        return this.preloadJsonSchema;
    }

    public boolean isReadOnly() {
        return null != this.readOnly && this.readOnly != false;
    }

    Boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean isStrict(String keyword) {
        return this.isStrict(keyword, Boolean.TRUE);
    }

    public boolean isStrict(String keyword, Boolean defaultValue) {
        return this.strictness.getOrDefault(Objects.requireNonNull(keyword, "keyword cannot be null"), defaultValue);
    }

    public boolean isTypeLoose() {
        return this.typeLoose;
    }

    public boolean isWriteOnly() {
        return null != this.writeOnly && this.writeOnly != false;
    }

    Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public void setApplyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
        this.applyDefaultsStrategy = applyDefaultsStrategy != null ? applyDefaultsStrategy : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
    }

    public void setCacheRefs(boolean cacheRefs) {
        this.cacheRefs = cacheRefs;
    }

    @Deprecated
    public void setCustomMessageSupported(boolean customMessageSupported) {
        this.errorMessageKeyword = customMessageSupported ? "message" : null;
    }

    public void setEcma262Validator(boolean ecma262Validator) {
        this.regularExpressionFactory = ecma262Validator ? ECMAScriptRegularExpressionFactory.getInstance() : JDKRegularExpressionFactory.getInstance();
    }

    public void setExecutionContextCustomizer(ExecutionContextCustomizer executionContextCustomizer) {
        this.executionContextCustomizer = executionContextCustomizer;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Deprecated
    public void setFormatAssertionsEnabled(Boolean formatAssertionsEnabled) {
        this.formatAssertionsEnabled = formatAssertionsEnabled;
    }

    public void setHandleNullableField(boolean handleNullableField) {
        this.nullableKeywordEnabled = handleNullableField;
    }

    public void setJavaSemantics(boolean javaSemantics) {
        this.javaSemantics = javaSemantics;
    }

    @Deprecated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLosslessNarrowing(boolean losslessNarrowing) {
        this.losslessNarrowing = losslessNarrowing;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setOpenAPI3StyleDiscriminators(boolean openAPI3StyleDiscriminators) {
        this.discriminatorKeywordEnabled = openAPI3StyleDiscriminators;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public void setPreloadJsonSchema(boolean preloadJsonSchema) {
        this.preloadJsonSchema = preloadJsonSchema;
    }

    public void setPreloadJsonSchemaRefMaxNestingDepth(int preloadJsonSchemaRefMaxNestingDepth) {
        this.preloadJsonSchemaRefMaxNestingDepth = preloadJsonSchemaRefMaxNestingDepth;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRegularExpressionFactory(RegularExpressionFactory regularExpressionFactory) {
        this.regularExpressionFactory = regularExpressionFactory;
    }

    public void setSchemaIdValidator(JsonSchemaIdValidator schemaIdValidator) {
        this.schemaIdValidator = schemaIdValidator;
    }

    public void setStrict(String keyword, boolean strict) {
        this.strictness.put(Objects.requireNonNull(keyword, "keyword cannot be null"), strict);
    }

    public void setTypeLoose(boolean typeLoose) {
        this.typeLoose = typeLoose;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaValidatorsConfig config2) {
        Builder builder = new Builder();
        builder.applyDefaultsStrategy = config2.applyDefaultsStrategy;
        builder.cacheRefs = config2.cacheRefs;
        builder.errorMessageKeyword = config2.errorMessageKeyword;
        builder.executionContextCustomizer = config2.executionContextCustomizer;
        builder.failFast = config2.failFast;
        builder.formatAssertionsEnabled = config2.formatAssertionsEnabled;
        builder.nullableKeywordEnabled = config2.nullableKeywordEnabled;
        builder.itemWalkListeners = config2.itemWalkListeners;
        builder.javaSemantics = config2.javaSemantics;
        builder.keywordWalkListeners = config2.keywordWalkListenersMap;
        builder.locale = config2.locale;
        builder.losslessNarrowing = config2.losslessNarrowing;
        builder.messageSource = config2.messageSource;
        builder.discriminatorKeywordEnabled = config2.discriminatorKeywordEnabled;
        builder.pathType = config2.pathType;
        builder.preloadJsonSchema = config2.preloadJsonSchema;
        builder.preloadJsonSchemaRefMaxNestingDepth = config2.preloadJsonSchemaRefMaxNestingDepth;
        builder.propertyWalkListeners = config2.propertyWalkListeners;
        builder.readOnly = config2.readOnly;
        builder.regularExpressionFactory = config2.regularExpressionFactory;
        builder.schemaIdValidator = config2.schemaIdValidator;
        builder.strictness = config2.strictness;
        builder.typeLoose = config2.typeLoose;
        builder.writeOnly = config2.writeOnly;
        return builder;
    }

    @Deprecated
    public boolean isWriteMode() {
        return null == this.writeOnly || this.writeOnly != false;
    }

    @Deprecated
    public void setLoadCollectors(boolean loadCollectors) {
        this.loadCollectors = loadCollectors;
    }

    @Deprecated
    public boolean doLoadCollectors() {
        return this.loadCollectors;
    }

    @Deprecated
    public SchemaValidatorsConfig disableUnevaluatedAnalysis() {
        return this;
    }

    @Deprecated
    public SchemaValidatorsConfig disableUnevaluatedItems() {
        return this;
    }

    @Deprecated
    public SchemaValidatorsConfig disableUnevaluatedProperties() {
        return this;
    }

    @Deprecated
    public SchemaValidatorsConfig enableUnevaluatedAnalysis() {
        return this;
    }

    @Deprecated
    public SchemaValidatorsConfig enableUnevaluatedItems() {
        return this;
    }

    @Deprecated
    public SchemaValidatorsConfig enableUnevaluatedProperties() {
        return this;
    }

    @Deprecated
    public boolean isUnevaluatedItemsAnalysisDisabled() {
        return false;
    }

    @Deprecated
    public boolean isUnevaluatedItemsAnalysisEnabled() {
        return !this.isUnevaluatedItemsAnalysisDisabled();
    }

    @Deprecated
    public boolean isUnevaluatedPropertiesAnalysisDisabled() {
        return false;
    }

    @Deprecated
    public boolean isUnevaluatedPropertiesAnalysisEnabled() {
        return !this.isUnevaluatedPropertiesAnalysisDisabled();
    }

    public static class Builder {
        private ApplyDefaultsStrategy applyDefaultsStrategy = ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
        private boolean cacheRefs = true;
        private String errorMessageKeyword = null;
        private ExecutionContextCustomizer executionContextCustomizer = null;
        private boolean failFast = false;
        private Boolean formatAssertionsEnabled = null;
        private boolean nullableKeywordEnabled = false;
        private List<JsonSchemaWalkListener> itemWalkListeners = new ArrayList<JsonSchemaWalkListener>();
        private boolean javaSemantics = false;
        private Map<String, List<JsonSchemaWalkListener>> keywordWalkListeners = new HashMap<String, List<JsonSchemaWalkListener>>();
        private Locale locale = null;
        private boolean losslessNarrowing = false;
        private MessageSource messageSource = null;
        private boolean discriminatorKeywordEnabled = false;
        private PathType pathType = PathType.JSON_POINTER;
        private boolean preloadJsonSchema = true;
        private int preloadJsonSchemaRefMaxNestingDepth = 40;
        private List<JsonSchemaWalkListener> propertyWalkListeners = new ArrayList<JsonSchemaWalkListener>();
        private Boolean readOnly = null;
        private RegularExpressionFactory regularExpressionFactory = JDKRegularExpressionFactory.getInstance();
        private JsonSchemaIdValidator schemaIdValidator = JsonSchemaIdValidator.DEFAULT;
        private Map<String, Boolean> strictness = new HashMap<String, Boolean>(0);
        private boolean typeLoose = false;
        private Boolean writeOnly = null;

        public Builder applyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
            this.applyDefaultsStrategy = applyDefaultsStrategy != null ? applyDefaultsStrategy : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
            return this;
        }

        public Builder cacheRefs(boolean cacheRefs) {
            this.cacheRefs = cacheRefs;
            return this;
        }

        public Builder errorMessageKeyword(String errorMessageKeyword) {
            this.errorMessageKeyword = errorMessageKeyword;
            return this;
        }

        public Builder executionContextCustomizer(ExecutionContextCustomizer executionContextCustomizer) {
            this.executionContextCustomizer = executionContextCustomizer;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder formatAssertionsEnabled(Boolean formatAssertionsEnabled) {
            this.formatAssertionsEnabled = formatAssertionsEnabled;
            return this;
        }

        public Builder nullableKeywordEnabled(boolean nullableKeywordEnabled) {
            this.nullableKeywordEnabled = nullableKeywordEnabled;
            return this;
        }

        public Builder itemWalkListeners(List<JsonSchemaWalkListener> itemWalkListeners) {
            this.itemWalkListeners = itemWalkListeners;
            return this;
        }

        public Builder javaSemantics(boolean javaSemantics) {
            this.javaSemantics = javaSemantics;
            return this;
        }

        public Builder keywordWalkListeners(Map<String, List<JsonSchemaWalkListener>> keywordWalkListeners) {
            this.keywordWalkListeners = keywordWalkListeners;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder losslessNarrowing(boolean losslessNarrowing) {
            this.losslessNarrowing = losslessNarrowing;
            return this;
        }

        public Builder messageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
            return this;
        }

        public Builder discriminatorKeywordEnabled(boolean discriminatorKeywordEnabled) {
            this.discriminatorKeywordEnabled = discriminatorKeywordEnabled;
            return this;
        }

        public Builder pathType(PathType pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder preloadJsonSchema(boolean preloadJsonSchema) {
            this.preloadJsonSchema = preloadJsonSchema;
            return this;
        }

        public Builder preloadJsonSchemaRefMaxNestingDepth(int preloadJsonSchemaRefMaxNestingDepth) {
            this.preloadJsonSchemaRefMaxNestingDepth = preloadJsonSchemaRefMaxNestingDepth;
            return this;
        }

        public Builder propertyWalkListeners(List<JsonSchemaWalkListener> propertyWalkListeners) {
            this.propertyWalkListeners = propertyWalkListeners;
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder regularExpressionFactory(RegularExpressionFactory regularExpressionFactory) {
            this.regularExpressionFactory = regularExpressionFactory;
            return this;
        }

        public Builder schemaIdValidator(JsonSchemaIdValidator schemaIdValidator) {
            this.schemaIdValidator = schemaIdValidator;
            return this;
        }

        public Builder strict(Map<String, Boolean> strict) {
            this.strictness = strict;
            return this;
        }

        public Builder typeLoose(boolean typeLoose) {
            this.typeLoose = typeLoose;
            return this;
        }

        public Builder writeOnly(Boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this;
        }

        public SchemaValidatorsConfig build() {
            return new ImmutableSchemaValidatorsConfig(this.applyDefaultsStrategy, this.cacheRefs, this.errorMessageKeyword, this.executionContextCustomizer, this.failFast, this.formatAssertionsEnabled, this.nullableKeywordEnabled, this.itemWalkListeners, this.javaSemantics, this.keywordWalkListeners, this.locale, this.losslessNarrowing, this.messageSource, this.discriminatorKeywordEnabled, this.pathType, this.preloadJsonSchema, this.preloadJsonSchemaRefMaxNestingDepth, this.propertyWalkListeners, this.readOnly, this.regularExpressionFactory, this.schemaIdValidator, this.strictness, this.typeLoose, this.writeOnly);
        }

        public Builder strict(String keyword, boolean strict) {
            this.strictness.put(Objects.requireNonNull(keyword, "keyword cannot be null"), strict);
            return this;
        }

        public Builder keywordWalkListener(String keyword, JsonSchemaWalkListener keywordWalkListener) {
            this.keywordWalkListeners.computeIfAbsent(keyword, key -> new ArrayList()).add(keywordWalkListener);
            return this;
        }

        public Builder keywordWalkListener(JsonSchemaWalkListener keywordWalkListener) {
            return this.keywordWalkListener(SchemaValidatorsConfig.ALL_KEYWORD_WALK_LISTENER_KEY, keywordWalkListener);
        }

        public Builder keywordWalkListeners(Consumer<Map<String, List<JsonSchemaWalkListener>>> keywordWalkListeners) {
            keywordWalkListeners.accept(this.keywordWalkListeners);
            return this;
        }

        public Builder propertyWalkListener(JsonSchemaWalkListener propertyWalkListener) {
            this.propertyWalkListeners.add(propertyWalkListener);
            return this;
        }

        public Builder propertyWalkListeners(Consumer<List<JsonSchemaWalkListener>> propertyWalkListeners) {
            propertyWalkListeners.accept(this.propertyWalkListeners);
            return this;
        }

        public Builder itemWalkListener(JsonSchemaWalkListener itemWalkListener) {
            this.itemWalkListeners.add(itemWalkListener);
            return this;
        }

        public Builder itemWalkListeners(Consumer<List<JsonSchemaWalkListener>> itemWalkListeners) {
            itemWalkListeners.accept(this.itemWalkListeners);
            return this;
        }
    }

    public static class ImmutableSchemaValidatorsConfig
    extends SchemaValidatorsConfig {
        public ImmutableSchemaValidatorsConfig(ApplyDefaultsStrategy applyDefaultsStrategy, boolean cacheRefs, String errorMessageKeyword, ExecutionContextCustomizer executionContextCustomizer, boolean failFast, Boolean formatAssertionsEnabled, boolean handleNullableField, List<JsonSchemaWalkListener> itemWalkListeners, boolean javaSemantics, Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap, Locale locale, boolean losslessNarrowing, MessageSource messageSource, boolean openAPI3StyleDiscriminators, PathType pathType, boolean preloadJsonSchema, int preloadJsonSchemaRefMaxNestingDepth, List<JsonSchemaWalkListener> propertyWalkListeners, Boolean readOnly, RegularExpressionFactory regularExpressionFactory, JsonSchemaIdValidator schemaIdValidator, Map<String, Boolean> strictness, boolean typeLoose, Boolean writeOnly) {
            super(applyDefaultsStrategy, cacheRefs, errorMessageKeyword, executionContextCustomizer, failFast, formatAssertionsEnabled, handleNullableField, itemWalkListeners, javaSemantics, keywordWalkListenersMap, locale, losslessNarrowing, messageSource, openAPI3StyleDiscriminators, pathType, preloadJsonSchema, preloadJsonSchemaRefMaxNestingDepth, propertyWalkListeners, readOnly, regularExpressionFactory, schemaIdValidator, strictness, typeLoose, writeOnly);
        }

        @Override
        public void addItemWalkListener(JsonSchemaWalkListener itemWalkListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addItemWalkListeners(List<JsonSchemaWalkListener> itemWalkListeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addKeywordWalkListener(JsonSchemaWalkListener keywordWalkListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addKeywordWalkListener(String keyword, JsonSchemaWalkListener keywordWalkListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addKeywordWalkListeners(List<JsonSchemaWalkListener> keywordWalkListeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addKeywordWalkListeners(String keyword, List<JsonSchemaWalkListener> keywordWalkListeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyWalkListener(JsonSchemaWalkListener propertyWalkListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyWalkListeners(List<JsonSchemaWalkListener> propertyWalkListeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setApplyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCacheRefs(boolean cacheRefs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCustomMessageSupported(boolean customMessageSupported) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEcma262Validator(boolean ecma262Validator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExecutionContextCustomizer(ExecutionContextCustomizer executionContextCustomizer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFailFast(boolean failFast) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFormatAssertionsEnabled(Boolean formatAssertionsEnabled) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHandleNullableField(boolean handleNullableField) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJavaSemantics(boolean javaSemantics) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLocale(Locale locale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLosslessNarrowing(boolean losslessNarrowing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMessageSource(MessageSource messageSource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOpenAPI3StyleDiscriminators(boolean openAPI3StyleDiscriminators) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPathType(PathType pathType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreloadJsonSchema(boolean preloadJsonSchema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreloadJsonSchemaRefMaxNestingDepth(int preloadJsonSchemaRefMaxNestingDepth) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRegularExpressionFactory(RegularExpressionFactory regularExpressionFactory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSchemaIdValidator(JsonSchemaIdValidator schemaIdValidator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrict(String keyword, boolean strict) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTypeLoose(boolean typeLoose) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteOnly(boolean writeOnly) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoadCollectors(boolean loadCollectors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig disableUnevaluatedAnalysis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig disableUnevaluatedItems() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig disableUnevaluatedProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig enableUnevaluatedAnalysis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig enableUnevaluatedItems() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SchemaValidatorsConfig enableUnevaluatedProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

