/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.io.AnsiProcessor;
import org.fusesource.jansi.io.Colors;

public class ColorsAnsiProcessor
extends AnsiProcessor {
    private final AnsiColors colors;

    public ColorsAnsiProcessor(OutputStream os, AnsiColors colors) {
        super(os);
        this.colors = colors;
    }

    @Override
    protected boolean processEscapeCommand(ArrayList<Object> options2, int command2) throws IOException {
        if (command2 == 109 && (this.colors == AnsiColors.Colors256 || this.colors == AnsiColors.Colors16)) {
            boolean has38or48 = false;
            for (Object next2 : options2) {
                if (next2 != null && next2.getClass() != Integer.class) {
                    throw new IllegalArgumentException();
                }
                Integer value = (Integer)next2;
                has38or48 |= value == 38 || value == 48;
            }
            if (!has38or48) {
                return false;
            }
            StringBuilder sb = new StringBuilder(32);
            sb.append('\u001b').append('[');
            boolean first2 = true;
            Iterator<Object> optionsIterator = options2.iterator();
            while (optionsIterator.hasNext()) {
                Object next3 = optionsIterator.next();
                if (next3 == null) continue;
                int value = (Integer)next3;
                if (value == 38 || value == 48) {
                    int arg2or5 = this.getNextOptionInt(optionsIterator);
                    if (arg2or5 == 2) {
                        int col2;
                        int r = this.getNextOptionInt(optionsIterator);
                        int g = this.getNextOptionInt(optionsIterator);
                        int b2 = this.getNextOptionInt(optionsIterator);
                        if (this.colors == AnsiColors.Colors256) {
                            col2 = Colors.roundRgbColor(r, g, b2, 256);
                            if (!first2) {
                                sb.append(';');
                            }
                            first2 = false;
                            sb.append(value);
                            sb.append(';');
                            sb.append(5);
                            sb.append(';');
                            sb.append(col2);
                            continue;
                        }
                        col2 = Colors.roundRgbColor(r, g, b2, 16);
                        if (!first2) {
                            sb.append(';');
                        }
                        first2 = false;
                        sb.append(value == 38 ? (col2 >= 8 ? 90 + col2 - 8 : 30 + col2) : (col2 >= 8 ? 100 + col2 - 8 : 40 + col2));
                        continue;
                    }
                    if (arg2or5 == 5) {
                        int paletteIndex = this.getNextOptionInt(optionsIterator);
                        if (this.colors == AnsiColors.Colors256) {
                            if (!first2) {
                                sb.append(';');
                            }
                            first2 = false;
                            sb.append(value);
                            sb.append(';');
                            sb.append(5);
                            sb.append(';');
                            sb.append(paletteIndex);
                            continue;
                        }
                        int col3 = Colors.roundColor(paletteIndex, 16);
                        if (!first2) {
                            sb.append(';');
                        }
                        first2 = false;
                        sb.append(value == 38 ? (col3 >= 8 ? 90 + col3 - 8 : 30 + col3) : (col3 >= 8 ? 100 + col3 - 8 : 40 + col3));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                if (!first2) {
                    sb.append(';');
                }
                first2 = false;
                sb.append(value);
            }
            sb.append('m');
            this.os.write(sb.toString().getBytes());
            return true;
        }
        return false;
    }

    @Override
    protected boolean processOperatingSystemCommand(ArrayList<Object> options2) {
        return false;
    }

    @Override
    protected boolean processCharsetSelect(ArrayList<Object> options2) {
        return false;
    }
}

