/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum PublicKeyRepresentationFormat {
    ECC_X962_RAW(256, "ecc_x962_raw"),
    ECC_X962_DER(257, "ecc_x962_der"),
    RSA_2048_RAW(258, "rsa_2048_raw"),
    RSA_2048_DER(259, "rsa_2048_der"),
    COSE(260, "cose");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private PublicKeyRepresentationFormat(int value, String string3) {
        this.value = value;
        this.string = string3;
    }

    public static PublicKeyRepresentationFormat create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        return Arrays.stream(PublicKeyRepresentationFormat.values()).filter(item2 -> item2.getValue() == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static PublicKeyRepresentationFormat create(String value) {
        return Arrays.stream(PublicKeyRepresentationFormat.values()).filter(item2 -> Objects.equals(item2.toString(), value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

