/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u001a\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/HttpMethod;", "", "", "value", "<init>", "(Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "component1", "copy", "(Ljava/lang/String;)Lio/ktor/http/HttpMethod;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getValue", "Companion", "ktor-http"})
public final class HttpMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private static final HttpMethod Get = new HttpMethod("GET");
    @NotNull
    private static final HttpMethod Post = new HttpMethod("POST");
    @NotNull
    private static final HttpMethod Put = new HttpMethod("PUT");
    @NotNull
    private static final HttpMethod Patch = new HttpMethod("PATCH");
    @NotNull
    private static final HttpMethod Delete = new HttpMethod("DELETE");
    @NotNull
    private static final HttpMethod Head = new HttpMethod("HEAD");
    @NotNull
    private static final HttpMethod Options = new HttpMethod("OPTIONS");
    @NotNull
    private static final List<HttpMethod> DefaultMethods;

    public HttpMethod(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final HttpMethod copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return new HttpMethod(value);
    }

    public static /* synthetic */ HttpMethod copy$default(HttpMethod httpMethod, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = httpMethod.value;
        }
        return httpMethod.copy(string2);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpMethod)) {
            return false;
        }
        HttpMethod httpMethod = (HttpMethod)other;
        return Intrinsics.areEqual(this.value, httpMethod.value);
    }

    static {
        HttpMethod[] httpMethodArray = new HttpMethod[]{Get, Post, Put, Patch, Delete, Head, Options};
        DefaultMethods = CollectionsKt.listOf(httpMethodArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\fR\u0017\u0010\u0015\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0016\u0010\fR\u0017\u0010\u0017\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0018\u0010\fR\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lio/ktor/http/HttpMethod$Companion;", "", "<init>", "()V", "", "method", "Lio/ktor/http/HttpMethod;", "parse", "(Ljava/lang/String;)Lio/ktor/http/HttpMethod;", "Get", "Lio/ktor/http/HttpMethod;", "getGet", "()Lio/ktor/http/HttpMethod;", "Post", "getPost", "Put", "getPut", "Patch", "getPatch", "Delete", "getDelete", "Head", "getHead", "Options", "getOptions", "", "DefaultMethods", "Ljava/util/List;", "getDefaultMethods", "()Ljava/util/List;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpMethod getGet() {
            return Get;
        }

        @NotNull
        public final HttpMethod getPost() {
            return Post;
        }

        @NotNull
        public final HttpMethod getPut() {
            return Put;
        }

        @NotNull
        public final HttpMethod getPatch() {
            return Patch;
        }

        @NotNull
        public final HttpMethod getDelete() {
            return Delete;
        }

        @NotNull
        public final HttpMethod getHead() {
            return Head;
        }

        @NotNull
        public final HttpMethod getOptions() {
            return Options;
        }

        @NotNull
        public final HttpMethod parse(@NotNull String method) {
            Intrinsics.checkNotNullParameter(method, "method");
            String string2 = method;
            return Intrinsics.areEqual(string2, this.getGet().getValue()) ? this.getGet() : (Intrinsics.areEqual(string2, this.getPost().getValue()) ? this.getPost() : (Intrinsics.areEqual(string2, this.getPut().getValue()) ? this.getPut() : (Intrinsics.areEqual(string2, this.getPatch().getValue()) ? this.getPatch() : (Intrinsics.areEqual(string2, this.getDelete().getValue()) ? this.getDelete() : (Intrinsics.areEqual(string2, this.getHead().getValue()) ? this.getHead() : (Intrinsics.areEqual(string2, this.getOptions().getValue()) ? this.getOptions() : new HttpMethod(method)))))));
        }

        @NotNull
        public final List<HttpMethod> getDefaultMethods() {
            return DefaultMethods;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

