/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.util;

import com.ethlo.time.Field;
import java.time.format.DateTimeParseException;
import java.util.Arrays;

public class ErrorUtil {
    private ErrorUtil() {
    }

    public static DateTimeParseException raiseUnexpectedCharacter(String chars, int index2, char ... expected) {
        throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", Arrays.toString(expected), index2 + 1, Character.valueOf(chars.charAt(index2)), chars), chars, index2);
    }

    public static DateTimeParseException raiseUnexpectedEndOfText(String chars, int offset) {
        throw new DateTimeParseException(String.format("Unexpected end of input: %s", chars), chars, offset);
    }

    public static DateTimeParseException raiseMissingGranularity(Field field, String chars, int offset) {
        throw new DateTimeParseException(String.format("Unexpected end of input, missing field %s: %s", field.name(), chars), chars, offset);
    }

    public static void assertPositionContains(Field field, String chars, int index2, char expected) {
        if (index2 >= chars.length()) {
            throw ErrorUtil.raiseMissingGranularity(field, chars, index2);
        }
        if (chars.charAt(index2) != expected) {
            throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", Character.valueOf(expected), index2 + 1, Character.valueOf(chars.charAt(index2)), chars), chars, index2);
        }
    }

    public static void assertFractionDigits(String chars, int fractionDigits, int idx) {
        if (fractionDigits == 0) {
            throw new DateTimeParseException(String.format("Must have at least 1 fraction digit: %s", chars), chars, idx);
        }
        if (fractionDigits > 9) {
            throw new DateTimeParseException(String.format("Maximum supported number of fraction digits in second is 9, got %d: %s", fractionDigits, chars), chars, idx);
        }
    }
}

