package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.PersonQrBadgeEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonQrBadgeEntityDao_Impl(
  __db: RoomDatabase,
) : PersonQrBadgeEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonQrBadgeEntity: EntityInsertAdapter<PersonQrBadgeEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonQrBadgeEntity = object : EntityInsertAdapter<PersonQrBadgeEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PersonQrBadgeEntity` (`pqrGuidNum`,`pqrGuid`,`pqrLastModified`,`pqrStored`,`pqrQrCodeUrl`,`pqrStatus`) VALUES (?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonQrBadgeEntity) {
        statement.bindLong(1, entity.pqrGuidNum)
        statement.bindText(2, entity.pqrGuid)
        val _tmp: Long? = __sharedConverters.fromInstant(entity.pqrLastModified)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindLong(3, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.pqrStored)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp_1)
        }
        val _tmpPqrQrCodeUrl: Url? = entity.pqrQrCodeUrl
        val _tmp_2: String? = __sharedConverters.fromUrl(_tmpPqrQrCodeUrl)
        if (_tmp_2 == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp_2)
        }
        val _tmp_3: Int = __schoolTypeConverters.fromStatusEnum(entity.pqrStatus)
        statement.bindLong(6, _tmp_3.toLong())
      }
    }
  }

  public override suspend fun upsertAsyncList(list: List<PersonQrBadgeEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonQrBadgeEntity.insert(_connection, list)
  }

  public override suspend fun findAll(
    authenticatedPersonUidNum: Long,
    personGuidNum: Long,
    includeDeleted: Boolean,
    qrCodeUrl: String?,
  ): List<PersonQrBadgeEntity> {
    val _sql: String = """
        |
        |            WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |                 
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |                 
        |          SELECT PersonQrBadgeEntity.*
        |            FROM PersonQrBadgeEntity
        |                 JOIN PersonEntity 
        |                      ON PersonEntity.pGuidHash = PersonQrBadgeEntity.pqrGuidNum
        |
        |           WHERE (? = 0 OR PersonQrBadgeEntity.pqrGuidNum = ?)
        |             AND (? OR PersonQrBadgeEntity.pqrStatus = 1)        
        |             AND (? IS NULL OR PersonQrBadgeEntity.pqrQrCodeUrl = ?)
        |             AND (
        |                PersonEntity.pGuidHash = ?
        |             OR PersonEntity.pGuidHash IN 
        |                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum
        |                   FROM PersonRelatedPersonEntity
        |                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM SchoolPermissionGrantEntity
        |                     WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                           (SELECT PersonRoleEntity.prRoleEnum
        |                              FROM PersonRoleEntity
        |                             WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ))
        |                               AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM AuthenticatedPersonClassPermissions
        |                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN 
        |                           (SELECT EnrollmentEntity.eClassUidNum
        |                              FROM EnrollmentEntity
        |                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)
        |                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |        )    
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 5
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 6
        val _tmp: Int = if (includeDeleted) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        _argIndex = 7
        if (qrCodeUrl == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, qrCodeUrl)
        }
        _argIndex = 8
        if (qrCodeUrl == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, qrCodeUrl)
        }
        _argIndex = 9
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 10
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: MutableList<PersonQrBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonQrBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_2
          }
          val _tmpPqrStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_4
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_5)
          val _tmpPqrStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          _item = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuid(guid: String): PersonQrBadgeEntity? {
    val _sql: String = """
        |
        |           SELECT PersonQrBadgeEntity.* 
        |             FROM PersonQrBadgeEntity
        |            WHERE pqrGuid = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, guid)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: PersonQrBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_4)
          val _tmpPqrStatus: StatusEnum
          val _tmp_5: Int
          _tmp_5 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_5)
          _result = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByQrCodeUrl(qrCodeUrl: String): PersonQrBadgeEntity? {
    val _sql: String = """
        |
        |        SELECT PersonQrBadgeEntity.*
        |          FROM PersonQrBadgeEntity
        |         WHERE PersonQrBadgeEntity.pqrQrCodeUrl = ?
        |           AND PersonQrBadgeEntity.pqrStatus = 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, qrCodeUrl)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: PersonQrBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_4)
          val _tmpPqrStatus: StatusEnum
          val _tmp_5: Int
          _tmp_5 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_5)
          _result = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT PersonQrBadgeEntity.pqrLastModified
        |          FROM PersonQrBadgeEntity
        |         WHERE PersonQrBadgeEntity.pqrGuidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidList(uids: List<Long>): List<PersonQrBadgeEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT PersonQrBadgeEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM PersonQrBadgeEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE PersonQrBadgeEntity.pqrGuidNum IN (")
    val _inputSize: Int = uids.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uids) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: MutableList<PersonQrBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: PersonQrBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_4)
          val _tmpPqrStatus: StatusEnum
          val _tmp_5: Int
          _tmp_5 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_5)
          _item_1 = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsFlow(
    authenticatedPersonUidNum: Long,
    personGuidNum: Long,
    includeDeleted: Boolean,
    qrCodeUrl: String?,
  ): Flow<List<PersonQrBadgeEntity>> {
    val _sql: String = """
        |
        |            WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |                 
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |                 
        |          SELECT PersonQrBadgeEntity.*
        |            FROM PersonQrBadgeEntity
        |                 JOIN PersonEntity 
        |                      ON PersonEntity.pGuidHash = PersonQrBadgeEntity.pqrGuidNum
        |
        |           WHERE (? = 0 OR PersonQrBadgeEntity.pqrGuidNum = ?)
        |             AND (? OR PersonQrBadgeEntity.pqrStatus = 1)        
        |             AND (? IS NULL OR PersonQrBadgeEntity.pqrQrCodeUrl = ?)
        |             AND (
        |                PersonEntity.pGuidHash = ?
        |             OR PersonEntity.pGuidHash IN 
        |                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum
        |                   FROM PersonRelatedPersonEntity
        |                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM SchoolPermissionGrantEntity
        |                     WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                           (SELECT PersonRoleEntity.prRoleEnum
        |                              FROM PersonRoleEntity
        |                             WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ))
        |                               AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM AuthenticatedPersonClassPermissions
        |                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN 
        |                           (SELECT EnrollmentEntity.eClassUidNum
        |                              FROM EnrollmentEntity
        |                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)
        |                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |        )    
        |        
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonRelatedPersonEntity", "PersonRoleEntity", "ClassPermissionEntity", "EnrollmentEntity", "PersonQrBadgeEntity", "PersonEntity", "SchoolPermissionGrantEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 5
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 6
        val _tmp: Int = if (includeDeleted) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        _argIndex = 7
        if (qrCodeUrl == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, qrCodeUrl)
        }
        _argIndex = 8
        if (qrCodeUrl == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, qrCodeUrl)
        }
        _argIndex = 9
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 10
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: MutableList<PersonQrBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonQrBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_2
          }
          val _tmpPqrStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_4
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_5)
          val _tmpPqrStatus: StatusEnum
          val _tmp_6: Int
          _tmp_6 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_6)
          _item = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidHashAsFlow(guidnum: Long): Flow<PersonQrBadgeEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonQrBadgeEntity
        |        WHERE pqrGuidNum = ?
        |          AND pqrStatus = 1
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonQrBadgeEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidnum)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _columnIndexOfPqrStatus: Int = getColumnIndexOrThrow(_stmt, "pqrStatus")
        val _result: PersonQrBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: Url?
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfPqrQrCodeUrl)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          }
          _tmpPqrQrCodeUrl = __sharedConverters.toUrl(_tmp_4)
          val _tmpPqrStatus: StatusEnum
          val _tmp_5: Int
          _tmp_5 = _stmt.getLong(_columnIndexOfPqrStatus).toInt()
          _tmpPqrStatus = __schoolTypeConverters.toStatusEnum(_tmp_5)
          _result = PersonQrBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl,_tmpPqrStatus)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
