/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringCommand$Type2KeyWord;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.DataInputByteArray;

public class Type2CharStringParser {
    private static final int CALLSUBR = 10;
    private static final int CALLGSUBR = 29;
    private int hstemCount;
    private int vstemCount;
    private List<Object> sequence;
    private final String fontName;
    private String currentGlyph;

    public Type2CharStringParser(String string) {
        this.fontName = string;
    }

    public List<Object> parse(byte[] byArray, byte[][] byArray2, byte[][] byArray3, String string) {
        this.hstemCount = 0;
        this.vstemCount = 0;
        this.sequence = new ArrayList<Object>();
        this.currentGlyph = string;
        return this.parseSequence(byArray, byArray2, byArray3);
    }

    private List<Object> parseSequence(byte[] object, byte[][] byArray, byte[][] byArray2) {
        boolean bl;
        object = new DataInputByteArray((byte[])object);
        boolean bl2 = byArray2 != null && byArray2.length > 0;
        boolean bl3 = bl = byArray != null && byArray.length > 0;
        while (object.hasRemaining()) {
            int n = object.readUnsignedByte();
            if (n == 10 && bl2) {
                this.processCallSubr(byArray, byArray2);
                continue;
            }
            if (n == 29 && bl) {
                this.processCallGSubr(byArray, byArray2);
                continue;
            }
            if (n >= 0 && n <= 27 || n >= 29 && n <= 31) {
                this.sequence.add(this.readCommand(n, (DataInput)object));
                continue;
            }
            if (n == 28 || n >= 32 && n <= 255) {
                this.sequence.add(this.readNumber(n, (DataInput)object));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.sequence;
    }

    private void processCallSubr(byte[][] object, byte[][] byArray) {
        Type2CharStringParser type2CharStringParser = this;
        int n = type2CharStringParser.calculateSubrNumber((Integer)type2CharStringParser.sequence.remove(this.sequence.size() - 1), byArray.length);
        if (n < byArray.length) {
            byte[] byArray2 = byArray[n];
            this.parseSequence(byArray2, (byte[][])object, byArray);
            Object object2 = this.sequence.get(this.sequence.size() - 1);
            object = object2;
            if (object2 instanceof CharStringCommand && CharStringCommand$Type2KeyWord.RET == ((CharStringCommand)object).getType2KeyWord()) {
                this.sequence.remove(this.sequence.size() - 1);
            }
        }
    }

    private void processCallGSubr(byte[][] object, byte[][] byArray) {
        Type2CharStringParser type2CharStringParser = this;
        int n = type2CharStringParser.calculateSubrNumber((Integer)type2CharStringParser.sequence.remove(this.sequence.size() - 1), ((byte[][])object).length);
        if (n < ((byte[][])object).length) {
            byte[] byArray2 = object[n];
            this.parseSequence(byArray2, (byte[][])object, byArray);
            Object object2 = this.sequence.get(this.sequence.size() - 1);
            object = object2;
            if (object2 instanceof CharStringCommand && CharStringCommand$Type2KeyWord.RET == ((CharStringCommand)object).getType2KeyWord()) {
                this.sequence.remove(this.sequence.size() - 1);
            }
        }
    }

    private int calculateSubrNumber(int n, int n2) {
        if (n2 < 1240) {
            return n + 107;
        }
        if (n2 < 33900) {
            return n + 1131;
        }
        return n + 32768;
    }

    private CharStringCommand readCommand(int n, DataInput dataInput) {
        if (n == 1 || n == 18) {
            this.hstemCount += this.countNumbers() / 2;
        } else if (n == 3 || n == 19 || n == 20 || n == 23) {
            this.vstemCount += this.countNumbers() / 2;
        }
        if (n == 12) {
            int n2 = dataInput.readUnsignedByte();
            return CharStringCommand.getInstance(n, n2);
        }
        if (n == 19 || n == 20) {
            int[] nArray = new int[1 + this.getMaskLength()];
            int[] nArray2 = nArray;
            nArray[0] = n;
            for (n = 1; n < nArray2.length; ++n) {
                nArray2[n] = dataInput.readUnsignedByte();
            }
            return CharStringCommand.getInstance(nArray2);
        }
        return CharStringCommand.getInstance(n);
    }

    private Number readNumber(int n, DataInput dataInput) {
        if (n == 28) {
            return (int)dataInput.readShort();
        }
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = dataInput.readUnsignedByte();
            return (n - 247 << 8) + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = dataInput.readUnsignedByte();
            return (-(n - 251) << 8) - n3 - 108;
        }
        if (n == 255) {
            short s = dataInput.readShort();
            double d = (double)dataInput.readUnsignedShort() / 65535.0;
            return (double)s + d;
        }
        throw new IllegalArgumentException();
    }

    private int getMaskLength() {
        int n = this.hstemCount + this.vstemCount;
        int n2 = n / 8;
        if (n % 8 > 0) {
            ++n2;
        }
        return n2;
    }

    private int countNumbers() {
        int n = 0;
        for (int i = this.sequence.size() - 1; i >= 0; --i) {
            if (!(this.sequence.get(i) instanceof Number)) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public String toString() {
        return this.fontName + ", current glpyh " + this.currentGlyph;
    }
}

