/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyfCompositeComp;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class GlyfCompositeDescript
extends GlyfDescript {
    private static final Log LOG = LogFactory.getLog(GlyfCompositeDescript.class);
    private final List<GlyfCompositeComp> components = new ArrayList<GlyfCompositeComp>();
    private final Map<Integer, GlyphDescription> descriptions = new HashMap<Integer, GlyphDescription>();
    private GlyphTable glyphTable = null;
    private boolean beingResolved = false;
    private boolean resolved = false;
    private int pointCount = -1;
    private int contourCount = -1;

    GlyfCompositeDescript(TTFDataStream tTFDataStream, GlyphTable object) {
        super((short)-1);
        this.glyphTable = object;
        do {
            object = new GlyfCompositeComp(tTFDataStream);
            this.components.add((GlyfCompositeComp)object);
        } while ((((GlyfCompositeComp)object).getFlags() & 0x20) != 0);
        if ((((GlyfCompositeComp)object).getFlags() & 0x100) != 0) {
            TTFDataStream tTFDataStream2 = tTFDataStream;
            this.readInstructions(tTFDataStream2, tTFDataStream2.readUnsignedShort());
        }
        this.initDescriptions();
    }

    @Override
    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            LOG.error((Object)"Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int n = 0;
        int n2 = 0;
        for (GlyfCompositeComp glyfCompositeComp : this.components) {
            glyfCompositeComp.setFirstIndex(n);
            glyfCompositeComp.setFirstContour(n2);
            GlyphDescription object = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            if (object == null) continue;
            object.resolve();
            n += object.getPointCount();
            n2 += object.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    @Override
    public int getEndPtOfContours(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n);
        if (glyfCompositeComp != null) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            return glyphDescription.getEndPtOfContours(n - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    @Override
    public byte getFlags(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            return glyphDescription.getFlags(n - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    @Override
    public short getXCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            short s = glyphDescription.getXCoordinate(n -= glyfCompositeComp.getFirstIndex());
            n = glyphDescription.getYCoordinate(n);
            return (short)(glyfCompositeComp.scaleX(s, n) + glyfCompositeComp.getXTranslate());
        }
        return 0;
    }

    @Override
    public short getYCoordinate(int n) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n);
        if (glyfCompositeComp != null) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            short s = glyphDescription.getXCoordinate(n -= glyfCompositeComp.getFirstIndex());
            n = glyphDescription.getYCoordinate(n);
            return (short)(glyfCompositeComp.scaleY(s, n) + glyfCompositeComp.getYTranslate());
        }
        return 0;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public int getPointCount() {
        if (!this.resolved) {
            LOG.error((Object)"getPointCount called on unresolved GlyfCompositeDescript");
        }
        if (this.pointCount < 0) {
            GlyfCompositeComp glyfCompositeComp = this.components.get(this.components.size() - 1);
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            if (glyphDescription == null) {
                LOG.error((Object)("GlyphDescription for index " + glyfCompositeComp.getGlyphIndex() + " is null, returning 0"));
                this.pointCount = 0;
            } else {
                this.pointCount = glyfCompositeComp.getFirstIndex() + glyphDescription.getPointCount();
            }
        }
        return this.pointCount;
    }

    @Override
    public int getContourCount() {
        if (!this.resolved) {
            LOG.error((Object)"getContourCount called on unresolved GlyfCompositeDescript");
        }
        if (this.contourCount < 0) {
            GlyfCompositeComp glyfCompositeComp = this.components.get(this.components.size() - 1);
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            if (glyphDescription == null) {
                LOG.error((Object)("missing glyph description for index " + glyfCompositeComp.getGlyphIndex()));
                this.contourCount = 0;
            } else {
                this.contourCount = glyfCompositeComp.getFirstContour() + glyphDescription.getContourCount();
            }
        }
        return this.contourCount;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public List<GlyfCompositeComp> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    private GlyfCompositeComp getCompositeComp(int n) {
        for (GlyfCompositeComp glyfCompositeComp : this.components) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() > n || glyphDescription == null || n >= glyfCompositeComp.getFirstIndex() + glyphDescription.getPointCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    private GlyfCompositeComp getCompositeCompEndPt(int n) {
        for (GlyfCompositeComp glyfCompositeComp : this.components) {
            GlyphDescription glyphDescription = this.descriptions.get(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() > n || glyphDescription == null || n >= glyfCompositeComp.getFirstContour() + glyphDescription.getContourCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    private void initDescriptions() {
        for (GlyfCompositeComp glyfCompositeComp : this.components) {
            try {
                int n = glyfCompositeComp.getGlyphIndex();
                GlyphData glyphData = this.glyphTable.getGlyph(n);
                if (glyphData == null) continue;
                this.descriptions.put(n, glyphData.getDescription());
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
            }
        }
    }
}

