/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyfDescript;
import org.apache.fontbox.ttf.TTFDataStream;

public class GlyfSimpleDescript
extends GlyfDescript {
    private static final Log LOG = LogFactory.getLog(GlyfSimpleDescript.class);
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private final int pointCount;

    GlyfSimpleDescript() {
        super((short)0);
        this.pointCount = 0;
    }

    GlyfSimpleDescript(short s, TTFDataStream tTFDataStream, short s2) {
        super(s);
        if (s == 0) {
            this.pointCount = 0;
            return;
        }
        this.endPtsOfContours = tTFDataStream.readUnsignedShortArray(s);
        int n = this.endPtsOfContours[s - 1];
        if (s == 1 && n == 65535) {
            this.pointCount = 0;
            return;
        }
        this.pointCount = n + 1;
        this.flags = new byte[this.pointCount];
        this.xCoordinates = new short[this.pointCount];
        this.yCoordinates = new short[this.pointCount];
        s = (short)tTFDataStream.readUnsignedShort();
        this.readInstructions(tTFDataStream, s);
        GlyfSimpleDescript glyfSimpleDescript = this;
        glyfSimpleDescript.readFlags(glyfSimpleDescript.pointCount, tTFDataStream);
        GlyfSimpleDescript glyfSimpleDescript2 = this;
        glyfSimpleDescript2.readCoords(glyfSimpleDescript2.pointCount, tTFDataStream, s2);
    }

    @Override
    public int getEndPtOfContours(int n) {
        return this.endPtsOfContours[n];
    }

    @Override
    public byte getFlags(int n) {
        return this.flags[n];
    }

    @Override
    public short getXCoordinate(int n) {
        return this.xCoordinates[n];
    }

    @Override
    public short getYCoordinate(int n) {
        return this.yCoordinates[n];
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getPointCount() {
        return this.pointCount;
    }

    private void readCoords(int n, TTFDataStream tTFDataStream, short s) {
        int n2;
        short s2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if ((this.flags[n2] & 0x10) != 0) {
                if ((this.flags[n2] & 2) != 0) {
                    s = (short)(s + (short)tTFDataStream.readUnsignedByte());
                }
            } else {
                s = (this.flags[n2] & 2) != 0 ? (short)(s - (short)tTFDataStream.readUnsignedByte()) : (short)(s + tTFDataStream.readSignedShort());
            }
            this.xCoordinates[n2] = s;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if ((this.flags[n2] & 0x20) != 0) {
                if ((this.flags[n2] & 4) != 0) {
                    s2 = (short)(s2 + (short)tTFDataStream.readUnsignedByte());
                }
            } else {
                s2 = (this.flags[n2] & 4) != 0 ? (short)(s2 - (short)tTFDataStream.readUnsignedByte()) : (short)(s2 + tTFDataStream.readSignedShort());
            }
            this.yCoordinates[n2] = s2;
        }
    }

    private void readFlags(int n, TTFDataStream tTFDataStream) {
        for (int i = 0; i < n; ++i) {
            this.flags[i] = (byte)tTFDataStream.readUnsignedByte();
            if ((this.flags[i] & 8) == 0) continue;
            int n2 = tTFDataStream.readUnsignedByte();
            for (int j = 1; j <= n2; ++j) {
                if (i + j >= this.flags.length) {
                    throw new IOException("repeat count (" + n2 + ") higher than remaining space");
                }
                this.flags[i + j] = this.flags[i];
            }
            i += n2;
        }
    }
}

