/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class VerticalOriginTable
extends TTFTable {
    public static final String TAG = "VORG";
    private float version;
    private int defaultVertOriginY;
    private Map<Integer, Integer> origins;

    VerticalOriginTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        this.version = tTFDataStream.read32Fixed();
        this.defaultVertOriginY = tTFDataStream.readSignedShort();
        int n = tTFDataStream.readUnsignedShort();
        this.origins = new ConcurrentHashMap<Integer, Integer>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = tTFDataStream.readUnsignedShort();
            short s = tTFDataStream.readSignedShort();
            this.origins.put(n2, Integer.valueOf(s));
        }
        this.initialized = true;
    }

    public float getVersion() {
        return this.version;
    }

    public int getOriginY(int n) {
        if (this.origins.containsKey(n)) {
            return this.origins.get(n);
        }
        return this.defaultVertOriginY;
    }
}

