/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fontbox.ttf.gsub.CompoundCharacterTokenizer;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitter;

public class GlyphArraySplitterRegexImpl
implements GlyphArraySplitter {
    private static final String GLYPH_ID_SEPARATOR = "_";
    private final CompoundCharacterTokenizer compoundCharacterTokenizer;

    public GlyphArraySplitterRegexImpl(Set<List<Integer>> set) {
        this.compoundCharacterTokenizer = new CompoundCharacterTokenizer(this.getMatchersAsStrings(set));
    }

    @Override
    public List<List<Integer>> split(List<Integer> list) {
        list = this.convertGlyphIdsToString(list);
        list = this.compoundCharacterTokenizer.tokenize((String)((Object)list));
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>(list.size());
        list.forEach(string -> arrayList.add(this.convertGlyphIdsToList((String)string)));
        return arrayList;
    }

    private Set<String> getMatchersAsStrings(Set<List<Integer>> set) {
        TreeSet<String> treeSet = new TreeSet<String>((string, string2) -> {
            if (string.length() == string2.length()) {
                return string2.compareTo((String)string);
            }
            return string2.length() - string.length();
        });
        set.forEach(list -> treeSet.add(this.convertGlyphIdsToString((List<Integer>)list)));
        return treeSet;
    }

    private String convertGlyphIdsToString(List<Integer> list) {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(GLYPH_ID_SEPARATOR);
        list.forEach(n -> stringBuilder.append(n).append(GLYPH_ID_SEPARATOR));
        return stringBuilder.toString();
    }

    private List<Integer> convertGlyphIdsToList(String stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : stringArray.split(GLYPH_ID_SEPARATOR)) {
            if ((string = string.trim()).isEmpty()) continue;
            arrayList.add(Integer.valueOf(string));
        }
        return arrayList;
    }
}

