/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Check$DefaultImpls;

final class NoDefaultAndVarargsCheck
implements Check {
    public static final NoDefaultAndVarargsCheck INSTANCE = new NoDefaultAndVarargsCheck();
    private static final String description = "should not have varargs or parameters with default values";

    private NoDefaultAndVarargsCheck() {
    }

    @Override
    public final String getDescription() {
        return description;
    }

    @Override
    public final boolean check(FunctionDescriptor iterator2) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"");
        List<ValueParameterDescriptor> list = iterator2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        iterator2 = list;
        if (!(iterator2 instanceof Collection) || !((Collection)((Object)iterator2)).isEmpty()) {
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                object = (ValueParameterDescriptor)object;
                Intrinsics.checkNotNull((Object)object);
                if (!DescriptorUtilsKt.declaresOrInheritsDefaultValue(object) && object.getVarargElementType() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final String invoke(FunctionDescriptor functionDescriptor) {
        return Check$DefaultImpls.invoke(this, functionDescriptor);
    }
}

