/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.JobStoreSupport$TransactionCallback;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.utils.DBConnectionManager;

public class JobStoreCMT
extends JobStoreSupport {
    protected String nonManagedTxDsName;
    protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;
    protected boolean setTxIsolationLevelReadCommitted = false;

    public void setNonManagedTXDataSource(String string) {
        this.nonManagedTxDsName = string;
    }

    public String getNonManagedTXDataSource() {
        return this.nonManagedTxDsName;
    }

    public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
        return this.dontSetNonManagedTXConnectionAutoCommitFalse;
    }

    public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean bl) {
        this.dontSetNonManagedTXConnectionAutoCommitFalse = bl;
    }

    public boolean isTxIsolationLevelReadCommitted() {
        return this.setTxIsolationLevelReadCommitted;
    }

    public void setTxIsolationLevelReadCommitted(boolean bl) {
        this.setTxIsolationLevelReadCommitted = bl;
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) {
        if (this.nonManagedTxDsName == null) {
            throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!  If your 'org.quartz.jobStore.dataSource' is XA, then set 'org.quartz.jobStore.nonManagedTXDataSource' to a non-XA datasource (for the same DB).  Otherwise, you can set them to be the same.");
        }
        if (this.getLockHandler() == null) {
            this.setUseDBLocks(true);
        }
        super.initialize(classLoadHelper, schedulerSignaler);
        this.getLog().info("JobStoreCMT initialized.");
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            DBConnectionManager.getInstance().shutdown(this.getNonManagedTXDataSource());
            return;
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Database connection shutdown unsuccessful.", (Throwable)sQLException);
            return;
        }
    }

    @Override
    protected Connection getNonManagedTXConnection() {
        Connection connection;
        try {
            connection = DBConnectionManager.getInstance().getConnection(this.getNonManagedTXDataSource());
        }
        catch (SQLException sQLException) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + sQLException.toString(), sQLException);
        }
        catch (Throwable throwable) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + throwable.toString(), throwable);
        }
        if (connection == null) {
            throw new JobPersistenceException("Could not get connection from DataSource '" + this.getNonManagedTXDataSource() + "'");
        }
        connection = this.getAttributeRestoringConnection(connection);
        try {
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                connection.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelReadCommitted()) {
                connection.setTransactionIsolation(2);
            }
        }
        catch (SQLException sQLException) {
            this.getLog().warn("Failed to override connection auto commit/transaction isolation.", (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (Throwable throwable2) {}
            throw new JobPersistenceException("Failure setting up connection.", throwable);
        }
        return connection;
    }

    protected Object executeInLock(String string, JobStoreSupport$TransactionCallback jobStoreSupport$TransactionCallback) {
        boolean bl = false;
        Connection connection = null;
        try {
            if (string != null) {
                if (this.getLockHandler().requiresConnection()) {
                    connection = this.getConnection();
                }
                bl = this.getLockHandler().obtainLock(connection, string);
            }
            if (connection == null) {
                connection = this.getConnection();
            }
            jobStoreSupport$TransactionCallback = jobStoreSupport$TransactionCallback.execute(connection);
            return jobStoreSupport$TransactionCallback;
        }
        finally {
            try {
                this.releaseLock(string, bl);
            }
            finally {
                this.cleanupConnection(connection);
            }
        }
    }
}

