/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate$TriggerPropertyBundle;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class SimpleTriggerPersistenceDelegate
implements StdJDBCConstants,
TriggerPersistenceDelegate {
    protected String tablePrefix;
    protected String schedNameLiteral;

    @Override
    public void initialize(String string, String string2) {
        this.tablePrefix = string;
        this.schedNameLiteral = "'" + string2 + "'";
    }

    @Override
    public String getHandledTriggerTypeDiscriminator() {
        return "SIMPLE";
    }

    @Override
    public boolean canHandleTriggerType(OperableTrigger operableTrigger) {
        return operableTrigger instanceof SimpleTriggerImpl && !((SimpleTriggerImpl)operableTrigger).hasAdditionalProperties();
    }

    @Override
    public int deleteExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(Util.rtp("DELETE FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            preparedStatement.setString(1, triggerKey.getName());
            preparedStatement.setString(2, triggerKey.getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeStatement(preparedStatement);
            throw throwable;
        }
        Util.closeStatement(preparedStatement);
        return n;
    }

    @Override
    public int insertExtendedTriggerProperties(Connection connection, OperableTrigger operableTrigger, String object, JobDetail object2) {
        object = (SimpleTrigger)((Object)operableTrigger);
        object2 = null;
        try {
            object2 = connection.prepareStatement(Util.rtp("INSERT INTO {0}SIMPLE_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES({1}, ?, ?, ?, ?, ?)", this.tablePrefix, this.schedNameLiteral));
            object2.setString(1, operableTrigger.getKey().getName());
            object2.setString(2, operableTrigger.getKey().getGroup());
            object2.setInt(3, object.getRepeatCount());
            object2.setBigDecimal(4, new BigDecimal(String.valueOf(object.getRepeatInterval())));
            object2.setInt(5, object.getTimesTriggered());
            int n = object2.executeUpdate();
            return n;
        }
        finally {
            Util.closeStatement((Statement)object2);
        }
    }

    @Override
    public TriggerPersistenceDelegate$TriggerPropertyBundle loadExtendedTriggerProperties(Connection connection, TriggerKey triggerKey) {
        block3: {
            Object object;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(Util.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
                preparedStatement.setString(1, triggerKey.getName());
                preparedStatement.setString(2, triggerKey.getGroup());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block3;
                int n = resultSet.getInt("REPEAT_COUNT");
                long l = resultSet.getLong("REPEAT_INTERVAL");
                int n2 = resultSet.getInt("TIMES_TRIGGERED");
                object = SimpleScheduleBuilder.simpleSchedule().withRepeatCount(n).withIntervalInMilliseconds(l);
                String[] stringArray = new String[]{"timesTriggered"};
                Object[] objectArray = new Object[]{n2};
                object = new TriggerPersistenceDelegate$TriggerPropertyBundle((ScheduleBuilder<?>)object, stringArray, objectArray);
            }
            catch (Throwable throwable) {
                Util.closeResultSet(resultSet);
                Util.closeStatement(preparedStatement);
                throw throwable;
            }
            Util.closeResultSet(resultSet);
            Util.closeStatement(preparedStatement);
            return object;
        }
        throw new IllegalStateException("No record found for selection of Trigger with key: '" + triggerKey + "' and statement: " + Util.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
    }

    @Override
    public int updateExtendedTriggerProperties(Connection connection, OperableTrigger trigger, String object, JobDetail jobDetail) {
        trigger = (SimpleTrigger)trigger;
        object = null;
        try {
            object = connection.prepareStatement(Util.rtp("UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?", this.tablePrefix, this.schedNameLiteral));
            object.setInt(1, trigger.getRepeatCount());
            object.setBigDecimal(2, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
            object.setInt(3, trigger.getTimesTriggered());
            object.setString(4, trigger.getKey().getName());
            object.setString(5, trigger.getKey().getGroup());
            int n = object.executeUpdate();
            return n;
        }
        finally {
            Util.closeStatement((Statement)object);
        }
    }
}

