/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE SCHED_NAME = {1} AND LOCK_NAME = ? FOR UPDATE";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";
    private int maxRetry = 3;
    private long retryPeriod = 1000L;

    public StdRowLockSemaphore() {
        super("QRTZ_", null, SELECT_FOR_LOCK, INSERT_LOCK);
    }

    public StdRowLockSemaphore(String string, String string2, String string3) {
        super(string, string2, string3 != null ? string3 : SELECT_FOR_LOCK, INSERT_LOCK);
    }

    public void setMaxRetry(int n) {
        this.maxRetry = n;
    }

    public void setRetryPeriod(long l) {
        this.retryPeriod = l;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public long getRetryPeriod() {
        return this.retryPeriod;
    }

    @Override
    protected void executeSQL(Connection connection, String string, String string2, String string3) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SQLException sQLException = null;
        int n = 0;
        int n2 = this.maxRetry;
        long l = this.retryPeriod;
        do {
            block34: {
                block35: {
                    block36: {
                        ++n;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("Lock '" + string + "' is being obtained: " + Thread.currentThread().getName());
                        }
                        if ((resultSet = preparedStatement.executeQuery()).next()) break block34;
                        this.getLog().debug("Inserting new lock row for lock: '" + string + "' being obtained by thread: " + Thread.currentThread().getName());
                        resultSet.close();
                        resultSet = null;
                        preparedStatement.close();
                        preparedStatement = null;
                        preparedStatement = connection.prepareStatement(string3);
                        preparedStatement.setString(1, string);
                        int n3 = preparedStatement.executeUpdate();
                        if (n3 == 1) break block34;
                        if (n >= n2) break block35;
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        if (resultSet == null) break block36;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (preparedStatement == null) continue;
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + string, this.getTablePrefix(), this.getSchedulerNameLiteral()));
                }
                catch (SQLException sQLException2) {
                    block37: {
                        block38: {
                            try {
                                if (sQLException == null) {
                                    sQLException = sQLException2;
                                }
                                if (this.getLog().isDebugEnabled()) {
                                    this.getLog().debug("Lock '" + string + "' was not obtained by: " + Thread.currentThread().getName() + (n < n2 ? " - will try again." : ""));
                                }
                                if (n >= n2) break block37;
                                try {
                                    Thread.sleep(l);
                                }
                                catch (InterruptedException interruptedException) {
                                    Thread.currentThread().interrupt();
                                }
                                if (resultSet == null) break block38;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (preparedStatement != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                throw throwable;
                            }
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (preparedStatement == null) continue;
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    throw new LockException("Failure obtaining db row lock: " + sQLException2.getMessage(), sQLException2);
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                    return;
                }
                catch (Exception exception) {}
            }
            return;
        } while (n < n2 + 1);
        throw new LockException("Failure obtaining db row lock, reached maximum number of attempts. Initial exception (if any) attached as root cause.", sQLException);
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String string) {
        this.setSQL(string);
    }
}

