/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class UpdateLockRowSemaphore
extends DBSemaphore {
    public static final String UPDATE_FOR_LOCK = "UPDATE {0}LOCKS SET LOCK_NAME = LOCK_NAME WHERE SCHED_NAME = {1} AND LOCK_NAME = ? ";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";
    private static final int RETRY_COUNT = 2;

    public UpdateLockRowSemaphore() {
        super("QRTZ_", null, UPDATE_FOR_LOCK, INSERT_LOCK);
    }

    @Override
    protected void executeSQL(Connection connection, String string, String string2, String string3) {
        SQLException sQLException = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.lockViaUpdate(connection, string, string2)) {
                    this.lockViaInsert(connection, string, string3);
                }
                return;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                sQLException = sQLException2;
                if (i + 1 == 2) {
                    this.getLog().debug("Lock '{}' was not obtained by: {}", (Object)string, (Object)Thread.currentThread().getName());
                } else {
                    this.getLog().debug("Lock '{}' was not obtained by: {} - will try again.", (Object)string, (Object)Thread.currentThread().getName());
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        throw new LockException("Failure obtaining db row lock: " + sQLException.getMessage(), sQLException);
    }

    protected String getUpdateLockRowSQL() {
        return this.getSQL();
    }

    public void setUpdateLockRowSQL(String string) {
        this.setSQL(string);
    }

    private boolean lockViaUpdate(Connection autoCloseable, String string, String string2) {
        autoCloseable = autoCloseable.prepareStatement(string2);
        try {
            autoCloseable.setString(1, string);
            this.getLog().debug("Lock '" + string + "' is being obtained: " + Thread.currentThread().getName());
            boolean bl = autoCloseable.executeUpdate() > 0;
            return bl;
        }
        finally {
            autoCloseable.close();
        }
    }

    private void lockViaInsert(Connection autoCloseable, String string, String string2) {
        this.getLog().debug("Inserting new lock row for lock: '" + string + "' being obtained by thread: " + Thread.currentThread().getName());
        autoCloseable = autoCloseable.prepareStatement(string2);
        try {
            autoCloseable.setString(1, string);
            if (autoCloseable.executeUpdate() != 1) {
                throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + string, this.getTablePrefix(), this.getSchedulerNameLiteral()));
            }
            return;
        }
        finally {
            autoCloseable.close();
        }
    }
}

