/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class CallbackReference$DefaultCallbackProxy
implements CallbackProxy {
    private final Method callbackMethod;
    private ToNativeConverter toNative;
    private final FromNativeConverter[] fromNative;
    private final String encoding;
    final /* synthetic */ CallbackReference this$0;

    public CallbackReference$DefaultCallbackProxy(CallbackReference classArray, Method method, TypeMapper typeMapper, String object) {
        this.this$0 = classArray;
        this.callbackMethod = method;
        this.encoding = object;
        classArray = method.getParameterTypes();
        object = method.getReturnType();
        this.fromNative = new FromNativeConverter[classArray.length];
        if (NativeMapped.class.isAssignableFrom((Class<?>)object)) {
            this.toNative = NativeMappedConverter.getInstance(object);
        } else if (typeMapper != null) {
            this.toNative = typeMapper.getToNativeConverter((Class<?>)object);
        }
        for (int i = 0; i < this.fromNative.length; ++i) {
            if (NativeMapped.class.isAssignableFrom(classArray[i])) {
                this.fromNative[i] = new NativeMappedConverter(classArray[i]);
                continue;
            }
            if (typeMapper == null) continue;
            this.fromNative[i] = typeMapper.getFromNativeConverter(classArray[i]);
        }
        if (!method.isAccessible()) {
            try {
                method.setAccessible(true);
                return;
            }
            catch (SecurityException securityException) {
                throw new IllegalArgumentException("Callback method is inaccessible, make sure the interface is public: " + method);
            }
        }
    }

    public Callback getCallback() {
        return CallbackReference.access$000(this.this$0);
    }

    private Object invokeCallback(Object[] objectArray) {
        Object object;
        Class<?>[] classArray = this.callbackMethod.getParameterTypes();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object = classArray[i];
            Object object2 = objectArray[i];
            if (this.fromNative[i] != null) {
                object = new CallbackParameterContext((Class<?>)object, this.callbackMethod, objectArray, i);
                objectArray2[i] = this.fromNative[i].fromNative(object2, (FromNativeContext)object);
                continue;
            }
            objectArray2[i] = this.convertArgument(object2, (Class<?>)object);
        }
        Object object3 = null;
        object = this.getCallback();
        if (object != null) {
            try {
                CallbackReference$DefaultCallbackProxy callbackReference$DefaultCallbackProxy = this;
                object3 = callbackReference$DefaultCallbackProxy.convertResult(callbackReference$DefaultCallbackProxy.callbackMethod.invoke(object, objectArray2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Native.getCallbackExceptionHandler().uncaughtException((Callback)object, invocationTargetException.getTargetException());
            }
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (!(objectArray2[i] instanceof Structure) || objectArray2[i] instanceof Structure.ByValue) continue;
            ((Structure)objectArray2[i]).autoWrite();
        }
        return object3;
    }

    @Override
    public Object callback(Object[] objectArray) {
        try {
            return this.invokeCallback(objectArray);
        }
        catch (Throwable throwable) {
            Native.getCallbackExceptionHandler().uncaughtException(this.getCallback(), throwable);
            return null;
        }
    }

    private Object convertArgument(Object object, Class<?> clazz) {
        if (object instanceof Pointer) {
            if (clazz == String.class) {
                object = ((Pointer)object).getString(0L, this.encoding);
            } else if (clazz == WString.class) {
                object = new WString(((Pointer)object).getWideString(0L));
            } else if (clazz == String[].class) {
                object = ((Pointer)object).getStringArray(0L, this.encoding);
            } else if (clazz == WString[].class) {
                object = ((Pointer)object).getWideStringArray(0L);
            } else if (Callback.class.isAssignableFrom(clazz)) {
                object = CallbackReference.getCallback(clazz, (Pointer)object);
            } else if (Structure.class.isAssignableFrom(clazz)) {
                if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                    clazz = Structure.newInstance(clazz);
                    byte[] byArray = new byte[((Structure)((Object)clazz)).size()];
                    ((Pointer)object).read(0L, byArray, 0, byArray.length);
                    ((Structure)((Object)clazz)).getPointer().write(0L, byArray, 0, byArray.length);
                    ((Structure)((Object)clazz)).read();
                    object = clazz;
                } else {
                    clazz = Structure.newInstance(clazz, (Pointer)object);
                    ((Structure)((Object)clazz)).conditionalAutoRead();
                    object = clazz;
                }
            }
        } else if ((Boolean.TYPE == clazz || Boolean.class == clazz) && object instanceof Number) {
            object = Function.valueOf(((Number)object).intValue() != 0);
        }
        return object;
    }

    private Object convertResult(Object object) {
        if (this.toNative != null) {
            object = this.toNative.toNative(object, new CallbackResultContext(this.callbackMethod));
        }
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return object;
            }
            return ((Structure)object).getPointer();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (Boolean.TRUE.equals(object)) {
                return Function.INTEGER_TRUE;
            }
            return Function.INTEGER_FALSE;
        }
        if (clazz == String.class || clazz == WString.class) {
            return CallbackReference.access$100(object, clazz == WString.class);
        }
        if (clazz == String[].class || clazz == WString[].class) {
            clazz = clazz == String[].class ? new StringArray((String[])object, this.encoding) : new StringArray((WString[])object);
            CallbackReference.allocations.put(object, clazz);
            return clazz;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            return CallbackReference.getFunctionPointer((Callback)object);
        }
        return object;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.callbackMethod.getParameterTypes();
    }

    @Override
    public Class<?> getReturnType() {
        return this.callbackMethod.getReturnType();
    }
}

