/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFactoryFinder;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";
    static Class class$javax$xml$xpath$XPathFactory;

    protected XPathFactory() {
    }

    public static final XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            throw new RuntimeException("XPathFactory#newInstance() failed to create an XPathFactory for the default object model: http://java.sun.com/jaxp/xpath/dom with the XPathFactoryConfigurationException: " + xPathFactoryConfigurationException.toString());
        }
    }

    public static final XPathFactory newInstance(String string) {
        if (string == null) {
            throw new NullPointerException("XPathFactory#newInstance(String uri) cannot be called with uri == null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("XPathFactory#newInstance(String uri) cannot be called with uri == \"\"");
        }
        Object object = SecuritySupport.getContextClassLoader();
        if (object == null) {
            object = (class$javax$xml$xpath$XPathFactory == null ? (class$javax$xml$xpath$XPathFactory = XPathFactory.class$(DEFAULT_PROPERTY_NAME)) : class$javax$xml$xpath$XPathFactory).getClassLoader();
        }
        if ((object = new XPathFactoryFinder((ClassLoader)object).newFactory(string)) == null) {
            throw new XPathFactoryConfigurationException("No XPathFctory implementation found for the object model: " + string);
        }
        return object;
    }

    public static XPathFactory newInstance(String string, String object, ClassLoader classLoader) {
        if (string == null) {
            throw new NullPointerException("XPathFactory#newInstance(String uri) cannot be called with uri == null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("XPathFactory#newInstance(String uri) cannot be called with uri == \"\"");
        }
        if (object == null) {
            throw new XPathFactoryConfigurationException("factoryClassName cannot be null.");
        }
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        if ((object = new XPathFactoryFinder(classLoader).createInstance((String)object)) == null || !((XPathFactory)object).isObjectModelSupported(string)) {
            throw new XPathFactoryConfigurationException("No XPathFctory implementation found for the object model: " + string);
        }
        return object;
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2);

    public abstract boolean getFeature(String var1);

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

